# News - 13 series

(release-13-0-4)=
## Release 13.0.4 - 2023-07-26

### Improvements

* [{doc}`/install/windows`] Stopped providing 32-bit packages.

### Fixes

* [{doc}`/install/debian`][{doc}`/install/ubuntu`] Fixed the default
  configuration file path for {doc}`/reference/query_expanders/tsv`.

* [CMake] Fixed a bug that some errors may be reported when CMake 3.16
  or 3.17 are used.

(release-13-0-3)=
## Release 13.0.3 - 2023-07-24

### Improvements

* [{doc}`/reference/executables/groonga-httpd`] Extracted to
  [groonga-nginx](https://github.com/groonga/groonga-nginx). We
  stopped providing the `groonga-httpd` package.

  If you're an user of Debian GNU/Linux 12+ or Ubuntu 23.10+, you can
  use the `libnginx-mod-http-groonga` package with the default `nginx`
  package. See [groonga-nginx's
  README](https://github.com/groonga/groonga-nginx#readme) for
  details.

  If you're an user of old Debian/Ubuntu or RHEL related
  distributions, you can't use any `groonga-httpd` equivalent
  package. You can use
  {doc}`/reference/executables/groonga-server-http` instead. If
  {doc}`/reference/executables/groonga-server-http` isn't suitable for
  your use case, please report it to
  [Discussions](https://github.com/groonga/groonga/discussions) with
  your use case.

* [{doc}`/install/ubuntu`] Added support for Ubuntu 23.10 (Mantic Minotaur).

* [{doc}`/install/debian`] Enabled xxHash support.

* [{doc}`/install/ubuntu`] Enabled xxHash support.

### Fixes

* Fixed a bug that the source archive can't be built with CMake.

(release-13-0-2)=
## Release 13.0.2 - 2023-07-12

### Improvements

* [{doc}`/install/ubuntu`] Dropped support for Ubuntu 18.04 (Bionic Beaver).

* [{doc}`/install/ubuntu`] Added support for Ubuntu 23.04 (Lunar Lobster).

* [{doc}`/install/debian`] Added support for Debian GNU/Linux 12
  (bookworm).

* [Oracle Linux] Dropped support for Oracle Linux. Use
  {doc}`/install/almalinux` packages instead.

* [`grn_highlighter`] Added support for changing tag.

  [GH-1453](https://github.com/groonga/groonga/issues/1453)
  [Reported by askdkc]

* [`grn_highlighter`] Added support for customizing normalizers.

* [`grn_highlighter`] Added support for customizing HTML mode.

* [`grn_highlighter`] Added support for multiple tags.

* [{doc}`/reference/functions/highlight`] Added
  the `sequential_class_tag_mode` option.

* [{doc}`/reference/functions/highlight_html`] Added
  the `sequential_class_tag_mode` option.

* [{doc}`/reference/commands/reference_acquire`] Changed to refer
  index columns that are for the target object when `--recursive
  dependent` is used.

  If the target object is a column, index columns for the column is
  also referred.

  If the target object is a table, index columns for the table is also
  referred.

  If the target object is a DB, all tables are processed as target
  objects.

* [CMake] Changed to require CMake 3.16 or later. We'll use CMake
  instead of GNU Autotools as our recommended build tool in near
  future and drop support for GNU Autotools eventually.

* [CMake] Added support for CMake package. You can use it by
  `find_package(Groonga)`.

* [Packaging] Changed to use newer GNU Autotools to generate
  `configure` in the source archive.

  [`ranguba/rroonga#220 <https://github.com/ranguba/rroonga/issues/220>`_]
  [Reported by ZangRuochen]

* [{doc}`/reference/commands/reference_acquire`] Optimized reference
  count implementation for built-in objects.

* Added support for logging backtrace on `SIGABRT`.

### Fixes

* [{ref}`query-syntax-ordered-near-phrase-product-search-condition`]
  [{ref}`script-syntax-ordered-near-phrase-product-search-operator`]
  Fixed a search bug that records that should be matched may not be
  matched.

  It's happen when multiple 3+ tokens are overlapped in query. For
  example, `abc` and `abcd` are an invalid combination. If shorter
  one (`abc`) exists before longer one (`abcd`), this bug is
  happen. For example, `ONPP1 "(abcd abc) (1 2)"` works but `ONPP1
  "(abc abcd) (1 2)"` doesn't work.

* Fixed a bug that invalid weight may be used with multiple adjusts.

* [{doc}`/reference/grn_expr/query_syntax`] Fixed a typo.

  [`GH-1560 <https://github.com/groonga/groonga/issues/1560>`_]
  [Patch by Dylan Golow]

* [{ref}`query-syntax-near-phrase-search-condition`]
  [{ref}`script-syntax-near-phrase-search-operator`]
  [{ref}`query-syntax-near-phrase-product-search-condition`]
  [{ref}`script-syntax-near-phrase-product-search-operator`]
  [{ref}`query-syntax-ordered-near-phrase-search-condition`]
  [{ref}`script-syntax-ordered-near-phrase-search-operator`]
  [{ref}`query-syntax-ordered-near-phrase-product-search-condition`]
  [{ref}`script-syntax-ordered-near-phrase-product-search-operator`]
  Fixed an invalid interval calculation when
  `additional_last_interval` is used.

  For example, let's think about `*NP3,-1"aaa bbb .$"` against
  `aaaxxxbbbcdefghi.` In this case, the number of tokens between
  `aaa` and `bbb` must be 3 but it was 7.

* [{ref}`query-syntax-near-phrase-product-search-condition`]
  [{ref}`script-syntax-near-phrase-product-search-operator`]
  [{ref}`query-syntax-ordered-near-phrase-product-search-condition`]
  [{ref}`script-syntax-ordered-near-phrase-product-search-operator`]
  Fixed infinite loop bugs when the same phrase exists in the same
  phrase group.

  For example, `*NPP1 "(abcd abc abcd bcde) (efghi)"` is a bad query
  because the first phrase group has two `abcd` phrases.

  For example, `*NPP1 "(abcde \"abc de\") (efghi)"` is a bad query
  because the first phrase group has `abcde` and `"abc de"`. They
  are "logically" the same phrases.

* Fixed a bug that internal lock count may not be decreased when lock
  acquisition is failed. In normal use-case, this will not be a real
  problem.

### Thanks

* askdkc

* Dylan Golow

* ZangRuochen

(release-13-0-1)=
## Release 13.0.1 - 2023-03-24

### Improvements

* [{doc}`/reference/functions/highlight_html`] Added support for prefix search.

  We can now use prefix search in `highlight_html`.

  Note that highlight keyword is also highlighted not only at the first but also in the middle or at the end.

  ```text
  table_create Tags TABLE_NO_KEY
  column_create Tags name COLUMN_SCALAR ShortText

  table_create Terms TABLE_PAT_KEY ShortText \
    --normalizer 'NormalizerNFKC150'
  column_create Terms tags_name COLUMN_INDEX Tags name

  load --table Tags
  [
  {"name": "Groonga"}
  ]

  select Tags \
    --query "name:^g" \
    --output_columns "highlight_html(name)"
  # [
  #   [
  #     0,
  #     0.0,
  #     0.0
  #   ],
  #   [
  #     [
  #       [
  #         1
  #       ],
  #       [
  #         [
  #           "highlight_html",
  #           null
  #         ]
  #       ],
  #       [
  #         "<span class=\"keyword\">G</span>roon<span class=\"keyword\">g</span>a"
  #       ]
  #     ]
  #   ]
  # ]
  ```

* [{doc}`/reference/normalizers`] Added new options for NormalizerNFKC*.

  * `unify_kana_prolonged_sound_mark`

    We can now normalize prolonged_sound_mark with this option as below.

    ```text
    ァー -> ァア, アー -> アア, ヵー -> ヵア, カー -> カア, ガー -> ガア, サー -> サア, ザー -> ザア,
    ター -> タア, ダー -> ダア, ナー -> ナア, ハー -> ハア, バー -> バア, パー -> パア, マー -> マア,
    ャー -> ャア, ヤー -> ヤア, ラー -> ラア, ヮー -> ヮア, ワー -> ワア, ヷー -> ヷア,

    ィー -> ィイ, イー -> イイ, キー -> キイ, ギー -> ギイ, シー -> シイ, ジー -> ジイ, チー -> チイ,
    ヂー -> ヂイ, ニー -> ニイ, ヒー -> ヒイ, ビー -> ビイ, ピー -> ピイ, ミー -> ミイ, リー -> リイ,
    ヰー -> ヰイ, ヸー -> ヸイ,

    ゥー -> ゥウ, ウー -> ウウ, クー -> クウ, グー -> グウ, スー -> スウ, ズー -> ズウ, ツー -> ツウ,
    ヅー -> ヅウ, ヌー -> ヌウ, フー -> フウ, ブー -> ブウ, プー -> プウ, ムー -> ムウ, ュー -> ュウ,
    ユー -> ユウ, ルー -> ルウ, ヱー -> ヱウ, ヴー -> ヴウ,

    ェー -> ェエ, エー -> エエ, ヶー -> ヶエ, ケー -> ケエ, ゲー -> ゲエ, セー -> セエ, ゼー -> ゼエ,
    テー -> テエ, デー -> デエ, ネー -> ネエ, ヘー -> ヘエ, ベー -> ベエ, ペー -> ペエ, メー -> メエ,
    レー -> レエ, ヹー -> ヹエ,

    ォー -> ォオ, オー -> オオ, コー -> コオ, ゴー -> ゴオ, ソー -> ソオ, ゾー -> ゾオ, トー -> トオ,
    ドー -> ドオ, ノー -> ノオ, ホー -> ホオ, ボー -> ボオ, ポー -> ポオ, モー -> モオ, ョー -> ョオ,
    ヨー -> ヨオ, ロー -> ロオ, ヲー -> ヲオ, ヺー -> ヺオ,

    ンー -> ンン

    ぁー -> ぁあ, あー -> ああ, ゕー -> ゕあ, かー -> かあ, がー -> があ, さー -> さあ, ざー -> ざあ,
    たー -> たあ, だー -> だあ, なー -> なあ, はー -> はあ, ばー -> ばあ, ぱー -> ぱあ, まー -> まあ,
    ゃー -> ゃあ, やー -> やあ, らー -> らあ, ゎー -> ゎあ, わー -> わあ

    ぃー -> ぃい, いー -> いい, きー -> きい, ぎー -> ぎい, しー -> しい, じー -> じい, ちー -> ちい,
    ぢー -> ぢい, にー -> にい, ひー -> ひい, びー -> びい, ぴー -> ぴい, みー -> みい, りー -> りい,
    ゐー -> ゐい

    ぅー -> ぅう, うー -> うう, くー -> くう, ぐー -> ぐう, すー -> すう, ずー -> ずう, つー -> つう,
    づー -> づう, ぬー -> ぬう, ふー -> ふう, ぶー -> ぶう, ぷー -> ぷう, むー -> むう, ゅー -> ゅう,
    ゆー -> ゆう, るー -> るう, ゑー -> ゑう, ゔー -> ゔう

    ぇー -> ぇえ, えー -> ええ, ゖー -> ゖえ, けー -> けえ, げー -> げえ, せー -> せえ, ぜー -> ぜえ,
    てー -> てえ, でー -> でえ, ねー -> ねえ, へー -> へえ, べー -> べえ, ぺー -> ぺえ, めー -> めえ,
    れー -> れえ

    ぉー -> ぉお, おー -> おお, こー -> こお, ごー -> ごお, そー -> そお, ぞー -> ぞお, とー -> とお,
    どー -> どお, のー -> のお, ほー -> ほお, ぼー -> ぼお, ぽー -> ぽお, もー -> もお, ょー -> ょお,
    よー -> よお, ろー -> ろお, をー -> をお

    んー -> んん
    ```

    Here is an example of `unify_kana_prolonged_sound_mark`.

    ```text
    table_create --name Animals --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Animals --name name --type ShortText
    column_create --table Animals --name sound --type ShortText
    load --table Animals
    [
    {"_key":"1","name":"羊", "sound":"メーメー"},
    ]

    table_create \
      --name idx_animals_sound \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_kana_prolonged_sound_mark", true)'
    column_create --table idx_animals_sound --name animals_sound --flags COLUMN_INDEX|WITH_POSITION --type Animals --source sound

    select --table Animals --query sound:@メエメエ
    # [
    #   [
    #     0,
    #     1677829950.652696,
    #     0.01971983909606934
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ],
    #         [
    #           "sound",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "羊",
    #         "メーメー"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_kana_hyphen`

    We can now normalize hyphen with this option as below.

    ```text
    ァ- -> ァア, ア- -> アア, ヵ- -> ヵア, カ- -> カア, ガ- -> ガア, サ- -> サア, ザ- -> ザア,
    タ- -> タア, ダ- -> ダア, ナ- -> ナア, ハ- -> ハア, バ- -> バア, パ- -> パア, マ- -> マア,
    ャ- -> ャア, ヤ- -> ヤア, ラ- -> ラア, ヮ- -> ヮア, ワ- -> ワア, ヷ- -> ヷア,

    ィ- -> ィイ, イ- -> イイ, キ- -> キイ, ギ- -> ギイ, シ- -> シイ, ジ- -> ジイ, チ- -> チイ,
    ヂ- -> ヂイ, ニ- -> ニイ, ヒ- -> ヒイ, ビ- -> ビイ, ピ- -> ピイ, ミ- -> ミイ, リ- -> リイ,
    ヰ- -> ヰイ, ヸ- -> ヸイ,

    ゥ- -> ゥウ, ウ- -> ウウ, ク- -> クウ, グ- -> グウ, ス- -> スウ, ズ- -> ズウ, ツ- -> ツウ,
    ヅ- -> ヅウ, ヌ- -> ヌウ, フ- -> フウ, ブ- -> ブウ, プ- -> プウ, ム- -> ムウ, ュ- -> ュウ,
    ユ- -> ユウ, ル- -> ルウ, ヱ- -> ヱウ, ヴ- -> ヴウ,

    ェ- -> ェエ, エ- -> エエ, ヶ- -> ヶエ, ケ- -> ケエ, ゲ- -> ゲエ, セ- -> セエ, ゼ- -> ゼエ,
    テ- -> テエ, デ- -> デエ, ネ- -> ネエ, ヘ- -> ヘエ, ベ- -> ベエ, ペ- -> ペエ, メ- -> メエ,
    レ- -> レエ, ヹ- -> ヹエ,

    ォ- -> ォオ, オ- -> オオ, コ- -> コオ, ゴ- -> ゴオ, ソ- -> ソオ, ゾ- -> ゾオ, ト- -> トオ,
    ド- -> ドオ, ノ- -> ノオ, ホ- -> ホオ, ボ- -> ボオ, ポ- -> ポオ, モ- -> モオ, ョ- -> ョオ,
    ヨ- -> ヨオ, ロ- -> ロオ, ヲ- -> ヲオ, ヺ- -> ヺオ,

    ン- -> ンン

    ぁ- -> ぁあ, あ- -> ああ, ゕ- -> ゕあ, か- -> かあ, が- -> があ, さ- -> さあ, ざ- -> ざあ,
    た- -> たあ, だ- -> だあ, な- -> なあ, は- -> はあ, ば- -> ばあ, ぱ- -> ぱあ, ま- -> まあ,
    ゃ- -> ゃあ, や- -> やあ, ら- -> らあ, ゎ- -> ゎあ, わ- -> わあ

    ぃ- -> ぃい, い- -> いい, き- -> きい, ぎ- -> ぎい, し- -> しい, じ- -> じい, ち- -> ちい,
    ぢ- -> ぢい, に- -> にい, ひ- -> ひい, び- -> びい, ぴ- -> ぴい, み- -> みい, り- -> りい,
    ゐ- -> ゐい

    ぅ- -> ぅう, う- -> うう, く- -> くう, ぐ- -> ぐう, す- -> すう, ず- -> ずう, つ- -> つう,
    づ- -> づう, ぬ- -> ぬう, ふ- -> ふう, ぶ- -> ぶう, ぷ- -> ぷう, む- -> むう, ゅ- -> ゅう,
    ゆ- -> ゆう, る- -> るう, ゑ- -> ゑう, ゔ- -> ゔう

    ぇ- -> ぇえ, え- -> ええ, ゖ- -> ゖえ, け- -> けえ, げ- -> げえ, せ- -> せえ, ぜ- -> ぜえ,
    て- -> てえ, で- -> でえ, ね- -> ねえ, へ- -> へえ, べ- -> べえ, ぺ- -> ぺえ, め- -> めえ,
    れ- -> れえ

    ぉ- -> ぉお, お- -> おお, こ- -> こお, ご- -> ごお, そ- -> そお, ぞ- -> ぞお, と- -> とお,
    ど- -> どお, の- -> のお, ほ- -> ほお, ぼ- -> ぼお, ぽ- -> ぽお, も- -> もお, ょ- -> ょお,
    よ- -> よお, ろ- -> ろお, を- -> をお

    ん- -> んん
    ```

    Here is an example of `unify_kana_hyphen`.

    ```text
    table_create --name Animals --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Animals --name name --type ShortText
    column_create --table Animals --name sound --type ShortText
    load --table Animals
    [
    {"_key":"1","name":"羊", "sound":"メ-メ-"},
    ]

    table_create \
      --name idx_animals_sound \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_kana_hyphen", true)'
    column_create --table idx_animals_sound --name animals_sound --flags COLUMN_INDEX|WITH_POSITION --type Animals --source sound

    select --table Animals --query sound:@メエメエ
    # [
    #   [
    #     0,1677829950.652696,
    #     0.01971983909606934
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ],
    #         [
    #           "sound",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "羊",
    #         "メ-メ-"
    #       ]
    #     ]
    #   ]
    # ]
    ```

* [{ref}`query-syntax-near-search-condition`][{ref}`script-syntax-near-search-operator`]
  Added a new option `${MIN_INTERVAL}` for near-search family.

  We can now specifiy the minimum interval between phrases (words) with `${MIN_INTERVAL}`.
  The interval between phrases (words) must be at least this value.

  Here are new syntax:

  ```text
  *N${MAX_INTERVAL},${MAX_TOKEN_INTERVAL_1}|${MAX_TOKEN_INTERVAL_2}|...,${MIN_INTERVAL} "word1 word2 ..."
  *NP${MAX_INTERVAL},${ADDITIONAL_LAST_INTERVAL},${MAX_PHRASE_INTERVAL_1}|${MAX_PHRASE_INTERVAL_2}|...,${MIN_INTERVAL} "phrase1 phrase2 ..."
  *NPP${MAX_INTERVAL},${ADDITIONAL_LAST_INTERVAL},${MAX_PHRASE_INTERVAL_1}|${MAX_PHRASE_INTERVAL_2}|...,${MIN_INTERVAL} "(phrase1-1 phrase1-2 ...) (phrase2-1 phrase2-2 ...) ..."
  *ONP${MAX_INTERVAL},${ADDITIONAL_LAST_INTERVAL},${MAX_PHRASE_INTERVAL_1}|${MAX_PHRASE_INTERVAL_2}|...,${MIN_INTERVAL} "phrase1 phrase2 ..."
  *ONPP${MAX_INTERVAL},${ADDITIONAL_LAST_INTERVAL},${MAX_PHRASE_INTERVAL_1}|${MAX_PHRASE_INTERVAL_2}|...,${MIN_INTERVAL} "(phrase1-1 phrase1-2 ...) (phrase2-1 phrase2-2 ...) ..."
  ```

  The default value of `${MIN_INTERVAL}` is `INT32_MIN` (`-2147483648`).
  We use the default value when `${MIN_INTERVAL}` is omitted.

  This option is useful when we want to ignore overlapped phrases.

  The interval for `*NP` is culculated as `interval between the top tokens of phrases - tokens in the left phrase + 1`.

  When a tokenizer is Bigram, for exmaple, `東京` has one token `東京`, also `京都` has one token `京都`.

  Considering `東京都` as a target value of `*NP "東京 京都"`:

  * `interval between the top tokens of phrases`: `1` (interval between `東京` and `京都`)
  * `tokens in the left phrase`: `1` ( `東京` )

  The interval for `*NP` of `東京都` is `1 - 1 + 1` = `1`.

  As a result, the interval for `*NP` is greater than `1` when `東京` and `京都` are not overlapped.

  Here is an example for ignoring overlapped phrases.

  ```text
  table_create Entries TABLE_NO_KEY
  column_create Entries content COLUMN_SCALAR Text

  table_create Terms TABLE_PAT_KEY ShortText \
    --default_tokenizer 'TokenNgram("unify_alphabet", false, \
                                    "unify_digit", false)' \
    --normalizer NormalizerNFKC150
  column_create Terms entries_content COLUMN_INDEX|WITH_POSITION Entries content

  load --table Entries
  [
  {"content": "東京都"},
  {"content": "東京京都"}
  ]

  select Entries \
    --match_columns content \
    --query '*NP-1,0,,2"東京 京都"' \
    --output_columns '_score, content'
  # [
  #   [
  #     0,
  #     0.0,
  #     0.0
  #   ],
  #   [
  #     [
  #       [
  #         1
  #       ],
  #       [
  #         [
  #           "_score",
  #           "Int32"
  #         ],
  #         [
  #           "content",
  #           "Text"
  #         ]
  #       ],
  #       [
  #         1,
  #         "東京京都"
  #       ]
  #     ]
  #   ]
  # ]
  ```

  In the example above, `東京都` is not matched as the interval is `1`
  but `東京京都` is matched as the interval is `2`.

* [{doc}`/reference/normalizers`] Added support for new values in the `unify_katakana_trailing_o` option.

  We added support for normalizing the following new values in the `unify_katakana_trailing_o` option
  because a vowel of those left letters is `O`.

  * `ォオ` -> `ォウ`
  * `ョオ` -> `ョウ`
  * `ヺオ` -> `ヺウ`

* Add support for MessagePack v6.0.0. [GitHub#1536][Reported by Carlo Cabrera]

  Groonga can not found MessagePack v6.0.0 or later when we execute configure or cmake until now.
  Groonga can found MessagePack since this release even if the version of MessagePack is v6.0.0 or later.

### Fixes

* [{doc}`/reference/normalizers`] Fixed a bug that NormalizerNFKC* did incorrect normalization.

  This bug occured when `unify_kana_case` and `unify_katakana_v_sounds` used at the same time.

  For example, `ヴァ` was normalized to `バア` with `unify_kana_case` and `unify_katakana_v_sounds`, 
  but `ヴァ` should be normalized to `バ`.

  This was because `ヴァ` was normalized to `ヴア` with `unify_kana_case`, and after that, `ヴア` was normalized
  to `バア` with `unify_katakana_v_sounds`. We fixed to normalize characters with `unify_katakana_v_sounds` before 
  `unify_kana_case`.

  Here is an example of the bug in the previous version.

  ```text
  normalize \
    'NormalizerNFKC150("unify_katakana_v_sounds", true, \
                       "unify_kana_case", true)' \
    "ヴァーチャル"
  #[
  #  [
  #    0,
  #    1678097412.913053,
  #    0.00019073486328125
  #  ],
  #  {
  #    "normalized":"ブアーチヤル",
  #    "types":[],
  #    "checks":[]
  #  }
  #]
  ```

  From this version, `ヴァーチャル` is normalized to `バーチヤル`.

* [{ref}`query-syntax-ordered-near-phrase-search-condition`][{ref}`script-syntax-ordered-near-phrase-search-operator`]
  Fixed a bug that `${MAX_PHRASE_INTERVALS}` doesn't work correctly.

  When this bug occured, intervals are regarded as `0`.
  Therefore, if this bug occurs, records may hit too many.

  This bug occured when:

  1. Use `*ONP` with `${MAX_PHRASE_INTERVALS}`
  2. The number of tokens in the matched left phrase is greater than or equal to the number of `${MAX_PHRASE_INTERVALS}` elements.

  Here is an example of this bug.

  ```text
  table_create Entries TABLE_NO_KEY
  column_create Entries content COLUMN_SCALAR Text
  table_create Terms TABLE_PAT_KEY ShortText \
    --default_tokenizer 'TokenNgram("unify_alphabet", false, \
                                    "unify_digit", false)' \
    --normalizer NormalizerNFKC150
  column_create Terms entries_content COLUMN_INDEX|WITH_POSITION Entries content
  load --table Entries
  [
  {"content": "abcXYZdef"},
  {"content": "abcdef"},
  {"content": "abc123456789def"},
  {"content": "abc12345678def"},
  {"content": "abc1de2def"}
  ]
  select Entries --filter 'content *ONP-1,0,1 "abc def"' --output_columns '_score, content'
  #[
  #  [
  #    0,
  #    0.0,
  #    0.0
  #  ],
  #  [
  #    [
  #      [
  #        5
  #      ],
  #      [
  #        [
  #          "_score",
  #          "Int32"
  #        ],
  #        [
  #          "content",
  #          "Text"
  #        ]
  #      ],
  #      [
  #        1,
  #        "abcXYZdef"
  #      ],
  #      [
  #        1,
  #        "abcdef"
  #      ],
  #      [
  #        1,
  #        "abc123456789def"
  #      ],
  #      [
  #        1,
  #        "abc12345678def"
  #      ],
  #      [
  #        1,
  #        "abc1de2def"
  #      ]
  #    ]
  #  ]
  #]
  ```

  In the example above, the first element interval is specified as `1` with `*ONP-1,0,1 "abc def"` 
  , but all `content` is matched, including those farther than `1`.

  This is because the example satisfies the condition for the bug and the interval is regarded as `0`.

  1. Use `*ONP` with `${MAX_PHRASE_INTERVALS}`

     `*ONP-1,0,1 "abc def"` specifies `${MAX_PHRASE_INTERVALS}`.

  2. The number of tokens in the matched left phrase is greater than or equal to the number of `${MAX_PHRASE_INTERVALS}` elements.

     * The matched left phrase: `abc`

       * Included tokens: `ab`, `bc`
       * Tokenized with `TokenNgram("unify_alphabet", false, "unify_digit", false)`
     * The number of elements specified with `max_element_intervals`: `1`

       * `1` of `*ONP-1,0,1 "abc def"`
     * The number of tokens in the left phrase (`2`) > the number of elements specified with `max_element_intervals` (`1`)

* [{ref}`query-syntax-near-phrase-search-condition`][{ref}`script-syntax-near-phrase-search-operator`]
  Fixed a bug that phrases specified as last didn't used as last in near-phrase family.

  When this bug occured, `${ADDITIONAL_LAST_INTERVAL}` was ignored and only `${MAX_INTERVAL}` was used.

  This bug occured when:

  1. A phrase specified as last contains multiple tokens.
  2. The size of the last token of the phrase is smaller than or equals to the sizes of other tokens in the phrase.

     * The token size is the number of tokens appeared in the all records.

  Here is an example of this bug.

  ```text
  table_create Entries TABLE_NO_KEY
  column_create Entries content COLUMN_SCALAR Text

  table_create Terms TABLE_PAT_KEY ShortText \
    --default_tokenizer 'TokenNgram("unify_alphabet", false, \
                                    "unify_digit", false)' \
    --normalizer NormalizerNFKC150
  column_create Terms entries_content COLUMN_INDEX|WITH_POSITION Entries content

  load --table Entries
  [
  {"content": "abc123456789defg"},
  {"content": "dededede"}
  ]

  select Entries \
    --filter 'content *NP10,1"abc defg$"' \
    --output_columns '_score, content'
  #[
  #  [
  #    0,
  #    0.0,
  #    0.0
  #  ],
  #  [
  #    [
  #      [
  #        0
  #      ],
  #      [
  #        [
  #          "_score",
  #          "Int32"
  #        ],
  #        [
  #          "content",
  #          "Text"
  #        ]
  #      ]
  #    ]
  #  ]
  #]
  ```

  In the example above, for `abc123456789defg`, the interval `abc` to `defg` is `11`.
  `${MAX_INTERVAL}` is `10` and `${ADDITIONAL_LAST_INTERVAL}` is `1`, so a threshold for matching last phrase is `11`.
  So it should be matched, but isn't.

  This is because the example satisfies the condition for the bug as below, and only ``${MAX_INTERVAL}` is used.

  1. A phrase specified as last contains multiple tokens.

     `defg$` is specified as last because the suffix is `$`.

     `defg$` is tokenized to `de`, `ef`, `fg` with `TokenNgram("unify_alphabet", false, "unify_digit", false)`

  2. The size of the last token of the phrase is smaller than or equals to the sizes of other tokens in the phrase.

     `fg` is the last token of `defg$`. `abc123456789defg` contains one `fg` and `de`, and `dededede` contains 4 `de`.

     So, the size of `fg` is 1 and `de` is 5.

* [{ref}`query-syntax-near-phrase-search-condition`] Fixed interval calculation.

  If we use near phrase search, records may hit too many by this bug.

* [{doc}`/reference/functions/highlight_html`] Fixed a bug that highlight position may move over when we use `loose_symbol=true`.

### Thanks

* Carlo Cabrera

(release-13-0-0)=
## Release 13.0.0 - 2023-02-09

This is a major version up!
But It keeps backward compatibility. We can upgrade to 13.0.0 without rebuilding database.

First of all, we introduce the main changes in 13.0.0.
Then, we introduce the hilight and summary of changes from Groonga 12.0.0 to 12.1.2.

### Improvements

* [{doc}`/reference/normalizers`] Added a new Normalizer `NormalizerNFKC150` based on Unicode NFKC (Normalization Form Compatibility Composition) for Unicode 15.0.

* [{doc}`/reference/token_filters`] Added a new TokenFilter `TokenFilterNFKC150` based on Unicode NFKC (Normalization Form Compatibility Composition) for Unicode 15.0.

* [{doc}`/reference/normalizers/normalizer_nfkc150`] Added new options for NormalizerNFKC* as below.

  * `unify_katakana_gu_small_sounds`

    We can normalize "グァ -> ガ", "グィ -> ギ", "グェ -> ゲ", and "グォ -> ゴ" with this option.

    Here is an example of `unify_katakana_gu_small_sounds` option.

    ```text
    table_create --name Countries --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Countries --name name --type ShortText
    load --table Countries
    [
    {"_key":"JP","name":"日本"},
    {"_key":"GT","name":"グァテマラ共和国"},
    ]

    table_create \
      --name idx_contry_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_gu_small_sounds", true)'
    column_create --table idx_contry_name --name contry_name --flags COLUMN_INDEX|WITH_POSITION --type Countries --source name

    select --table Countries --query name:@ガテマラ共和国
    # [
    #   [0,
    #    0,
    #    0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         2,
    #         "GT",
    #         "グァテマラ共和国"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_di_sound`

    We can normalize "ヂ -> ジ" with this option.

    Here is an example of `unify_katakana_di_sound` option.

    ```text
    table_create --name Foods --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Foods --name name --type ShortText
    load --table Foods
    [
    {"_key":"1","name":"チジミ"},
    {"_key":"2","name":"パジョン"},
    ]

    table_create \
      --name idx_food_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_di_sound", true)'
    column_create --table idx_food_name --name food_name --flags COLUMN_INDEX|WITH_POSITION --type Foods --source name

    select --table Foods --query name:@チヂミ
    # [
    #   [
    #     0,
    #     0,
    #     0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "チジミ"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_wo_sound`

    We can normalize "ヲ -> オ" with this option.

    Here is an example of `unify_katakana_wo_sound` option.

    ```text
    table_create --name Foods --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Foods --name name --type ShortText
    load --table Foods
    [
    {"_key":"1","name":"アヲハタ"},
    {"_key":"2","name":"ヴェルデ"},
    {"_key":"3","name":"ランプ"},
    ]

    table_create \
      --name idx_food_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_wo_sound", true)'
    column_create --table idx_food_name --name food_name --flags COLUMN_INDEX|WITH_POSITION --type Foods --source name

    select --table Foods --query name:@アオハタ
    # [
    #   [
    #     0,
    #     0,
    #     0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "アヲハタ"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_zu_small_sounds`

    We can normalize "ズァ -> ザ", "ズィ -> ジ", "ズェ -> ゼ", and "ズォ -> ゾ" with this option.

    Here is an example of `unify_katakana_zu_small_sounds` option.

    ```text
    table_create --name Cities --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Cities --name name --type ShortText
    load --table Cities
    [
    {"_key":"1","name":"ガージヤーバード"},
    {"_key":"2","name":"デリー"},
    ]

    table_create \
      --name idx_city_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_zu_small_sounds", true)'
    column_create --table idx_city_name --name city_name --flags COLUMN_INDEX|WITH_POSITION --type Cities --source name

    select --table Cities --query name:@ガーズィヤーバード
    # [
    #   [
    #     0,
    #     0,
    #     0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "ガージヤーバード"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_du_sound`

    We can normalize "ヅ -> ズ" with this option.

    Here is an example of `unify_katakana_du_sound` option.

    ```text
    table_create --name Plants --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Plants --name name --type ShortText
    load --table Plants
    [
    {"_key":"1","name":"ハスノカヅラ"},
    {"_key":"2","name":"オオツヅラフジ"},
    {"_key":"3","name":"アオツヅラフジ"},
    ]

    table_create \
      --name idx_plant_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_du_sound", true)'
    column_create --table idx_plant_name --name plant_name --flags COLUMN_INDEX|WITH_POSITION --type Plants --source name

    select --table Plants --query name:@ツズラ
    # [
    #   [
    #     0,
    #     0,
    #     0
    #   ],
    #   [
    #     [
    #       [
    #         2
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         2,
    #         "2",
    #         "オオツヅラフジ"
    #       ],
    #       [
    #         3,
    #         "3",
    #         "アオツヅラフジ"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_trailing_o`

    We can normalize following characters with this option.

      * "オオ -> オウ"
      * "コオ -> コウ"
      * "ソオ -> ソウ"
      * "トオ -> トウ"
      * "ノオ -> ノウ"
      * "ホオ -> ホウ"
      * "モオ -> モウ"
      * "ヨオ -> ヨウ"
      * "ロオ -> ロウ"
      * "ゴオ -> ゴウ"
      * "ゾオ -> ゾウ"
      * "ドオ -> ドウ"
      * "ボオ -> ボウ"
      * "ポオ -> ポウ"

    Here is an example of `unify_katakana_trailing_o` option.

    ```text
    table_create --name Sharks --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Sharks --name name --type ShortText
    load --table Sharks
    [
    {"_key":"1","name":"ホオジロザメ"},
    {"_key":"2","name":"ジンベイザメ"},
    ]

    table_create \
      --name idx_shark_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_trailing_o", true)'
    column_create --table idx_shark_name --name shark_name --flags COLUMN_INDEX|WITH_POSITION --type Sharks --source name

    select --table Sharks --query name:@ホウジロザメ
    # [
    #   [
    #     0,
    #     0,
    #     0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "_id",
    #           "UInt32"
    #         ],
    #         [
    #           "_key",
    #           "ShortText"
    #         ],
    #         [
    #           "name",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         1,
    #         "1",
    #         "ホオジロザメ"
    #       ]
    #     ]
    #   ]
    # ]
    ```

  * `unify_katakana_du_small_sounds`

    We can normalize "ヅァ -> ザ", "ヅィ -> ジ", "ヅェ -> ゼ", and "ヅォ -> ゾ" with this option.

    Here is an example of `unify_katakana_du_small_sounds` option.

    ```text
    table_create --name Airports --flags TABLE_HASH_KEY --key_type ShortText
    column_create --table Airports --name name --type ShortText
    load --table Airports
    [
    {"_key":"HER","name":"イラクリオ・ニコスカザンヅァキス国際空港"},
    {"_key":"ATH","name":"アテネ国際空港"},
    ]

    table_create \
      --name idx_airport_name \
      --flags TABLE_PAT_KEY \
      --key_type ShortText \
      --default_tokenizer TokenBigram \
      --normalizer 'NormalizerNFKC150("unify_katakana_du_small_sounds", true)'
    column_create --table idx_airport_name --name airport_name --flags COLUMN_INDEX|WITH_POSITION --type Airports --source name

    select --table Airports --query name:@ニコスカザンザキス
    # [
    #   [
    #     [
    #       1
    #     ],
    #     [
    #       [
    #         "_id",
    #         "UInt32"
    #       ],
    #       [
    #         "_key",
    #         "ShortText"
    #       ],
    #       [
    #         "name",
    #         "ShortText"
    #       ]
    #     ],
    #     [
    #       1,
    #       "HER",
    #       "イラクリオ・ニコスカザンヅァキス国際空港"
    #     ]
    #   ]
    # ]
    ```

* [Oracle Linux] Added newly support for Oracle Linux 8 and 9.

### Thanks

* Atsushi Shinoda
* i10a
* naoa
* shinonon
* Zhanzhao (Deo) Liang
* David CARLIER

### Higlight and Summary of changes from 12.0.0 to 12.1.2

#### Higlight

[{ref}`release-12-0-9`]

  * [{doc}`/reference/normalizers`] Added `NormalizerHTML`. (Experimental)

    `NormalizerHTML` is a normalizer for HTML.

    Currently `NormalizerHTML` supports removing tags like `<span>` or `</span>` and expanding character references like `&amp;` or `&#38;`.

    Here are sample queries for `NormalizerHTML`.

    ```text
    normalize NormalizerHTML "<span> Groonga &amp; Mroonga &#38; Rroonga </span>"
    # [[0,1666923364.883798,0.0005481243133544922],{"normalized":" Groonga & Mroonga & Rroonga ","types":[],"checks":[]}]
    ```

    In this sample `<span>` and `</span>` are removed, and `&amp;` and `&#38;` are expanded to `&`.

    We can specify whether removing the tags with the `remove_tag` option.
    (The default value of the `remove_tag` option is `true`.)

    ```text
    normalize 'NormalizerHTML("remove_tag", false)' "<span> Groonga &amp; Mroonga &#38; Rroonga </span>"
    # [[0,1666924069.278549,0.0001978874206542969],{"normalized":"<span> Groonga & Mroonga & Rroonga </span>","types":[],"checks":[]}]
    ```

    In this sample, `<span>` and `</span>` are not removed.

    We can specify whether expanding the character references with the `expand_character_reference` option.
    (The default value of the `expand_character_reference` option is `true`.)

    ```text
    normalize 'NormalizerHTML("expand_character_reference", false)' "<span> Groonga &amp; Mroonga &#38; Rroonga </span>"
    # [[0,1666924357.099782,0.0002346038818359375],{"normalized":" Groonga &amp; Mroonga &#38; Rroonga ","types":[],"checks":[]}]
    ```

    In this sample, `&amp;` and `&#38;` are not expanded.

[{ref}`release-12-0-3`]

  * [{doc}`/reference/functions/snippet`],[{doc}`/reference/functions/snippet_html`] Added support for text vector as input. [groonga-dev,04956][Reported by shinonon]

    For example, we can extract snippets of target text around search keywords against vector in JSON data as below.

    ```text
    table_create Entries TABLE_NO_KEY
    column_create Entries title COLUMN_SCALAR ShortText
    column_create Entries contents COLUMN_VECTOR ShortText

    table_create Tokens TABLE_PAT_KEY ShortText   --default_tokenizer TokenNgram   --normalizer NormalizerNFKC130
    column_create Tokens entries_title COLUMN_INDEX|WITH_POSITION Entries title
    column_create Tokens entries_contents COLUMN_INDEX|WITH_SECTION|WITH_POSITION   Entries contents

    load --table Entries
    [
    {
      "title": "Groonga and MySQL",
      "contents": [
        "Groonga is a full text search engine",
        "MySQL is a RDBMS",
        "Mroonga is a MySQL storage engine based on Groonga"
      ]
    }
    ]

    select Entries\
      --output_columns 'snippet_html(contents), contents'\
      --match_columns 'title'\
      --query Groonga
    # [
    #   [
    #     0,
    #     0.0,
    #     0.0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "snippet_html",
    #           null
    #         ],
    #         [
    #           "contents",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         [
    #           "<span class=\"keyword\">Groonga</span> is a full text search engine",
    #           "Mroonga is a MySQL storage engine based on <span class=\"keyword\">Groonga</span>"
    #         ],
    #         [
    #           "Groonga is a full text search engine",
    #           "MySQL is a RDBMS",
    #           "Mroonga is a MySQL storage engine based on Groonga"
    #         ]
    #       ]
    #     ]
    #   ]
    # ]
    ```

    Until now, if we specified `snippet*` like `--output_columns 'snippet_html(contents[1])`,
    we could extract snippets of target text around search keywords against the vector as below.
    However, we didn't know which we should output elements. Because we didn't know which element was hit on search.

    ```text
    select Entries\
      --output_columns 'snippet_html(contents[0]), contents'\
      --match_columns 'title'\
      --query Groonga
    # [
    #   [
    #     0,
    #     0.0,
    #     0.0
    #   ],
    #   [
    #     [
    #       [
    #         1
    #       ],
    #       [
    #         [
    #           "snippet_html",
    #           null
    #         ],
    #         [
    #           "contents",
    #           "ShortText"
    #         ]
    #       ],
    #       [
    #         [
    #           "<span class=\"keyword\">Groonga</span> is a full text search engine"
    #         ],
    #         [
    #           "Groonga is a full text search engine",
    #           "MySQL is a RDBMS",
    #           "Mroonga is a MySQL storage engine based on Groonga"
    #         ]
    #       ]
    #     ]
    #   ]
    # ]
    ```

[{ref}`release-12-0-1`]

  * [{doc}`/reference/commands/query_expand`] Added a support for synonym group.

    Until now, We had to each defined a keyword and synonyms of the keyword as below when we use the synonym search.

    ```text
    table_create Thesaurus TABLE_PAT_KEY ShortText --normalizer NormalizerAuto
    # [[0, 1337566253.89858, 0.000355720520019531], true]
    column_create Thesaurus synonym COLUMN_VECTOR ShortText
    # [[0, 1337566253.89858, 0.000355720520019531], true]
    load --table Thesaurus
    [
    {"_key": "mroonga", "synonym": ["mroonga", "tritonn", "groonga mysql"]},
    {"_key": "groonga", "synonym": ["groonga", "senna"]}
    ]
    ```

    In the above case, if we search `mroonga`, Groonga search `mroonga OR tritonn OR "groonga mysql"` as we intended.
    However, if we search `tritonn`, Groonga search only `tritonn`.
    If we want to search `tritonn OR mroonga OR "groonga mysql"` even if we search `tritonn`, we need had added a definition as below.

    ```text
    load --table Thesaurus
    [
    {"_key": "tritonn", "synonym": ["tritonn", "mroonga", "groonga mysql"]},
    ]
    ```

    In many cases, if we expand `mroonga` to `mroonga OR tritonn OR "groonga mysql"`, we feel we want to expand `tritonn` and `"groonga mysql"` to `mroonga OR tritonn OR "groonga mysql"`.
    However, until now, we had needed additional definitions in such a case.
    Therefore, if target keywords for synonyms are many, we are troublesome to define synonyms.
    Because we need to define many similar definitions.

    In addition, when we remove synonyms, we are troublesome because we need to execute remove against many records.

    We can make a group by deciding on a representative synonym record since this release.
    For example, the all following keywords are the "mroonga" group.

    ```text
    load --table Synonyms
    [
      {"_key": "mroonga": "representative": "mroonga"}
    ]

    load --table Synonyms
    [
      {"_key": "tritonn": "representative": "mroonga"},
      {"_key": "groonga mysql": "representative": "mroonga"}
    ]
    ```

    In this case, `mroonga` is expanded to `mroonga OR tritonn OR "groonga mysql"`.
    In addition, `tritonn` and `"groonga mysql"` are also expanded to `mroonga OR tritonn OR "groonga mysql"`.

    When we want to remove synonyms, we execute just remove against a target record.
    For example, if we want to remove `"groonga mysql"` from synonyms, we just remove `{"_key": "groonga mysql": "representative": "mroonga"}`.

[{ref}`release-12-0-0`]

  * [index_column_have_source_record] Added a new function `index_column_have_source_record()`.

    We can confirm whether a token that is existing in the index is included in any of the records that are registered in Groonga or not.

    Groonga does not remove a token even if the token become never used from records in Groonga by updating records.
    Therefore, for example, when we use the feature of autocomplete, Groonga may return a token that is not included in any of the records as candidates for search words.
    However, we can become that we don't return the needless token by using this function.

    Because this function can detect a token that is not included in any of the records.

  * [{doc}`/reference/commands/select`] Added new arguments `drilldown_max_n_target_records` and `drilldown[${LABEL}].max_n_target_records`.

    We can specify the max number of records of the drilldown target table (filtered result) to use drilldown.
    If the number of filtered result is larger than the specified value, some records in filtered result aren't used for drilldown.
    The default value of this arguments are `-1`.
    If these arguments are set `-1`, Groonga uses all records for drilldown.

    This argument is useful when filtered result may be very large.
    Because a drilldown against large filtered result may be slow.
    We can limit the max number of records to be used for drilldown by this feature.

    Here is an example to limit the max number of records to be used for drilldown.
    The last 2 records, `{\"_id\": 4, \"tag\": \"Senna\"}` and `{\"_id\": 5, \"tag\": \"Senna\"}`, aren't used.

    ```text
     table_create Entries TABLE_HASH_KEY ShortText
     column_create Entries content COLUMN_SCALAR Text
     column_create Entries n_likes COLUMN_SCALAR UInt32
     column_create Entries tag COLUMN_SCALAR ShortText

     table_create Terms TABLE_PAT_KEY ShortText --default_tokenizer TokenBigram --normalizer NormalizerAuto
     column_create Terms entries_key_index COLUMN_INDEX|WITH_POSITION Entries _key
     column_create Terms entries_content_index COLUMN_INDEX|WITH_POSITION Entries content
     load --table Entries
     [
     {"_key":    "The first post!",
      "content": "Welcome! This is my first post!",
      "n_likes": 5,
      "tag": "Hello"},
     {"_key":    "Groonga",
      "content": "I started to use Groonga. It's very fast!",
      "n_likes": 10,
      "tag": "Groonga"},
     {"_key":    "Mroonga",
      "content": "I also started to use Mroonga. It's also very fast! Really fast!",
      "n_likes": 15,
      "tag": "Groonga"},
     {"_key":    "Good-bye Senna",
      "content": "I migrated all Senna system!",
      "n_likes": 3,
      "tag": "Senna"},
     {"_key":    "Good-bye Tritonn",
      "content": "I also migrated all Tritonn system!",
      "n_likes": 3,
      "tag": "Senna"}
     ]

     select Entries \
       --limit -1 \
       --output_columns _id,tag \
       --drilldown tag \
       --drilldown_max_n_target_records 3
     # [
     #   [
     #     0,
     #     1337566253.89858,
     #     0.000355720520019531
     #   ],
     #   [
     #     [
     #       [
     #         5
     #       ],
     #       [
     #         [
     #           "_id",
     #           "UInt32"
     #         ],
     #         [
     #           "tag",
     #           "ShortText"
     #         ]
     #       ],
     #       [
     #         1,
     #         "Hello"
     #       ],
     #       [
     #         2,
     #         "Groonga"
     #       ],
     #       [
     #         3,
     #         "Groonga"
     #       ],
     #       [
     #         4,
     #         "Senna"
     #       ],
     #       [
     #         5,
     #         "Senna"
     #       ]
     #     ],
     #     [
     #       [
     #         2
     #       ],
     #       [
     #         [
     #           "_key",
     #           "ShortText"
     #         ],
     #         [
     #           "_nsubrecs",
     #           "Int32"
     #         ]
     #       ],
     #       [
     #         "Hello",
     #         1
     #       ],
     #       [
     #         "Groonga",
     #         2
     #       ]
     #     ]
     #   ]
     # ]
     ```

### Summary

#### Improvements

[{ref}`release-12-1-2`]

  * [httpd] Updated bundled nginx to 1.23.3.

[{ref}`release-12-1-1`]

  * [{doc}`/reference/commands/select`][{ref}`select-drilldowns-label-key-vector-expansions-power-set`] Vector's power set is now able to aggregate with the drilldowns.
  * [{doc}`/reference/commands/select`] Specific element of vector column is now able to be search target.
  * [{doc}`/reference/commands/load`] Added support for `YYYY-MM-DD` time format.

[{ref}`release-12-1-0`]

  * [{doc}`/reference/commands/load`] Added support for slow log output of `load`. 
  * [{doc}`/reference/api`] Added new API `grn_is_reference_count_enable()`.
  * [{doc}`/reference/commands/status`] Added new items: `back_trace` and `/reference_count`.

[{ref}`release-12-0-9`]

  * [{doc}`/install/almalinux`] Added support for AlmaLinux 9.
  * [{doc}`/reference/functions/escalate`] Added a document for the `escalate()` function.
  * [{doc}`/reference/normalizers`] Added `NormalizerHTML`. (Experimental)
  * [httpd] Updated bundled nginx to 1.23.2.
  * Suppressed logging a lot of same messages when no memory is available.

[{ref}`release-12-0-8`]

  * Changed specification of the `escalate()` function (Experimental) to make it easier to use.
  * [{doc}`/install/cmake`] Added a document about how to build Groonga with CMake.
  * [{doc}`/install/others`] Added descriptions about how to enable/disable Apache Arrow support when building with GNU Autotools.
  * [{doc}`/reference/commands/select`] Added a document about {ref}`select-drilldowns-label-table`.
  * [{doc}`/contribution/documentation/i18n`] Updated the translation procedure.

[{ref}`release-12-0-7`]

  * Added a new function `escalate()`. (experimental)
  * [httpd] Updated bundled nginx to 1.23.1.
  * [{doc}`/reference/commands/select`] Add a document for the `--n_workers` option.

[{ref}`release-12-0-6`]

  * Added new Munin plugins for groonga-delta.
  * [{doc}`/reference/commands/column_copy`] Added support for weight vector.
  * [{doc}`/install/ubuntu`] Dropped support for Ubuntu 21.10 (Impish Indri).
  * [{doc}`/install/debian`] Dropped Debian 10 (buster) support.

[{ref}`release-12-0-5`]

  * [{doc}`/reference/commands/select`] Improved a little bit of performance for prefix search by search escalation.
  * [{doc}`/reference/commands/select`] Added support for specifying a reference vector column with weight in `drilldowns[LABEL]._key`.
  * [{doc}`/reference/commands/select`] Added support for doing drilldown with a reference vector with weight even if we use `query` or `filter`, or `post_filter`.

[{ref}`release-12-0-4`]

  * [{doc}`/install/ubuntu`] Added support for Ubuntu 22.04 (Jammy Jellyfish).
  * We don't provide `groonga-benchmark`.
  * [{doc}`/reference/commands/status`] Added a new item `memory_map_size`.

[{ref}`release-12-0-3`]

  * [{doc}`/reference/commands/logical_count`] Improved memory usage while `logical_count` executed.
  * [{doc}`/reference/commands/dump`] Added support for `MISSING_IGNORE/MISSING_NIL`.
  * [{doc}`/reference/functions/snippet`],[{doc}`/reference/functions/snippet_html`] Added support for text vector as input.
  * [`vector_join`] Added a new function `vector_join()`.
  * [{doc}`/reference/indexing`] Ignore too large a token like online index construction.

[{ref}`release-12-0-2`]

  * [{doc}`/reference/commands/logical_range_filter`] Added support for reducing reference immediately after processing a shard.
  * We increased the stability of the feature of recovering on crashes.
  * Improved performance for mmap if anonymous mmap available.
  * [{doc}`/reference/indexing`] Added support for the static index construction against the following types of columns.
  * [{doc}`/reference/commands/column_create`] Added new flags `MISSING_*` and `INVALID_*`.
  * [{doc}`/reference/commands/dump`][{doc}`/reference/commands/column_list`] Added support for `MISSING_*` and `INVALID_*` flags.
  * [{doc}`/reference/commands/schema`] Added support for `MISSING_*` and `INVALID_*` flags.
  * We provided the package of Amazon Linux 2.
  * [Windows] Dropped support for building with Visual Studio 2017.

[{ref}`release-12-0-1`]

  * [{doc}`/reference/commands/query_expand`] Added a support for synonym group.
  * [{doc}`/reference/commands/query_expand`] Added a support for text vector and index.
  * Added support for disabling a backtrace by the environment variable.
  * [{doc}`/reference/commands/select`] Improved performance for `--slices`.
  * [Windows] Added support for Visual Studio 2022.
  * [{doc}`/reference/commands/select`] Added support for specifing max intervals for each elements in near search.
  * [{doc}`/reference/executables/groonga-server-http`] We could use `groonga-server-http` even if Groonga of RPM packages.

[{ref}`release-12-0-0`]

  * [{doc}`/reference/functions/sub_filter`] Added a new option `pre_filter_threshold`.
  * [index_column_have_source_record] Added a new function `index_column_have_source_record()`.
  * [{doc}`/reference/normalizers/normalizer_nfkc130`] Added a new option `strip`
  * [{doc}`/reference/commands/select`] Added new arguments `drilldown_max_n_target_records` and `drilldown[${LABEL}].max_n_target_records`.
  * [httpd] Updated bundled nginx to 1.21.6.

#### Fixes

[{ref}`release-12-1-1`]

  * [{doc}`/reference/commands/select`] Fix a bug displaying a wrong label in `drilldown` results when `command_version` is `3`.
  * [{doc}`/reference/normalizers/normalizer_table`] Fix a bug for Groonga to crush with specific definition setting in `NormalizerTable`.

[{ref}`release-12-1-0`]

  * [{doc}`/reference/commands/select`][{doc}`/reference/columns/vector`] Fixed a bug displaying integer in the results when a weight vector column specifies `WEIGHT FLOAT32`.

[{ref}`release-12-0-9`]

  * [{doc}`/reference/commands/select`] Fixed a bug that Groonga could crash or return incorrect results when specifying {ref}`select-n-workers`.

[{ref}`release-12-0-8`]

  * Fixed a bug that Groonga could return incorrect results when we use {doc}`/reference/normalizers/normalizer_table` and it contains a non-idempotent (results can be changed when executed repeatedly) definition.

[{ref}`release-12-0-7`]

  * Fixed a bug Groonga's response may be slow when we execute the `request_cancel` while executing a OR search.

[{ref}`release-12-0-6`]

  * Fixed a bug that Groonga may crash when we execute drilldown in a parallel by `n_workers` option.
  * [{doc}`/reference/commands/select`] Fixed a bug that the syntax error occurred when we specify a very long expression in `--filter`.

[{ref}`release-12-0-4`]

  * Fixed a bug Groonga's response may be slow when we execute `request_cancel` while executing a search.
  * Fixed a bug that string list can't be casted to int32 vector.
  * Fixed a bug that Groonga Munin Plugins do not work on AlmaLinux 8 and CentOS 7.

[{ref}`release-12-0-3`]

  * Fixed a bug that we may be not able to add a key to a table of patricia trie.
