# News - 13 series

(release-13-05)=
## Release 13.05 - 2023-08-02

### Improvements

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support MySQL 5.7.43.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support MySQL 8.0.34.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 5.7.42-46.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.33-25.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support MariaDB 10.4.30, 10.5.21, 10.6.14, 10.8.8, 10.9.7, 10.10.5, and 10.11.4.

* [{doc}`/install/debian`] Added support for MariaDB 10.5.19.

* [{doc}`/install/debian`] Added newly support for Debian 12 (bookworm).

  However, we only support Mroonga with MariaDB 10.11 in this release.

  Because the source of MySQL Community Server for Debian 12 doesn't exist in MySQL APT Repository(https://repo.mysql.com/apt/debian/dists/) currently.

  Therefore, we don't support Mroonga with MySQL community server 8.0 on Debian 12 temporarily.
  We will support Mroonga with MySQL community server 8.0 after the source of it for Debian 12 is available.

* Dropped support for MariaDB 10.3.

  It reached EOL on 2023-05-25.

(release-13-01)=
## Release 13.01 - 2023-03-29

### Improvements

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added newly support for MariaDB 10.11 [GitHub#606][Patched by Josep Sanz]

* [{doc}`/install/amazon-linux`] Added support for MariaDB 10.5.18-1.amzn2.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.32-24.

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 5.7.41-44.

* [Oracle Linux] Dropped support for Oracle Linux 8 and 9

  We supported Oracle Linux for installing Mroonga to MySQL official Docker image.
  However, a package that needed to install to MySQL official Docker image is Mroonga for MySQL community server minimal

  Therefore, we cann't install Mroonga to MySQL official Docker image even if we use Mroonga for Oracle Linux.

* [{doc}`/install/ubuntu`] Dropped support for Ubuntu 18.04.

  Because Ubuntu 18.04 reached EOL.

* [{doc}`/install/almalinux`] Added support for MySQL community server minimal 8.0.

  This is for supporting the `mysql:8.0-oracle` Docker image.

(release-13-00)=
## Release 13.00 - 2023-02-09

This is a major version up!
But It keeps backward compatibility. We can upgrade to 13.00 without rebuilding database.

First of all, we introduce the main changes in 13.00.
Then, we introduce the hilight and summary of changes from Mroonga 12.00 to 12.12.

### New Features and Improvements in 13.00

  :::{note}
    Currently, we don't provide packages of Mroonga 13.00 for Percona Server.
    Because there is a problem with buildong packages of Mroonga 13.00 for Percona Server.
    If we will resolve this problem, we will provide packages of Mroonga for Percona Server again.
  :::

### Improvements

* [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.3.38, 10.4.28, 10.5.19, 10.6.12, 10.7.8, 10.8.7, 10.9.5, and 10.10.3. 

### Higlight and Summary of changes from 12.00 to 12.12

#### Higlight

* Added support for reference count mode.

  Though this feature can keep fixed memory usage, its performance would be dropped.
  Thus, memory increments should be first consideration before using this feature.

  The reference count mode is used with `table_open_cache <https://dev.mysql.com/doc/refman/8.0/en/server-system-variables.html#sysvar_table_open_cache>`_ of MySQL.

  MySQL can cache specified number of tables with `table_open_cache``.
  Groonga's object would not be released because the cached tables are still in use.

  The tables with low usage would be closed if number of open tables is larger than number specified with `table_open_cache`.
  Groonga objects would be released at the same time with table closing if the reference count mode is enabled.

  These are how the reference count mode keep fixed memory usage.

  For actual use, we need to adjust balance between memory usage and perfomance with value of `table_open_cache` while checking
  memory usage and value of status variables `Open_tables <https://dev.mysql.com/doc/refman/8.0/en/server-status-variables.html#statvar_Open_tables>`_. 
  Because this feature can keep fixed memory usage, but its performance would be dropped.

  There is how to check `Open_tables` as follows.

  ```sql
    SHOW GLOBAL STATUS LIKE 'Open_tables';
    -- +---------------+-------+
    -- | Variable_name | Value |
    -- +---------------+-------+
    -- | Open_tables   | 643   |
    -- +---------------+-------+
  ```

  Normally, all of tables in use are cached by setting `table_open_cache` larger than `Open_tables`.
  However, if there is limited memory, memory usage would be decreased by releasing memory for tables with low usage dropping from the cache.
  In order to releasing tables with low usage from the cache, `table_open_cache` should be set smaller than `Open_tables`.
  The smaller `Open Tables` setting , the more tables dropping from the cache.
  As cache is released, memory usage decrease, yet performance become worse due to reopen tables.
  The smaller `table_open_cache`, the more necessary to reopen tables. `table_open_cache` should set as much value as only to reaching memory tolerance.

  In order to enable reference count mode, we need to specify values in my.cnf as follows;

  ```
    loose-mroonga-enable-reference-count = ON
  ```

  :::{note}

     The reference count mode would not be enabled with variables after booting MySQL.
     It is necesarry to specify values in my.cnf.

  :::

  ```sql
    SET GLOBAL mroonga_enable_reference_count = ON
  ```

* Added support for execution timeout parameter.[GitHub #344][Reported by Kazuhiko]

  MySQL/MariaDB can abort queries if the execution timeout parameter is specified and a execution time exceeds a time specified with the parameter.
  The execution timeout parameter is `MAX_EXECUTION_TIME` in MySQL and `max_statement_time` in MariaDB.

  However, Mroonga did not abort executing queries even after MySQL/MariaDB abort the queries and return results.
  So if the Groonga queries match too many results, it could continue to consume memory and CPU resources even after MySQL/MariaDB abort the queries.

  From this version, Mroonga can abort queries in the specified time and the execution timeout parameter works correctly. So Mroonga don't continue to consume memory and CPU resources after MySQL/MariaDB abort the queries.

  The following how to use this feature.

  Here is a sample for MySQL.

  ```sql
    CREATE TABLE diaries(
      title TEXT
      FULLTEXT INDEX (title)
    ) ENGINE = Mroonga DEFAULT CHARSET=utf8mb4;

    INSERT INTO diaries (title) VALUES ("It'll be fine tomorrow.");
    INSERT INTO diaries (title) VALUES ("It'll rain tomorrow");

    SELECT /*+ MAX_EXECUTION_TIME(1) */ title
      FROM diaries
     WHERE MATCH(title) AGAINST("+fine" IN BOOLEAN MODE);
  ```

  Here is a sample for MariaDB.

  ```sql
    CREATE TABLE diaries(
      title TEXT
      FULLTEXT INDEX (title)
    ) ENGINE = Mroonga DEFAULT CHARSET=utf8mb4;

    INSERT INTO diaries (title) VALUES ("It'll be fine tomorrow.");
    INSERT INTO diaries (title) VALUES ("It'll rain tomorrow");

    SET STATEMENT max_statement_time = 0.001 FOR
    SELECT title
      FROM diaries
     WHERE MATCH(title) AGAINST("+fine" IN BOOLEAN MODE);
   ```

  This feature can use in `mroonga_command()` also.

* Fixed a bug to fail to install or upgrade Mroonga with install.sql.[GitHub #525][Reported by Tomohiro KATO][Patched by Jérome Perrin]

  Broken install.sql caused this bug. This bug had occurred since Mroonga 12.06.

* Fixed a memory leak on full text search. [Reported by OHTSUKA Soushi and Mitsuo Yoshida]

  This is occurred when `order limit optimization <https://mroonga.org/ja/docs/reference/optimizations.html#order-by-limit>`_ is used.
  However, if we use MariaDB, this occurs even if we don't use order limit optimization.

  This bug had occurred since Mroonga 11.03.

* Fixed a bug that Mroonga for Windows does not bundle groonga-normalizer-mysql.

#### Summary

#### Improvements

[{ref}`release-12-12`]

  * [{doc}`/install/almalinux`] Added newly support for AlmaLinux 9.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL 8.0.32.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL 5.7.41
  * Added support for updating normal columns with composite primary key table. [GitHub#592][Reported by handmound]

[{ref}`release-12-11`]

  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added newly support for MariaDB 10.10.
  * [{doc}`/install/amazon-linux`] Added support for MariaDB 10.5.10-2.amzn2.0.2.
  * [{doc}`/reference/server_variables`] Added a new status variable `libgroonga_support_mecab`.
  * [{doc}`/install/debian`] Added support for MariaDB 10.5.18.

[{ref}`release-12-10`]

  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.3.37, 10.4.27, 10.5.18, 10.6.11, 10.7.7, 10.8.6, 10.9.4. [GitHub #564][Reported by Josep Sanz][Patched by Tomohiro KATO]
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.30-22.
  * [{doc}`/install/centos`] Added support for Percona Server 5.7.40-43.
  * [{doc}`/install/windows`] Added support for MariaDB 10.7, 10.8, 10.9.
  * [{doc}`/install/windows`] Dropped support for 32bit versions.
  * [{doc}`/reference/udf/mroonga_highlight_html`] Added new parameters: `open_tag` and `close_tag`. [GitHub #537][Reported by ishitaka]
  * Added support for reference count mode.

[{ref}`release-12-09`]

  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.9.3.
  * [{doc}`/install/centos`][{doc}`/install/ubuntu`] Added support for MySQL 5.7.40.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`][{doc}`/install/debian`][{doc}`/install/ubuntu`] Added support for MySQL 8.0.31.
  * [{doc}`/install/ubuntu`] Added support for MariaDB 10.6 on Ubuntu 22.04 (Jammy Jellyfish).
  * Added support for execution timeout parameter.[GitHub #344][Reported by Kazuhiko]

[{ref}`release-12-08`]

  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.6.10, 10.7.6 and 10.8.5.
  * [{doc}`/install/oracle-linux`] Added support for MySQL 8.0.30.

[{ref}`release-12-07`]

  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.3.36, 10.4.26, 10.5.17, 10.6.9, 10.7.5 and 10.8.4.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 5.7.39-42.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.29-21.

[{ref}`release-12-06`]

  * [{doc}`/install/centos`] Added support for MySQL 5.7.39.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MySQL 8.0.30.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.28-20.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.8.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Dropped support for MariaDB 10.2.
  * [{doc}`/install/debian`] Dropped support for Debian 10 (buster).
  * Changed to not require to run update.sql for registering Mroonga to MySQL.[GitHub #509][Reported by Jérome Perrin]

[{ref}`release-12-04`]

  * [{doc}`/reference/server_variables`] Add a new status variable `Mroonga_memory_map_size`.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.28-19.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 5.7.38-41.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.2.44, 10.3.35, 10.4.25, 10.5.16, 10.6.8, and 10.7.4.

[{ref}`release-12-03`]

  * [{doc}`/install/centos`] Added support for Percona Server 5.7.37-40.
  * [{doc}`/install/centos`] Added support for MySQL 5.7.38.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MySQL 8.0.29.

[{ref}`release-12-02`]

  * Dropped support wrapper mode with MySQL 8.0 or later.
  * Added support for disabling a back trace by the server variable.
  * Added support for `float32` weight vector.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for MariaDB 10.3.34, 10.4.24, 10.5.15, 10.6.7, and 10.7.3.
  * [{doc}`/install/centos`] Added support for MariaDB 10.2.43.
  * [{doc}`/install/centos`][{doc}`/install/almalinux`] Added support for Percona Server 8.0.27-18.
  * Added support for `MISSING_*` and `INVALID_*` flags

[{ref}`release-12-00`]

  * [{doc}`/install/ubuntu`] Added support for the latest version of mysql-server package for Ubuntu.
  * [{doc}`/install/centos`] Added support for MariaDB 10.2.42, 10.3.33, 10.4.23, 10.5.14, and 10.6.6.
  * [{doc}`/install/almalinux`] Added support for MariaDB 10.3.33, 10.4.23, 10.5.14, and 10.6.6.

#### Fixes

[{ref}`release-12-11`]

  * [{doc}`/reference/udf/mroonga_highlight_html`] Fixed memory leak when we use `mroonga_highlight_html()` with `AS query`.
  * Fixed a bug that initialization of MeCab is fail when we use Mroonga on MariaDB 10.9 or later for Windows.

[{ref}`release-12-10`]

  * Fixed a bug that Mroonga for Windows does not bundle groonga-normalizer-mysql.

[{ref}`release-12-09`]

  * Fixed a bug that Mroonga for Windows does not bundle groonga-normalizer-mysql.

[{ref}`release-12-07`]

  * Fixed a bug to fail to install or upgrade Mroonga with install.sql.[GitHub #525][Reported by Tomohiro KATO][Patched by Jérome Perrin]
  * Fixed a bug that `mroonga_command()` returns results with hex dump for MySQL 8.0 and above.
  * [{doc}`/install/almalinux`] Fixed an installation document for Mroonga on AlmaLinux 8. [Gitter/ja:62fe4ca5b16e8236e3ef225c][Reported by handmound]

[{ref}`release-12-04`]

  * Fixed a bug that Mroonga may update failed. [groonga-dev,04982, groonga-dev,04987][Reported by Mitsuo Yoshida and OHTSUKA Soushi]

[{ref}`release-12-03`]

  * Fixed a bug that Mroonga may fail create the index on MariaDB 10.5.14. [GitHub clear-code/redmine_full_text_search#103][Reported by wate]
  * Fixed a memory leak on full text search. [Reported by OHTSUKA Soushi and Mitsuo Yoshida]

#### Thanks

  * handmound
  * Josep Sanz
  * Tomohiro KATO
  * ishitaka
  * Kazuhiko
  * Jérome Perrin
  * Mitsuo Yoshida
  * OHTSUKA Soushi
  * wate
