# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

import sys

import pytest

import pyarrow as pa


def test_serialization_deprecated():
    with pytest.warns(DeprecationWarning):
        ser = pa.serialize(1)

    with pytest.warns(DeprecationWarning):
        pa.deserialize(ser.to_buffer())

    f = pa.BufferOutputStream()
    with pytest.warns(DeprecationWarning):
        pa.serialize_to(12, f)

    buf = f.getvalue()
    f = pa.BufferReader(buf)
    with pytest.warns(DeprecationWarning):
        pa.read_serialized(f).deserialize()

    with pytest.warns(DeprecationWarning):
        pa.default_serialization_context()

    context = pa.lib.SerializationContext()
    with pytest.warns(DeprecationWarning):
        pa.register_default_serialization_handlers(context)


@pytest.mark.skipif(sys.version_info < (3, 7),
                    reason="getattr needs Python 3.7")
def test_serialization_deprecated_toplevel():
    with pytest.warns(DeprecationWarning):
        pa.SerializedPyObject()

    with pytest.warns(DeprecationWarning):
        pa.SerializationContext()
