// Generated by CoffeeScript 1.3.3
(function() {
  var formatResult, msgpack, nroonga, optionsToCommandString, overrideOutputType;

  nroonga = module.exports = require('../build/Release/nroonga_bindings.node');

  msgpack = require('msgpack2');

  optionsToCommandString = function(command, options) {
    var args, key, value;
    args = [command];
    if (options != null) {
      for (key in options) {
        value = options[key];
        if (value != null) {
          args.push('--' + key);
          args.push(JSON.stringify(value));
        }
      }
    }
    return args.join(' ');
  };

  overrideOutputType = function(optionsGiven, type) {
    var key, options, value;
    options = {};
    for (key in optionsGiven) {
      value = optionsGiven[key];
      options[key] = value;
    }
    options.output_type = type;
    return options;
  };

  formatResult = function(result, command) {
    if (command === 'dump') {
      return result.toString('UTF-8');
    } else {
      if (result.length > 0) {
        return msgpack.unpack(result);
      } else {
        return void 0;
      }
    }
  };

  nroonga.Database.prototype.commandSync = function(command, options) {
    var result;
    if (options == null) {
      options = {};
    }
    options = overrideOutputType(options, 'msgpack');
    result = this.commandSyncString(optionsToCommandString(command, options));
    return formatResult(result, command);
  };

  nroonga.Database.prototype.command = function(command, options, callback) {
    var wrappedCallback;
    if (arguments.length === 2) {
      callback = options;
      options = {};
    }
    options = overrideOutputType(options, 'msgpack');
    wrappedCallback = callback != null ? function(error, data) {
      if (error != null) {
        return callback(error);
      } else {
        return callback(void 0, formatResult(data, command));
      }
    } : void 0;
    return this.commandString(optionsToCommandString(command, options), wrappedCallback);
  };

}).call(this);
