//
// MessagePack for Java
//
// Copyright (C) 2009-2010 FURUHASHI Sadayuki
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
package org.msgpack;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UnpackIterator extends UnpackResult implements Iterator<MessagePackObject> {
	private Unpacker pac;

	UnpackIterator(Unpacker pac) {
		super();
		this.pac = pac;
	}

	public boolean hasNext() {
		if(finished) { return true; }
		try {
			return pac.next(this);
		} catch (IOException e) {
			return false;
		}
	}

	public MessagePackObject next() {
		if(!finished && !hasNext()) {
			throw new NoSuchElementException();
		}
		finished = false;
		return data;
	}

	public void remove() {
		throw new UnsupportedOperationException();
	}
}

