// Generated by CoffeeScript 1.3.3
var Access, Cookie, Cookies, HTML, Tough;

HTML = require("jsdom").dom.level3.html;

Tough = require("tough-cookie");

Cookie = Tough.Cookie;

Access = (function() {

  function Access(_cookies, domain, path) {
    this._cookies = _cookies;
    this.domain = Tough.canonicalDomain(domain);
    this.path = path || "/";
  }

  Access.prototype.all = function() {
    var _this = this;
    return this._cookies.all().filter(function(cookie) {
      return Tough.domainMatch(_this.domain, cookie.domain) && Tough.pathMatch(_this.path, cookie.path) && cookie.TTL() > 0;
    }).sort(Tough.cookieCompare);
  };

  Access.prototype.get = function(name) {
    var cookie, sorted, _i, _len;
    sorted = this.all();
    for (_i = 0, _len = sorted.length; _i < _len; _i++) {
      cookie = sorted[_i];
      if (cookie.key === name) {
        return cookie.value;
      }
    }
  };

  Access.prototype.set = function(name, value, options) {
    var cookie,
      _this = this;
    if (options == null) {
      options = {};
    }
    cookie = new Cookie({
      key: name,
      value: value,
      domain: options.domain || this.domain,
      path: options.path || this.path
    });
    if (options.expires) {
      cookie.setExpires(options.expirs);
    } else if (options.hasOwnProperty("max-age")) {
      cookie.setMaxAge(options["max-age"]);
    }
    cookie.secure = !!options.secure;
    cookie.httpOnly = !!options.httpOnly;
    this._cookies.filter(function(c) {
      return !(cookie.key === c.key && cookie.domain === c.domain && cookie.path === c.path);
    });
    if (Tough.domainMatch(cookie.domain, this.domain) && Tough.pathMatch(cookie.path, this.path) && cookie.TTL() > 0) {
      return this._cookies.push(cookie);
    }
  };

  Access.prototype.remove = function(name) {
    var _this = this;
    return this._cookies.filter(function(cookie) {
      return !(cookie.key === name && cookie.domain === _this.domain && cookie.path === _this.path);
    });
  };

  Access.prototype.clear = function() {
    var _this = this;
    return this._cookies.filter(function(cookie) {
      return !(cookie.domain === _this.domain && cookie.path === _this.path);
    });
  };

  Access.prototype.update = function(serialized) {
    var cookie, _i, _len, _ref, _results;
    if (!serialized) {
      return;
    }
    if (serialized.constructor === Array) {
      serialized = serialized.join(",");
    }
    _ref = serialized.split(/,(?=[^;,]*=)|,$/);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      cookie = _ref[_i];
      cookie = Cookie.parse(cookie);
      cookie.domain || (cookie.domain = this.domain);
      cookie.path || (cookie.path = this.path);
      this._cookies.filter(function(c) {
        return !(cookie.key === c.key && cookie.domain === c.domain && cookie.path === c.path);
      });
      if (Tough.domainMatch(this.domain, cookie.domain) && Tough.pathMatch(this.path, cookie.path) && cookie.TTL() > 0) {
        _results.push(this._cookies.push(cookie));
      } else {
        _results.push(void 0);
      }
    }
    return _results;
  };

  Access.prototype.addHeader = function(headers) {
    var cookie, header;
    header = ((function() {
      var _i, _len, _ref, _results;
      _ref = this.all();
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        cookie = _ref[_i];
        _results.push(cookie.cookieString());
      }
      return _results;
    }).call(this)).join("; ");
    if (header.length > 0) {
      return headers.cookie = header;
    }
  };

  Access.prototype.dump = function(separator) {
    var cookie;
    if (separator == null) {
      separator = "\n";
    }
    return ((function() {
      var _i, _len, _ref, _results;
      _ref = this.all();
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        cookie = _ref[_i];
        _results.push(cookie.toString());
      }
      return _results;
    }).call(this)).join(separator);
  };

  Access.prototype.toString = function() {
    var cookie;
    return ((function() {
      var _i, _len, _ref, _results;
      _ref = this.all();
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        cookie = _ref[_i];
        _results.push(cookie.toString());
      }
      return _results;
    }).call(this)).join("\n");
  };

  return Access;

})();

Cookies = (function() {

  function Cookies() {
    this._cookies = [];
  }

  Cookies.prototype.access = function(hostname, pathname) {
    return new Access(this, hostname, pathname);
  };

  Cookies.prototype.extend = function(window) {
    return Object.defineProperty(window, "cookies", {
      get: function() {
        return this.browser.cookies(this.location.hostname, this.location.pathname);
      }
    });
  };

  Cookies.prototype.dump = function() {
    var cookie, _i, _len, _ref, _results;
    _ref = this._cookies.sort(Tough.cookieCompare);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      cookie = _ref[_i];
      _results.push(process.stdout.write(cookie.toString() + "\n"));
    }
    return _results;
  };

  Cookies.prototype.save = function() {
    var cookie, serialized, _i, _len, _ref;
    serialized = ["# Saved on " + (new Date().toISOString())];
    _ref = this._cookies.sort(Tough.cookieCompare);
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      cookie = _ref[_i];
      serialized.push(cookie.toString());
    }
    return serialized.join("\n") + "\n";
  };

  Cookies.prototype.load = function(serialized) {
    var line, _i, _len, _ref, _results;
    _ref = serialized.split(/\n+/);
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      line = _ref[_i];
      line = line.trim();
      if (line[0] === "#" || line === "") {
        continue;
      }
      _results.push(this._cookies.push(Cookie.parse(line)));
    }
    return _results;
  };

  Cookies.prototype.filter = function(fn) {
    return this._cookies = this._cookies.filter(fn);
  };

  Cookies.prototype.push = function(cookie) {
    return this._cookies.push(cookie);
  };

  Cookies.prototype.all = function() {
    return this._cookies.slice();
  };

  return Cookies;

})();

HTML.HTMLDocument.prototype.__defineGetter__("cookie", function() {
  var cookie, cookies;
  cookies = (function() {
    var _i, _len, _ref, _results;
    _ref = this.parentWindow.cookies.all();
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      cookie = _ref[_i];
      if (!cookie.httpOnly) {
        _results.push("" + cookie.key + "=" + cookie.value);
      }
    }
    return _results;
  }).call(this);
  return cookies.join("; ");
});

HTML.HTMLDocument.prototype.__defineSetter__("cookie", function(cookie) {
  return this.parentWindow.cookies.update(cookie);
});

module.exports = Cookies;
