// Generated by CoffeeScript 1.3.3
var HTML, JSDOM, Scripts, createDocument, element, setAttribute, setFocus, _i, _len, _ref;

JSDOM = require("jsdom");

Scripts = require("./scripts");

HTML = JSDOM.dom.level3.html;

createDocument = function(browser, window) {
  var document, jsdomOpts;
  jsdomOpts = {
    deferClose: true,
    features: {
      MutationEvents: "2.0",
      ProcessExternalResources: [],
      FetchExternalResources: ["iframe"]
    },
    parser: browser.htmlParser
  };
  if (browser.runScripts) {
    jsdomOpts.features.ProcessExternalResources.push("script");
    jsdomOpts.features.FetchExternalResources.push("script");
  }
  if (browser.loadCSS) {
    jsdomOpts.features.FetchExternalResources.push("css");
  }
  document = JSDOM.jsdom(null, HTML, jsdomOpts);
  if (browser.runScripts) {
    Scripts.addInlineScriptSupport(document);
  }
  Object.defineProperty(document, "window", {
    value: window
  });
  Object.defineProperty(document, "parentWindow", {
    value: window.parent
  });
  Object.defineProperty(document, "location", {
    get: function() {
      return window.location;
    },
    set: function(url) {
      return window.location = url;
    }
  });
  Object.defineProperty(document, "URL", {
    get: function() {
      return window.location.href;
    }
  });
  return document;
};

HTML.HTMLDocument.prototype.__defineGetter__("activeElement", function() {
  return this._inFocus || this.body;
});

setFocus = function(document, element) {
  var onblur, onfocus;
  if (element !== document._inFocus) {
    if (document._inFocus) {
      onblur = document.createEvent("HTMLEvents");
      onblur.initEvent("blur", false, false);
      document.window._dispatchEvent(document._inFocus, onblur);
    }
    if (element) {
      onfocus = document.createEvent("HTMLEvents");
      onfocus.initEvent("focus", false, false);
      document.window._dispatchEvent(element, onfocus);
    }
    return document._inFocus = element;
  }
};

HTML.Element.prototype.focus = function() {};

HTML.Element.prototype.blur = function() {};

_ref = [HTML.HTMLInputElement, HTML.HTMLSelectElement, HTML.HTMLTextAreaElement, HTML.HTMLButtonElement, HTML.HTMLAnchorElement];
for (_i = 0, _len = _ref.length; _i < _len; _i++) {
  element = _ref[_i];
  element.prototype.focus = function() {
    return setFocus(this.ownerDocument, this);
  };
  element.prototype.blur = function() {
    if (this.ownerDocument.activeElement === this) {
      return setFocus(this.ownerDocument, null);
    }
  };
}

setAttribute = HTML.HTMLElement.prototype.setAttribute;

HTML.HTMLElement.prototype.setAttribute = function(name, value) {
  setAttribute.call(this, name, value);
  if (name === "autofocus" && ~["INPUT", "SELECT", "TEXTAREA", "BUTTON", "ANCHOR"].indexOf(this.tagName)) {
    return this.ownerDocument._inFocus = this;
  }
};

module.exports = createDocument;
