// Generated by CoffeeScript 1.3.3
var EventLoop, EventQueue, Interval, Timeout, ms;

ms = require("ms");

EventLoop = (function() {

  function EventLoop(browser) {
    this.browser = browser;
    this.active = null;
    this.expected = 0;
    this.running = false;
    this.listeners = [];
  }

  EventLoop.prototype.wait = function(waitDuration, waitFunction, callback) {
    var done, listener, timeout, timeoutTimer,
      _this = this;
    waitDuration = ms(waitDuration.toString()) || this.browser.waitDuration;
    timeoutTimer = global.setTimeout(function() {
      return done(null, true);
    }, waitDuration);
    timeout = Date.now() + waitDuration;
    done = function(error, timedOut) {
      clearTimeout(timeoutTimer);
      _this.listeners = _this.listeners.filter(function(l) {
        return l !== listener;
      });
      if (_this.listeners.length === 0) {
        _this.emit("done");
      }
      return callback(error, !!timedOut);
    };
    listener = function(event) {
      var completed, next, waitFor;
      switch (event) {
        case "tick":
          try {
            next = arguments[1];
            if (next >= timeout) {
              return done(null, true);
            } else if (waitFunction) {
              waitFor = Math.max(next - Date.now(), 0);
              completed = waitFunction(_this.active, waitFor);
              if (completed) {
                return done(null, false);
              }
            }
          } catch (error) {
            return done(error);
          }
          break;
        case "done":
          return done();
        case "error":
          return done(error = arguments[1]);
      }
    };
    this.listeners.push(listener);
    if (this.listeners.length === 1) {
      process.nextTick(function() {
        if (_this.active) {
          _this.active._eventQueue.resume();
          return _this.run();
        }
      });
    }
  };

  EventLoop.prototype.createEventQueue = function(window) {
    return new EventQueue(window);
  };

  EventLoop.prototype.setActiveWindow = function(window) {
    if (window === this.active) {
      return;
    }
    if (this.active) {
      this.active._eventQueue.suspend();
    }
    this.active = window;
    if (this.active) {
      this.active._eventQueue.resume();
      return this.run();
    }
  };

  EventLoop.prototype.expecting = function() {
    var done,
      _this = this;
    ++this.expected;
    done = function() {
      --_this.expected;
      _this.run();
    };
    return done;
  };

  EventLoop.prototype.run = function() {
    var _this = this;
    if (this.running) {
      return;
    }
    if (this.listeners.length === 0) {
      return;
    }
    if (!this.active) {
      this.emit("done");
      return;
    }
    this.running = true;
    process.nextTick(function() {
      var fn, time;
      _this.running = false;
      if (!_this.active) {
        _this.emit("done");
        return;
      }
      if (fn = _this.active._eventQueue.dequeue()) {
        try {
          fn();
          _this.emit("tick", 0);
          _this.run();
        } catch (error) {
          _this.emit("error", error);
        }
      } else if (_this.expected > 0) {
        return _this.emit("tick", 0);
      } else {
        time = _this.active._eventQueue.next();
        _this.emit("tick", time);
        return _this.run();
      }
    });
  };

  EventLoop.prototype.emit = function(event, value) {
    var listener, _i, _len, _ref, _results;
    this.browser.emit(event, value);
    _ref = this.listeners;
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      listener = _ref[_i];
      _results.push(listener(event, value));
    }
    return _results;
  };

  return EventLoop;

})();

EventQueue = (function() {

  function EventQueue(window) {
    this.window = window;
    this.browser = this.window.browser;
    this.eventLoop = this.browser._eventLoop;
    this.timers = [];
    this.queue = [];
    this.expecting = [];
  }

  EventQueue.prototype.destroy = function() {
    var expecting, timer, _i, _j, _len, _len1, _ref, _ref1;
    if (!this.queue) {
      return;
    }
    _ref = this.timers;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      timer = _ref[_i];
      if (timer) {
        timer.stop();
      }
    }
    _ref1 = this.expecting;
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      expecting = _ref1[_j];
      expecting();
    }
    return this.timers = this.queue = this.expecting = null;
  };

  EventQueue.prototype.enqueue = function(fn) {
    if (fn) {
      this.queue.push(fn);
      this.eventLoop.run();
    }
  };

  EventQueue.prototype.dequeue = function() {
    var fn, frame, _i, _len, _ref;
    if (!this.queue) {
      return;
    }
    if (fn = this.queue.shift()) {
      return fn;
    }
    _ref = this.window.frames;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      frame = _ref[_i];
      if (fn = frame._eventQueue.dequeue()) {
        return fn;
      }
    }
  };

  EventQueue.prototype.http = function(params, callback) {
    var done,
      _this = this;
    if (!this.queue) {
      return;
    }
    done = this.eventLoop.expecting();
    this.expecting.push(done);
    this.browser.resources._makeRequest(params, function(error, response) {
      if (_this.queue) {
        _this.enqueue(function() {
          return callback(error, response);
        });
        _this.expecting.splice(_this.expecting.indexOf(done), 1);
        return done();
      }
    });
  };

  EventQueue.prototype.onerror = function(error) {
    var event;
    this.window.console.error(error);
    this.browser.emit("error", error);
    event = this.window.document.createEvent("Event");
    event.initEvent("error", false, false);
    event.message = error.message;
    event.error = error;
    return this.window._dispatchEvent(this.window, event, true);
  };

  EventQueue.prototype.setTimeout = function(fn, delay) {
    var index, remove, timer,
      _this = this;
    if (delay == null) {
      delay = 0;
    }
    if (!fn) {
      return;
    }
    index = this.timers.length;
    remove = function() {
      return delete _this.timers[index];
    };
    timer = new Timeout(this, fn, delay, remove);
    this.timers[index] = timer;
    return index;
  };

  EventQueue.prototype.clearTimeout = function(index) {
    var timer;
    timer = this.timers[index];
    if (timer) {
      timer.stop();
    }
  };

  EventQueue.prototype.setInterval = function(fn, interval) {
    var index, remove, timer,
      _this = this;
    if (interval == null) {
      interval = 0;
    }
    if (!fn) {
      return;
    }
    index = this.timers.length;
    remove = function() {
      return delete _this.timers[index];
    };
    timer = new Interval(this, fn, interval, remove);
    this.timers[index] = timer;
    return index;
  };

  EventQueue.prototype.clearInterval = function(index) {
    var timer;
    timer = this.timers[index];
    if (timer) {
      timer.stop();
    }
  };

  EventQueue.prototype.suspend = function() {
    var timer, _i, _len, _ref, _results;
    _ref = this.timers;
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      timer = _ref[_i];
      if (timer) {
        _results.push(timer.suspend());
      } else {
        _results.push(void 0);
      }
    }
    return _results;
  };

  EventQueue.prototype.resume = function() {
    var timer, _i, _len, _ref, _results;
    _ref = this.timers;
    _results = [];
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      timer = _ref[_i];
      if (timer) {
        _results.push(timer.resume());
      } else {
        _results.push(void 0);
      }
    }
    return _results;
  };

  EventQueue.prototype.next = function() {
    var frame, frameNext, next, timer, _i, _j, _len, _len1, _ref, _ref1;
    next = Infinity;
    _ref = this.timers;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      timer = _ref[_i];
      if (timer && timer.next < next) {
        next = timer.next;
      }
    }
    _ref1 = this.window.frames;
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      frame = _ref1[_j];
      frameNext = frame._eventQueue.next();
      if (frameNext < next) {
        next = frameNext;
      }
    }
    return next;
  };

  return EventQueue;

})();

Timeout = (function() {

  function Timeout(queue, fn, delay, remove) {
    this.queue = queue;
    this.fn = fn;
    this.delay = delay;
    this.remove = remove;
    this.delay = Math.max(this.delay || 0, 0);
    this.resume();
  }

  Timeout.prototype.resume = function() {
    var fire,
      _this = this;
    if (this.handle) {
      return;
    }
    fire = function() {
      _this.queue.enqueue(function() {
        _this.queue.browser.emit("timeout", _this.fn, _this.delay);
        return _this.queue.window._evaluate(_this.fn);
      });
      return _this.remove();
    };
    this.handle = global.setTimeout(fire, this.delay);
    return this.next = Date.now() + this.delay;
  };

  Timeout.prototype.suspend = function() {
    global.clearTimeout(this.handle);
    return this.handle = null;
  };

  Timeout.prototype.stop = function() {
    this.stopped = true;
    global.clearTimeout(this.handle);
    return this.remove();
  };

  return Timeout;

})();

Interval = (function() {

  function Interval(queue, fn, interval, remove) {
    this.queue = queue;
    this.fn = fn;
    this.interval = interval;
    this.remove = remove;
    this.interval = Math.max(this.interval || 0);
    this.resume();
  }

  Interval.prototype.resume = function() {
    var fire,
      _this = this;
    if (this.handle) {
      return;
    }
    fire = function() {
      _this.queue.enqueue(function() {
        _this.queue.browser.emit("interval", _this.fn, _this.interval);
        return _this.queue.window._evaluate(_this.fn);
      });
      return _this.next = Date.now() + _this.interval;
    };
    this.handle = global.setInterval(fire, this.interval);
    return this.next = Date.now() + this.interval;
  };

  Interval.prototype.suspend = function() {
    global.clearInterval(this.handle);
    return this.handle = null;
  };

  Interval.prototype.stop = function() {
    global.clearInterval(this.handle);
    return this.remove();
  };

  return Interval;

})();

module.exports = EventLoop;
