// Generated by CoffeeScript 1.3.3
var File, HTML, Mime, Path, UploadedFile;

HTML = require("jsdom").dom.level3.html;

Path = require("path");

File = require("fs");

Mime = require("mime");

UploadedFile = function(filename) {
  var file;
  file = new String(Path.basename(filename));
  file.filename = filename;
  file.mime = Mime.lookup(filename);
  file.read = function() {
    return File.readFileSync(filename);
  };
  return file;
};

HTML.HTMLFormElement.prototype.submit = function(button) {
  var data, document, process,
    _this = this;
  document = this.ownerDocument;
  data = [];
  process = function(index) {
    var field, name, option, selected, value, _i, _len, _ref, _ref1;
    if (field = _this.elements.item(index)) {
      value = null;
      if (!field.getAttribute("disabled") && (name = field.getAttribute("name"))) {
        if (field.nodeName === "SELECT") {
          selected = [];
          _ref = field.options;
          for (_i = 0, _len = _ref.length; _i < _len; _i++) {
            option = _ref[_i];
            if (option.selected) {
              selected.push(option.value);
            }
          }
          if (field.multiple) {
            data.push([name, selected]);
          } else {
            if (selected.length > 0) {
              value = selected[0];
            } else {
              value = (_ref1 = field.options[0]) != null ? _ref1.value : void 0;
            }
            data.push([name, value]);
          }
        } else if (field.nodeName === "INPUT" && (field.type === "checkbox" || field.type === "radio")) {
          if (field.checked) {
            data.push([name, field.value || "1"]);
          }
        } else if (field.nodeName === "INPUT" && field.type === "file") {
          if (field.value) {
            data.push([name, UploadedFile(field.value)]);
          }
        } else if (field.nodeName === "TEXTAREA" || field.nodeName === "INPUT") {
          if (field.type !== "submit" && field.type !== "image") {
            data.push([name, field.value || ""]);
          }
        }
      }
      return process(index + 1);
    } else {
      if (button && button.name) {
        data.push([button.name, button.value]);
      }
      return document.window._submit({
        url: _this.getAttribute("action") || document.location.href,
        method: _this.getAttribute("method") || "GET",
        encoding: _this.getAttribute("enctype"),
        data: data,
        form: _this
      });
    }
  };
  return process(0);
};

HTML.HTMLFormElement.prototype.reset = function() {
  var field, option, _i, _len, _ref, _results;
  _ref = this.elements;
  _results = [];
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    field = _ref[_i];
    if (field.nodeName === "SELECT") {
      _results.push((function() {
        var _j, _len1, _ref1, _results1;
        _ref1 = field.options;
        _results1 = [];
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          option = _ref1[_j];
          _results1.push(option.selected = option._defaultSelected);
        }
        return _results1;
      })());
    } else if (field.nodeName === "INPUT" && (field.type === "checkbox" || field.type === "radio")) {
      _results.push(field.checked = !!field._defaultChecked);
    } else if (field.nodeName === "INPUT" || field.nodeName === "TEXTAREA") {
      _results.push(field.value = field._defaultValue);
    } else {
      _results.push(void 0);
    }
  }
  return _results;
};

HTML.HTMLFormElement.prototype._dispatchSubmitEvent = function(button) {
  var event;
  event = this.ownerDocument.createEvent("HTMLEvents");
  event.initEvent("submit", true, true);
  event._button = button;
  return this.ownerDocument.parentWindow._dispatchEvent(this, event, true);
};

HTML.HTMLFormElement.prototype._eventDefaults["submit"] = function(event) {
  return event.target.submit(event._button);
};

HTML.HTMLInputElement.prototype._eventDefaults = {
  click: function(event) {
    var change, form, input;
    input = event.target;
    change = function() {
      event = input.ownerDocument.createEvent("HTMLEvents");
      event.initEvent("change", true, true);
      return input.ownerDocument.parentWindow._dispatchEvent(input, event, true);
    };
    switch (input.type) {
      case "reset":
        if (form = input.form) {
          return form.reset();
        }
        break;
      case "submit":
      case "image":
        if (form = input.form) {
          return form._dispatchSubmitEvent(input);
        }
        break;
      case "checkbox":
        return change();
      case "radio":
        if (!input.getAttribute("readonly")) {
          input.checked = true;
          return change();
        }
    }
  }
};

HTML.HTMLInputElement.prototype.click = function() {
  var change, checked, click, original, radio, radios, _i, _j, _len, _len1,
    _this = this;
  this.focus();
  click = function() {
    var cancelled, event;
    event = _this.ownerDocument.createEvent("HTMLEvents");
    event.initEvent("click", true, true);
    cancelled = _this.ownerDocument.parentWindow._dispatchEvent(_this, event);
    return !cancelled;
  };
  change = function() {
    var event;
    event = _this.ownerDocument.createEvent("HTMLEvents");
    event.initEvent("change", true, true);
    return _this.ownerDocument.parentWindow._dispatchEvent(_this, event);
  };
  switch (this.type) {
    case "checkbox":
      if (!this.getAttribute("readonly")) {
        original = this.checked;
        this.checked = !this.checked;
        if (click()) {
          change();
        } else {
          this.checked = original;
        }
      }
      break;
    case "radio":
      if (!this.getAttribute("readonly")) {
        if (this.checked) {
          click();
        } else {
          radios = this.ownerDocument.querySelectorAll(":radio[name='" + (this.getAttribute("name")) + "']", this.form);
          checked = null;
          for (_i = 0, _len = radios.length; _i < _len; _i++) {
            radio = radios[_i];
            if (radio.checked) {
              checked = radio;
              radio.checked = false;
            }
          }
          this.checked = true;
          if (click()) {
            change();
          } else {
            this.checked = false;
            for (_j = 0, _len1 = radios.length; _j < _len1; _j++) {
              radio = radios[_j];
              radio.checked = radio === checked;
            }
          }
        }
      }
      break;
    default:
      click();
  }
};

HTML.HTMLButtonElement.prototype._eventDefaults = {
  click: function(event) {
    var button, form;
    button = event.target;
    if (button.getAttribute("disabled")) {

    } else {
      form = button.form;
      if (form) {
        return form._dispatchSubmitEvent(button);
      }
    }
  }
};

HTML.Document.prototype._elementBuilders["button"] = function(doc, s) {
  var button;
  button = new HTML.HTMLButtonElement(doc, s);
  button.type || (button.type = "submit");
  return button;
};
