// Generated by CoffeeScript 1.3.3
var Entry, HTML, History, URL, createHistory, createLocation, createWindow, hashChange, parentFrom;

createWindow = require("./window");

HTML = require("jsdom").dom.level3.html;

URL = require("url");

createHistory = function(browser, focus) {
  var history;
  history = new History(browser, focus);
  return history.open.bind(history);
};

parentFrom = function(window) {
  if (window.parent !== window.getGlobal()) {
    return window.parent;
  }
};

Entry = (function() {

  function Entry(window, url, pushState) {
    this.window = window;
    this.pushState = pushState;
    this.url = URL.format(url);
    this.next = this.prev = null;
  }

  Entry.prototype.destroy = function(options) {
    if (this.next) {
      this.next.destroy(options);
      this.next = null;
    }
    if (options && options.keepAlive === this.window) {
      return;
    }
    if (this.prev && this.prev.window === this.window) {
      return;
    }
    return this.window._destroy();
  };

  Entry.prototype.append = function(newEntry, options) {
    if (this.next) {
      this.next.destroy(options);
    }
    newEntry.prev = this;
    return this.next = newEntry;
  };

  return Entry;

})();

History = (function() {

  function History(browser, focus) {
    this.browser = browser;
    this.focus = focus;
    this.first = this.current = null;
  }

  History.prototype.open = function(_arg) {
    var name, opener, parent, url, window;
    name = _arg.name, opener = _arg.opener, parent = _arg.parent, url = _arg.url;
    window = createWindow({
      browser: this.browser,
      history: this,
      name: name,
      opener: opener,
      parent: parent,
      url: url
    });
    this.addEntry(window, url);
    return window;
  };

  History.prototype.destroy = function() {
    this.focus(null);
    if (this.first) {
      this.first.destroy();
      return this.first = this.current = null;
    }
  };

  History.prototype.addEntry = function(window, url, pushState) {
    var entry;
    url || (url = window.location.href);
    entry = new Entry(window, url, pushState);
    this.updateLocation(window, url);
    this.focus(window);
    if (this.current) {
      this.current.append(entry);
      return this.current = entry;
    } else {
      return this.current = this.first = entry;
    }
  };

  History.prototype.replaceEntry = function(window, url, pushState) {
    var entry;
    url || (url = window.location.href);
    entry = new Entry(window, url, pushState);
    this.updateLocation(window, url);
    this.focus(window);
    if (this.current === this.first) {
      if (this.current) {
        this.current.destroy({
          keepAlive: window
        });
      }
      return this.current = this.first = entry;
    } else {
      return this.current.prev.append(entry, {
        keepAlive: window
      });
    }
  };

  History.prototype.updateLocation = function(window, url) {
    var history;
    history = this;
    return Object.defineProperty(window, "location", {
      get: function() {
        return createLocation(history, url);
      },
      set: function(url) {
        return history.assign(url);
      },
      enumerable: true
    });
  };

  History.prototype.submit = function(_arg) {
    var data, encoding, method, newWindow, params, url, window;
    url = _arg.url, method = _arg.method, encoding = _arg.encoding, data = _arg.data;
    window = this.current.window;
    url = HTML.resourceLoader.resolve(window.document, url);
    params = {
      browser: this.browser,
      history: this,
      name: window.name,
      parent: parentFrom(window),
      url: url,
      method: method,
      encoding: encoding,
      data: data
    };
    newWindow = createWindow(params);
    return this.addEntry(newWindow, url);
  };

  History.prototype.__defineGetter__("url", function() {
    var _ref;
    return (_ref = this.current) != null ? _ref.url : void 0;
  });

  History.prototype.assign = function(url) {
    var event, name, window;
    if (this.current) {
      url = HTML.resourceLoader.resolve(this.current.window.document, url);
      name = this.current.window.name;
    }
    if (this.current && this.current.url === url) {
      return;
    }
    if (hashChange(this.current, url)) {
      window = this.current.window;
      this.addEntry(window, url);
      event = window.document.createEvent("HTMLEvents");
      event.initEvent("hashchange", true, false);
      window._dispatchEvent(window, event, true);
    } else {
      window = createWindow({
        browser: this.browser,
        history: this,
        name: name,
        url: url,
        parent: parentFrom(this.current.window)
      });
      this.addEntry(window, url);
    }
  };

  History.prototype.replace = function(url) {
    var event, name, window;
    url = URL.format(url);
    if (this.current) {
      url = HTML.resourceLoader.resolve(this.current.window.document, url);
      name = this.current.window.name;
    }
    if (this.current && this.current.url === url) {
      return;
    }
    if (hashChange(this.current, url)) {
      window = this.current.window;
      this.replaceEntry(window, url);
      event = window.document.createEvent("HTMLEvents");
      event.initEvent("hashchange", true, false);
      window._dispatchEvent(window, event, true);
    } else {
      window = createWindow({
        browser: this.browser,
        history: this,
        name: name,
        url: url,
        parent: parentFrom(this.current.window)
      });
      this.replaceEntry(window, url);
    }
  };

  History.prototype.reload = function() {
    var newWindow, url, window;
    if (window = this.current.window) {
      url = window.location.href;
      newWindow = createWindow({
        browser: this.browser,
        history: this,
        name: window.name,
        url: url,
        parent: parentFrom(window)
      });
      return this.replaceEntry(newWindow, url);
    }
  };

  History.prototype.go = function(amount) {
    var event, newHost, oldHost, was, window;
    was = this.current;
    while (amount > 0) {
      if (this.current.next) {
        this.current = this.current.next;
      }
      --amount;
    }
    while (amount < 0) {
      if (this.current.prev) {
        this.current = this.current.prev;
      }
      ++amount;
    }
    if (this.current && was && this.current !== was) {
      window = this.current.window;
      this.updateLocation(window, this.current.url);
      this.focus(window);
      if (this.current.pushState || was.pushState) {
        oldHost = URL.parse(was.url).host;
        newHost = URL.parse(this.current.url).host;
        if (oldHost === newHost) {
          event = window.document.createEvent("HTMLEvents");
          event.initEvent("popstate", false, false);
          event.state = this.current.pushState;
          window._dispatchEvent(window, event, true);
        }
      } else if (hashChange(was, this.current.url)) {
        event = window.document.createEvent("HTMLEvents");
        event.initEvent("hashchange", true, false);
        window._dispatchEvent(window, event, true);
      }
    }
  };

  History.prototype.__defineGetter__("length", function() {
    var entry, length;
    entry = this.first;
    length = 0;
    while (entry) {
      ++length;
      entry = entry.next;
    }
    return length;
  });

  History.prototype.pushState = function(state, title, url) {
    url || (url = this.current.window.location.href);
    url = HTML.resourceLoader.resolve(this.current.window.document, url);
    this.addEntry(this.current.window, url, state || {});
  };

  History.prototype.replaceState = function(state, title, url) {
    url || (url = this.current.window.location.href);
    url = HTML.resourceLoader.resolve(this.current.window.document, url);
    this.replaceEntry(this.current.window, url, state || {});
  };

  History.prototype.__defineGetter__("state", function() {
    if (this.current.pushState) {
      return this.current.pushState;
    }
  });

  return History;

})();

hashChange = function(entry, url) {
  if (!entry) {
    return false;
  }
  return /^https?:/i.test(entry.url) && entry.url.split("#")[0] === url.split("#")[0];
};

createLocation = function(history, url) {
  var location, prop, _fn, _i, _len, _ref,
    _this = this;
  location = new Object();
  Object.defineProperties(location, {
    assign: {
      value: function(url) {
        return history.assign(url);
      }
    },
    replace: {
      value: function(url) {
        return history.replace(url);
      }
    },
    reload: {
      value: function(force) {
        return history.reload();
      }
    },
    toString: {
      value: function() {
        return url;
      },
      enumerable: true
    },
    hostname: {
      get: function() {
        return URL.parse(url).hostname;
      },
      set: function(hostname) {
        var newUrl;
        newUrl = URL.parse(url);
        if (newUrl.port) {
          newUrl.host = "" + hostname + ":" + newUrl.port;
        } else {
          newUrl.host = hostname;
        }
        return history.assign(URL.format(newUrl));
      },
      enumerable: true
    },
    href: {
      get: function() {
        return url;
      },
      set: function(href) {
        return history.assign(URL.format(href));
      },
      enumerable: true
    }
  });
  _ref = ["hash", "host", "pathname", "port", "protocol", "search"];
  _fn = function(prop) {
    return Object.defineProperty(location, prop, {
      get: function() {
        return URL.parse(url)[prop] || "";
      },
      set: function(value) {
        var newUrl;
        newUrl = URL.parse(url);
        newUrl[prop] = value;
        return history.assign(URL.format(newUrl));
      },
      enumerable: true
    });
  };
  for (_i = 0, _len = _ref.length; _i < _len; _i++) {
    prop = _ref[_i];
    _fn(prop);
  }
  return location;
};

module.exports = createHistory;
