// Generated by CoffeeScript 1.3.3
var CoffeeScript, HTML, URL, addInlineScriptSupport, raise, setAttribute;

HTML = require("jsdom").dom.level3.html;

URL = require("url");

try {
  CoffeeScript = require("coffee-script");
  HTML.languageProcessors.coffeescript = function(element, code, filename) {
    return this.javascript(element, CoffeeScript.compile(code), filename);
  };
} catch (ex) {

}

HTML.languageProcessors.javascript = function(element, code, filename) {
  var cast, document, window;
  document = element.ownerDocument;
  window = document.window;
  try {
    return window._evaluate(code, filename);
  } catch (error) {
    if (!(error instanceof Error)) {
      cast = new Error(error.message);
      cast.stack = error.stack;
      error = cast;
    }
    return raise({
      element: element,
      location: filename,
      from: __filename,
      error: error
    });
  }
};

addInlineScriptSupport = function(document) {
  return document.addEventListener("DOMNodeInserted", function(event) {
    var element, loaded, window;
    element = event.target;
    if (element.tagName !== "SCRIPT") {
      return;
    }
    if (element.src) {
      return;
    }
    window = document.window;
    loaded = function(error, filename) {
      var code, language;
      language = HTML.languageProcessors[element.language];
      code = element.text;
      if (code && language) {
        return language(element, code, filename);
      }
    };
    HTML.resourceLoader.enqueue(element, loaded, document.location.href)();
  });
};

HTML.resourceLoader.load = function(element, href, callback) {
  var document, loaded, ownerImplementation, tagName, url, window;
  document = element.ownerDocument;
  window = document.parentWindow;
  ownerImplementation = document.implementation;
  tagName = element.tagName.toLowerCase();
  if (ownerImplementation.hasFeature("FetchExternalResources", tagName)) {
    loaded = function(response) {
      return callback.call(element, response.body, URL.parse(response.url).pathname);
    };
    url = HTML.resourceLoader.resolve(document, href);
    return window._eventQueue.http({
      url: url,
      target: element
    }, this.enqueue(element, loaded, url));
  }
};

setAttribute = HTML.Element.prototype.setAttribute;

HTML.Element.prototype.setAttribute = function(name, value) {
  var attr, wrapped;
  if (/^on.+/.test(name)) {
    wrapped = "if ((function() { " + value + " }).call(this,event) === false) event.preventDefault();";
    this[name] = function(event) {
      var window;
      if (this.run) {
        window = this;
      } else {
        window = this._ownerDocument.parentWindow;
      }
      try {
        window.event = event;
        return window.run(wrapped);
      } finally {
        window.event = null;
      }
    };
    if (this._ownerDocument) {
      attr = this._ownerDocument.createAttribute(name);
      attr.value = value;
      return this._attributes.setNamedItem(attr);
    }
  } else {
    return setAttribute.apply(this, arguments);
  }
};

raise = function(_arg) {
  var document, element, error, from, line, location, message, partial, scope, window, _i, _len, _ref;
  element = _arg.element, location = _arg.location, from = _arg.from, scope = _arg.scope, error = _arg.error;
  document = element.ownerDocument || element;
  window = document.parentWindow;
  message = scope ? "" + scope + ": " + error.message : error.message;
  location || (location = document.location.href);
  partial = [];
  if (error.stack) {
    _ref = error.stack.split("\n");
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      line = _ref[_i];
      if (~line.indexOf("contextify/lib/contextify.js")) {
        break;
      }
      partial.push(line);
    }
  }
  partial.push("    in " + location);
  error.stack = partial.join("\n");
  window._eventQueue.onerror(error);
};

module.exports = {
  raise: raise,
  addInlineScriptSupport: addInlineScriptSupport
};
