// Generated by CoffeeScript 1.3.3
var Console, EventSource, Events, File, HTML, History, JSDOM, Screen, URL, WebSocket, createDocument, createWindow, inContext, loadDocument;

Console = require("./console");

EventSource = require("eventsource");

History = require("./history");

JSDOM = require("jsdom");

WebSocket = require("ws");

URL = require("url");

createDocument = require("./document");

Events = JSDOM.dom.level3.events;

HTML = JSDOM.dom.level3.html;

inContext = null;

createWindow = function(_arg) {
  var browser, closed, data, document, encoding, eventQueue, global, history, method, name, opener, parent, url, window, windowHistory;
  browser = _arg.browser, data = _arg.data, encoding = _arg.encoding, history = _arg.history, method = _arg.method, name = _arg.name, opener = _arg.opener, parent = _arg.parent, url = _arg.url;
  name || (name = "");
  url || (url = "about:blank");
  window = JSDOM.createWindow(HTML);
  global = window.getGlobal();
  closed = false;
  Object.defineProperty(window, "browser", {
    value: browser,
    enumerable: true
  });
  document = createDocument(browser, window);
  Object.defineProperty(window, "document", {
    value: document,
    enumerable: true
  });
  Object.defineProperty(window, "name", {
    value: name,
    enumerable: true
  });
  if (parent) {
    Object.defineProperty(window, "parent", {
      value: parent,
      enumerable: true
    });
    Object.defineProperty(window, "top", {
      value: parent.top,
      enumerable: true
    });
  } else {
    Object.defineProperty(window, "parent", {
      value: global,
      enumerable: true
    });
    Object.defineProperty(window, "top", {
      value: global,
      enumerable: true
    });
  }
  Object.defineProperty(window, "opener", {
    value: opener && opener,
    enumerable: true
  });
  Object.defineProperty(window, "title", {
    get: function() {
      return document.title;
    },
    set: function(title) {
      return document.title = title;
    },
    enumerable: true
  });
  Object.defineProperty(window, "console", {
    value: new Console(browser),
    enumerable: true
  });
  Object.defineProperties(window.navigator, {
    cookieEnabled: {
      value: true
    },
    javaEnabled: {
      value: function() {
        return false;
      }
    },
    plugins: {
      value: []
    },
    userAgent: {
      value: browser.userAgent
    },
    vendor: {
      value: "Zombie Industries"
    }
  });
  browser._cookies.extend(window);
  browser._storages.extend(window);
  browser._interact.extend(window);
  browser._xhr.extend(window);
  Object.defineProperties(window, {
    File: {
      value: File
    },
    Event: {
      value: Events.Event
    },
    screen: {
      value: new Screen()
    },
    MouseEvent: {
      value: Events.MouseEvent
    },
    MutationEvent: {
      value: Events.MutationEvent
    },
    UIEvent: {
      value: Events.UIEvent
    }
  });
  window.atob = function(string) {
    return new Buffer(string, "base64").toString("utf8");
  };
  window.btoa = function(string) {
    return new Buffer(string, "utf8").toString("base64");
  };
  window.EventSource = function(url) {
    url = HTML.resourceLoader.resolve(document, url);
    window.setInterval((function() {}), 100);
    return new EventSource(url);
  };
  window.WebSocket = function(url, protocol) {
    var origin;
    url = HTML.resourceLoader.resolve(document, url);
    origin = "" + window.location.protocol + "//" + window.location.host;
    return new WebSocket(url, {
      origin: origin,
      protocol: protocol
    });
  };
  window.Image = function(width, height) {
    var img;
    img = new HTML.HTMLImageElement(window.document);
    img.width = width;
    img.height = height;
    return img;
  };
  window.resizeTo = function(width, height) {
    window.outerWidth = window.innerWidth = width;
    return window.outerHeight = window.innerHeight = height;
  };
  window.resizeBy = function(width, height) {
    return window.resizeTo(window.outerWidth + width, window.outerHeight + height);
  };
  window.postMessage = function(data, targetOrigin) {
    var event, origin;
    document = window.document;
    event = document.createEvent("MessageEvent");
    event.initEvent("message", false, false);
    event.data = data;
    event.source = inContext;
    origin = event.source.location;
    event.origin = URL.format({
      protocol: origin.protocol,
      host: origin.host
    });
    return window._dispatchEvent(window, event, true);
  };
  window._evaluate = function(code, filename) {
    var original, result, _ref;
    try {
      _ref = [inContext, window], original = _ref[0], inContext = _ref[1];
      inContext = window;
      if (typeof code === "string" || code instanceof String) {
        result = global.run(code, filename);
      } else if (code) {
        result = code.call(global);
      }
      browser.emit("evaluated", code, result);
      return result;
    } catch (error) {
      error.filename || (error.filename = filename);
      return browser.emit("error", error);
    } finally {
      inContext = original;
    }
  };
  window._dispatchEvent = function(target, event, async) {
    if (async == null) {
      async = false;
    }
    if (async) {
      window._eventQueue.enqueue(function() {
        return window._evaluate(function() {
          return target.dispatchEvent(event);
        });
      });
    } else {
      return window._evaluate(function() {
        return target.dispatchEvent(event);
      });
    }
  };
  window.onerror = function(event) {
    var error;
    error = event.error || new Error("Error loading script");
    return browser.emit("error", error);
  };
  eventQueue = browser._eventLoop.createEventQueue(window);
  Object.defineProperties(window, {
    _eventQueue: {
      value: eventQueue
    },
    setTimeout: {
      value: eventQueue.setTimeout.bind(eventQueue)
    },
    clearTimeout: {
      value: eventQueue.clearTimeout.bind(eventQueue)
    },
    setInterval: {
      value: eventQueue.setInterval.bind(eventQueue)
    },
    clearInterval: {
      value: eventQueue.clearInterval.bind(eventQueue)
    }
  });
  window.open = function(url, name, features) {
    url = url && HTML.resourceLoader.resolve(document, url);
    return browser.open({
      name: name,
      url: url,
      opener: window
    });
  };
  Object.defineProperty(window, "closed", {
    get: function() {
      return closed;
    },
    enumerable: true
  });
  window._destroy = function() {
    var frame, _i, _len, _ref;
    if (closed) {
      return;
    }
    closed = true;
    _ref = window.frames;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      frame = _ref[_i];
      frame.close();
    }
    eventQueue.destroy();
    window.document = null;
    window.dispose();
  };
  window.close = function() {
    if (parent || closed) {
      return;
    }
    if (inContext === opener || inContext === null) {
      browser.emit("closed", window);
      history.destroy();
      window._destroy();
    } else {
      browser.log("Scripts may not close windows that were not opened by script");
    }
  };
  history.updateLocation(window, url);
  windowHistory = {
    forward: history.go.bind(history, 1),
    back: history.go.bind(history, -1),
    go: history.go.bind(history),
    pushState: history.pushState.bind(history),
    replaceState: history.replaceState.bind(history)
  };
  Object.defineProperties(windowHistory, {
    length: {
      get: function() {
        return history.length;
      },
      enumerable: true
    },
    state: {
      get: function() {
        return history.state;
      },
      enumerable: true
    }
  });
  Object.defineProperties(window, {
    history: {
      value: windowHistory
    }
  });
  browser.emit("opened", window);
  window._submit = function(params) {
    browser.emit("submit", params.form, params.url);
    return history.submit(params);
  };
  loadDocument({
    document: document,
    history: history,
    url: url,
    method: method,
    encoding: encoding,
    data: data
  });
  return window;
};

loadDocument = function(_arg) {
  var browser, data, document, done, encoding, headers, history, method, pathname, protocol, referer, request, url, window, _ref;
  document = _arg.document, history = _arg.history, url = _arg.url, method = _arg.method, encoding = _arg.encoding, data = _arg.data;
  window = document.window;
  browser = window.browser;
  referer = history.url || browser.referer;
  done = function(error, url) {
    if (error) {
      return browser.emit("error", error);
    } else {
      if (url) {
        history.updateLocation(window, url);
      }
      return browser.emit("loaded", document);
    }
  };
  method = (method || "GET").toUpperCase();
  if (method === "POST") {
    headers = {
      "content-type": encoding || "application/x-www-form-urlencoded"
    };
  }
  _ref = URL.parse(url), protocol = _ref.protocol, pathname = _ref.pathname;
  switch (protocol) {
    case "about:":
      return done();
    case "javascript:":
      try {
        window._evaluate(pathname, "javascript:");
        return done();
      } catch (error) {
        return done(error);
      }
      break;
    case "http:":
    case "https:":
    case "file:":
      request = {
        url: url,
        method: (method || "GET").toUpperCase(),
        headers: headers || {},
        data: data,
        target: document
      };
      if (referer) {
        request.headers.referer = referer;
      }
      return window._eventQueue.http(request, function(error, response) {
        var contentLoaded, windowLoaded;
        if (error) {
          document.open();
          document.write(error.message || error);
          document.close();
          done(error);
          return;
        }
        windowLoaded = function(event) {
          document.removeEventListener("load", windowLoaded);
          return window._dispatchEvent(window, event, true);
        };
        document.addEventListener("load", windowLoaded);
        contentLoaded = function(event) {
          document.removeEventListener("DOMContentLoaded", contentLoaded);
          return window._dispatchEvent(window, event, true);
        };
        document.addEventListener("DOMContentLoaded", contentLoaded);
        document.open();
        document.write(response.body || "<html><body></body></html>");
        document.close();
        if (response.statusCode >= 400) {
          return done(new Error("Server returned status code " + response.statusCode + " from " + url));
        } else if (document.documentElement) {
          return done(null, response.url);
        } else {
          return done(new Error("Could not parse document at " + url));
        }
      });
    default:
      return done(new Error("Cannot load resource " + url + ", unsupported protocol"));
  }
};

Screen = (function() {

  function Screen() {
    this.top = this.left = 0;
    this.width = 1280;
    this.height = 800;
  }

  Screen.prototype.__defineGetter__("availLeft", function() {
    return 0;
  });

  Screen.prototype.__defineGetter__("availTop", function() {
    return 0;
  });

  Screen.prototype.__defineGetter__("availWidth", function() {
    return 1280;
  });

  Screen.prototype.__defineGetter__("availHeight", function() {
    return 800;
  });

  Screen.prototype.__defineGetter__("colorDepth", function() {
    return 24;
  });

  Screen.prototype.__defineGetter__("pixelDepth", function() {
    return 24;
  });

  return Screen;

})();

File = (function() {

  function File() {}

  return File;

})();

module.exports = createWindow;
