var fmt = require('fmt');
var awssum = require('awssum');
var amazon = awssum.load('amazon/amazon');
var SimpleDB = awssum.load('amazon/simpledb').SimpleDB;

var env             = process.env;
var accessKeyId     = env.ACCESS_KEY_ID;
var secretAccessKey = env.SECRET_ACCESS_KEY;
var awsAccountId    = env.AWS_ACCOUNT_ID;

var sdb = new SimpleDB({
    'accessKeyId'     : accessKeyId,
    'secretAccessKey' : secretAccessKey,
    // 'awsAccountId'    : awsAccountId, // optional
    'region'          : amazon.US_EAST_1
});

fmt.field('Region', sdb.region() );
fmt.field('EndPoint', sdb.host() );
fmt.field('AccessKeyId', sdb.accessKeyId().substr(0, 3) + '...' );
fmt.field('SecretAccessKey', sdb.secretAccessKey().substr(0, 3) + '...' );
fmt.field('AwsAccountId', sdb.awsAccountId() );

sdb.ListDomains({}, function(err, data) {
    fmt.msg('\nlist domains - expecting success');
    fmt.dump(err, 'Error');
    fmt.dump(data, 'Data');
});

sdb.ListDomains({ MaxNumberOfDomains : 1 }, function(err, data) {
    fmt.msg('\nlist domains (max=1) - expecting success');
    fmt.dump(err, 'Error');
    fmt.dump(data, 'Data');

    var token;

    if ( err ) {
        fmt.msg('\nNot getting next set of domains due to an error.');
    }
    else {
        token = data.Body.ListDomainsResponse.ListDomainsResult.NextToken;
        sdb.ListDomains({ NextToken : token }, function(err, data) {
            fmt.msg('\nlisting next set of domains (token=' + token + ' ) - expecting success');
            fmt.dump(err, 'Error');
            fmt.dump(data, 'Data');
        });
    }
});
