// Generated by CoffeeScript 1.3.3
var HTML, Path, URL, createHistory, createSizzle, descendantOf, descendants, element, sizzle, _i, _j, _len, _len1, _ref, _ref1;

createHistory = require("./history");

Path = require("path");

sizzle = Path.resolve(require.resolve("jsdom"), "../jsdom/selectors/sizzle");

createSizzle = require(sizzle);

HTML = require("jsdom").dom.level3.html;

URL = require("url");

HTML.HTMLElement.prototype.__defineGetter__("offsetLeft", function() {
  return 0;
});

HTML.HTMLElement.prototype.__defineGetter__("offsetTop", function() {
  return 0;
});

HTML.Element.prototype.getAttribute = function(name) {
  var attribute;
  attribute = this._attributes.getNamedItem(name);
  return (attribute != null ? attribute.value : void 0) || null;
};

HTML.HTMLAnchorElement.prototype.__defineGetter__("href", function() {
  return HTML.resourceLoader.resolve(this._ownerDocument, this.getAttribute('href') || "");
});

HTML.HTMLLinkElement.prototype.__defineGetter__("href", function() {
  return HTML.resourceLoader.resolve(this._ownerDocument, this.getAttribute('href') || "");
});

HTML.HTMLElement.prototype.__defineGetter__("id", function() {
  return this.getAttribute("id") || "";
});

_ref = [HTML.HTMLFormElement, HTML.HTMLMenuElement, HTML.HTMLSelectElement, HTML.HTMLInputElement, HTML.HTMLTextAreaElement, HTML.HTMLButtonElement, HTML.HTMLAnchorElement, HTML.HTMLImageElement, HTML.HTMLObjectElement, HTML.HTMLParamElement, HTML.HTMLAppletElement, HTML.HTMLMapElement, HTML.HTMLFrameElement, HTML.HTMLIFrameElement];
for (_i = 0, _len = _ref.length; _i < _len; _i++) {
  element = _ref[_i];
  element.prototype.__defineGetter__("name", function() {
    return this.getAttribute("name") || "";
  });
}

_ref1 = [HTML.HTMLInputElement, HTML.HTMLButtonElement, HTML.HTMLParamElement];
for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
  element = _ref1[_j];
  element.prototype.__defineGetter__("value", function() {
    return this.getAttribute("value") || "";
  });
}

HTML.HTMLAnchorElement.prototype._eventDefaults = {
  click: function(event) {
    var anchor, browser, window;
    anchor = event.target;
    if (!anchor.href) {
      return;
    }
    window = anchor.ownerDocument.window;
    browser = window.browser;
    switch (anchor.target || "_self") {
      case "_self":
        return window.location = anchor.href;
      case "_parent":
        return window.parent.location = anchor.href;
      case "_top":
        return window.top.location = anchor.href;
      default:
        return browser.tabs.open({
          name: anchor.target,
          url: anchor.href
        });
    }
  }
};

HTML.Document.prototype._elementBuilders["iframe"] = function(document, tag) {
  var create, iframe, parent, window;
  parent = document.window;
  iframe = new HTML.HTMLIFrameElement(document, tag);
  Object.defineProperties(iframe, {
    contentWindow: {
      get: function() {
        return window || create();
      }
    },
    contentDocument: {
      get: function() {
        return (window || create()).document;
      }
    }
  });
  window = null;
  create = function(url) {
    var focus, open;
    focus = function(active) {
      return window = active;
    };
    open = createHistory(parent.browser, focus);
    return window = open({
      name: iframe.name,
      parent: parent,
      url: url
    });
  };
  iframe.setAttribute = function(name, value) {
    var url;
    if (name === "src" && value) {
      url = HTML.resourceLoader.resolve(parent.document, value);
      if (window) {
        window.location = url;
      } else {
        create(url);
      }
      window.addEventListener("load", function() {
        var onload;
        onload = document.createEvent("HTMLEvents");
        onload.initEvent("load", true, false);
        return parent._dispatchEvent(iframe, onload, true);
      });
      return HTML.HTMLElement.prototype.setAttribute.call(this, name, value);
    } else {
      return HTML.HTMLFrameElement.prototype.setAttribute.call(this, name, value);
    }
  };
  return iframe;
};

Object.defineProperty(HTML.CSSStyleDeclaration.prototype, "opacity", {
  get: function() {
    return this._opacity || "";
  },
  set: function(opacity) {
    if (opacity) {
      opacity = parseFloat(opacity);
      if (!isNaN(opacity)) {
        return this._opacity = opacity.toString();
      }
    } else {
      return delete this._opacity;
    }
  }
});

["height", "width"].forEach(function(prop) {
  var client, internal, offset;
  internal = "_" + prop;
  client = "client" + (prop[0].toUpperCase()) + (prop.slice(1));
  offset = "offset" + (prop[0].toUpperCase()) + (prop.slice(1));
  Object.defineProperty(HTML.CSSStyleDeclaration.prototype, prop, {
    get: function() {
      return this[internal] || "";
    },
    set: function(value) {
      if (/^\d+px$/.test(value)) {
        return this[internal] = value;
      } else if (!value) {
        return delete this[internal];
      }
    }
  });
  Object.defineProperty(HTML.HTMLElement.prototype, client, {
    get: function() {
      return parseInt(this[internal] || 100);
    }
  });
  return Object.defineProperty(HTML.HTMLElement.prototype, offset, {
    get: function() {
      return parseInt(this[internal] || 100);
    }
  });
});

HTML.Node.prototype.__defineGetter__("textContent", function() {
  if (this.nodeType === HTML.Node.TEXT_NODE || this.nodeType === HTML.Node.COMMENT_NODE || this.nodeType === HTML.Node.ATTRIBUTE_NODE || this.nodeType === HTML.Node.CDATA_SECTION_NODE) {
    return this.nodeValue;
  } else if (this.nodeType === HTML.Node.ELEMENT_NODE || this.nodeType === HTML.Node.DOCUMENT_FRAGMENT_NODE) {
    return this.childNodes.filter(function(node) {
      return node.nodeType === HTML.Node.TEXT_NODE || node.nodeType === HTML.Node.ELEMENT_NODE || node.nodeType === HTML.Node.CDATA_SECTION_NODE;
    }).map(function(node) {
      return node.textContent;
    }).join("");
  } else {
    return null;
  }
});

HTML.NodeList.prototype.update = function() {
  var i, name, node, nodes, _k, _l, _len2, _ref2, _ref3;
  if (this._element && this._version < this._element._version) {
    for (i = _k = 0, _ref2 = this._length; 0 <= _ref2 ? _k <= _ref2 : _k >= _ref2; i = 0 <= _ref2 ? ++_k : --_k) {
      delete this[i];
    }
    if (this._names) {
      _ref3 = this._names;
      for (_l = 0, _len2 = _ref3.length; _l < _len2; _l++) {
        name = _ref3[_l];
        delete this[name];
      }
    }
    nodes = this._snapshot = this._query();
    this._length = nodes.length;
    this._names = [];
    for (i in nodes) {
      node = nodes[i];
      this[i] = node;
      if (name = node.name) {
        this._names.push(name);
        this[node.name] = node;
      }
    }
    this._version = this._element._version;
  }
  return this._snapshot;
};

HTML.Node.prototype.contains = function(otherNode) {
  return !!(this.compareDocumentPosition(otherNode) & 16);
};

HTML.HTMLDocument.prototype.querySelector = function(selector) {
  this._sizzle || (this._sizzle = createSizzle(this));
  return this._sizzle(selector, this)[0];
};

HTML.HTMLDocument.prototype.querySelectorAll = function(selector) {
  this._sizzle || (this._sizzle = createSizzle(this));
  return new HTML.NodeList(this._sizzle(selector, this));
};

descendantOf = function(element, context) {
  var parent;
  parent = element.parentNode;
  if (parent) {
    return parent === context || descendantOf(parent, context);
  } else {
    return false;
  }
};

descendants = function(element, selector) {
  var document, parent;
  document = element.ownerDocument;
  document._sizzle || (document._sizzle = createSizzle(document));
  if (!element.parentNode) {
    parent = element.ownerDocument.createElement("div");
    parent.appendChild(element);
    element = parent;
  }
  return document._sizzle(selector, element.parentNode || element).filter(function(node) {
    return descendantOf(node, element);
  });
};

HTML.Element.prototype.querySelector = function(selector) {
  return descendants(this, selector)[0];
};

HTML.Element.prototype.querySelectorAll = function(selector) {
  return new HTML.NodeList(descendants(this, selector));
};
