// Generated by CoffeeScript 1.3.3
var FS, HTTP, HTTPRequest, HTTPResponse, HTTPS, Path, QS, Request, Resource, Resources, STATUS, URL, indent, inspect, partial,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

inspect = require("util").inspect;

HTTP = require("http");

HTTPS = require("https");

FS = require("fs");

Path = require("path");

QS = require("querystring");

Request = require("request");

URL = require("url");

partial = function(text, length) {
  if (length == null) {
    length = 250;
  }
  if (!text) {
    return "";
  }
  if (text.length <= length) {
    return text;
  }
  return text.substring(0, length - 3) + "...";
};

indent = function(text) {
  return text.toString().split("\n").map(function(l) {
    return "  " + l;
  }).join("\n");
};

Resource = (function() {

  function Resource(request) {
    this.request = request;
    this.request.resource = this;
    this.redirects = 0;
    this.start = new Date().getTime();
    this.time = 0;
  }

  Resource.prototype.__defineGetter__("size", function() {
    var _ref;
    return ((_ref = this.response) != null ? _ref.body.length : void 0) || 0;
  });

  Resource.prototype.__defineGetter__("url", function() {
    var _ref;
    return ((_ref = this.response) != null ? _ref.url : void 0) || this.request.url;
  });

  Resource.prototype.__defineGetter__("response", function() {
    return this._response;
  });

  Resource.prototype.__defineSetter__("response", function(response) {
    this.time = new Date().getTime() - this.start;
    response.resource = this;
    return this._response = response;
  });

  Resource.prototype.toString = function() {
    return "URL:      " + this.url + "\nTime:     " + this.time + "ms\nSize:     " + (this.size / 1024) + "kb\nRequest:\n" + (indent(this.request)) + "\nResponse:\n" + (indent(this.response)) + "\n";
  };

  return Resource;

})();

HTTPRequest = (function() {

  function HTTPRequest(method, url, headers, body) {
    this.method = method;
    this.headers = headers;
    this.body = body;
    this.url = URL.format(url);
  }

  HTTPRequest.prototype.toString = function() {
    return "" + (inspect(this.headers)) + "\n" + (partial(this.body));
  };

  return HTTPRequest;

})();

HTTPResponse = (function() {

  function HTTPResponse(url, statusCode, headers, body) {
    this.statusCode = statusCode;
    this.headers = headers;
    this.body = body;
    this.url = URL.format(url);
  }

  HTTPResponse.prototype.__defineGetter__("statusText", function() {
    return STATUS[this.statusCode];
  });

  HTTPResponse.prototype.__defineGetter__("redirected", function() {
    return !!this.resource.redirects;
  });

  HTTPResponse.prototype.toString = function() {
    return "" + this.statusCode + " " + this.statusText + "\n" + (inspect(this.headers)) + "\n" + (partial(this.body));
  };

  return HTTPResponse;

})();

Resources = (function(_super) {
  var stringify, stringifyPrimitive, typeOf;

  __extends(Resources, _super);

  function Resources(_browser) {
    this._browser = _browser;
  }

  Resources.prototype.__defineGetter__("first", function() {
    return this[0];
  });

  Resources.prototype.__defineGetter__("last", function() {
    return this[this.length - 1];
  });

  Resources.prototype.clear = function() {
    return this.length = 0;
  };

  Resources.prototype.dump = function() {
    process.stdout.write(this.toString());
    return process.stdout.write("\n");
  };

  Resources.prototype.toString = function() {
    return this.map(function(resource) {
      return resource.toString();
    }).join("\n");
  };

  Resources.prototype._makeRequest = function(_arg, callback) {
    var binary, body, boundary, browser, content, cookies, credentials, data, disp, field, headers, jar, method, multipart, name, params, resource, target, url, value, _i, _len, _ref,
      _this = this;
    method = _arg.method, url = _arg.url, data = _arg.data, headers = _arg.headers, resource = _arg.resource, target = _arg.target;
    browser = this._browser;
    url = url.replace(/^file:\/{1,3}/, "file:///");
    url = URL.parse(url);
    method = (method || "GET").toUpperCase();
    headers = headers ? JSON.parse(JSON.stringify(headers)) : {};
    headers["User-Agent"] = browser.userAgent;
    headers["Accept-Encoding"] = "identity";
    if (method === "GET" || method === "HEAD") {
      if (data) {
        url.search = "?" + stringify(data);
      }
    } else {
      switch (headers["content-type"]) {
        case "multipart/form-data":
          if (Object.keys(data).length > 0) {
            boundary = "" + (new Date().getTime()) + (Math.random());
            headers["content-type"] += "; boundary=" + boundary;
          } else {
            headers["content-type"] = "text/plain;charset=UTF-8";
          }
          break;
        case "application/x-www-form-urlencoded":
          data = stringify(data);
          if (!headers["transfer-encoding"]) {
            headers["content-length"] || (headers["content-length"] = data.length);
          }
          break;
        default:
          headers["content-type"] || (headers["content-type"] = "text/plain;charset=UTF-8");
      }
    }
    headers["Host"] = url.host;
    credentials = this._browser.authenticate(url.host, false);
    if (credentials) {
      credentials.apply(headers);
    }
    if (!(url.pathname && url.pathname[0] === "/")) {
      url.pathname = "/" + (url.pathname || "");
    }
    if (!resource) {
      resource = new Resource(new HTTPRequest(method, url, headers, null));
      this.push(resource);
      this._browser.emit("request", resource.request, target);
    }
    if (method === "PUT" || method === "POST") {
      switch (headers["content-type"].split(";")[0]) {
        case "application/x-www-form-urlencoded":
          body = data;
          break;
        case "multipart/form-data":
          multipart = [];
          for (_i = 0, _len = data.length; _i < _len; _i++) {
            field = data[_i];
            name = field[0], content = field[1];
            disp = "form-data; name=\"" + name + "\"";
            if (content.read) {
              binary = content.read();
              multipart.push({
                "Content-Disposition": "" + disp + "; filename=\"" + content + "\"",
                "Content-Type": content.mime || "application/octet-stream",
                "Content-Length": binary.length,
                body: binary
              });
            } else {
              multipart.push({
                "Content-Disposition": disp,
                "Content-Type": "text/plain",
                "Content-Transfer-Encoding": "utf8",
                "Content-Length": content.length,
                body: content
              });
            }
          }
          break;
        default:
          body = (data || "").toString();
      }
    } else {
      delete headers["content-type"];
      delete headers["content-length"];
      delete headers["content-transfer-encoding"];
    }
    cookies = browser.cookies(url.hostname, url.pathname);
    cookies.addHeader(headers);
    jar = Request.jar();
    if (browser.headers) {
      _ref = browser.headers;
      for (name in _ref) {
        value = _ref[name];
        headers[name] = value;
      }
    }
    params = {
      method: method,
      url: url,
      headers: headers,
      body: body,
      multipart: multipart,
      proxy: browser.proxy,
      jar: jar,
      followRedirect: false
    };
    if (url.protocol === "file:") {
      if (method === "GET") {
        FS.readFile(Path.normalize(url.pathname), function(error, data) {
          if (error) {
            return callback(error);
          } else {
            resource.response = new HTTPResponse(url, 200, {}, String(data));
            _this._browser.emit("response", resource.response, target);
            return callback(null, resource.response);
          }
        });
      } else {
        callback(new Error("Cannot " + method + " a file: URL"));
      }
      return;
    }
    return Request(params, function(error, response) {
      var cookie, redirect, _j, _len1, _ref1;
      if (error) {
        callback(error);
        return;
      }
      _ref1 = jar.cookies;
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        cookie = _ref1[_j];
        cookies.update(cookie.str);
      }
      switch (response.statusCode) {
        case 301:
        case 307:
          if (method === "GET" || method === "HEAD") {
            redirect = URL.resolve(url, response.headers.location);
          }
          break;
        case 302:
        case 303:
          redirect = URL.resolve(url, response.headers.location);
          if (!(method === "GET" || method === "HEAD")) {
            method = "GET";
          }
      }
      if (redirect) {
        ++resource.redirects;
        if (resource.redirects > browser.maxRedirects) {
          callback(new Error("More than " + browser.maxRedirects + " redirects, giving up"));
          return;
        }
        resource.response = new HTTPResponse(redirect, response.statusCode, response.headers, response.body);
        _this._browser.emit("redirect", resource.response, target);
        headers.referer = URL.format(url);
        return _this._makeRequest({
          method: method,
          url: redirect,
          headers: headers,
          resource: resource,
          target: target
        }, callback);
      } else {
        resource.response = new HTTPResponse(url, response.statusCode, response.headers, response.body);
        _this._browser.emit("response", resource.response, target);
        return callback(null, resource.response);
      }
    });
  };

  typeOf = function(object) {
    return Object.prototype.toString.call(object);
  };

  stringifyPrimitive = function(v) {
    var _ref;
    switch (typeOf(v)) {
      case '[object Boolean]':
        return v != null ? v : {
          'true': 'false'
        };
      case '[object Number]':
        return (_ref = isFinite(v)) != null ? _ref : {
          v: ''
        };
      case '[object String]':
        return v;
      default:
        return '';
    }
  };

  stringify = function(object) {
    if (!object.map) {
      return object.toString();
    }
    return object.map(function(k) {
      if (Array.isArray(k[1])) {
        return k[1].map(function(v) {
          return QS.escape(stringifyPrimitive(k[0])) + "=" + QS.escape(stringifyPrimitive(v));
        }).join("&");
      } else {
        return QS.escape(stringifyPrimitive(k[0])) + "=" + QS.escape(stringifyPrimitive(k[1]));
      }
    }).join("&");
  };

  return Resources;

})(Array);

STATUS = {
  100: "Continue",
  101: "Switching Protocols",
  200: "OK",
  201: "Created",
  202: "Accepted",
  203: "Non-Authoritative",
  204: "No Content",
  205: "Reset Content",
  206: "Partial Content",
  300: "Multiple Choices",
  301: "Moved Permanently",
  302: "Found",
  303: "See Other",
  304: "Not Modified",
  305: "Use Proxy",
  307: "Temporary Redirect",
  400: "Bad Request",
  401: "Unauthorized",
  402: "Payment Required",
  403: "Forbidden",
  404: "Not Found",
  405: "Method Not Allowed",
  406: "Not Acceptable",
  407: "Proxy Authentication Required",
  408: "Request Timeout",
  409: "Conflict",
  410: "Gone",
  411: "Length Required",
  412: "Precondition Failed",
  413: "Request Entity Too Large",
  414: "Request-URI Too Long",
  415: "Unsupported Media Type",
  416: "Requested Range Not Satisfiable",
  417: "Expectation Failed",
  500: "Internal Server Error",
  501: "Not Implemented",
  502: "Bad Gateway",
  503: "Service Unavailable",
  504: "Gateway Timeout",
  505: "HTTP Version Not Supported"
};

module.exports = Resources;
