// Generated by CoffeeScript 1.3.3
var createHistory, createTabs;

createHistory = require("./history");

createTabs = function(browser) {
  var current, tabs;
  tabs = [];
  current = null;
  Object.defineProperties(tabs, {
    current: {
      get: function() {
        return current;
      },
      set: function(window) {
        window = tabs.find(window) || window;
        if (!~tabs.indexOf(window)) {
          return;
        }
        if (window && window !== current) {
          if (current) {
            browser.emit("inactive", current);
          }
          current = window;
          browser.emit("active", current);
        }
      }
    },
    open: {
      value: function(options) {
        var active, focus, name, open, opener, url, window;
        if (options == null) {
          options = {};
        }
        name = options.name, opener = options.opener, url = options.url;
        if (name && (window = this.find(name.toString()))) {
          tabs.current = window;
          if (url) {
            window.location = url;
          }
          return current;
        } else {
          if (name === "_blank" || !name) {
            name = "";
          }
          active = null;
          focus = function(window) {
            var index;
            if (window && window !== active) {
              index = tabs.indexOf(active);
              if (~index) {
                tabs[index] = window;
              }
              if (tabs.current === active) {
                tabs.current = window;
              }
              active = window;
            }
            return browser._eventLoop.setActiveWindow(window);
          };
          open = createHistory(browser, focus);
          window = open({
            name: name,
            opener: opener,
            url: url
          });
          this.push(window);
          if (name && (Object.propertyIsEnumerable(name) || !this[name])) {
            this[name] = window;
          }
          active = window;
          tabs.current = window;
          return window;
        }
      }
    },
    index: {
      get: function() {
        return this.indexOf(current);
      }
    },
    find: {
      value: function(name) {
        var window, _i, _len;
        if (tabs.propertyIsEnumerable(name)) {
          return this[name];
        }
        for (_i = 0, _len = this.length; _i < _len; _i++) {
          window = this[_i];
          if (window.name === name) {
            return window;
          }
        }
        return null;
      }
    },
    close: {
      value: function(window) {
        if (arguments.length === 0) {
          window = current;
        } else {
          window = this.find(window) || window;
        }
        if (~this.indexOf(window)) {
          window.close();
        }
      }
    },
    closeAll: {
      value: function() {
        var window, windows, _i, _len, _results;
        windows = this.slice(0);
        _results = [];
        for (_i = 0, _len = windows.length; _i < _len; _i++) {
          window = windows[_i];
          if (window.close) {
            _results.push(window.close());
          } else {
            _results.push(void 0);
          }
        }
        return _results;
      }
    }
  });
  browser.on("closed", function(window) {
    var index;
    index = tabs.indexOf(window);
    if (!~index) {
      return;
    }
    browser.emit("inactive", window);
    tabs.splice(index, 1);
    if (window === current) {
      current = tabs[index - 1] || tabs[0];
      if (current) {
        return browser.emit("active", current);
      }
    }
  });
  return tabs;
};

module.exports = createTabs;
