// Generated by CoffeeScript 1.3.3
var ALIASES, BCat, COMMANDS, exec, http, spawn, _ref;

_ref = require("child_process"), exec = _ref.exec, spawn = _ref.spawn;

http = require("http");

COMMANDS = {
  "Darwin": {
    "default": "open",
    "safari": "open -a Safari",
    "firefox": "open -a Firefox",
    "chrome": "open -a Google\\ Chrome",
    "chromium": "open -a Chromium",
    "opera": "open -a Opera",
    "curl": "curl -s"
  },
  "X11": {
    "default": "xdg-open",
    "firefox": "firefox",
    "chrome": "google-chrome",
    "chromium": "chromium",
    "mozilla": "mozilla",
    "epiphany": "epiphany",
    "curl": "curl -s"
  }
};

ALIASES = {
  "google-chrome": "chrome",
  "google chrome": "chrome",
  "gnome": "epiphany"
};

BCat = (function() {

  function BCat() {}

  BCat.prototype.open = function(browser, port) {
    return exec("uname", function(err, stdout) {
      var cmd, command, env;
      if (err) {
        throw new Error("Sorry, I don't support your operating system");
      }
      if (/Darwin/.test(stdout)) {
        env = "Darwin";
      } else if (/(Linux|BSD)/.test(stdout)) {
        env = "X11";
      } else {
        env = "X11";
      }
      browser = ALIASES[browser] || browser || "default";
      command = COMMANDS[env][browser];
      if (!command) {
        throw new Error("Sorry, don't know how to run " + browser);
      }
      cmd = spawn(command, ["http://localhost:" + port + "/"]);
      return cmd.stderr.on("data", function(data) {
        return process.stdout.write(data);
      });
    });
  };

  BCat.prototype.serve = function(input, port) {
    var server;
    if (input.setEncoding && input.pause) {
      input.setEncoding("utf8");
      input.pause();
    }
    server = http.createServer(function(req, res) {
      res.writeHead(200, {
        "Content-Type": "text/html"
      });
      if (input.resume && input.on) {
        input.resume();
        input.on("data", function(chunk) {
          return res.write(chunk, "utf8");
        });
        return input.on("end", function() {
          res.end();
          server.close();
          return process.exit(0);
        });
      } else {
        res.write(input, "utf8");
        res.end();
        server.close();
        return process.exit(0);
      }
    });
    return server.listen(port);
  };

  return BCat;

})();

exports.bcat = function(input, port, browser) {
  var bcat;
  if (port == null) {
    port = 8091;
  }
  bcat = new BCat;
  input || (input = process.openStdin());
  bcat.serve(input, port);
  process.stdout.write("open your browser on http://127.0.0.1:" + port + "/\n\n");
  return bcat.open(browser, port);
};
