// Generated by CoffeeScript 1.3.3
var BROWSER_OPTIONS, Browser, Cache, Cookies, Credentials, EventEmitter, EventLoop, FS, GLOBAL_OPTIONS, HTML, HTML5, Interact, JSDOM, MOUSE_EVENT_NAMES, Mime, PACKAGE, Path, Q, Resources, Storages, URL, VERSION, XHR, createTabs, deprecated, format, ms,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

require("./jsdom_patches");

require("./forms");

require("./xpath");

createTabs = require("./tabs");

deprecated = require("./helpers").deprecated;

Cache = require("./cache");

Cookies = require("./cookies");

EventEmitter = require("events").EventEmitter;

EventLoop = require("./eventloop");

format = require("util").format;

FS = require("fs");

HTML5 = require("html5").HTML5;

Interact = require("./interact");

JSDOM = require("jsdom");

Mime = require("mime");

ms = require("ms");

Q = require("q");

Path = require("path");

Resources = require("./resources");

Storages = require("./storage");

URL = require("url");

XHR = require("./xhr");

BROWSER_OPTIONS = ["debug", "headers", "htmlParser", "loadCSS", "waitDuration", "proxy", "referer", "runScripts", "silent", "site", "userAgent", "maxRedirects"];

GLOBAL_OPTIONS = ["debug", "headers", "htmlParser", "loadCSS", "waitDuration", "proxy", "runScripts", "silent", "site", "userAgent", "maxRedirects"];

PACKAGE = JSON.parse(require("fs").readFileSync(__dirname + "/../../package.json"));

VERSION = PACKAGE.version;

HTML = JSDOM.dom.level3.html;

MOUSE_EVENT_NAMES = ["mousedown", "mousemove", "mouseup"];

Browser = (function(_super) {

  __extends(Browser, _super);

  function Browser(options) {
    var active, browser, name, _i, _len;
    if (options == null) {
      options = {};
    }
    browser = this;
    this.cache = new Cache();
    this._cookies = new Cookies();
    this._storages = new Storages();
    this._interact = Interact.use(this);
    this._xhr = XHR.use();
    Object.defineProperty(this, "tabs", {
      value: createTabs(this)
    });
    this._eventLoop = new EventLoop(this);
    active = null;
    this.on("error", function(error) {
      browser.errors.push(error);
      browser.log(error.message, error.stack);
      return Browser.events.emit("error", error);
    });
    this.on("console", function(level, message) {
      return Browser.events.emit("console", level, message);
    });
    this.on("log", function(message) {
      if (browser.debug) {
        process.stdout.write("Zombie: " + message + "\n");
      }
      return Browser.events.emit("log", message);
    });
    this.on("active", function(window) {
      var element, onfocus;
      if (active === window) {
        return;
      }
      active = window;
      onfocus = window.document.createEvent("HTMLEvents");
      onfocus.initEvent("focus", false, false);
      window._dispatchEvent(window, onfocus, true);
      if (element = window.document.activeElement) {
        onfocus = window.document.createEvent("HTMLEvents");
        onfocus.initEvent("focus", false, false);
        return window._dispatchEvent(element, onfocus, true);
      }
    });
    this.on("inactive", function(window) {
      var element, onblur;
      if (active !== window) {
        return;
      }
      active = null;
      if (element = window.document.activeElement) {
        onblur = window.document.createEvent("HTMLEvents");
        onblur.initEvent("blur", false, false);
        window._dispatchEvent(element, onblur, true);
      }
      onblur = window.document.createEvent("HTMLEvents");
      onblur.initEvent("blur", false, false);
      return window._dispatchEvent(window, onblur, true);
    });
    this.on("closed", function(window) {
      return browser.log("Closed window", window.location.href, window.name || "un-named");
    });
    this.on("opened", function(window) {
      return browser.log("Opened window", window.location.href, window.name || "un-named");
    });
    this.on("loaded", function(document) {
      return browser.log("Loaded document", document.location.href);
    });
    this.on("done", function(timedOut) {
      if (timedOut) {
        return browser.log("Event loop timed out");
      } else {
        return browser.log("Event loop is empty");
      }
    });
    this.on("timeout", function(fn, delay) {
      return browser.log("Fired timeout after " + delay + "ms delay");
    });
    this.on("interval", function(fn, interval) {
      return browser.log("Fired interval every " + interval + "ms");
    });
    this.on("redirect", function(response, target) {
      browser.log(function() {
        return "" + response.statusCode + " => " + response.url;
      });
      if (target && target.window && target.window.top === target.window.getGlobal()) {
        return browser.response = response;
      }
    });
    this.on("request", function(request, target) {
      if (target && target.window && target.window.top === target.window.getGlobal()) {
        return browser.request = request;
      }
    });
    this.on("response", function(response, target) {
      browser.log(function() {
        var request;
        request = response.resource.request;
        return "" + request.method + " " + (URL.format(request.url)) + " => " + response.statusCode;
      });
      if (target && target.window && target.window.top === target.window.getGlobal()) {
        return browser.response = response;
      }
    });
    this.on("submit", function(form, url) {
      return browser.log(function() {
        return "submit form to " + url;
      });
    });
    this.referer = void 0;
    for (_i = 0, _len = BROWSER_OPTIONS.length; _i < _len; _i++) {
      name = BROWSER_OPTIONS[_i];
      if (options.hasOwnProperty(name)) {
        this[name] = options[name];
      } else if (~GLOBAL_OPTIONS.indexOf(name)) {
        this[name] = Browser[name];
      }
    }
    this._setCredentials(options.credentials || Browser.credentials);
    this.errors = [];
    this.resources = new Resources(this);
    Browser.events.emit("created", this);
  }

  Browser.VERSION = VERSION;

  Browser.events = new EventEmitter();

  Browser.events.on("error", function() {});

  Browser.debug = false;

  Browser.htmlParser = HTML5;

  Browser.loadCSS = true;

  Browser.waitDuration = "5s";

  Browser.proxy = null;

  Browser.runScripts = true;

  Browser.silent = false;

  Browser.userAgent = "Mozilla/5.0 Chrome/10.0.613.0 Safari/534.15 Zombie.js/" + VERSION;

  Browser.site = void 0;

  Browser.maxRedirects = 5;

  Browser.headers = {};

  Browser.prototype.withOptions = function(options, fn) {
    var k, restore, v, _ref,
      _this = this;
    if (options) {
      restore = {};
      for (k in options) {
        v = options[k];
        if (~BROWSER_OPTIONS.indexOf(k)) {
          _ref = [this[k], v], restore[k] = _ref[0], this[k] = _ref[1];
        }
      }
      this._setCredentials(options.credentials);
      return function() {
        var _results;
        _results = [];
        for (k in restore) {
          v = restore[k];
          _results.push(_this[k] = v);
        }
        return _results;
      };
    } else {
      return function() {};
    }
  };

  Browser.prototype.fork = function() {
    var forked, name, _i, _len;
    forked = new Browser();
    forked.loadCookies(this.saveCookies());
    forked.loadStorage(this.saveStorage());
    forked.loadHistory(this.saveHistory());
    forked.location = this.location;
    for (_i = 0, _len = BROWSER_OPTIONS.length; _i < _len; _i++) {
      name = BROWSER_OPTIONS[_i];
      forked[name] = this[name];
    }
    return forked;
  };

  Browser.prototype.__defineGetter__("window", function() {
    return this.tabs.current;
  });

  Browser.prototype.open = function(options) {
    return this.tabs.open(options);
  };

  Browser.prototype.__defineGetter__("error", function() {
    return this.errors[this.errors.length - 1];
  });

  Browser.prototype.wait = function(options, callback) {
    var catchError, deferred, lastError, waitDuration, waitFunction, _ref,
      _this = this;
    if (!this.window) {
      process.nextTick(function() {
        return callback(new Error("No window open"));
      });
      return;
    }
    if (arguments.length === 1 && typeof options === "function") {
      _ref = [options, null], callback = _ref[0], options = _ref[1];
    }
    if (callback && typeof callback !== "function") {
      throw new Error("Second argument expected to be a callback function or null");
    }
    if (typeof options === "number") {
      waitDuration = options;
    } else if (typeof options === "string") {
      waitDuration = options;
    } else if (typeof options === "function") {
      waitDuration = this.waitDuration;
      waitFunction = options;
    } else if (options) {
      waitDuration = options.duration || this.waitDuration;
      if (options.element) {
        waitFunction = function(window) {
          return !!window.document.querySelector(options.element);
        };
      } else {
        waitFunction = options["function"];
      }
    } else {
      waitDuration = this.waitDuration;
    }
    if (!callback) {
      deferred = Q.defer();
    }
    lastError = null;
    catchError = function(error) {
      return lastError || (lastError = error);
    };
    this.addListener("error", catchError);
    this._eventLoop.wait(waitDuration, waitFunction, function(error, timedOut) {
      error || (error = lastError);
      _this.removeListener("error", catchError);
      if (callback) {
        return callback(error, _this);
      } else if (error) {
        return deferred.reject(error);
      } else {
        return deferred.resolve();
      }
    });
    if (deferred) {
      return deferred.promise;
    }
  };

  Browser.prototype.fire = function(name, target, callback) {
    var event, type;
    if (!this.window) {
      throw new Error("No window open");
    }
    type = __indexOf.call(MOUSE_EVENT_NAMES, name) >= 0 ? "MouseEvents" : "HTMLEvents";
    event = this.document.createEvent(type);
    event.initEvent(name, true, true);
    this.window._dispatchEvent(target, event, false);
    return this.wait(callback);
  };

  Browser.prototype.dispatchEvent = function(target, event) {
    if (!this.window) {
      throw new Error("No window open");
    }
    return this.window._dispatchEvent(target, event);
  };

  Browser.prototype.queryAll = function(selector, context) {
    var elements;
    if (selector) {
      context || (context = this.document);
      elements = context.querySelectorAll(selector);
      return Array.prototype.slice.call(elements, 0);
    } else {
      context || (context = this.document.documentElement);
      return [context];
    }
  };

  Browser.prototype.query = function(selector, context) {
    context || (context = this.document);
    if (selector) {
      return context.querySelector(selector);
    } else {
      return context;
    }
  };

  Browser.prototype.$$ = function(selector, context) {
    return this.query(selector, context);
  };

  Browser.prototype.querySelector = function(selector) {
    return this.document.querySelector(selector);
  };

  Browser.prototype.querySelectorAll = function(selector) {
    return this.document.querySelectorAll(selector);
  };

  Browser.prototype.text = function(selector, context) {
    if (this.document.documentElement) {
      return this.queryAll(selector, context).map(function(e) {
        return e.textContent;
      }).join("").trim().replace(/\s+/g, " ");
    }
    return this.source;
  };

  Browser.prototype.html = function(selector, context) {
    if (this.document.documentElement) {
      return this.queryAll(selector, context).map(function(e) {
        return e.outerHTML.trim();
      }).join("");
    }
    return this.source;
  };

  Browser.prototype.css = function(selector, context) {
    deprecated("Browser.css is deprecated, please use browser.query and browser.queryAll instead.");
    return this.queryAll(selector, context);
  };

  Browser.prototype.xpath = function(expression, context) {
    return this.document.evaluate(expression, context || this.document.documentElement);
  };

  Browser.prototype.__defineGetter__("document", function() {
    return this.window.document;
  });

  Browser.prototype.__defineGetter__("body", function() {
    return this.document.querySelector("body");
  });

  Browser.prototype.__defineGetter__("activeElement", function() {
    return this.document.activeElement;
  });

  Browser.prototype.__defineGetter__("statusCode", function() {
    var _ref;
    return (_ref = this.response) != null ? _ref.statusCode : void 0;
  });

  Browser.prototype.__defineGetter__("success", function() {
    return this.statusCode >= 200 && this.statusCode < 300;
  });

  Browser.prototype.__defineGetter__("redirected", function() {
    var _ref;
    return !!((_ref = this.response) != null ? _ref.redirected : void 0);
  });

  Browser.prototype.__defineGetter__("source", function() {
    var _ref;
    return (_ref = this.response) != null ? _ref.body : void 0;
  });

  Browser.prototype.close = function(window) {
    return this.tabs.close.apply(this.tabs, arguments);
  };

  Browser.prototype.destroy = function() {
    if (this.tabs) {
      this.tabs.closeAll();
      this.tabs = null;
      return Browser.events.emit("destroyed", this);
    }
  };

  Browser.prototype.visit = function(url, options, callback) {
    var deferred, reset_options, site, _ref,
      _this = this;
    if (typeof options === "function" && !callback) {
      _ref = [options, null], callback = _ref[0], options = _ref[1];
    }
    deferred = Q.defer();
    reset_options = this.withOptions(options);
    if (site = this.site) {
      if (!/^(https?:|file:)/i.test(site)) {
        site = "http://" + site;
      }
      url = URL.resolve(site, URL.parse(URL.format(url)));
    }
    if (this.window) {
      this.window.location = url;
    } else {
      this.open({
        url: url
      });
    }
    this.wait(options, function(error) {
      reset_options();
      if (error) {
        deferred.reject(error);
      } else {
        deferred.resolve();
      }
      if (callback) {
        return callback(error, _this, _this.statusCode, _this.errors);
      }
    });
    if (!callback) {
      return deferred.promise;
    }
  };

  Browser.prototype.load = function(html, callback) {
    var deferred, first;
    this.location = "about:blank";
    try {
      this.errors = [];
      this.document.open();
      this.document.write(html);
      this.document.close();
    } catch (error) {
      this.emit("error", error);
    }
    first = this.errors[0];
    if (first) {
      if (callback) {
        process.nextTick(function() {
          return callback(first);
        });
      } else {
        deferred = Q.defer();
        deferred.reject(first);
        return deferred.promise;
      }
    } else {
      return this.wait(callback);
    }
  };

  Browser.prototype.__defineGetter__("location", function() {
    if (this.window) {
      return this.window.location;
    }
  });

  Browser.prototype.__defineSetter__("location", function(url) {
    if (this.window) {
      return this.window.location = url;
    } else {
      return this.open({
        url: url
      });
    }
  });

  Browser.prototype.__defineGetter__("url", function() {
    if (this.window) {
      return URL.format(this.window.location);
    }
  });

  Browser.prototype.link = function(selector) {
    var link, _i, _len, _ref;
    if (selector instanceof HTML.Element) {
      return selector;
    }
    if (link = this.querySelector(selector)) {
      if (link.tagName === "A") {
        return link;
      }
    }
    _ref = this.querySelectorAll("body a");
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      link = _ref[_i];
      if (link.textContent.trim() === selector) {
        return link;
      }
    }
  };

  Browser.prototype.clickLink = function(selector, callback) {
    var link;
    if (!(link = this.link(selector))) {
      throw new Error("No link matching '" + selector + "'");
    }
    return this.fire("click", link, callback);
  };

  Browser.prototype.__defineGetter__("history", function() {
    if (!this.window) {
      this.open();
    }
    return this.window.history;
  });

  Browser.prototype.back = function(callback) {
    this.window.history.back();
    return this.wait(callback);
  };

  Browser.prototype.reload = function(callback) {
    this.window.location.reload();
    return this.wait(callback);
  };

  Browser.prototype.authenticate = function(host, create) {
    var credentials, _ref;
    if (create == null) {
      create = true;
    }
    host || (host = "*");
    credentials = (_ref = this._credentials) != null ? _ref[host] : void 0;
    if (!credentials) {
      if (create) {
        credentials = new Credentials();
        this._credentials || (this._credentials = {});
        this._credentials[host] = credentials;
      } else {
        credentials = this.authenticate();
      }
    }
    return credentials;
  };

  Browser.prototype._setCredentials = function(credentials) {
    if (!credentials) {
      return;
    }
    deprecated("This credentials option is deprecated, please use browser.authenticate(host) instead.");
    switch (credentials.scheme.toLowerCase()) {
      case "basic":
        return this.authenticate().basic(credentials.user || credentials.username, credentials.password);
      case "bearer":
        return this.authenticate().bearer(credentials.token);
      case "oauth":
        return this.authenticate().oauth(credentials.token);
    }
  };

  Browser.prototype.saveHistory = function() {
    return this.window.history.save();
  };

  Browser.prototype.loadHistory = function(serialized) {
    return this.window.history.load(serialized);
  };

  Browser.prototype.field = function(selector) {
    var field, forAttr, label, _i, _j, _len, _len1, _ref, _ref1;
    if (selector instanceof HTML.Element) {
      return selector;
    }
    try {
      field = this.querySelector(selector);
      if (field && (field.tagName === "INPUT" || field.tagName === "TEXTAREA" || field.tagName === "SELECT")) {
        return field;
      }
    } catch (error) {

    }
    _ref = this.querySelectorAll(":input[name]");
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      field = _ref[_i];
      if (field.getAttribute("name") === selector) {
        return field;
      }
    }
    _ref1 = this.querySelectorAll("label");
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      label = _ref1[_j];
      if (label.textContent.trim() === selector) {
        if (forAttr = label.getAttribute("for")) {
          return this.document.getElementById(forAttr);
        } else {
          return label.querySelector(":input");
        }
      }
    }
  };

  Browser.prototype.fill = function(selector, value, callback) {
    var field;
    field = this.field(selector);
    if (!(field && (field.tagName === "TEXTAREA" || (field.tagName === "INPUT")))) {
      throw new Error("No INPUT matching '" + selector + "'");
    }
    if (field.getAttribute("disabled")) {
      throw new Error("This INPUT field is disabled");
    }
    if (field.getAttribute("readonly")) {
      throw new Error("This INPUT field is readonly");
    }
    field.focus();
    field.value = value;
    this.fire("change", field, callback);
    return this;
  };

  Browser.prototype._setCheckbox = function(selector, value, callback) {
    var field;
    field = this.field(selector);
    if (!(field && field.tagName === "INPUT" && field.type === "checkbox")) {
      throw new Error("No checkbox INPUT matching '" + selector + "'");
    }
    if (field.getAttribute("disabled")) {
      throw new Error("This INPUT field is disabled");
    }
    if (field.getAttribute("readonly")) {
      throw new Error("This INPUT field is readonly");
    }
    if (field.checked ^ value) {
      field.click();
    }
    if (callback) {
      this.wait(callback);
    }
    return this;
  };

  Browser.prototype.check = function(selector, callback) {
    return this._setCheckbox(selector, true, callback);
  };

  Browser.prototype.uncheck = function(selector, callback) {
    return this._setCheckbox(selector, false, callback);
  };

  Browser.prototype.choose = function(selector, callback) {
    var field;
    field = this.field(selector) || this.field("input[type=radio][value=\"" + (escape(selector)) + "\"]");
    if (!(field && field.tagName === "INPUT" && field.type === "radio")) {
      throw new Error("No radio INPUT matching '" + selector + "'");
    }
    field.click();
    if (callback) {
      this.wait(callback);
    }
    return this;
  };

  Browser.prototype._findOption = function(selector, value) {
    var field, option, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2;
    field = this.field(selector);
    if (!(field && field.tagName === "SELECT")) {
      throw new Error("No SELECT matching '" + selector + "'");
    }
    if (field.getAttribute("disabled")) {
      throw new Error("This SELECT field is disabled");
    }
    if (field.getAttribute("readonly")) {
      throw new Error("This SELECT field is readonly");
    }
    _ref = field.options;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      option = _ref[_i];
      if (option.value === value) {
        return option;
      }
    }
    _ref1 = field.options;
    for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
      option = _ref1[_j];
      if (option.label === value) {
        return option;
      }
    }
    _ref2 = field.options;
    for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
      option = _ref2[_k];
      if (option.textContent.trim() === value) {
        return option;
      }
    }
    throw new Error("No OPTION '" + value + "'");
  };

  Browser.prototype.select = function(selector, value, callback) {
    var option;
    option = this._findOption(selector, value);
    return this.selectOption(option, callback);
  };

  Browser.prototype.selectOption = function(option, callback) {
    var select;
    if (option && !option.getAttribute("selected")) {
      select = this.xpath("./ancestor::select", option).value[0];
      option.setAttribute("selected", "selected");
      select.focus();
      this.fire("change", select, callback);
    } else if (callback) {
      process.nextTick(function() {
        return callback(null, false);
      });
    }
    return this;
  };

  Browser.prototype.unselect = function(selector, value, callback) {
    var option;
    option = this._findOption(selector, value);
    return this.unselectOption(option, callback);
  };

  Browser.prototype.unselectOption = function(option, callback) {
    var select;
    if (option && option.getAttribute("selected")) {
      select = this.xpath("./ancestor::select", option).value[0];
      if (!select.multiple) {
        throw new Error("Cannot unselect in single select");
      }
      option.removeAttribute("selected");
      select.focus();
      this.fire("change", select, callback);
    } else if (callback) {
      process.nextTick(function() {
        return callback(null, false);
      });
    }
    return this;
  };

  Browser.prototype.attach = function(selector, filename, callback) {
    var field, file, stat;
    field = this.field(selector);
    if (!(field && field.tagName === "INPUT" && field.type === "file")) {
      throw new Error("No file INPUT matching '" + selector + "'");
    }
    if (filename) {
      stat = FS.statSync(filename);
      file = new this.window.File();
      file.name = Path.basename(filename);
      file.type = Mime.lookup(filename);
      file.size = stat.size;
      field.files || (field.files = []);
      field.files.push(file);
      field.value = filename;
    }
    field.focus();
    this.fire("change", field, callback);
    return this;
  };

  Browser.prototype.button = function(selector) {
    var button, input, inputs, _i, _j, _k, _len, _len1, _len2, _ref;
    if (selector instanceof HTML.Element) {
      return selector;
    }
    if (button = this.querySelector(selector)) {
      if (button.tagName === "BUTTON" || button.tagName === "INPUT") {
        return button;
      }
    }
    _ref = this.querySelectorAll("button");
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      button = _ref[_i];
      if (button.textContent.trim() === selector) {
        return button;
      }
    }
    inputs = this.querySelectorAll(":submit, :reset, :button");
    for (_j = 0, _len1 = inputs.length; _j < _len1; _j++) {
      input = inputs[_j];
      if (input.name === selector) {
        return input;
      }
    }
    for (_k = 0, _len2 = inputs.length; _k < _len2; _k++) {
      input = inputs[_k];
      if (input.value === selector) {
        return input;
      }
    }
  };

  Browser.prototype.pressButton = function(selector, callback) {
    var button;
    if (!(button = this.button(selector))) {
      throw new Error("No BUTTON '" + selector + "'");
    }
    if (button.getAttribute("disabled")) {
      throw new Error("This button is disabled");
    }
    button.focus();
    return this.fire("click", button, callback);
  };

  Browser.prototype.cookies = function(domain, path) {
    var location;
    if (!domain && (location = this.location)) {
      domain = this.location.hostname;
    }
    if (!path && (location = this.location)) {
      path = this.location.pathname;
    }
    return this._cookies.access(domain || "localhost", path || "/");
  };

  Browser.prototype.saveCookies = function() {
    return this._cookies.save();
  };

  Browser.prototype.loadCookies = function(serialized) {
    return this._cookies.load(serialized);
  };

  Browser.prototype.localStorage = function(host) {
    return this._storages.local(host);
  };

  Browser.prototype.sessionStorage = function(host) {
    return this._storages.session(host);
  };

  Browser.prototype.saveStorage = function() {
    return this._storages.save();
  };

  Browser.prototype.loadStorage = function(serialized) {
    return this._storages.load(serialized);
  };

  Browser.prototype.evaluate = function(code, filename) {
    if (!this.window) {
      this.open();
    }
    return this.window._evaluate(code, filename);
  };

  Browser.prototype.onalert = function(fn) {
    return this._interact.onalert(fn);
  };

  Browser.prototype.onconfirm = function(question, response) {
    return this._interact.onconfirm(question, response);
  };

  Browser.prototype.onprompt = function(message, response) {
    return this._interact.onprompt(message, response);
  };

  Browser.prototype.prompted = function(message) {
    return this._interact.prompted(message);
  };

  Browser.prototype.viewInBrowser = function(browser) {
    return require("./bcat").bcat(this.html());
  };

  Browser.prototype.log = function() {
    var args;
    if (typeof arguments[0] === "function") {
      args = [arguments[0]()];
    } else {
      args = arguments;
    }
    return this.emit("log", format.apply(null, args));
  };

  Browser.prototype.dump = function() {
    var html, indent;
    indent = function(lines) {
      return lines.map(function(l) {
        return "  " + l + "\n";
      }).join("");
    };
    process.stdout.write("Zombie: " + VERSION + "\n\n");
    process.stdout.write("URL: " + this.window.location.href + "\n");
    process.stdout.write("History:\n" + (indent(this.window.history.dump())) + "\n");
    process.stdout.write("Cookies:\n" + (indent(this._cookies.dump())) + "\n");
    process.stdout.write("Storage:\n" + (indent(this._storages.dump())) + "\n");
    process.stdout.write("Eventloop:\n" + (indent(this.window._eventLoop.dump())) + "\n");
    if (this.document) {
      html = this.document.outerHTML;
      if (html.length > 497) {
        html = html.slice(0, 497) + "...";
      }
      return process.stdout.write("Document:\n" + (indent(html.split("\n"))) + "\n");
    } else {
      if (!this.document) {
        return process.stdout.write("No document\n");
      }
    }
  };

  return Browser;

})(EventEmitter);

Credentials = (function() {

  function Credentials() {}

  Credentials.prototype.apply = function(headers) {
    var base64;
    switch (this.scheme) {
      case "basic":
        base64 = new Buffer(this.user + ":" + this.password).toString("base64");
        return headers["authorization"] = "Basic " + base64;
      case "bearer":
        return headers["authorization"] = "Bearer " + this.token;
      case "oauth":
        return headers["authorization"] = "OAuth " + this.token;
    }
  };

  Credentials.prototype.basic = function(user, password) {
    this.user = user;
    this.password = password;
    return this.scheme = "basic";
  };

  Credentials.prototype.bearer = function(token) {
    this.token = token;
    return this.scheme = "bearer";
  };

  Credentials.prototype.oauth = function(token) {
    this.token = token;
    return this.scheme = "oauth";
  };

  Credentials.prototype.reset = function() {
    delete this.scheme;
    delete this.token;
    delete this.user;
    return delete this.password;
  };

  return Credentials;

})();

module.exports = Browser;
