// Generated by CoffeeScript 1.3.3
var Console, format, level, _fn, _i, _len, _ref,
  __slice = [].slice;

format = require("util").format;

Console = (function() {

  function Console(browser) {
    this.browser = browser;
  }

  Console.prototype.assert = function(expression) {
    var message;
    if (expression) {
      return;
    }
    message = "Assertion failed:" + (format.apply(null, [""].concat(__slice.call(Array.prototype.slice.call(arguments, 1)))));
    this.browser.emit("console", "assert", message);
    if (!this.browser.silent) {
      process.stderr.write(message + "\n");
    }
    throw new Error(message);
  };

  Console.prototype.count = function(name) {
    var message, _base;
    this.counters || (this.counters = {});
    (_base = this.counters)[name] || (_base[name] = 0);
    this.counters[name]++;
    message = "" + name + ": " + this.counters[name];
    this.browser.emit("console", "count", message);
    if (!this.browser.silent) {
      return process.stdout.write(message + "\n");
    }
  };

  Console.prototype.group = function() {};

  Console.prototype.groupCollapsed = function() {};

  Console.prototype.groupEnd = function() {};

  Console.prototype.time = function(name) {
    this.timers || (this.timers = {});
    return this.timers[name] = Date.now();
  };

  Console.prototype.timeEnd = function(name) {
    var message, start;
    if (!this.timers) {
      return;
    }
    start = this.timers[name];
    if (!start) {
      return;
    }
    delete this.timers[name];
    message = "" + name + ": " + (Date.now() - start) + "ms";
    this.browser.emit("console", "time", message);
    if (!this.browser.silent) {
      return process.stdout.write(message + "\n");
    }
  };

  Console.prototype.trace = function() {
    var message, stack;
    stack = (new Error).stack.split("\n");
    stack[0] = "console.trace()";
    message = stack.join("\n");
    this.browser.emit("console", "trace", message);
    if (!this.browser.silent) {
      return process.stdout.write(message + "\n");
    }
  };

  return Console;

})();

_ref = ["info", "log", "warn"];
_fn = function(level) {
  return Console.prototype[level] = function() {
    var message;
    message = format.apply(null, arguments);
    this.browser.emit("console", level, message);
    if (!this.browser.silent) {
      return process.stdout.write(message + "\n");
    }
  };
};
for (_i = 0, _len = _ref.length; _i < _len; _i++) {
  level = _ref[_i];
  _fn(level);
}

Console.prototype.debug = function() {
  var message;
  message = format.apply(null, arguments);
  this.browser.emit("console", "debug", message);
  if (this.browser.debug && !this.browser.silent) {
    return process.stdout.write(message + "\n");
  }
};

Console.prototype.error = function() {
  var message;
  message = format.apply(null, arguments);
  this.browser.emit("console", "error", message);
  if (!this.browser.silent) {
    return process.stderr.write(message + "\n");
  }
};

module.exports = Console;
