
var Mode = {
    Text: 'text',
    Tag: 'tag',
    Attr: 'attr',
    CData: 'cdata',
    Comment: 'comment'
};

function parseText (state) {
    var foundPos = state.data.indexOf('<', state.pos);
    var text = (foundPos === -1) ? state.data.substring(state.pos, state.data.length) : state.data.substring(state.pos, foundPos);
    if (foundPos < 0 && state.done) {
        foundPos = state.data.length;
    }
    if (foundPos < 0) {
        if (!state.pendingText) {
            state.pendingText = [];
        }
        state.pendingText.push(state.data.substring(state.pos, state.data.length));
        state.pos = state.data.length;
    } else {
        if (state.pendingText) {
            state.pendingText.push(state.data.substring(state.pos, foundPos));
            text = state.pendingText.join('');
            state.pendingText = null;
        } else {
            text = state.data.substring(state.pos, foundPos);
        }
        if (text !== '') {
            state.output.push({ type: Mode.Text, data: text });
        }
        state.pos = foundPos + 1;
        state.mode = Mode.Tag;
    }
}

var re_parseTag = /(\s*)(\/?[^\s>\/]+)(\s*)(>?)/g;
function parseTag (state) {
    re_parseTag.lastIndex = state.pos;
    var match = re_parseTag.exec(state.data);
    if (match) {
        if (match[2].substr(0, 3) === '!--') {
            state.mode = Mode.Comment;
            state.pos += 3;
            return;
        }
        if (match[2].substr(0, 8) === '![CDATA[') {
            state.mode = Mode.CData;
            state.pos += 8;
            return;
        }
        if (!state.done && (state.pos + match[0].length) === state.data.length) {
            //We're at the and of the data, might be incomplete
            state.needData = true;
            return;
        }
        var raw;
        //TODO: handle <div/>?
        if (match[4] === '>') {
            state.mode = Mode.Text;
            raw = match[0].substr(0, match[0].length - 1);
        } else {
            state.mode = Mode.Attr;
            raw = match[0];
        }
        state.pos += match[0].length;
        var tag = { type: Mode.Tag, name: match[2].toLowerCase(), name_raw: match[2], raw: raw };
        if (state.mode === Mode.Attr) {
            state.lastTag = tag;
        }
        state.output.push(tag);
    } else {
        //TODO: end of tag?
        //TODO: push to pending?
        state.needData = true;
    }
}

var re_parseAttr_findName = /\s*([^=<>\s'"\/]+)\s*/g;
function parseAttr_findName (state) {
    re_parseAttr_findName.lastIndex = state.pos;
    var match = re_parseAttr_findName.exec(state.data);
    if (!match) {
        return null;
    }
    if (state.pos + match[0].length !== re_parseAttr_findName.lastIndex) {
        return null;
    }
    return {
          match: match[0]
        , name: match[1]
        };
}
var re_parseAttr_findValue = /\s*=\s*(?:'([^']*)'|"([^"]*)"|([^'"\s\/>]+))\s*/g;
var re_parseAttr_findValue_last = /\s*=\s*['"]?(.*)$/g;
function parseAttr_findValue (state) {
    re_parseAttr_findValue.lastIndex = state.pos;
    var match = re_parseAttr_findValue.exec(state.data);
    if (!match) {
        if (!state.done) {
            return null;
        }
        re_parseAttr_findValue_last.lastIndex = state.pos;
        match = re_parseAttr_findValue_last.exec(state.data);
        if (!match) {
            return null;
        }
        return {
              match: match[0]
            , value: (match[1] !== '') ? match[1] : null
            };
    }
    if (state.pos + match[0].length !== re_parseAttr_findValue.lastIndex) {
        return null;
    }
    return {
          match: match[0]
        , value: match[1] || match[2] || match[3]
        };
}
var re_parseAttr_splitValue = /\s*=\s*['"]?/g;
var re_parseAttr_selfClose = /(\s*\/\s*)(>?)/g;
function parseAttr (state) {
    var name_data = parseAttr_findName(state);
    if (!name_data) {
        re_parseAttr_selfClose.lastIndex = state.pos;
        var matchTrailingSlash = re_parseAttr_selfClose.exec(state.data);
        if (matchTrailingSlash && matchTrailingSlash.index === state.pos) {
            if (!state.done && !matchTrailingSlash[2] && state.pos + matchTrailingSlash[0].length === state.data.length) {
                state.needData = true;
                return;
            }
            state.lastTag.raw += matchTrailingSlash[1];
            state.output.push({ type: Mode.Tag, name: '/' + state.lastTag.name, name_raw: '/' + state.lastTag.name_raw, raw: null });
            state.pos += matchTrailingSlash[1].length;
        }
        var foundPos = state.data.indexOf('>', state.pos);
        if (foundPos < 0) {
            if (state.done) { //TODO: is this needed?
                state.lastTag.raw += state.data.substr(state.pos);
                state.pos = state.data.length;
                return;
            }
            state.needData = true;
        } else {
            state.lastTag = null;
            state.pos = foundPos + 1;
            state.mode = Mode.Text;
        }
        return;
    }
    if (!state.done && state.pos + name_data.match.length === state.data.length) {
        state.needData = true;
        return null;
    }
    state.pos += name_data.match.length;
    var value_data = parseAttr_findValue(state);
    if (value_data) {
        if (!state.done && state.pos + value_data.match.length === state.data.length) {
            state.needData = true;
            state.pos -= name_data.match.length;
            return;
        }
        state.pos += value_data.match.length;
    } else {
        re_parseAttr_splitValue.lastIndex = state.pos;
        if (re_parseAttr_splitValue.exec(state.data)) {
            state.needData = true;
            state.pos -= name_data.match.length;
            return;
        }
        value_data = {
              match: ''
            , value: null
            };
    }
    state.lastTag.raw += name_data.match + value_data.match;

    state.output.push({ type: Mode.Attr, name: name_data.name.toLowerCase(), name_raw: name_data.name, value: value_data.value });
}

var re_parseCData_findEnding = /\]{1,2}$/;
function parseCData (state) {
    var foundPos = state.data.indexOf(']]>', state.pos);
    if (foundPos < 0 && state.done) {
        foundPos = state.data.length;
    }
    if (foundPos < 0) {
        re_parseCData_findEnding.lastIndex = state.pos;
        var matchPartialCDataEnd = re_parseCData_findEnding.exec(state.data);
        if (matchPartialCDataEnd) {
            state.needData = true;
            return;
        }
        if (!state.pendingText) {
            state.pendingText = [];
        }
        state.pendingText.push(state.data.substr(state.pos, state.data.length));
        state.pos = state.data.length;
        state.needData = true;
    } else {
        var text;
        if (state.pendingText) {
            state.pendingText.push(state.data.substring(state.pos, foundPos));
            text = state.pendingText.join('');
            state.pendingText = null;
        } else {
            text = state.data.substring(state.pos, foundPos);
        }
        state.output.push({ type: Mode.CData, data: text });
        state.mode = Mode.Text;
        state.pos = foundPos + 3;
    }
}

var re_parseComment_findEnding = /\-{1,2}$/;
function parseComment (state) {
    var foundPos = state.data.indexOf('-->', state.pos);
    if (foundPos < 0 && state.done) {
        foundPos = state.data.length;
    }
    if (foundPos < 0) {
        re_parseComment_findEnding.lastIndex = state.pos;
        var matchPartialCommentEnd = re_parseComment_findEnding.exec(state.data);
        if (matchPartialCommentEnd) {
            state.needData = true;
            return;
        }
        if (!state.pendingText) {
            state.pendingText = [];
        }
        state.pendingText.push(state.data.substr(state.pos, state.data.length));
        state.pos = state.data.length;
        state.needData = true;
    } else {
        var text;
        if (state.pendingText) {
            state.pendingText.push(state.data.substring(state.pos, foundPos));
            text = state.pendingText.join('');
            state.pendingText = null;
        } else {
            text = state.data.substring(state.pos, foundPos);
        }
        state.output.push({ type: Mode.Comment, data: text });
        state.mode = Mode.Text;
        state.pos = foundPos + 3;
    }
}

function parse (state) {
    switch (state.mode) {
        case Mode.Text:
            return parseText(state);
        case Mode.Tag:
            return parseTag(state);
        case Mode.Attr:
            return parseAttr(state);
        case Mode.CData:
            return parseCData(state);
        case Mode.Comment:
            return parseComment(state);
    }
}

function HtmlParser () {
    this.reset();
}
HtmlParser.Type = Mode;

HtmlParser.prototype.reset = function HtmlParser$reset () {
    this.state = {
        mode: Mode.Text,
        pos: 0,
        data: null,
        pendingText: null,
        lastTag: null,
        needData: false,
        output: [],
        done: false
    };
};

HtmlParser.prototype.parse = function HtmlParser$parse (chunk) {
    this.state.needData = false;
    this.state.data = (this.state.data !== null) ?
         this.state.data.substr(this.pos) + chunk
         :
        chunk
        ;
    while (this.state.pos < this.state.data.length && !this.state.needData) {
        parse(this.state);
    }
};

HtmlParser.prototype.done = function HtmlParser$done () {
    this.state.done = true;
    parse(this.state);
};

// HtmlParser.prototype.done_old = function HtmlParser$done_old () {
//     if (this.state.pendingText) {
//         this.state.output.push({ type: this.state.mode, data: this.state.pendingText.join('') });
//         this.state.pendingText = null;
//     }
//     console.log(this.state);

//     var buffer = [];
//     var lastType;
//     for (var i = 0, len = this.state.output.length; i < len; i++) {
//         var node = this.state.output[i];
//         if ((lastType === Mode.Attr && node.type !== Mode.Attr) || (lastType === Mode.Tag && node.type !== Mode.Attr)) {
//             buffer.push('>');
//         }
//         switch (node.type) {

//             case Mode.Text:
//                 buffer.push(node.data);
//                 break;

//             case Mode.Comment:
//                 buffer.push('<!--', node.data, '-->');
//                 break;

//             case Mode.CData:
//                 buffer.push('<![CDATA[', node.data, ']]>');
//                 break;

//             case Mode.Tag:
//                 buffer.push('<', node.name);
//                 break;

//             case Mode.Attr:
//                 var quoteChar = (node.value.indexOf('\'') < 0) ? '\'' : '"';
//                 buffer.push(' ', node.name, '=', quoteChar, node.value, quoteChar);
//                 break;

//         }
//         lastType = node.type;
//     }
//     if (lastType === Mode.Tag || lastType === Mode.Attr) {
//         buffer.push('>');
//     }
//     console.log(buffer.join(''));
// };

module.exports = HtmlParser;
