/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2013  Kouhei Sutou <kou@clear-code.com>
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GGRN_ERROR_H
#define GGRN_ERROR_H

#include <glib-object.h>

G_BEGIN_DECLS

#define GGRN_ERROR \
  (ggrn_error_quark())

typedef enum
{
  GGRN_ERROR_END_OF_DATA = 1,
  GGRN_ERROR_UNKNOWN_ERROR = -1,
  GGRN_ERROR_OPERATION_NOT_PERMITTED = -2,
  GGRN_ERROR_NO_SUCH_FILE_OR_DIRECTORY = -3,
  GGRN_ERROR_NO_SUCH_PROCESS = -4,
  GGRN_ERROR_INTERRUPTED_FUNCTION_CALL = -5,
  GGRN_ERROR_INPUT_OUTPUT_ERROR = -6,
  GGRN_ERROR_NO_SUCH_DEVICE_OR_ADDRESS = -7,
  GGRN_ERROR_ARG_LIST_TOO_LONG = -8,
  GGRN_ERROR_EXEC_FORMAT_ERROR = -9,
  GGRN_ERROR_BAD_FILE_DESCRIPTOR = -10,
  GGRN_ERROR_NO_CHILD_PROCESSES = -11,
  GGRN_ERROR_RESOURCE_TEMPORARILY_UNAVAILABLE = -12,
  GGRN_ERROR_NOT_ENOUGH_SPACE = -13,
  GGRN_ERROR_PERMISSION_DENIED = -14,
  GGRN_ERROR_BAD_ADDRESS = -15,
  GGRN_ERROR_RESOURCE_BUSY = -16,
  GGRN_ERROR_FILE_EXISTS = -17,
  GGRN_ERROR_IMPROPER_LINK = -18,
  GGRN_ERROR_NO_SUCH_DEVICE = -19,
  GGRN_ERROR_NOT_A_DIRECTORY = -20,
  GGRN_ERROR_IS_A_DIRECTORY = -21,
  GGRN_ERROR_INVALID_ARGUMENT = -22,
  GGRN_ERROR_TOO_MANY_OPEN_FILES_IN_SYSTEM = -23,
  GGRN_ERROR_TOO_MANY_OPEN_FILES = -24,
  GGRN_ERROR_INAPPROPRIATE_IO_CONTROL_OPERATION = -25,
  GGRN_ERROR_FILE_TOO_LARGE = -26,
  GGRN_ERROR_NO_SPACE_LEFT_ON_DEVICE = -27,
  GGRN_ERROR_INVALID_SEEK = -28,
  GGRN_ERROR_READ_ONLY_FILE_SYSTEM = -29,
  GGRN_ERROR_TOO_MANY_LINKS = -30,
  GGRN_ERROR_BROKEN_PIPE = -31,
  GGRN_ERROR_DOMAIN_ERROR = -32,
  GGRN_ERROR_RESULT_TOO_LARGE = -33,
  GGRN_ERROR_RESOURCE_DEADLOCK_AVOIDED = -34,
  GGRN_ERROR_NO_MEMORY_AVAILABLE = -35,
  GGRN_ERROR_FILENAME_TOO_LONG = -36,
  GGRN_ERROR_NO_LOCKS_AVAILABLE = -37,
  GGRN_ERROR_FUNCTION_NOT_IMPLEMENTED = -38,
  GGRN_ERROR_DIRECTORY_NOT_EMPTY = -39,
  GGRN_ERROR_ILLEGAL_BYTE_SEQUENCE = -40,
  GGRN_ERROR_SOCKET_NOT_INITIALIZED = -41,
  GGRN_ERROR_OPERATION_WOULD_BLOCK = -42,
  GGRN_ERROR_ADDRESS_IS_NOT_AVAILABLE = -43,
  GGRN_ERROR_NETWORK_IS_DOWN = -44,
  GGRN_ERROR_NO_BUFFER = -45,
  GGRN_ERROR_SOCKET_IS_ALREADY_CONNECTED = -46,
  GGRN_ERROR_SOCKET_IS_NOT_CONNECTED = -47,
  GGRN_ERROR_SOCKET_IS_ALREADY_SHUTDOWNED = -48,
  GGRN_ERROR_OPERATION_TIMEOUT = -49,
  GGRN_ERROR_CONNECTION_REFUSED = -50,
  GGRN_ERROR_RANGE_ERROR = -51,
  GGRN_ERROR_TOKENIZER_ERROR = -52,
  GGRN_ERROR_FILE_CORRUPT = -53,
  GGRN_ERROR_INVALID_FORMAT = -54,
  GGRN_ERROR_OBJECT_CORRUPT = -55,
  GGRN_ERROR_TOO_MANY_SYMBOLIC_LINKS = -56,
  GGRN_ERROR_NOT_SOCKET = -57,
  GGRN_ERROR_OPERATION_NOT_SUPPORTED = -58,
  GGRN_ERROR_ADDRESS_IS_IN_USE = -59,
  GGRN_ERROR_ZLIB_ERROR = -60,
  GGRN_ERROR_LZO_ERROR = -61,
  GGRN_ERROR_STACK_OVER_FLOW = -62,
  GGRN_ERROR_SYNTAX_ERROR = -63,
  GGRN_ERROR_RETRY_MAX = -64,
  GGRN_ERROR_INCOMPATIBLE_FILE_FORMAT = -65,
  GGRN_ERROR_UPDATE_NOT_ALLOWED = -66,
  GGRN_ERROR_TOO_SMALL_OFFSET = -67,
  GGRN_ERROR_TOO_LARGE_OFFSET = -68,
  GGRN_ERROR_TOO_SMALL_LIMIT = -69,
  GGRN_ERROR_CAS_ERROR = -70,
  GGRN_ERROR_UNSUPPORTED_COMMAND_VERSION = -71,
  GGRN_ERROR_NORMALIZER_ERROR = -72,
} GGrnError;

GQuark       ggrn_error_quark     (void);
const gchar *ggrn_error_to_string (GGrnError error);

G_END_DECLS

#endif
