/*
  Copyright(C) 2013  Kouhei Sutou <kou@clear-code.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; version 2
  of the License.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
  MA 02110-1301, USA

  This file uses normalization table defined in
  mysql-5.5.29/strings/ctype-uca.c.
  The following is the header of the file:

    Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; version 2
    of the License.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
    MA 02110-1301, USA

    UCA (Unicode Collation Algorithm) support.
    Written by Alexander Barkov <bar@mysql.com>
*/

#ifndef MYSQL_UCA_H
#define MYSQL_UCA_H

#include <stdint.h>

static uint32_t unicode_ci_page_00[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00009, 0x0000a, 0x0000b, 0x0000c, 0x0000d, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00020, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 0x00027,
  0x00028, 0x00029, 0x0002a, 0x0002b, 0x0002c, 0x0002d, 0x0002e, 0x0002f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0003a, 0x0003b, 0x0003c, 0x0003d, 0x0003e, 0x0003f,
  0x00040, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0005b, 0x0005c, 0x0005d, 0x0005e, 0x0005f,
  0x00060, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0007b, 0x0007c, 0x0007d, 0x0007e, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00085, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00020, 0x000a1, 0x000a2, 0x000a3, 0x000a4, 0x000a5, 0x000a6, 0x000a7,
  0x000a8, 0x000a9, 0x00041, 0x000ab, 0x000ac, 0x000ad, 0x000ae, 0x000af,
  0x000b0, 0x000b1, 0x00032, 0x00033, 0x000b4, 0x000b5, 0x000b6, 0x000b7,
  0x000b8, 0x00031, 0x0004f, 0x000bb, 0x000bc, 0x000bd, 0x000be, 0x000bf,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x000d0, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000d7,
  0x000d8, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000de, 0x000df,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x000c6, 0x00043,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00049, 0x00049, 0x00049, 0x00049,
  0x000d0, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x000f7,
  0x000d8, 0x00055, 0x00055, 0x00055, 0x00055, 0x00059, 0x000de, 0x00059
};

static uint32_t unicode_ci_page_01[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00043, 0x00043,
  0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00043, 0x00044, 0x00044,
  0x00110, 0x00110, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00047, 0x00047, 0x00047, 0x00047,
  0x00047, 0x00047, 0x00047, 0x00047, 0x00048, 0x00048, 0x00126, 0x00126,
  0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049, 0x00049,
  0x00049, 0x00131, 0x00132, 0x00132, 0x0004a, 0x0004a, 0x0004b, 0x0004b,
  0x00138, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0013f,
  0x0013f, 0x00141, 0x00141, 0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x00149, 0x0014a, 0x0014a, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00152, 0x00152, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00052, 0x00052, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00166, 0x00166,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00057, 0x00057, 0x00059, 0x00059,
  0x00059, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00053,
  0x00180, 0x00181, 0x00182, 0x00182, 0x00184, 0x00184, 0x00186, 0x00187,
  0x00187, 0x00189, 0x0018a, 0x0018b, 0x0018b, 0x0018d, 0x0018e, 0x0018f,
  0x00190, 0x00191, 0x00191, 0x00193, 0x00194, 0x00195, 0x00196, 0x00197,
  0x00198, 0x00198, 0x0019a, 0x0019b, 0x0019c, 0x0019d, 0x0019e, 0x0019f,
  0x0004f, 0x0004f, 0x001a2, 0x001a2, 0x001a4, 0x001a4, 0x001a6, 0x001a7,
  0x001a7, 0x001a9, 0x001aa, 0x001ab, 0x001ac, 0x001ac, 0x001ae, 0x00055,
  0x00055, 0x001b1, 0x001b2, 0x001b3, 0x001b3, 0x001b5, 0x001b5, 0x001b7,
  0x001b8, 0x001b8, 0x001ba, 0x001bb, 0x001bc, 0x001bc, 0x001be, 0x001bf,
  0x001c0, 0x001c1, 0x001c2, 0x001c3, 0x001c4, 0x001c4, 0x001c4, 0x001c7,
  0x001c7, 0x001c7, 0x001ca, 0x001ca, 0x001ca, 0x00041, 0x00041, 0x00049,
  0x00049, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x0018e, 0x00041, 0x00041,
  0x00041, 0x00041, 0x000c6, 0x000c6, 0x001e4, 0x001e4, 0x00047, 0x00047,
  0x0004b, 0x0004b, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x001b7, 0x001b7,
  0x0004a, 0x001c4, 0x001c4, 0x001c4, 0x00047, 0x00047, 0x00195, 0x001bf,
  0x0004e, 0x0004e, 0x00041, 0x00041, 0x000c6, 0x000c6, 0x000d8, 0x001ff
};

static uint32_t unicode_ci_page_02[] = {
  0x00041, 0x00041, 0x00041, 0x00041, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00053, 0x00053, 0x00054, 0x00054, 0x0021c, 0x0021c, 0x00048, 0x00048,
  0x0019e, 0x00221, 0x00222, 0x00222, 0x00224, 0x00224, 0x00041, 0x00041,
  0x00045, 0x00045, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x00059, 0x00059, 0x00234, 0x00235, 0x00236, 0x00237,
  0x00238, 0x00239, 0x0023a, 0x0023b, 0x0023c, 0x0023d, 0x0023e, 0x0023f,
  0x00240, 0x00241, 0x00242, 0x00243, 0x00244, 0x00245, 0x00246, 0x00247,
  0x00248, 0x00249, 0x0024a, 0x0024b, 0x0024c, 0x0024d, 0x0024e, 0x0024f,
  0x00250, 0x00251, 0x00252, 0x00181, 0x00186, 0x00255, 0x00189, 0x0018a,
  0x00258, 0x0018f, 0x0025a, 0x00190, 0x0025c, 0x0025d, 0x0025e, 0x0025f,
  0x00193, 0x00261, 0x00262, 0x00194, 0x00264, 0x00265, 0x00266, 0x00267,
  0x00197, 0x00196, 0x0026a, 0x0026b, 0x0026c, 0x0026d, 0x0026e, 0x0019c,
  0x00270, 0x00271, 0x0019d, 0x00273, 0x00274, 0x0019f, 0x00276, 0x00277,
  0x00278, 0x00279, 0x0027a, 0x0027b, 0x0027c, 0x0027d, 0x0027e, 0x0027f,
  0x001a6, 0x00281, 0x00282, 0x001a9, 0x00284, 0x00285, 0x00286, 0x00287,
  0x001ae, 0x00289, 0x001b1, 0x001b2, 0x0028c, 0x0028d, 0x0028e, 0x0028f,
  0x00290, 0x00291, 0x001b7, 0x00293, 0x00294, 0x00295, 0x00296, 0x00297,
  0x00298, 0x00299, 0x0029a, 0x0029b, 0x0029c, 0x0029d, 0x0029e, 0x0029f,
  0x002a0, 0x002a1, 0x002a2, 0x001c4, 0x002a4, 0x002a5, 0x001be, 0x002a7,
  0x002a8, 0x002a9, 0x002aa, 0x002ab, 0x002ac, 0x002ad, 0x002ae, 0x002af,
  0x00048, 0x00266, 0x0004a, 0x00052, 0x00279, 0x0027b, 0x00281, 0x00057,
  0x00059, 0x002b9, 0x002ba, 0x002bb, 0x002bc, 0x002bd, 0x002be, 0x002bf,
  0x002c0, 0x002c1, 0x002c2, 0x002c3, 0x002c4, 0x002c5, 0x002c6, 0x002c7,
  0x002c8, 0x002c9, 0x002ca, 0x002cb, 0x002cc, 0x002cd, 0x002ce, 0x002cf,
  0x002d0, 0x002d1, 0x002d2, 0x002d3, 0x002d4, 0x002d5, 0x002d6, 0x002d7,
  0x002d8, 0x002d9, 0x002da, 0x002db, 0x002dc, 0x002dd, 0x002de, 0x002df,
  0x00194, 0x0004c, 0x00053, 0x00058, 0x00295, 0x002e5, 0x002e6, 0x002e7,
  0x002e8, 0x002e9, 0x002ea, 0x002eb, 0x002ec, 0x002ed, 0x002ee, 0x002ef,
  0x002f0, 0x002f1, 0x002f2, 0x002f3, 0x002f4, 0x002f5, 0x002f6, 0x002f7,
  0x002f8, 0x002f9, 0x002fa, 0x002fb, 0x002fc, 0x002fd, 0x002fe, 0x002ff
};

static uint32_t unicode_ci_page_03[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00358, 0x00359, 0x0035a, 0x0035b, 0x0035c, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00041, 0x00045, 0x00049, 0x0004f, 0x00055,
  0x00043, 0x00044, 0x00048, 0x0004d, 0x00052, 0x00054, 0x00056, 0x00058,
  0x00370, 0x00371, 0x00372, 0x00373, 0x002b9, 0x00375, 0x00376, 0x00377,
  0x00378, 0x00379, 0x0037a, 0x0037b, 0x0037c, 0x0037d, 0x0003b, 0x0037f,
  0x00380, 0x00381, 0x00382, 0x00383, 0x000b4, 0x000a8, 0x00386, 0x000b7,
  0x00388, 0x00389, 0x0037a, 0x0038b, 0x0038c, 0x0038d, 0x0038e, 0x0038f,
  0x0037a, 0x00386, 0x00392, 0x00393, 0x00394, 0x00388, 0x00396, 0x00389,
  0x00398, 0x0037a, 0x0039a, 0x0039b, 0x000b5, 0x0039d, 0x0039e, 0x0038c,
  0x003a0, 0x003a1, 0x003a2, 0x003a3, 0x003a4, 0x0038e, 0x003a6, 0x003a7,
  0x003a8, 0x0038f, 0x0037a, 0x0038e, 0x00386, 0x00388, 0x00389, 0x0037a,
  0x0038e, 0x00386, 0x00392, 0x00393, 0x00394, 0x00388, 0x00396, 0x00389,
  0x00398, 0x0037a, 0x0039a, 0x0039b, 0x000b5, 0x0039d, 0x0039e, 0x0038c,
  0x003a0, 0x003a1, 0x003a3, 0x003a3, 0x003a4, 0x0038e, 0x003a6, 0x003a7,
  0x003a8, 0x0038f, 0x0037a, 0x0038e, 0x0038c, 0x0038e, 0x0038f, 0x003cf,
  0x00392, 0x00398, 0x0038e, 0x0038e, 0x0038e, 0x003a6, 0x003a0, 0x003d7,
  0x003d8, 0x003d8, 0x003da, 0x003da, 0x003dc, 0x003dc, 0x003de, 0x003de,
  0x003e0, 0x003e0, 0x003e2, 0x003e2, 0x003e4, 0x003e4, 0x003e6, 0x003e6,
  0x003e8, 0x003e8, 0x003ea, 0x003ea, 0x003ec, 0x003ec, 0x003ee, 0x003ee,
  0x0039a, 0x003a1, 0x003a3, 0x003f3, 0x00398, 0x00388, 0x003f6, 0x003f7,
  0x003f7, 0x003a3, 0x003fa, 0x003fa, 0x003fc, 0x003fd, 0x003fe, 0x003ff
};

static uint32_t unicode_ci_page_04[] = {
  0x00400, 0x00400, 0x00402, 0x00403, 0x00404, 0x00405, 0x00406, 0x00407,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0040c, 0x0040d, 0x0040e, 0x0040f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00400, 0x00416, 0x00417,
  0x0040d, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00410, 0x00411, 0x00412, 0x00413, 0x00414, 0x00400, 0x00416, 0x00417,
  0x0040d, 0x00419, 0x0041a, 0x0041b, 0x0041c, 0x0041d, 0x0041e, 0x0041f,
  0x00420, 0x00421, 0x00422, 0x00423, 0x00424, 0x00425, 0x00426, 0x00427,
  0x00428, 0x00429, 0x0042a, 0x0042b, 0x0042c, 0x0042d, 0x0042e, 0x0042f,
  0x00400, 0x00400, 0x00402, 0x00403, 0x00404, 0x00405, 0x00406, 0x00407,
  0x00408, 0x00409, 0x0040a, 0x0040b, 0x0040c, 0x0040d, 0x0040e, 0x0040f,
  0x00460, 0x00460, 0x00462, 0x00462, 0x00464, 0x00464, 0x00466, 0x00466,
  0x00468, 0x00468, 0x0046a, 0x0046a, 0x0046c, 0x0046c, 0x0046e, 0x0046e,
  0x00470, 0x00470, 0x00472, 0x00472, 0x00474, 0x00474, 0x00476, 0x00476,
  0x00478, 0x00478, 0x0047a, 0x0047a, 0x0047c, 0x0047c, 0x0047e, 0x0047e,
  0x00480, 0x00480, 0x00482, 0x00000, 0x00000, 0x00000, 0x00000, 0x00487,
  0x00000, 0x00000, 0x0048a, 0x0048a, 0x0048c, 0x0048c, 0x0048e, 0x0048e,
  0x00413, 0x00413, 0x00492, 0x00492, 0x00494, 0x00494, 0x00496, 0x00496,
  0x00498, 0x00498, 0x0049a, 0x0049a, 0x0049c, 0x0049c, 0x0049e, 0x0049e,
  0x004a0, 0x004a0, 0x004a2, 0x004a2, 0x004a4, 0x004a4, 0x004a6, 0x004a6,
  0x004a8, 0x004a8, 0x004aa, 0x004aa, 0x004ac, 0x004ac, 0x004ae, 0x004ae,
  0x004b0, 0x004b0, 0x004b2, 0x004b2, 0x004b4, 0x004b4, 0x004b6, 0x004b6,
  0x004b8, 0x004b8, 0x004ba, 0x004ba, 0x004bc, 0x004bc, 0x004be, 0x004be,
  0x004c0, 0x00416, 0x00416, 0x004c3, 0x004c3, 0x004c5, 0x004c5, 0x004c7,
  0x004c7, 0x004c9, 0x004c9, 0x004cb, 0x004cb, 0x004cd, 0x004cd, 0x004cf,
  0x004d0, 0x004d0, 0x004d2, 0x004d2, 0x004d4, 0x004d4, 0x004d6, 0x004d6,
  0x004d8, 0x004d8, 0x004da, 0x004da, 0x004dc, 0x004dc, 0x004de, 0x004de,
  0x004e0, 0x004e0, 0x0040d, 0x0040d, 0x004e4, 0x004e4, 0x004e6, 0x004e6,
  0x004e8, 0x004e8, 0x004ea, 0x004ea, 0x004ec, 0x004ec, 0x00423, 0x00423,
  0x004f0, 0x004f0, 0x004f2, 0x004f2, 0x004f4, 0x004f4, 0x004f6, 0x004f7,
  0x004f8, 0x004f8, 0x004fa, 0x004fb, 0x004fc, 0x004fd, 0x004fe, 0x004ff
};

static uint32_t unicode_ci_page_05[] = {
  0x00500, 0x00500, 0x00502, 0x00502, 0x00504, 0x00504, 0x00506, 0x00506,
  0x00508, 0x00508, 0x0050a, 0x0050a, 0x0050c, 0x0050c, 0x0050e, 0x0050e,
  0x00510, 0x00511, 0x00512, 0x00513, 0x00514, 0x00515, 0x00516, 0x00517,
  0x00518, 0x00519, 0x0051a, 0x0051b, 0x0051c, 0x0051d, 0x0051e, 0x0051f,
  0x00520, 0x00521, 0x00522, 0x00523, 0x00524, 0x00525, 0x00526, 0x00527,
  0x00528, 0x00529, 0x0052a, 0x0052b, 0x0052c, 0x0052d, 0x0052e, 0x0052f,
  0x00530, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00557,
  0x00558, 0x00559, 0x0055a, 0x0055b, 0x0055c, 0x0055d, 0x0055e, 0x0055f,
  0x00560, 0x00531, 0x00532, 0x00533, 0x00534, 0x00535, 0x00536, 0x00537,
  0x00538, 0x00539, 0x0053a, 0x0053b, 0x0053c, 0x0053d, 0x0053e, 0x0053f,
  0x00540, 0x00541, 0x00542, 0x00543, 0x00544, 0x00545, 0x00546, 0x00547,
  0x00548, 0x00549, 0x0054a, 0x0054b, 0x0054c, 0x0054d, 0x0054e, 0x0054f,
  0x00550, 0x00551, 0x00552, 0x00553, 0x00554, 0x00555, 0x00556, 0x00587,
  0x00588, 0x00589, 0x0058a, 0x0058b, 0x0058c, 0x0058d, 0x0058e, 0x0058f,
  0x00590, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x005a2, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x005ba, 0x00000, 0x00000, 0x00000, 0x005be, 0x00000,
  0x005c0, 0x00000, 0x00000, 0x005c3, 0x00000, 0x005c5, 0x005c6, 0x005c7,
  0x005c8, 0x005c9, 0x005ca, 0x005cb, 0x005cc, 0x005cd, 0x005ce, 0x005cf,
  0x005d0, 0x005d1, 0x005d2, 0x005d3, 0x005d4, 0x005d5, 0x005d6, 0x005d7,
  0x005d8, 0x005d9, 0x005da, 0x005da, 0x005dc, 0x005dd, 0x005dd, 0x005df,
  0x005df, 0x005e1, 0x005e2, 0x005e3, 0x005e3, 0x005e5, 0x005e5, 0x005e7,
  0x005e8, 0x005e9, 0x005ea, 0x005eb, 0x005ec, 0x005ed, 0x005ee, 0x005ef,
  0x005f0, 0x005f1, 0x005f2, 0x005f3, 0x005f4, 0x005f5, 0x005f6, 0x005f7,
  0x005f8, 0x005f9, 0x005fa, 0x005fb, 0x005fc, 0x005fd, 0x005fe, 0x005ff
};

static uint32_t unicode_ci_page_06[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00604, 0x00605, 0x00606, 0x00607,
  0x00608, 0x00609, 0x0060a, 0x0060b, 0x0060c, 0x0060d, 0x0060e, 0x0060f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00616, 0x00617,
  0x00618, 0x00619, 0x0061a, 0x0061b, 0x0061c, 0x0061d, 0x0061e, 0x0061f,
  0x00620, 0x00621, 0x00622, 0x00623, 0x00624, 0x00625, 0x00626, 0x00627,
  0x00628, 0x00629, 0x0062a, 0x0062b, 0x0062c, 0x0062d, 0x0062e, 0x0062f,
  0x00630, 0x00631, 0x00632, 0x00633, 0x00634, 0x00635, 0x00636, 0x00637,
  0x00638, 0x00639, 0x0063a, 0x0063b, 0x0063c, 0x0063d, 0x0063e, 0x0063f,
  0x00640, 0x00641, 0x00642, 0x00643, 0x00644, 0x00645, 0x00646, 0x00647,
  0x00648, 0x00649, 0x0064a, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00659, 0x0065a, 0x0065b, 0x0065c, 0x0065d, 0x0065e, 0x0065f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0066a, 0x0066b, 0x0066c, 0x0066d, 0x0066e, 0x0066f,
  0x00000, 0x00671, 0x00672, 0x00673, 0x00621, 0x00675, 0x00676, 0x00677,
  0x00678, 0x00679, 0x0067a, 0x0067b, 0x0067c, 0x0067d, 0x0067e, 0x0067f,
  0x00680, 0x00681, 0x00682, 0x00683, 0x00684, 0x00685, 0x00686, 0x00687,
  0x00688, 0x00689, 0x0068a, 0x0068b, 0x0068c, 0x0068d, 0x0068e, 0x0068f,
  0x00690, 0x00691, 0x00692, 0x00693, 0x00694, 0x00695, 0x00696, 0x00697,
  0x00698, 0x00699, 0x0069a, 0x0069b, 0x0069c, 0x0069d, 0x0069e, 0x0069f,
  0x006a0, 0x006a1, 0x006a2, 0x006a3, 0x006a4, 0x006a5, 0x006a6, 0x006a7,
  0x006a8, 0x006a9, 0x006aa, 0x006ab, 0x006ac, 0x006ad, 0x006ae, 0x006af,
  0x006b0, 0x006b1, 0x006b2, 0x006b3, 0x006b4, 0x006b5, 0x006b6, 0x006b7,
  0x006b8, 0x006b9, 0x006ba, 0x006bb, 0x006bc, 0x006bd, 0x006be, 0x006bf,
  0x006c0, 0x006c1, 0x006c1, 0x006c3, 0x006c4, 0x006c5, 0x006c6, 0x006c7,
  0x006c8, 0x006c9, 0x006ca, 0x006cb, 0x006cc, 0x006cd, 0x006ce, 0x006cf,
  0x006d0, 0x006d1, 0x006d2, 0x006d2, 0x006d4, 0x006c0, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00648, 0x0064a, 0x00000,
  0x00000, 0x006e9, 0x00000, 0x00000, 0x00000, 0x00000, 0x006ee, 0x006ef,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x006fa, 0x006fb, 0x006fc, 0x00621, 0x00645, 0x006ff
};

static uint32_t unicode_ci_page_07[] = {
  0x00700, 0x00701, 0x00702, 0x00703, 0x00704, 0x00705, 0x00706, 0x00707,
  0x00708, 0x00709, 0x0070a, 0x0070b, 0x0070c, 0x0070d, 0x0070e, 0x00000,
  0x00710, 0x00000, 0x00712, 0x00713, 0x00713, 0x00715, 0x00716, 0x00717,
  0x00718, 0x00719, 0x0071a, 0x0071b, 0x0071b, 0x0071d, 0x0071e, 0x0071f,
  0x00720, 0x00721, 0x00722, 0x00723, 0x00723, 0x00725, 0x00726, 0x00726,
  0x00728, 0x00729, 0x0072a, 0x0072b, 0x0072c, 0x00712, 0x00713, 0x00715,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x0074b, 0x0074c, 0x0074d, 0x0074e, 0x0074f,
  0x00750, 0x00751, 0x00752, 0x00753, 0x00754, 0x00755, 0x00756, 0x00757,
  0x00758, 0x00759, 0x0075a, 0x0075b, 0x0075c, 0x0075d, 0x0075e, 0x0075f,
  0x00760, 0x00761, 0x00762, 0x00763, 0x00764, 0x00765, 0x00766, 0x00767,
  0x00768, 0x00769, 0x0076a, 0x0076b, 0x0076c, 0x0076d, 0x0076e, 0x0076f,
  0x00770, 0x00771, 0x00772, 0x00773, 0x00774, 0x00775, 0x00776, 0x00777,
  0x00778, 0x00779, 0x0077a, 0x0077b, 0x0077c, 0x0077d, 0x0077e, 0x0077f,
  0x00780, 0x00781, 0x00782, 0x00783, 0x00784, 0x00785, 0x00786, 0x00787,
  0x00788, 0x00789, 0x0078a, 0x0078b, 0x0078c, 0x0078d, 0x0078e, 0x0078f,
  0x00790, 0x00791, 0x00792, 0x00793, 0x00794, 0x00795, 0x00796, 0x00797,
  0x00798, 0x00799, 0x0079a, 0x0079b, 0x0079c, 0x0079d, 0x0079e, 0x0079f,
  0x007a0, 0x007a1, 0x007a2, 0x007a3, 0x007a4, 0x007a5, 0x007a6, 0x007a7,
  0x007a8, 0x007a9, 0x007aa, 0x007ab, 0x007ac, 0x007ad, 0x007ae, 0x007af,
  0x007b0, 0x007b1, 0x007b2, 0x007b3, 0x007b4, 0x007b5, 0x007b6, 0x007b7,
  0x007b8, 0x007b9, 0x007ba, 0x007bb, 0x007bc, 0x007bd, 0x007be, 0x007bf,
  0x007c0, 0x007c1, 0x007c2, 0x007c3, 0x007c4, 0x007c5, 0x007c6, 0x007c7,
  0x007c8, 0x007c9, 0x007ca, 0x007cb, 0x007cc, 0x007cd, 0x007ce, 0x007cf,
  0x007d0, 0x007d1, 0x007d2, 0x007d3, 0x007d4, 0x007d5, 0x007d6, 0x007d7,
  0x007d8, 0x007d9, 0x007da, 0x007db, 0x007dc, 0x007dd, 0x007de, 0x007df,
  0x007e0, 0x007e1, 0x007e2, 0x007e3, 0x007e4, 0x007e5, 0x007e6, 0x007e7,
  0x007e8, 0x007e9, 0x007ea, 0x007eb, 0x007ec, 0x007ed, 0x007ee, 0x007ef,
  0x007f0, 0x007f1, 0x007f2, 0x007f3, 0x007f4, 0x007f5, 0x007f6, 0x007f7,
  0x007f8, 0x007f9, 0x007fa, 0x007fb, 0x007fc, 0x007fd, 0x007fe, 0x007ff
};

static uint32_t unicode_ci_page_09[] = {
  0x00900, 0x00000, 0x00000, 0x00000, 0x00904, 0x00905, 0x00906, 0x00907,
  0x00908, 0x00909, 0x0090a, 0x0090b, 0x0090c, 0x0090d, 0x0090e, 0x0090f,
  0x00910, 0x00911, 0x00912, 0x00913, 0x00914, 0x00915, 0x00916, 0x00917,
  0x00918, 0x00919, 0x0091a, 0x0091b, 0x0091c, 0x0091d, 0x0091e, 0x0091f,
  0x00920, 0x00921, 0x00922, 0x00923, 0x00924, 0x00925, 0x00926, 0x00927,
  0x00928, 0x00928, 0x0092a, 0x0092b, 0x0092c, 0x0092d, 0x0092e, 0x0092f,
  0x00930, 0x00930, 0x00932, 0x00933, 0x00933, 0x00935, 0x00936, 0x00937,
  0x00938, 0x00939, 0x0093a, 0x0093b, 0x00000, 0x0093d, 0x0093e, 0x0093f,
  0x00940, 0x00941, 0x00942, 0x00943, 0x00944, 0x00945, 0x00946, 0x00947,
  0x00948, 0x00949, 0x0094a, 0x0094b, 0x0094c, 0x0094d, 0x0094e, 0x0094f,
  0x00950, 0x00000, 0x00000, 0x00000, 0x00000, 0x00955, 0x00956, 0x00957,
  0x00915, 0x00916, 0x00917, 0x0091c, 0x00921, 0x00922, 0x0092b, 0x0092f,
  0x00960, 0x00961, 0x00962, 0x00963, 0x00964, 0x00965, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00970, 0x00971, 0x00972, 0x00973, 0x00974, 0x00975, 0x00976, 0x00977,
  0x00978, 0x00979, 0x0097a, 0x0097b, 0x0097c, 0x0097d, 0x0097e, 0x0097f,
  0x00980, 0x00000, 0x00000, 0x00000, 0x00984, 0x00985, 0x00986, 0x00987,
  0x00988, 0x00989, 0x0098a, 0x0098b, 0x0098c, 0x0098d, 0x0098e, 0x0098f,
  0x00990, 0x00991, 0x00992, 0x00993, 0x00994, 0x00995, 0x00996, 0x00997,
  0x00998, 0x00999, 0x0099a, 0x0099b, 0x0099c, 0x0099d, 0x0099e, 0x0099f,
  0x009a0, 0x009a1, 0x009a2, 0x009a3, 0x009a4, 0x009a5, 0x009a6, 0x009a7,
  0x009a8, 0x009a9, 0x009aa, 0x009ab, 0x009ac, 0x009ad, 0x009ae, 0x009af,
  0x009b0, 0x009b1, 0x009b2, 0x009b3, 0x009b4, 0x009b5, 0x009b6, 0x009b7,
  0x009b8, 0x009b9, 0x009ba, 0x009bb, 0x00000, 0x009bd, 0x009be, 0x009bf,
  0x009c0, 0x009c1, 0x009c2, 0x009c3, 0x009c4, 0x009c5, 0x009c6, 0x009c7,
  0x009c8, 0x009c9, 0x009ca, 0x009cb, 0x009cc, 0x009cd, 0x009ce, 0x009cf,
  0x009d0, 0x009d1, 0x009d2, 0x009d3, 0x009d4, 0x009d5, 0x009d6, 0x009d7,
  0x009d8, 0x009d9, 0x009da, 0x009db, 0x009a1, 0x009a2, 0x009de, 0x009af,
  0x009e0, 0x009e1, 0x009e2, 0x009e3, 0x009e4, 0x009e5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x009f0, 0x009f1, 0x009f2, 0x009f3, 0x00031, 0x00032, 0x00033, 0x00034,
  0x009f8, 0x009f9, 0x009fa, 0x009fb, 0x009fc, 0x009fd, 0x009fe, 0x009ff
};

static uint32_t unicode_ci_page_0a[] = {
  0x00a00, 0x00000, 0x00000, 0x00000, 0x00a04, 0x00a05, 0x00a06, 0x00a07,
  0x00a08, 0x00a09, 0x00a0a, 0x00a0b, 0x00a0c, 0x00a0d, 0x00a0e, 0x00a0f,
  0x00a10, 0x00a11, 0x00a12, 0x00a13, 0x00a14, 0x00a15, 0x00a16, 0x00a17,
  0x00a18, 0x00a19, 0x00a1a, 0x00a1b, 0x00a1c, 0x00a1d, 0x00a1e, 0x00a1f,
  0x00a20, 0x00a21, 0x00a22, 0x00a23, 0x00a24, 0x00a25, 0x00a26, 0x00a27,
  0x00a28, 0x00a29, 0x00a2a, 0x00a2b, 0x00a2c, 0x00a2d, 0x00a2e, 0x00a2f,
  0x00a30, 0x00a31, 0x00a32, 0x00a32, 0x00a34, 0x00a35, 0x00a36, 0x00a37,
  0x00a36, 0x00a39, 0x00a3a, 0x00a3b, 0x00000, 0x00a3d, 0x00a3e, 0x00a3f,
  0x00a40, 0x00a41, 0x00a42, 0x00a43, 0x00a44, 0x00a45, 0x00a46, 0x00a47,
  0x00a48, 0x00a49, 0x00a4a, 0x00a4b, 0x00a4c, 0x00a4d, 0x00a4e, 0x00a4f,
  0x00a50, 0x00a51, 0x00a52, 0x00a53, 0x00a54, 0x00a55, 0x00a56, 0x00a57,
  0x00a58, 0x00a16, 0x00a17, 0x00a1c, 0x00a5c, 0x00a5d, 0x00a2b, 0x00a5f,
  0x00a60, 0x00a61, 0x00a62, 0x00a63, 0x00a64, 0x00a65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00000, 0x00000, 0x00a72, 0x00a73, 0x00a74, 0x00a75, 0x00a76, 0x00a77,
  0x00a78, 0x00a79, 0x00a7a, 0x00a7b, 0x00a7c, 0x00a7d, 0x00a7e, 0x00a7f,
  0x00a80, 0x00000, 0x00000, 0x00000, 0x00a84, 0x00a85, 0x00a86, 0x00a87,
  0x00a88, 0x00a89, 0x00a8a, 0x00a8b, 0x00a8c, 0x00a8d, 0x00a8e, 0x00a8f,
  0x00a90, 0x00a91, 0x00a92, 0x00a93, 0x00a94, 0x00a95, 0x00a96, 0x00a97,
  0x00a98, 0x00a99, 0x00a9a, 0x00a9b, 0x00a9c, 0x00a9d, 0x00a9e, 0x00a9f,
  0x00aa0, 0x00aa1, 0x00aa2, 0x00aa3, 0x00aa4, 0x00aa5, 0x00aa6, 0x00aa7,
  0x00aa8, 0x00aa9, 0x00aaa, 0x00aab, 0x00aac, 0x00aad, 0x00aae, 0x00aaf,
  0x00ab0, 0x00ab1, 0x00ab2, 0x00ab3, 0x00ab4, 0x00ab5, 0x00ab6, 0x00ab7,
  0x00ab8, 0x00ab9, 0x00aba, 0x00abb, 0x00000, 0x00abd, 0x00abe, 0x00abf,
  0x00ac0, 0x00ac1, 0x00ac2, 0x00ac3, 0x00ac4, 0x00ac5, 0x00ac6, 0x00ac7,
  0x00ac8, 0x00ac9, 0x00aca, 0x00acb, 0x00acc, 0x00acd, 0x00ace, 0x00acf,
  0x00ad0, 0x00ad1, 0x00ad2, 0x00ad3, 0x00ad4, 0x00ad5, 0x00ad6, 0x00ad7,
  0x00ad8, 0x00ad9, 0x00ada, 0x00adb, 0x00adc, 0x00add, 0x00ade, 0x00adf,
  0x00ae0, 0x00ae1, 0x00ae2, 0x00ae3, 0x00ae4, 0x00ae5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00af0, 0x00af1, 0x00af2, 0x00af3, 0x00af4, 0x00af5, 0x00af6, 0x00af7,
  0x00af8, 0x00af9, 0x00afa, 0x00afb, 0x00afc, 0x00afd, 0x00afe, 0x00aff
};

static uint32_t unicode_ci_page_0b[] = {
  0x00b00, 0x00000, 0x00000, 0x00000, 0x00b04, 0x00b05, 0x00b06, 0x00b07,
  0x00b08, 0x00b09, 0x00b0a, 0x00b0b, 0x00b0c, 0x00b0d, 0x00b0e, 0x00b0f,
  0x00b10, 0x00b11, 0x00b12, 0x00b13, 0x00b14, 0x00b15, 0x00b16, 0x00b17,
  0x00b18, 0x00b19, 0x00b1a, 0x00b1b, 0x00b1c, 0x00b1d, 0x00b1e, 0x00b1f,
  0x00b20, 0x00b21, 0x00b22, 0x00b23, 0x00b24, 0x00b25, 0x00b26, 0x00b27,
  0x00b28, 0x00b29, 0x00b2a, 0x00b2b, 0x00b2c, 0x00b2d, 0x00b2e, 0x00b2f,
  0x00b30, 0x00b31, 0x00b32, 0x00b33, 0x00b34, 0x00b35, 0x00b36, 0x00b37,
  0x00b38, 0x00b39, 0x00b3a, 0x00b3b, 0x00000, 0x00b3d, 0x00b3e, 0x00b3f,
  0x00b40, 0x00b41, 0x00b42, 0x00b43, 0x00b44, 0x00b45, 0x00b46, 0x00b47,
  0x00b48, 0x00b49, 0x00b4a, 0x00b4b, 0x00b4c, 0x00b4d, 0x00b4e, 0x00b4f,
  0x00b50, 0x00b51, 0x00b52, 0x00b53, 0x00b54, 0x00b55, 0x00b56, 0x00b57,
  0x00b58, 0x00b59, 0x00b5a, 0x00b5b, 0x00b21, 0x00b22, 0x00b5e, 0x00b5f,
  0x00b60, 0x00b61, 0x00b62, 0x00b63, 0x00b64, 0x00b65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00b70, 0x00b71, 0x00b72, 0x00b73, 0x00b74, 0x00b75, 0x00b76, 0x00b77,
  0x00b78, 0x00b79, 0x00b7a, 0x00b7b, 0x00b7c, 0x00b7d, 0x00b7e, 0x00b7f,
  0x00b80, 0x00b81, 0x00000, 0x00b83, 0x00b84, 0x00b85, 0x00b86, 0x00b87,
  0x00b88, 0x00b89, 0x00b8a, 0x00b8b, 0x00b8c, 0x00b8d, 0x00b8e, 0x00b8f,
  0x00b90, 0x00b91, 0x00b92, 0x00b93, 0x00b94, 0x00b95, 0x00b96, 0x00b97,
  0x00b98, 0x00b99, 0x00b9a, 0x00b9b, 0x00b9c, 0x00b9d, 0x00b9e, 0x00b9f,
  0x00ba0, 0x00ba1, 0x00ba2, 0x00ba3, 0x00ba4, 0x00ba5, 0x00ba6, 0x00ba7,
  0x00ba8, 0x00ba9, 0x00baa, 0x00bab, 0x00bac, 0x00bad, 0x00bae, 0x00baf,
  0x00bb0, 0x00bb1, 0x00bb2, 0x00bb3, 0x00bb4, 0x00bb5, 0x00bb6, 0x00bb7,
  0x00bb8, 0x00bb9, 0x00bba, 0x00bbb, 0x00bbc, 0x00bbd, 0x00bbe, 0x00bbf,
  0x00bc0, 0x00bc1, 0x00bc2, 0x00bc3, 0x00bc4, 0x00bc5, 0x00bc6, 0x00bc7,
  0x00bc8, 0x00bc9, 0x00bca, 0x00bcb, 0x00bcc, 0x00bcd, 0x00bce, 0x00bcf,
  0x00bd0, 0x00bd1, 0x00bd2, 0x00bd3, 0x00bd4, 0x00bd5, 0x00bd6, 0x00bd7,
  0x00bd8, 0x00bd9, 0x00bda, 0x00bdb, 0x00bdc, 0x00bdd, 0x00bde, 0x00bdf,
  0x00be0, 0x00be1, 0x00be2, 0x00be3, 0x00be4, 0x00be5, 0x00be6, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00bf0, 0x00bf1, 0x00bf2, 0x00bf3, 0x00bf4, 0x00bf5, 0x00bf6, 0x00bf7,
  0x00bf8, 0x00bf9, 0x00bfa, 0x00bfb, 0x00bfc, 0x00bfd, 0x00bfe, 0x00bff
};

static uint32_t unicode_ci_page_0c[] = {
  0x00c00, 0x00000, 0x00000, 0x00000, 0x00c04, 0x00c05, 0x00c06, 0x00c07,
  0x00c08, 0x00c09, 0x00c0a, 0x00c0b, 0x00c0c, 0x00c0d, 0x00c0e, 0x00c0f,
  0x00c10, 0x00c11, 0x00c12, 0x00c13, 0x00c14, 0x00c15, 0x00c16, 0x00c17,
  0x00c18, 0x00c19, 0x00c1a, 0x00c1b, 0x00c1c, 0x00c1d, 0x00c1e, 0x00c1f,
  0x00c20, 0x00c21, 0x00c22, 0x00c23, 0x00c24, 0x00c25, 0x00c26, 0x00c27,
  0x00c28, 0x00c29, 0x00c2a, 0x00c2b, 0x00c2c, 0x00c2d, 0x00c2e, 0x00c2f,
  0x00c30, 0x00c31, 0x00c32, 0x00c33, 0x00c34, 0x00c35, 0x00c36, 0x00c37,
  0x00c38, 0x00c39, 0x00c3a, 0x00c3b, 0x00c3c, 0x00c3d, 0x00c3e, 0x00c3f,
  0x00c40, 0x00c41, 0x00c42, 0x00c43, 0x00c44, 0x00c45, 0x00c46, 0x00c47,
  0x00c48, 0x00c49, 0x00c4a, 0x00c4b, 0x00c4c, 0x00c4d, 0x00c4e, 0x00c4f,
  0x00c50, 0x00c51, 0x00c52, 0x00c53, 0x00c54, 0x00c55, 0x00c56, 0x00c57,
  0x00c58, 0x00c59, 0x00c5a, 0x00c5b, 0x00c5c, 0x00c5d, 0x00c5e, 0x00c5f,
  0x00c60, 0x00c61, 0x00c62, 0x00c63, 0x00c64, 0x00c65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00c70, 0x00c71, 0x00c72, 0x00c73, 0x00c74, 0x00c75, 0x00c76, 0x00c77,
  0x00c78, 0x00c79, 0x00c7a, 0x00c7b, 0x00c7c, 0x00c7d, 0x00c7e, 0x00c7f,
  0x00c80, 0x00c81, 0x00000, 0x00000, 0x00c84, 0x00c85, 0x00c86, 0x00c87,
  0x00c88, 0x00c89, 0x00c8a, 0x00c8b, 0x00c8c, 0x00c8d, 0x00c8e, 0x00c8f,
  0x00c90, 0x00c91, 0x00c92, 0x00c93, 0x00c94, 0x00c95, 0x00c96, 0x00c97,
  0x00c98, 0x00c99, 0x00c9a, 0x00c9b, 0x00c9c, 0x00c9d, 0x00c9e, 0x00c9f,
  0x00ca0, 0x00ca1, 0x00ca2, 0x00ca3, 0x00ca4, 0x00ca5, 0x00ca6, 0x00ca7,
  0x00ca8, 0x00ca9, 0x00caa, 0x00cab, 0x00cac, 0x00cad, 0x00cae, 0x00caf,
  0x00cb0, 0x00cb1, 0x00cb2, 0x00cb3, 0x00cb4, 0x00cb5, 0x00cb6, 0x00cb7,
  0x00cb8, 0x00cb9, 0x00cba, 0x00cbb, 0x00000, 0x00cbd, 0x00cbe, 0x00cbf,
  0x00cc0, 0x00cc1, 0x00cc2, 0x00cc3, 0x00cc4, 0x00cc5, 0x00cc6, 0x00cc7,
  0x00cc8, 0x00cc9, 0x00cca, 0x00ccb, 0x00ccc, 0x00ccd, 0x00cce, 0x00ccf,
  0x00cd0, 0x00cd1, 0x00cd2, 0x00cd3, 0x00cd4, 0x00cd5, 0x00cd6, 0x00cd7,
  0x00cd8, 0x00cd9, 0x00cda, 0x00cdb, 0x00cdc, 0x00cdd, 0x00cde, 0x00cdf,
  0x00ce0, 0x00ce1, 0x00ce2, 0x00ce3, 0x00ce4, 0x00ce5, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00cf0, 0x00cf1, 0x00cf2, 0x00cf3, 0x00cf4, 0x00cf5, 0x00cf6, 0x00cf7,
  0x00cf8, 0x00cf9, 0x00cfa, 0x00cfb, 0x00cfc, 0x00cfd, 0x00cfe, 0x00cff
};

static uint32_t unicode_ci_page_0d[] = {
  0x00d00, 0x00d01, 0x00000, 0x00000, 0x00d04, 0x00d05, 0x00d06, 0x00d07,
  0x00d08, 0x00d09, 0x00d0a, 0x00d0b, 0x00d0c, 0x00d0d, 0x00d0e, 0x00d0f,
  0x00d10, 0x00d11, 0x00d12, 0x00d13, 0x00d14, 0x00d15, 0x00d16, 0x00d17,
  0x00d18, 0x00d19, 0x00d1a, 0x00d1b, 0x00d1c, 0x00d1d, 0x00d1e, 0x00d1f,
  0x00d20, 0x00d21, 0x00d22, 0x00d23, 0x00d24, 0x00d25, 0x00d26, 0x00d27,
  0x00d28, 0x00d29, 0x00d2a, 0x00d2b, 0x00d2c, 0x00d2d, 0x00d2e, 0x00d2f,
  0x00d30, 0x00d31, 0x00d32, 0x00d33, 0x00d34, 0x00d35, 0x00d36, 0x00d37,
  0x00d38, 0x00d39, 0x00d3a, 0x00d3b, 0x00d3c, 0x00d3d, 0x00d3e, 0x00d3f,
  0x00d40, 0x00d41, 0x00d42, 0x00d43, 0x00d44, 0x00d45, 0x00d46, 0x00d47,
  0x00d48, 0x00d49, 0x00d4a, 0x00d4b, 0x00d4c, 0x00d4d, 0x00d4e, 0x00d4f,
  0x00d50, 0x00d51, 0x00d52, 0x00d53, 0x00d54, 0x00d55, 0x00d56, 0x00d57,
  0x00d58, 0x00d59, 0x00d5a, 0x00d5b, 0x00d5c, 0x00d5d, 0x00d5e, 0x00d5f,
  0x00d60, 0x00d61, 0x00d62, 0x00d63, 0x00d64, 0x00d65, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x00d70, 0x00d71, 0x00d72, 0x00d73, 0x00d74, 0x00d75, 0x00d76, 0x00d77,
  0x00d78, 0x00d79, 0x00d7a, 0x00d7b, 0x00d7c, 0x00d7d, 0x00d7e, 0x00d7f,
  0x00d80, 0x00d81, 0x00000, 0x00000, 0x00d84, 0x00d85, 0x00d86, 0x00d87,
  0x00d88, 0x00d89, 0x00d8a, 0x00d8b, 0x00d8c, 0x00d8d, 0x00d8e, 0x00d8f,
  0x00d90, 0x00d91, 0x00d92, 0x00d93, 0x00d94, 0x00d95, 0x00d96, 0x00d97,
  0x00d98, 0x00d99, 0x00d9a, 0x00d9b, 0x00d9c, 0x00d9d, 0x00d9e, 0x00d9f,
  0x00da0, 0x00da1, 0x00da2, 0x00da3, 0x00da4, 0x00da5, 0x00da6, 0x00da7,
  0x00da8, 0x00da9, 0x00daa, 0x00dab, 0x00dac, 0x00dad, 0x00dae, 0x00daf,
  0x00db0, 0x00db1, 0x00db2, 0x00db3, 0x00db4, 0x00db5, 0x00db6, 0x00db7,
  0x00db8, 0x00db9, 0x00dba, 0x00dbb, 0x00dbc, 0x00dbd, 0x00dbe, 0x00dbf,
  0x00dc0, 0x00dc1, 0x00dc2, 0x00dc3, 0x00dc4, 0x00dc5, 0x00dc6, 0x00dc7,
  0x00dc8, 0x00dc9, 0x00dca, 0x00dcb, 0x00dcc, 0x00dcd, 0x00dce, 0x00dcf,
  0x00dd0, 0x00dd1, 0x00dd2, 0x00dd3, 0x00dd4, 0x00dd5, 0x00dd6, 0x00dd7,
  0x00dd8, 0x00dd9, 0x00dda, 0x00ddb, 0x00ddc, 0x00ddd, 0x00dde, 0x00ddf,
  0x00de0, 0x00de1, 0x00de2, 0x00de3, 0x00de4, 0x00de5, 0x00de6, 0x00de7,
  0x00de8, 0x00de9, 0x00dea, 0x00deb, 0x00dec, 0x00ded, 0x00dee, 0x00def,
  0x00df0, 0x00df1, 0x00df2, 0x00df3, 0x00df4, 0x00df5, 0x00df6, 0x00df7,
  0x00df8, 0x00df9, 0x00dfa, 0x00dfb, 0x00dfc, 0x00dfd, 0x00dfe, 0x00dff
};

static uint32_t unicode_ci_page_0e[] = {
  0x00e00, 0x00e01, 0x00e02, 0x00e03, 0x00e04, 0x00e05, 0x00e06, 0x00e07,
  0x00e08, 0x00e09, 0x00e0a, 0x00e0b, 0x00e0c, 0x00e0d, 0x00e0e, 0x00e0f,
  0x00e10, 0x00e11, 0x00e12, 0x00e13, 0x00e14, 0x00e15, 0x00e16, 0x00e17,
  0x00e18, 0x00e19, 0x00e1a, 0x00e1b, 0x00e1c, 0x00e1d, 0x00e1e, 0x00e1f,
  0x00e20, 0x00e21, 0x00e22, 0x00e23, 0x00e24, 0x00e25, 0x00e26, 0x00e27,
  0x00e28, 0x00e29, 0x00e2a, 0x00e2b, 0x00e2c, 0x00e2d, 0x00e2e, 0x00e2f,
  0x00e30, 0x00e31, 0x00e32, 0x00e33, 0x00e34, 0x00e35, 0x00e36, 0x00e37,
  0x00e38, 0x00e39, 0x00e3a, 0x00e3b, 0x00e3c, 0x00e3d, 0x00e3e, 0x00e3f,
  0x00e40, 0x00e41, 0x00e42, 0x00e43, 0x00e44, 0x00e45, 0x00e46, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00e4c, 0x00e4d, 0x00000, 0x00e4f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00e5a, 0x00e5b, 0x00e5c, 0x00e5d, 0x00e5e, 0x00e5f,
  0x00e60, 0x00e61, 0x00e62, 0x00e63, 0x00e64, 0x00e65, 0x00e66, 0x00e67,
  0x00e68, 0x00e69, 0x00e6a, 0x00e6b, 0x00e6c, 0x00e6d, 0x00e6e, 0x00e6f,
  0x00e70, 0x00e71, 0x00e72, 0x00e73, 0x00e74, 0x00e75, 0x00e76, 0x00e77,
  0x00e78, 0x00e79, 0x00e7a, 0x00e7b, 0x00e7c, 0x00e7d, 0x00e7e, 0x00e7f,
  0x00e80, 0x00e81, 0x00e82, 0x00e83, 0x00e84, 0x00e85, 0x00e86, 0x00e87,
  0x00e88, 0x00e89, 0x00e8a, 0x00e8b, 0x00e8c, 0x00e8d, 0x00e8e, 0x00e8f,
  0x00e90, 0x00e91, 0x00e92, 0x00e93, 0x00e94, 0x00e95, 0x00e96, 0x00e97,
  0x00e98, 0x00e99, 0x00e9a, 0x00e9b, 0x00e9c, 0x00e9d, 0x00e9e, 0x00e9f,
  0x00ea0, 0x00ea1, 0x00ea2, 0x00ea3, 0x00ea4, 0x00ea5, 0x00ea6, 0x00ea7,
  0x00ea8, 0x00ea9, 0x00eaa, 0x00eab, 0x00eac, 0x00ead, 0x00eae, 0x00eaf,
  0x00eb0, 0x00eb1, 0x00eb2, 0x00eb3, 0x00eb4, 0x00eb5, 0x00eb6, 0x00eb7,
  0x00eb8, 0x00eb9, 0x00eba, 0x00ebb, 0x00ebc, 0x00ebd, 0x00ebe, 0x00ebf,
  0x00ec0, 0x00ec1, 0x00ec2, 0x00ec3, 0x00ec4, 0x00ec5, 0x00ec6, 0x00ec7,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00ecc, 0x00ecd, 0x00ece, 0x00ecf,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00eda, 0x00edb, 0x00edc, 0x00edd, 0x00ede, 0x00edf,
  0x00ee0, 0x00ee1, 0x00ee2, 0x00ee3, 0x00ee4, 0x00ee5, 0x00ee6, 0x00ee7,
  0x00ee8, 0x00ee9, 0x00eea, 0x00eeb, 0x00eec, 0x00eed, 0x00eee, 0x00eef,
  0x00ef0, 0x00ef1, 0x00ef2, 0x00ef3, 0x00ef4, 0x00ef5, 0x00ef6, 0x00ef7,
  0x00ef8, 0x00ef9, 0x00efa, 0x00efb, 0x00efc, 0x00efd, 0x00efe, 0x00eff
};

static uint32_t unicode_ci_page_0f[] = {
  0x00f00, 0x00f01, 0x00f02, 0x00f03, 0x00f04, 0x00f05, 0x00f06, 0x00f07,
  0x00f08, 0x00f09, 0x00f0a, 0x00f0b, 0x00f0b, 0x00f0d, 0x00f0e, 0x00f0f,
  0x00f10, 0x00f11, 0x00f12, 0x00f13, 0x00f14, 0x00f15, 0x00f16, 0x00f17,
  0x00000, 0x00000, 0x00f1a, 0x00f1b, 0x00f1c, 0x00f1d, 0x00f1e, 0x00f1f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036,
  0x00037, 0x00038, 0x00039, 0x00030, 0x00f34, 0x00000, 0x00f36, 0x00000,
  0x00f38, 0x00000, 0x00f3a, 0x00f3b, 0x00f3c, 0x00f3d, 0x00f3e, 0x00f3f,
  0x00f40, 0x00f41, 0x00f42, 0x00f43, 0x00f44, 0x00f45, 0x00f46, 0x00f47,
  0x00f48, 0x00f49, 0x00f4a, 0x00f4b, 0x00f4c, 0x00f4d, 0x00f4e, 0x00f4f,
  0x00f50, 0x00f51, 0x00f52, 0x00f53, 0x00f54, 0x00f55, 0x00f56, 0x00f57,
  0x00f58, 0x00f59, 0x00f5a, 0x00f5b, 0x00f5c, 0x00f5d, 0x00f5e, 0x00f5f,
  0x00f60, 0x00f61, 0x00f62, 0x00f63, 0x00f64, 0x00f65, 0x00f66, 0x00f67,
  0x00f68, 0x00f69, 0x00f62, 0x00f6b, 0x00f6c, 0x00f6d, 0x00f6e, 0x00f6f,
  0x00f70, 0x00f71, 0x00f72, 0x00f73, 0x00f74, 0x00f75, 0x00f76, 0x00f77,
  0x00f78, 0x00f79, 0x00f7a, 0x00f7b, 0x00f7c, 0x00f7d, 0x00000, 0x00000,
  0x00f80, 0x00f81, 0x00000, 0x00000, 0x00f84, 0x00f85, 0x00000, 0x00000,
  0x00f88, 0x00f89, 0x00f8a, 0x00f8b, 0x00f8c, 0x00f8d, 0x00f8e, 0x00f8f,
  0x00f90, 0x00f91, 0x00f92, 0x00f93, 0x00f94, 0x00f95, 0x00f96, 0x00f97,
  0x00f98, 0x00f99, 0x00f9a, 0x00f9b, 0x00f9c, 0x00f9d, 0x00f9e, 0x00f9f,
  0x00fa0, 0x00fa1, 0x00fa2, 0x00fa3, 0x00fa4, 0x00fa5, 0x00fa6, 0x00fa7,
  0x00fa8, 0x00fa9, 0x00faa, 0x00fab, 0x00fac, 0x00fad, 0x00fae, 0x00faf,
  0x00fb0, 0x00fb1, 0x00fb2, 0x00fb3, 0x00fb4, 0x00fb5, 0x00fb6, 0x00fb7,
  0x00fb8, 0x00fb9, 0x00fad, 0x00fb1, 0x00fb2, 0x00fbd, 0x00fbe, 0x00fbf,
  0x00fc0, 0x00fc1, 0x00fc2, 0x00fc3, 0x00fc4, 0x00fc5, 0x00000, 0x00fc7,
  0x00fc8, 0x00fc9, 0x00fca, 0x00fcb, 0x00fcc, 0x00fcd, 0x00fce, 0x00fcf,
  0x00fd0, 0x00fd1, 0x00fd2, 0x00fd3, 0x00fd4, 0x00fd5, 0x00fd6, 0x00fd7,
  0x00fd8, 0x00fd9, 0x00fda, 0x00fdb, 0x00fdc, 0x00fdd, 0x00fde, 0x00fdf,
  0x00fe0, 0x00fe1, 0x00fe2, 0x00fe3, 0x00fe4, 0x00fe5, 0x00fe6, 0x00fe7,
  0x00fe8, 0x00fe9, 0x00fea, 0x00feb, 0x00fec, 0x00fed, 0x00fee, 0x00fef,
  0x00ff0, 0x00ff1, 0x00ff2, 0x00ff3, 0x00ff4, 0x00ff5, 0x00ff6, 0x00ff7,
  0x00ff8, 0x00ff9, 0x00ffa, 0x00ffb, 0x00ffc, 0x00ffd, 0x00ffe, 0x00fff
};

static uint32_t unicode_ci_page_10[] = {
  0x01000, 0x01001, 0x01002, 0x01003, 0x01004, 0x01005, 0x01006, 0x01007,
  0x01008, 0x01009, 0x0100a, 0x0100b, 0x0100c, 0x0100d, 0x0100e, 0x0100f,
  0x01010, 0x01011, 0x01012, 0x01013, 0x01014, 0x01015, 0x01016, 0x01017,
  0x01018, 0x01019, 0x0101a, 0x0101b, 0x0101c, 0x0101d, 0x0101e, 0x0101f,
  0x01020, 0x01021, 0x01022, 0x01023, 0x01024, 0x01025, 0x01026, 0x01027,
  0x01028, 0x01029, 0x0102a, 0x0102b, 0x0102c, 0x0102d, 0x0102e, 0x0102f,
  0x01030, 0x01031, 0x01032, 0x01033, 0x01034, 0x01035, 0x00000, 0x00000,
  0x00000, 0x01039, 0x0103a, 0x0103b, 0x0103c, 0x0103d, 0x0103e, 0x0103f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0104a, 0x0104b, 0x0104c, 0x0104d, 0x0104e, 0x0104f,
  0x01050, 0x01051, 0x01052, 0x01053, 0x01054, 0x01055, 0x01056, 0x01057,
  0x01058, 0x01059, 0x0105a, 0x0105b, 0x0105c, 0x0105d, 0x0105e, 0x0105f,
  0x01060, 0x01061, 0x01062, 0x01063, 0x01064, 0x01065, 0x01066, 0x01067,
  0x01068, 0x01069, 0x0106a, 0x0106b, 0x0106c, 0x0106d, 0x0106e, 0x0106f,
  0x01070, 0x01071, 0x01072, 0x01073, 0x01074, 0x01075, 0x01076, 0x01077,
  0x01078, 0x01079, 0x0107a, 0x0107b, 0x0107c, 0x0107d, 0x0107e, 0x0107f,
  0x01080, 0x01081, 0x01082, 0x01083, 0x01084, 0x01085, 0x01086, 0x01087,
  0x01088, 0x01089, 0x0108a, 0x0108b, 0x0108c, 0x0108d, 0x0108e, 0x0108f,
  0x01090, 0x01091, 0x01092, 0x01093, 0x01094, 0x01095, 0x01096, 0x01097,
  0x01098, 0x01099, 0x0109a, 0x0109b, 0x0109c, 0x0109d, 0x0109e, 0x0109f,
  0x010a0, 0x010a1, 0x010a2, 0x010a3, 0x010a4, 0x010a5, 0x010a6, 0x010a7,
  0x010a8, 0x010a9, 0x010aa, 0x010ab, 0x010ac, 0x010ad, 0x010ae, 0x010af,
  0x010b0, 0x010b1, 0x010b2, 0x010b3, 0x010b4, 0x010b5, 0x010b6, 0x010b7,
  0x010b8, 0x010b9, 0x010ba, 0x010bb, 0x010bc, 0x010bd, 0x010be, 0x010bf,
  0x010c0, 0x010c1, 0x010c2, 0x010c3, 0x010c4, 0x010c5, 0x010c6, 0x010c7,
  0x010c8, 0x010c9, 0x010ca, 0x010cb, 0x010cc, 0x010cd, 0x010ce, 0x010cf,
  0x010a0, 0x010a1, 0x010a2, 0x010a3, 0x010a4, 0x010a5, 0x010a6, 0x010a7,
  0x010a8, 0x010a9, 0x010aa, 0x010ab, 0x010ac, 0x010ad, 0x010ae, 0x010af,
  0x010b0, 0x010b1, 0x010b2, 0x010b3, 0x010b4, 0x010b5, 0x010b6, 0x010b7,
  0x010b8, 0x010b9, 0x010ba, 0x010bb, 0x010bc, 0x010bd, 0x010be, 0x010bf,
  0x010c0, 0x010c1, 0x010c2, 0x010c3, 0x010c4, 0x010c5, 0x010f6, 0x010f7,
  0x010f8, 0x010f9, 0x010fa, 0x010fb, 0x010fc, 0x010fd, 0x010fe, 0x010ff
};

static uint32_t unicode_ci_page_13[] = {
  0x01300, 0x01301, 0x01302, 0x01303, 0x01304, 0x01305, 0x01306, 0x01307,
  0x01308, 0x01309, 0x0130a, 0x0130b, 0x0130c, 0x0130d, 0x0130e, 0x0130f,
  0x01310, 0x01311, 0x01312, 0x01313, 0x01314, 0x01315, 0x01316, 0x01317,
  0x01318, 0x01319, 0x0131a, 0x0131b, 0x0131c, 0x0131d, 0x0131e, 0x0131f,
  0x01320, 0x01321, 0x01322, 0x01323, 0x01324, 0x01325, 0x01326, 0x01327,
  0x01328, 0x01329, 0x0132a, 0x0132b, 0x0132c, 0x0132d, 0x0132e, 0x0132f,
  0x01330, 0x01331, 0x01332, 0x01333, 0x01334, 0x01335, 0x01336, 0x01337,
  0x01338, 0x01339, 0x0133a, 0x0133b, 0x0133c, 0x0133d, 0x0133e, 0x0133f,
  0x01340, 0x01341, 0x01342, 0x01343, 0x01344, 0x01345, 0x01346, 0x01347,
  0x01348, 0x01349, 0x0134a, 0x0134b, 0x0134c, 0x0134d, 0x0134e, 0x0134f,
  0x01350, 0x01351, 0x01352, 0x01353, 0x01354, 0x01355, 0x01356, 0x01357,
  0x01358, 0x01359, 0x0135a, 0x0135b, 0x0135c, 0x0135d, 0x0135e, 0x0135f,
  0x01360, 0x01361, 0x01362, 0x01363, 0x01364, 0x01365, 0x01366, 0x01367,
  0x01368, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x01372, 0x01373, 0x01374, 0x01375, 0x01376, 0x01377,
  0x01378, 0x01379, 0x0137a, 0x0137b, 0x0137c, 0x0137d, 0x0137e, 0x0137f,
  0x01380, 0x01381, 0x01382, 0x01383, 0x01384, 0x01385, 0x01386, 0x01387,
  0x01388, 0x01389, 0x0138a, 0x0138b, 0x0138c, 0x0138d, 0x0138e, 0x0138f,
  0x01390, 0x01391, 0x01392, 0x01393, 0x01394, 0x01395, 0x01396, 0x01397,
  0x01398, 0x01399, 0x0139a, 0x0139b, 0x0139c, 0x0139d, 0x0139e, 0x0139f,
  0x013a0, 0x013a1, 0x013a2, 0x013a3, 0x013a4, 0x013a5, 0x013a6, 0x013a7,
  0x013a8, 0x013a9, 0x013aa, 0x013ab, 0x013ac, 0x013ad, 0x013ae, 0x013af,
  0x013b0, 0x013b1, 0x013b2, 0x013b3, 0x013b4, 0x013b5, 0x013b6, 0x013b7,
  0x013b8, 0x013b9, 0x013ba, 0x013bb, 0x013bc, 0x013bd, 0x013be, 0x013bf,
  0x013c0, 0x013c1, 0x013c2, 0x013c3, 0x013c4, 0x013c5, 0x013c6, 0x013c7,
  0x013c8, 0x013c9, 0x013ca, 0x013cb, 0x013cc, 0x013cd, 0x013ce, 0x013cf,
  0x013d0, 0x013d1, 0x013d2, 0x013d3, 0x013d4, 0x013d5, 0x013d6, 0x013d7,
  0x013d8, 0x013d9, 0x013da, 0x013db, 0x013dc, 0x013dd, 0x013de, 0x013df,
  0x013e0, 0x013e1, 0x013e2, 0x013e3, 0x013e4, 0x013e5, 0x013e6, 0x013e7,
  0x013e8, 0x013e9, 0x013ea, 0x013eb, 0x013ec, 0x013ed, 0x013ee, 0x013ef,
  0x013f0, 0x013f1, 0x013f2, 0x013f3, 0x013f4, 0x013f5, 0x013f6, 0x013f7,
  0x013f8, 0x013f9, 0x013fa, 0x013fb, 0x013fc, 0x013fd, 0x013fe, 0x013ff
};

static uint32_t unicode_ci_page_16[] = {
  0x01600, 0x01601, 0x01602, 0x01603, 0x01604, 0x01605, 0x01606, 0x01607,
  0x01608, 0x01609, 0x0160a, 0x0160b, 0x0160c, 0x0160d, 0x0160e, 0x0160f,
  0x01610, 0x01611, 0x01612, 0x01613, 0x01614, 0x01615, 0x01616, 0x01617,
  0x01618, 0x01619, 0x0161a, 0x0161b, 0x0161c, 0x0161d, 0x0161e, 0x0161f,
  0x01620, 0x01621, 0x01622, 0x01623, 0x01624, 0x01625, 0x01626, 0x01627,
  0x01628, 0x01629, 0x0162a, 0x0162b, 0x0162c, 0x0162d, 0x0162e, 0x0162f,
  0x01630, 0x01631, 0x01632, 0x01633, 0x01634, 0x01635, 0x01636, 0x01637,
  0x01638, 0x01639, 0x0163a, 0x0163b, 0x0163c, 0x0163d, 0x0163e, 0x0163f,
  0x01640, 0x01641, 0x01642, 0x01643, 0x01644, 0x01645, 0x01646, 0x01647,
  0x01648, 0x01649, 0x0164a, 0x0164b, 0x0164c, 0x0164d, 0x0164e, 0x0164f,
  0x01650, 0x01651, 0x01652, 0x01653, 0x01654, 0x01655, 0x01656, 0x01657,
  0x01658, 0x01659, 0x0165a, 0x0165b, 0x0165c, 0x0165d, 0x0165e, 0x0165f,
  0x01660, 0x01661, 0x01662, 0x01663, 0x01664, 0x01665, 0x01666, 0x01667,
  0x01668, 0x01669, 0x0166a, 0x0166b, 0x0166c, 0x0166d, 0x0166e, 0x0166f,
  0x01670, 0x01671, 0x01672, 0x01673, 0x01674, 0x01675, 0x01676, 0x01677,
  0x01678, 0x01679, 0x0167a, 0x0167b, 0x0167c, 0x0167d, 0x0167e, 0x0167f,
  0x01680, 0x01681, 0x01682, 0x01683, 0x01684, 0x01685, 0x01686, 0x01687,
  0x01688, 0x01689, 0x0168a, 0x0168b, 0x0168c, 0x0168d, 0x0168e, 0x0168f,
  0x01690, 0x01691, 0x01692, 0x01693, 0x01694, 0x01695, 0x01696, 0x01697,
  0x01698, 0x01699, 0x0169a, 0x0169b, 0x0169c, 0x0169d, 0x0169e, 0x0169f,
  0x016a0, 0x016a0, 0x016a2, 0x016a3, 0x016a2, 0x016a2, 0x016a6, 0x016a6,
  0x016a8, 0x016a8, 0x016aa, 0x016ab, 0x016a8, 0x016a8, 0x016a8, 0x016af,
  0x016b0, 0x016b1, 0x016b2, 0x016b2, 0x016b2, 0x016b2, 0x016b2, 0x016b7,
  0x016b8, 0x016b9, 0x016ba, 0x016ba, 0x016ba, 0x016ba, 0x016be, 0x016be,
  0x016be, 0x016c1, 0x016c1, 0x016c3, 0x016c3, 0x016c5, 0x016c5, 0x016c7,
  0x016c8, 0x016c9, 0x016ca, 0x016ca, 0x016ca, 0x016ca, 0x016ca, 0x016cf,
  0x016cf, 0x016cf, 0x016d2, 0x016d2, 0x016d2, 0x016c8, 0x016d6, 0x016d7,
  0x016d7, 0x016d7, 0x016da, 0x016da, 0x016dc, 0x016dc, 0x016de, 0x016df,
  0x016e0, 0x016e1, 0x016e2, 0x016e3, 0x016e4, 0x016e5, 0x016e6, 0x016e6,
  0x016e6, 0x016b9, 0x016ca, 0x016eb, 0x016ec, 0x016ed, 0x016ee, 0x016ef,
  0x016f0, 0x016f1, 0x016f2, 0x016f3, 0x016f4, 0x016f5, 0x016f6, 0x016f7,
  0x016f8, 0x016f9, 0x016fa, 0x016fb, 0x016fc, 0x016fd, 0x016fe, 0x016ff
};

static uint32_t unicode_ci_page_17[] = {
  0x01700, 0x01701, 0x01702, 0x01703, 0x01704, 0x01705, 0x01706, 0x01707,
  0x01708, 0x01709, 0x0170a, 0x0170b, 0x0170c, 0x0170d, 0x0170e, 0x0170f,
  0x01710, 0x01711, 0x01712, 0x01713, 0x01714, 0x01715, 0x01716, 0x01717,
  0x01718, 0x01719, 0x0171a, 0x0171b, 0x0171c, 0x0171d, 0x0171e, 0x0171f,
  0x01720, 0x01721, 0x01722, 0x01723, 0x01724, 0x01725, 0x01726, 0x01727,
  0x01728, 0x01729, 0x0172a, 0x0172b, 0x0172c, 0x0172d, 0x0172e, 0x0172f,
  0x01730, 0x01731, 0x01732, 0x01733, 0x01734, 0x01735, 0x01736, 0x01737,
  0x01738, 0x01739, 0x0173a, 0x0173b, 0x0173c, 0x0173d, 0x0173e, 0x0173f,
  0x01740, 0x01741, 0x01742, 0x01743, 0x01744, 0x01745, 0x01746, 0x01747,
  0x01748, 0x01749, 0x0174a, 0x0174b, 0x0174c, 0x0174d, 0x0174e, 0x0174f,
  0x01750, 0x01751, 0x01752, 0x01753, 0x01754, 0x01755, 0x01756, 0x01757,
  0x01758, 0x01759, 0x0175a, 0x0175b, 0x0175c, 0x0175d, 0x0175e, 0x0175f,
  0x01760, 0x01761, 0x01762, 0x01763, 0x01764, 0x01765, 0x01766, 0x01767,
  0x01768, 0x01769, 0x0176a, 0x0176b, 0x0176c, 0x0176d, 0x0176e, 0x0176f,
  0x01770, 0x01771, 0x01772, 0x01773, 0x01774, 0x01775, 0x01776, 0x01777,
  0x01778, 0x01779, 0x0177a, 0x0177b, 0x0177c, 0x0177d, 0x0177e, 0x0177f,
  0x01780, 0x01781, 0x01782, 0x01783, 0x01784, 0x01785, 0x01786, 0x01787,
  0x01788, 0x01789, 0x0178a, 0x0178b, 0x0178c, 0x0178d, 0x0178e, 0x0178f,
  0x01790, 0x01791, 0x01792, 0x01793, 0x01794, 0x01795, 0x01796, 0x01797,
  0x01798, 0x01799, 0x0179a, 0x0179b, 0x0179c, 0x0179d, 0x0179e, 0x0179f,
  0x017a0, 0x017a1, 0x017a2, 0x017a3, 0x017a4, 0x017a5, 0x017a6, 0x017a7,
  0x017a8, 0x017a9, 0x017aa, 0x017ab, 0x017ac, 0x017ad, 0x017ae, 0x017af,
  0x017b0, 0x017b1, 0x017b2, 0x017b3, 0x017b4, 0x017b5, 0x017b6, 0x017b7,
  0x017b8, 0x017b9, 0x017ba, 0x017bb, 0x017bc, 0x017bd, 0x017be, 0x017bf,
  0x017c0, 0x017c1, 0x017c2, 0x017c3, 0x017c4, 0x017c5, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x017d2, 0x00000, 0x017d4, 0x017d5, 0x017d6, 0x017d7,
  0x017d8, 0x017d9, 0x017da, 0x017db, 0x017dc, 0x00000, 0x017de, 0x017df,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x017ea, 0x017eb, 0x017ec, 0x017ed, 0x017ee, 0x017ef,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x017fa, 0x017fb, 0x017fc, 0x017fd, 0x017fe, 0x017ff
};

static uint32_t unicode_ci_page_18[] = {
  0x01800, 0x01801, 0x01802, 0x01803, 0x01804, 0x01805, 0x01806, 0x01807,
  0x01808, 0x01809, 0x0180a, 0x00000, 0x00000, 0x00000, 0x00000, 0x0180f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0181a, 0x0181b, 0x0181c, 0x0181d, 0x0181e, 0x0181f,
  0x01820, 0x01821, 0x01822, 0x01823, 0x01824, 0x01825, 0x01826, 0x01827,
  0x01828, 0x01829, 0x0182a, 0x0182b, 0x0182c, 0x0182d, 0x0182e, 0x0182f,
  0x01830, 0x01831, 0x01832, 0x01833, 0x01834, 0x01835, 0x01836, 0x01837,
  0x01838, 0x01839, 0x0183a, 0x0183b, 0x0183c, 0x0183d, 0x0183e, 0x0183f,
  0x01840, 0x01841, 0x01842, 0x01843, 0x01844, 0x01845, 0x01846, 0x01847,
  0x01848, 0x01849, 0x0184a, 0x0184b, 0x0184c, 0x0184d, 0x0184e, 0x0184f,
  0x01850, 0x01851, 0x01852, 0x01853, 0x01854, 0x01855, 0x01856, 0x01857,
  0x01858, 0x01859, 0x0185a, 0x0185b, 0x0185c, 0x0185d, 0x0185e, 0x0185f,
  0x01860, 0x01861, 0x01862, 0x01863, 0x01864, 0x01865, 0x01866, 0x01867,
  0x01868, 0x01869, 0x0186a, 0x0186b, 0x0186c, 0x0186d, 0x0186e, 0x0186f,
  0x01870, 0x01871, 0x01872, 0x01873, 0x01874, 0x01875, 0x01876, 0x01877,
  0x01878, 0x01879, 0x0187a, 0x0187b, 0x0187c, 0x0187d, 0x0187e, 0x0187f,
  0x01880, 0x01881, 0x01882, 0x01883, 0x01884, 0x01885, 0x01886, 0x01887,
  0x01888, 0x01889, 0x0188a, 0x0188b, 0x0188c, 0x0188d, 0x0188e, 0x0188f,
  0x01890, 0x01891, 0x01892, 0x01893, 0x01894, 0x01895, 0x01896, 0x01897,
  0x01898, 0x01899, 0x0189a, 0x0189b, 0x0189c, 0x0189d, 0x0189e, 0x0189f,
  0x018a0, 0x018a1, 0x018a2, 0x018a3, 0x018a4, 0x018a5, 0x018a6, 0x018a7,
  0x018a8, 0x018a9, 0x018aa, 0x018ab, 0x018ac, 0x018ad, 0x018ae, 0x018af,
  0x018b0, 0x018b1, 0x018b2, 0x018b3, 0x018b4, 0x018b5, 0x018b6, 0x018b7,
  0x018b8, 0x018b9, 0x018ba, 0x018bb, 0x018bc, 0x018bd, 0x018be, 0x018bf,
  0x018c0, 0x018c1, 0x018c2, 0x018c3, 0x018c4, 0x018c5, 0x018c6, 0x018c7,
  0x018c8, 0x018c9, 0x018ca, 0x018cb, 0x018cc, 0x018cd, 0x018ce, 0x018cf,
  0x018d0, 0x018d1, 0x018d2, 0x018d3, 0x018d4, 0x018d5, 0x018d6, 0x018d7,
  0x018d8, 0x018d9, 0x018da, 0x018db, 0x018dc, 0x018dd, 0x018de, 0x018df,
  0x018e0, 0x018e1, 0x018e2, 0x018e3, 0x018e4, 0x018e5, 0x018e6, 0x018e7,
  0x018e8, 0x018e9, 0x018ea, 0x018eb, 0x018ec, 0x018ed, 0x018ee, 0x018ef,
  0x018f0, 0x018f1, 0x018f2, 0x018f3, 0x018f4, 0x018f5, 0x018f6, 0x018f7,
  0x018f8, 0x018f9, 0x018fa, 0x018fb, 0x018fc, 0x018fd, 0x018fe, 0x018ff
};

static uint32_t unicode_ci_page_19[] = {
  0x01900, 0x01901, 0x01902, 0x01903, 0x01904, 0x01905, 0x01906, 0x01907,
  0x01908, 0x01909, 0x0190a, 0x0190b, 0x0190c, 0x0190d, 0x0190e, 0x0190f,
  0x01910, 0x01911, 0x01912, 0x01913, 0x01914, 0x01915, 0x01916, 0x01917,
  0x01918, 0x01919, 0x0191a, 0x0191b, 0x0191c, 0x0191d, 0x0191e, 0x0191f,
  0x01920, 0x01921, 0x01922, 0x01923, 0x01924, 0x01925, 0x01926, 0x01927,
  0x01928, 0x01929, 0x0192a, 0x0192b, 0x0192c, 0x0192d, 0x0192e, 0x0192f,
  0x01930, 0x01931, 0x01932, 0x01933, 0x01934, 0x01935, 0x01936, 0x01937,
  0x01938, 0x00000, 0x00000, 0x00000, 0x0193c, 0x0193d, 0x0193e, 0x0193f,
  0x01940, 0x01941, 0x01942, 0x01943, 0x01944, 0x01945, 0x00030, 0x00031,
  0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039,
  0x01950, 0x01951, 0x01952, 0x01953, 0x01954, 0x01955, 0x01956, 0x01957,
  0x01958, 0x01959, 0x0195a, 0x0195b, 0x0195c, 0x0195d, 0x0195e, 0x0195f,
  0x01960, 0x01961, 0x01962, 0x01963, 0x01964, 0x01965, 0x01966, 0x01967,
  0x01968, 0x01969, 0x0196a, 0x0196b, 0x0196c, 0x0196d, 0x0196e, 0x0196f,
  0x01970, 0x01971, 0x01972, 0x01973, 0x01974, 0x01975, 0x01976, 0x01977,
  0x01978, 0x01979, 0x0197a, 0x0197b, 0x0197c, 0x0197d, 0x0197e, 0x0197f,
  0x01980, 0x01981, 0x01982, 0x01983, 0x01984, 0x01985, 0x01986, 0x01987,
  0x01988, 0x01989, 0x0198a, 0x0198b, 0x0198c, 0x0198d, 0x0198e, 0x0198f,
  0x01990, 0x01991, 0x01992, 0x01993, 0x01994, 0x01995, 0x01996, 0x01997,
  0x01998, 0x01999, 0x0199a, 0x0199b, 0x0199c, 0x0199d, 0x0199e, 0x0199f,
  0x019a0, 0x019a1, 0x019a2, 0x019a3, 0x019a4, 0x019a5, 0x019a6, 0x019a7,
  0x019a8, 0x019a9, 0x019aa, 0x019ab, 0x019ac, 0x019ad, 0x019ae, 0x019af,
  0x019b0, 0x019b1, 0x019b2, 0x019b3, 0x019b4, 0x019b5, 0x019b6, 0x019b7,
  0x019b8, 0x019b9, 0x019ba, 0x019bb, 0x019bc, 0x019bd, 0x019be, 0x019bf,
  0x019c0, 0x019c1, 0x019c2, 0x019c3, 0x019c4, 0x019c5, 0x019c6, 0x019c7,
  0x019c8, 0x019c9, 0x019ca, 0x019cb, 0x019cc, 0x019cd, 0x019ce, 0x019cf,
  0x019d0, 0x019d1, 0x019d2, 0x019d3, 0x019d4, 0x019d5, 0x019d6, 0x019d7,
  0x019d8, 0x019d9, 0x019da, 0x019db, 0x019dc, 0x019dd, 0x019de, 0x019df,
  0x019e0, 0x019e1, 0x019e2, 0x019e3, 0x019e4, 0x019e5, 0x019e6, 0x019e7,
  0x019e8, 0x019e9, 0x019ea, 0x019eb, 0x019ec, 0x019ed, 0x019ee, 0x019ef,
  0x019f0, 0x019f1, 0x019f2, 0x019f3, 0x019f4, 0x019f5, 0x019f6, 0x019f7,
  0x019f8, 0x019f9, 0x019fa, 0x019fb, 0x019fc, 0x019fd, 0x019fe, 0x019ff
};

static uint32_t unicode_ci_page_1d[] = {
  0x01d00, 0x01d01, 0x01d02, 0x01d03, 0x01d04, 0x01d05, 0x01d06, 0x01d07,
  0x01d08, 0x01d09, 0x01d0a, 0x01d0b, 0x01d0c, 0x01d0d, 0x01d0e, 0x01d0f,
  0x01d10, 0x01d11, 0x01d12, 0x01d13, 0x01d14, 0x01d15, 0x01d16, 0x01d17,
  0x01d18, 0x01d19, 0x01d1a, 0x01d1b, 0x01d1c, 0x01d1d, 0x01d1e, 0x01d1f,
  0x01d20, 0x01d21, 0x01d22, 0x01d23, 0x01d24, 0x01d25, 0x01d26, 0x01d27,
  0x01d28, 0x01d29, 0x01d2a, 0x01d2b, 0x00041, 0x000c6, 0x00042, 0x01d2f,
  0x00044, 0x00045, 0x0018e, 0x00047, 0x00048, 0x00049, 0x0004a, 0x0004b,
  0x0004c, 0x0004d, 0x0004e, 0x01d3b, 0x0004f, 0x00222, 0x00050, 0x00052,
  0x00054, 0x00055, 0x00057, 0x00041, 0x00250, 0x00251, 0x01d02, 0x00042,
  0x00044, 0x00045, 0x0018f, 0x00190, 0x01d08, 0x00047, 0x01d09, 0x0004b,
  0x0004d, 0x0014a, 0x0004f, 0x00186, 0x01d16, 0x01d17, 0x00050, 0x00054,
  0x00055, 0x01d1d, 0x0019c, 0x00056, 0x01d25, 0x00392, 0x00393, 0x00394,
  0x003a6, 0x003a7, 0x00049, 0x00052, 0x00055, 0x00056, 0x00392, 0x00393,
  0x003a1, 0x003a6, 0x003a7, 0x01d6b, 0x01d6c, 0x01d6d, 0x01d6e, 0x01d6f,
  0x01d70, 0x01d71, 0x01d72, 0x01d73, 0x01d74, 0x01d75, 0x01d76, 0x01d77,
  0x01d78, 0x01d79, 0x01d7a, 0x01d7b, 0x01d7c, 0x01d7d, 0x01d7e, 0x01d7f,
  0x01d80, 0x01d81, 0x01d82, 0x01d83, 0x01d84, 0x01d85, 0x01d86, 0x01d87,
  0x01d88, 0x01d89, 0x01d8a, 0x01d8b, 0x01d8c, 0x01d8d, 0x01d8e, 0x01d8f,
  0x01d90, 0x01d91, 0x01d92, 0x01d93, 0x01d94, 0x01d95, 0x01d96, 0x01d97,
  0x01d98, 0x01d99, 0x01d9a, 0x01d9b, 0x01d9c, 0x01d9d, 0x01d9e, 0x01d9f,
  0x01da0, 0x01da1, 0x01da2, 0x01da3, 0x01da4, 0x01da5, 0x01da6, 0x01da7,
  0x01da8, 0x01da9, 0x01daa, 0x01dab, 0x01dac, 0x01dad, 0x01dae, 0x01daf,
  0x01db0, 0x01db1, 0x01db2, 0x01db3, 0x01db4, 0x01db5, 0x01db6, 0x01db7,
  0x01db8, 0x01db9, 0x01dba, 0x01dbb, 0x01dbc, 0x01dbd, 0x01dbe, 0x01dbf,
  0x01dc0, 0x01dc1, 0x01dc2, 0x01dc3, 0x01dc4, 0x01dc5, 0x01dc6, 0x01dc7,
  0x01dc8, 0x01dc9, 0x01dca, 0x01dcb, 0x01dcc, 0x01dcd, 0x01dce, 0x01dcf,
  0x01dd0, 0x01dd1, 0x01dd2, 0x01dd3, 0x01dd4, 0x01dd5, 0x01dd6, 0x01dd7,
  0x01dd8, 0x01dd9, 0x01dda, 0x01ddb, 0x01ddc, 0x01ddd, 0x01dde, 0x01ddf,
  0x01de0, 0x01de1, 0x01de2, 0x01de3, 0x01de4, 0x01de5, 0x01de6, 0x01de7,
  0x01de8, 0x01de9, 0x01dea, 0x01deb, 0x01dec, 0x01ded, 0x01dee, 0x01def,
  0x01df0, 0x01df1, 0x01df2, 0x01df3, 0x01df4, 0x01df5, 0x01df6, 0x01df7,
  0x01df8, 0x01df9, 0x01dfa, 0x01dfb, 0x01dfc, 0x01dfd, 0x01dfe, 0x01dff
};

static uint32_t unicode_ci_page_1e[] = {
  0x00041, 0x00041, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042, 0x00042,
  0x00043, 0x00043, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044, 0x00044,
  0x00044, 0x00044, 0x00044, 0x00044, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00046, 0x00046,
  0x00047, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048, 0x00048,
  0x00048, 0x00048, 0x00048, 0x00048, 0x00049, 0x00049, 0x00049, 0x00049,
  0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004b, 0x0004c, 0x0004c,
  0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004c, 0x0004d, 0x0004d,
  0x0004d, 0x0004d, 0x0004d, 0x0004d, 0x0004e, 0x0004e, 0x0004e, 0x0004e,
  0x0004e, 0x0004e, 0x0004e, 0x0004e, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00050, 0x00050, 0x00050, 0x00050,
  0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052, 0x00052,
  0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053, 0x00053,
  0x00053, 0x00053, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054, 0x00054,
  0x00054, 0x00054, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00056, 0x00056, 0x00056, 0x00056,
  0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057, 0x00057,
  0x00057, 0x00057, 0x00058, 0x00058, 0x00058, 0x00058, 0x00059, 0x00059,
  0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x0005a, 0x00048, 0x00054,
  0x00057, 0x00059, 0x01e9a, 0x00053, 0x01e9c, 0x01e9d, 0x01e9e, 0x01e9f,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041, 0x00041,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045, 0x00045,
  0x00049, 0x00049, 0x00049, 0x00049, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x0004f,
  0x0004f, 0x0004f, 0x0004f, 0x0004f, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055, 0x00055,
  0x00055, 0x00055, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059, 0x00059,
  0x00059, 0x00059, 0x01efa, 0x01efb, 0x01efc, 0x01efd, 0x01efe, 0x01eff
};

static uint32_t unicode_ci_page_1f[] = {
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386,
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386,
  0x00388, 0x00388, 0x00388, 0x00388, 0x00388, 0x00388, 0x01f16, 0x01f17,
  0x00388, 0x00388, 0x00388, 0x00388, 0x00388, 0x00388, 0x01f1e, 0x01f1f,
  0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389,
  0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389,
  0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a,
  0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x0037a,
  0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x01f46, 0x01f47,
  0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x0038c, 0x01f4e, 0x01f4f,
  0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x0038e,
  0x01f58, 0x0038e, 0x01f5a, 0x0038e, 0x01f5c, 0x0038e, 0x01f5e, 0x0038e,
  0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f,
  0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f,
  0x00386, 0x00386, 0x00388, 0x00388, 0x00389, 0x00389, 0x0037a, 0x0037a,
  0x0038c, 0x0038c, 0x0038e, 0x0038e, 0x0038f, 0x0038f, 0x01f7e, 0x01f7f,
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386,
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x00386,
  0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389,
  0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389, 0x00389,
  0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f,
  0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f, 0x0038f,
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x01fb5, 0x00386, 0x00386,
  0x00386, 0x00386, 0x00386, 0x00386, 0x00386, 0x01fbd, 0x0037a, 0x01fbd,
  0x01fc0, 0x000a8, 0x00389, 0x00389, 0x00389, 0x01fc5, 0x00389, 0x00389,
  0x00388, 0x00388, 0x00389, 0x00389, 0x00389, 0x01fbd, 0x01fbd, 0x01fbd,
  0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x01fd4, 0x01fd5, 0x0037a, 0x0037a,
  0x0037a, 0x0037a, 0x0037a, 0x0037a, 0x01fdc, 0x01fdd, 0x01fdd, 0x01fdd,
  0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x003a1, 0x003a1, 0x0038e, 0x0038e,
  0x0038e, 0x0038e, 0x0038e, 0x0038e, 0x003a1, 0x000a8, 0x000a8, 0x00060,
  0x01ff0, 0x01ff1, 0x0038f, 0x0038f, 0x0038f, 0x01ff5, 0x0038f, 0x0038f,
  0x0038c, 0x0038c, 0x0038f, 0x0038f, 0x0038f, 0x000b4, 0x01fdd, 0x01fff
};

static uint32_t unicode_ci_page_20[] = {
  0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020, 0x00020,
  0x00020, 0x00020, 0x00020, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x02010, 0x02010, 0x02012, 0x02013, 0x02014, 0x02015, 0x02016, 0x02017,
  0x02018, 0x02019, 0x0201a, 0x0201b, 0x0201c, 0x0201d, 0x0201e, 0x0201f,
  0x02020, 0x02021, 0x02022, 0x02023, 0x0002e, 0x02025, 0x02026, 0x02027,
  0x02028, 0x02029, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00020,
  0x02030, 0x02031, 0x02032, 0x02033, 0x02034, 0x02035, 0x02036, 0x02037,
  0x02038, 0x02039, 0x0203a, 0x0203b, 0x0203c, 0x0203d, 0x0203e, 0x0203f,
  0x02040, 0x02041, 0x02042, 0x02043, 0x02044, 0x02045, 0x02046, 0x02047,
  0x02048, 0x02049, 0x0204a, 0x0204b, 0x0204c, 0x0204d, 0x0204e, 0x0204f,
  0x02050, 0x02051, 0x02052, 0x02053, 0x02054, 0x02055, 0x02056, 0x02057,
  0x02058, 0x02059, 0x0205a, 0x0205b, 0x0205c, 0x0205d, 0x0205e, 0x00020,
  0x00000, 0x00000, 0x00000, 0x00000, 0x02064, 0x02065, 0x02066, 0x02067,
  0x02068, 0x02069, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00030, 0x00049, 0x02072, 0x02073, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0002b, 0x0207b, 0x0003d, 0x00028, 0x00029, 0x0004e,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0002b, 0x0207b, 0x0003d, 0x00028, 0x00029, 0x0208f,
  0x02090, 0x02091, 0x02092, 0x02093, 0x02094, 0x02095, 0x02096, 0x02097,
  0x02098, 0x02099, 0x0209a, 0x0209b, 0x0209c, 0x0209d, 0x0209e, 0x0209f,
  0x020a0, 0x020a1, 0x020a2, 0x020a3, 0x020a4, 0x020a5, 0x020a6, 0x020a7,
  0x020a8, 0x020a9, 0x020aa, 0x020ab, 0x020ac, 0x020ad, 0x020ae, 0x020af,
  0x020b0, 0x020b1, 0x020b2, 0x020b3, 0x020b4, 0x020b5, 0x020b6, 0x020b7,
  0x020b8, 0x020b9, 0x020ba, 0x020bb, 0x020bc, 0x020bd, 0x020be, 0x020bf,
  0x020c0, 0x020c1, 0x020c2, 0x020c3, 0x020c4, 0x020c5, 0x020c6, 0x020c7,
  0x020c8, 0x020c9, 0x020ca, 0x020cb, 0x020cc, 0x020cd, 0x020ce, 0x020cf,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x020eb, 0x020ec, 0x020ed, 0x020ee, 0x020ef,
  0x020f0, 0x020f1, 0x020f2, 0x020f3, 0x020f4, 0x020f5, 0x020f6, 0x020f7,
  0x020f8, 0x020f9, 0x020fa, 0x020fb, 0x020fc, 0x020fd, 0x020fe, 0x020ff
};

static uint32_t unicode_ci_page_21[] = {
  0x02100, 0x02101, 0x00043, 0x02103, 0x02104, 0x02105, 0x02106, 0x00190,
  0x02108, 0x02109, 0x00047, 0x00048, 0x00048, 0x00048, 0x00048, 0x00126,
  0x00049, 0x00049, 0x0004c, 0x0004c, 0x02114, 0x0004e, 0x02116, 0x02117,
  0x02118, 0x00050, 0x00051, 0x00052, 0x00052, 0x00052, 0x0211e, 0x0211f,
  0x02120, 0x02121, 0x02122, 0x02123, 0x0005a, 0x02125, 0x0038f, 0x02127,
  0x0005a, 0x02129, 0x0004b, 0x00041, 0x00042, 0x00043, 0x0212e, 0x00045,
  0x00045, 0x00046, 0x02132, 0x0004d, 0x0004f, 0x005d0, 0x005d1, 0x005d2,
  0x005d3, 0x00049, 0x0213a, 0x0213b, 0x0213c, 0x00393, 0x00393, 0x003a0,
  0x02140, 0x02141, 0x02142, 0x02143, 0x02144, 0x00044, 0x00044, 0x00045,
  0x00049, 0x0004a, 0x0214a, 0x0214b, 0x0214c, 0x0214d, 0x0214e, 0x0214f,
  0x02150, 0x02151, 0x02152, 0x02153, 0x02154, 0x02155, 0x02156, 0x02157,
  0x02158, 0x02159, 0x0215a, 0x0215b, 0x0215c, 0x0215d, 0x0215e, 0x0215f,
  0x00049, 0x02161, 0x02162, 0x02163, 0x00056, 0x02165, 0x02166, 0x02167,
  0x02168, 0x00058, 0x0216a, 0x0216b, 0x0004c, 0x00043, 0x00044, 0x0004d,
  0x00049, 0x02161, 0x02162, 0x02163, 0x00056, 0x02165, 0x02166, 0x02167,
  0x02168, 0x00058, 0x0216a, 0x0216b, 0x0004c, 0x00043, 0x00044, 0x0004d,
  0x02180, 0x02181, 0x02182, 0x02183, 0x02184, 0x02185, 0x02186, 0x02187,
  0x02188, 0x02189, 0x0218a, 0x0218b, 0x0218c, 0x0218d, 0x0218e, 0x0218f,
  0x02190, 0x02191, 0x02192, 0x02193, 0x02194, 0x02195, 0x02196, 0x02197,
  0x02198, 0x02199, 0x02190, 0x02192, 0x0219c, 0x0219d, 0x0219e, 0x0219f,
  0x021a0, 0x021a1, 0x021a2, 0x021a3, 0x021a4, 0x021a5, 0x021a6, 0x021a7,
  0x021a8, 0x021a9, 0x021aa, 0x021ab, 0x021ac, 0x021ad, 0x02194, 0x021af,
  0x021b0, 0x021b1, 0x021b2, 0x021b3, 0x021b4, 0x021b5, 0x021b6, 0x021b7,
  0x021b8, 0x021b9, 0x021ba, 0x021bb, 0x021bc, 0x021bd, 0x021be, 0x021bf,
  0x021c0, 0x021c1, 0x021c2, 0x021c3, 0x021c4, 0x021c5, 0x021c6, 0x021c7,
  0x021c8, 0x021c9, 0x021ca, 0x021cb, 0x021cc, 0x021cd, 0x021ce, 0x021cf,
  0x021cd, 0x021d1, 0x021cf, 0x021d3, 0x021ce, 0x021d5, 0x021d6, 0x021d7,
  0x021d8, 0x021d9, 0x021da, 0x021db, 0x021dc, 0x021dd, 0x021de, 0x021df,
  0x021e0, 0x021e1, 0x021e2, 0x021e3, 0x021e4, 0x021e5, 0x021e6, 0x021e7,
  0x021e8, 0x021e9, 0x021ea, 0x021eb, 0x021ec, 0x021ed, 0x021ee, 0x021ef,
  0x021f0, 0x021f1, 0x021f2, 0x021f3, 0x021f4, 0x021f5, 0x021f6, 0x021f7,
  0x021f8, 0x021f9, 0x021fa, 0x021fb, 0x021fc, 0x021fd, 0x021fe, 0x021ff
};

static uint32_t unicode_ci_page_22[] = {
  0x02200, 0x02201, 0x02202, 0x02203, 0x02203, 0x02205, 0x02206, 0x02207,
  0x02208, 0x02208, 0x0220a, 0x0220b, 0x0220b, 0x0220d, 0x0220e, 0x0220f,
  0x02210, 0x02140, 0x0207b, 0x02213, 0x02214, 0x02215, 0x02216, 0x02217,
  0x02218, 0x02219, 0x0221a, 0x0221b, 0x0221c, 0x0221d, 0x0221e, 0x0221f,
  0x02220, 0x02221, 0x02222, 0x02223, 0x02223, 0x02225, 0x02225, 0x02227,
  0x02228, 0x02229, 0x0222a, 0x0222b, 0x0222c, 0x0222d, 0x0222e, 0x0222f,
  0x02230, 0x02231, 0x02232, 0x02233, 0x02234, 0x02235, 0x02236, 0x02237,
  0x02238, 0x02239, 0x0223a, 0x0223b, 0x0223c, 0x0223d, 0x0223e, 0x0223f,
  0x02240, 0x0223c, 0x02242, 0x02243, 0x02243, 0x02245, 0x02246, 0x02245,
  0x02248, 0x02248, 0x0224a, 0x0224b, 0x0224c, 0x0224d, 0x0224e, 0x0224f,
  0x02250, 0x02251, 0x02252, 0x02253, 0x02254, 0x02255, 0x02256, 0x02257,
  0x02258, 0x02259, 0x0225a, 0x0225b, 0x0225c, 0x0225d, 0x0225e, 0x0225f,
  0x0003d, 0x02261, 0x02261, 0x02263, 0x02264, 0x02265, 0x02266, 0x02267,
  0x02268, 0x02269, 0x0226a, 0x0226b, 0x0226c, 0x0224d, 0x0003c, 0x0003e,
  0x02264, 0x02265, 0x02272, 0x02273, 0x02272, 0x02273, 0x02276, 0x02277,
  0x02276, 0x02277, 0x0227a, 0x0227b, 0x0227c, 0x0227d, 0x0227e, 0x0227f,
  0x0227a, 0x0227b, 0x02282, 0x02283, 0x02282, 0x02283, 0x02286, 0x02287,
  0x02286, 0x02287, 0x0228a, 0x0228b, 0x0228c, 0x0228d, 0x0228e, 0x0228f,
  0x02290, 0x02291, 0x02292, 0x02293, 0x02294, 0x02295, 0x02296, 0x02297,
  0x02298, 0x02299, 0x0229a, 0x0229b, 0x0229c, 0x0229d, 0x0229e, 0x0229f,
  0x022a0, 0x022a1, 0x022a2, 0x022a3, 0x022a4, 0x022a5, 0x022a6, 0x022a7,
  0x022a8, 0x022a9, 0x022aa, 0x022ab, 0x022a2, 0x022a8, 0x022a9, 0x022ab,
  0x022b0, 0x022b1, 0x022b2, 0x022b3, 0x022b4, 0x022b5, 0x022b6, 0x022b7,
  0x022b8, 0x022b9, 0x022ba, 0x022bb, 0x022bc, 0x022bd, 0x022be, 0x022bf,
  0x022c0, 0x022c1, 0x022c2, 0x022c3, 0x022c4, 0x022c5, 0x022c6, 0x022c7,
  0x022c8, 0x022c9, 0x022ca, 0x022cb, 0x022cc, 0x022cd, 0x022ce, 0x022cf,
  0x022d0, 0x022d1, 0x022d2, 0x022d3, 0x022d4, 0x022d5, 0x022d6, 0x022d7,
  0x022d8, 0x022d9, 0x022da, 0x022db, 0x022dc, 0x022dd, 0x022de, 0x022df,
  0x0227c, 0x0227d, 0x02291, 0x02292, 0x022e4, 0x022e5, 0x022e6, 0x022e7,
  0x022e8, 0x022e9, 0x022b2, 0x022b3, 0x022b4, 0x022b5, 0x022ee, 0x022ef,
  0x022f0, 0x022f1, 0x022f2, 0x022f3, 0x022f4, 0x022f5, 0x022f6, 0x022f7,
  0x022f8, 0x022f9, 0x022fa, 0x022fb, 0x022fc, 0x022fd, 0x022fe, 0x022ff
};

static uint32_t unicode_ci_page_24[] = {
  0x02400, 0x02401, 0x02402, 0x02403, 0x02404, 0x02405, 0x02406, 0x02407,
  0x02408, 0x02409, 0x0240a, 0x0240b, 0x0240c, 0x0240d, 0x0240e, 0x0240f,
  0x02410, 0x02411, 0x02412, 0x02413, 0x02414, 0x02415, 0x02416, 0x02417,
  0x02418, 0x02419, 0x0241a, 0x0241b, 0x0241c, 0x0241d, 0x0241e, 0x0241f,
  0x02420, 0x02421, 0x02422, 0x02423, 0x02424, 0x02425, 0x02426, 0x02427,
  0x02428, 0x02429, 0x0242a, 0x0242b, 0x0242c, 0x0242d, 0x0242e, 0x0242f,
  0x02430, 0x02431, 0x02432, 0x02433, 0x02434, 0x02435, 0x02436, 0x02437,
  0x02438, 0x02439, 0x0243a, 0x0243b, 0x0243c, 0x0243d, 0x0243e, 0x0243f,
  0x02440, 0x02441, 0x02442, 0x02443, 0x02444, 0x02445, 0x02446, 0x02447,
  0x02448, 0x02449, 0x0244a, 0x0244b, 0x0244c, 0x0244d, 0x0244e, 0x0244f,
  0x02450, 0x02451, 0x02452, 0x02453, 0x02454, 0x02455, 0x02456, 0x02457,
  0x02458, 0x02459, 0x0245a, 0x0245b, 0x0245c, 0x0245d, 0x0245e, 0x0245f,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x02469, 0x0246a, 0x0246b, 0x0246c, 0x0246d, 0x0246e, 0x0246f,
  0x02470, 0x02471, 0x02472, 0x02473, 0x02474, 0x02475, 0x02476, 0x02477,
  0x02478, 0x02479, 0x0247a, 0x0247b, 0x0247c, 0x0247d, 0x0247e, 0x0247f,
  0x02480, 0x02481, 0x02482, 0x02483, 0x02484, 0x02485, 0x02486, 0x02487,
  0x02488, 0x02489, 0x0248a, 0x0248b, 0x0248c, 0x0248d, 0x0248e, 0x0248f,
  0x02490, 0x02491, 0x02492, 0x02493, 0x02494, 0x02495, 0x02496, 0x02497,
  0x02498, 0x02499, 0x0249a, 0x0249b, 0x0249c, 0x0249d, 0x0249e, 0x0249f,
  0x024a0, 0x024a1, 0x024a2, 0x024a3, 0x024a4, 0x024a5, 0x024a6, 0x024a7,
  0x024a8, 0x024a9, 0x024aa, 0x024ab, 0x024ac, 0x024ad, 0x024ae, 0x024af,
  0x024b0, 0x024b1, 0x024b2, 0x024b3, 0x024b4, 0x024b5, 0x00041, 0x00042,
  0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048, 0x00049, 0x0004a,
  0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050, 0x00051, 0x00052,
  0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058, 0x00059, 0x0005a,
  0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047, 0x00048,
  0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f, 0x00050,
  0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057, 0x00058,
  0x00059, 0x0005a, 0x00030, 0x0246a, 0x0246b, 0x0246c, 0x0246d, 0x0246e,
  0x0246f, 0x02470, 0x02471, 0x02472, 0x02473, 0x00031, 0x00032, 0x00033,
  0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x02469, 0x00030
};

static uint32_t unicode_ci_page_27[] = {
  0x02700, 0x02701, 0x02702, 0x02703, 0x02704, 0x02705, 0x02706, 0x02707,
  0x02708, 0x02709, 0x0270a, 0x0270b, 0x0270c, 0x0270d, 0x0270e, 0x0270f,
  0x02710, 0x02711, 0x02712, 0x02713, 0x02714, 0x02715, 0x02716, 0x02717,
  0x02718, 0x02719, 0x0271a, 0x0271b, 0x0271c, 0x0271d, 0x0271e, 0x0271f,
  0x02720, 0x02721, 0x02722, 0x02723, 0x02724, 0x02725, 0x02726, 0x02727,
  0x02728, 0x02729, 0x0272a, 0x0272b, 0x0272c, 0x0272d, 0x0272e, 0x0272f,
  0x02730, 0x02731, 0x02732, 0x02733, 0x02734, 0x02735, 0x02736, 0x02737,
  0x02738, 0x02739, 0x0273a, 0x0273b, 0x0273c, 0x0273d, 0x0273e, 0x0273f,
  0x02740, 0x02741, 0x02742, 0x02743, 0x02744, 0x02745, 0x02746, 0x02747,
  0x02748, 0x02749, 0x0274a, 0x0274b, 0x0274c, 0x0274d, 0x0274e, 0x0274f,
  0x02750, 0x02751, 0x02752, 0x02753, 0x02754, 0x02755, 0x02756, 0x02757,
  0x02758, 0x02759, 0x0275a, 0x0275b, 0x0275c, 0x0275d, 0x0275e, 0x0275f,
  0x02760, 0x02761, 0x02762, 0x02763, 0x02764, 0x02765, 0x02766, 0x02767,
  0x02768, 0x02769, 0x0276a, 0x0276b, 0x0276c, 0x0276d, 0x0276e, 0x0276f,
  0x02770, 0x02771, 0x02772, 0x02773, 0x02774, 0x02775, 0x00031, 0x00032,
  0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038, 0x00039, 0x02469,
  0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037, 0x00038,
  0x00039, 0x02469, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036,
  0x00037, 0x00038, 0x00039, 0x02469, 0x02794, 0x02795, 0x02796, 0x02797,
  0x02798, 0x02799, 0x0279a, 0x0279b, 0x0279c, 0x0279d, 0x0279e, 0x0279f,
  0x027a0, 0x027a1, 0x027a2, 0x027a3, 0x027a4, 0x027a5, 0x027a6, 0x027a7,
  0x027a8, 0x027a9, 0x027aa, 0x027ab, 0x027ac, 0x027ad, 0x027ae, 0x027af,
  0x027b0, 0x027b1, 0x027b2, 0x027b3, 0x027b4, 0x027b5, 0x027b6, 0x027b7,
  0x027b8, 0x027b9, 0x027ba, 0x027bb, 0x027bc, 0x027bd, 0x027be, 0x027bf,
  0x027c0, 0x027c1, 0x027c2, 0x027c3, 0x027c4, 0x027c5, 0x027c6, 0x027c7,
  0x027c8, 0x027c9, 0x027ca, 0x027cb, 0x027cc, 0x027cd, 0x027ce, 0x027cf,
  0x027d0, 0x027d1, 0x027d2, 0x027d3, 0x027d4, 0x027d5, 0x027d6, 0x027d7,
  0x027d8, 0x027d9, 0x027da, 0x027db, 0x027dc, 0x027dd, 0x027de, 0x027df,
  0x027e0, 0x027e1, 0x027e2, 0x027e3, 0x027e4, 0x027e5, 0x027e6, 0x027e7,
  0x027e8, 0x027e9, 0x027ea, 0x027eb, 0x027ec, 0x027ed, 0x027ee, 0x027ef,
  0x027f0, 0x027f1, 0x027f2, 0x027f3, 0x027f4, 0x027f5, 0x027f6, 0x027f7,
  0x027f8, 0x027f9, 0x027fa, 0x027fb, 0x027fc, 0x027fd, 0x027fe, 0x027ff
};

static uint32_t unicode_ci_page_2a[] = {
  0x02a00, 0x02a01, 0x02a02, 0x02a03, 0x02a04, 0x02a05, 0x02a06, 0x02a07,
  0x02a08, 0x02a09, 0x02a0a, 0x02a0b, 0x02a0c, 0x02a0d, 0x02a0e, 0x02a0f,
  0x02a10, 0x02a11, 0x02a12, 0x02a13, 0x02a14, 0x02a15, 0x02a16, 0x02a17,
  0x02a18, 0x02a19, 0x02a1a, 0x02a1b, 0x02a1c, 0x02a1d, 0x02a1e, 0x02a1f,
  0x02a20, 0x02a21, 0x02a22, 0x02a23, 0x02a24, 0x02a25, 0x02a26, 0x02a27,
  0x02a28, 0x02a29, 0x02a2a, 0x02a2b, 0x02a2c, 0x02a2d, 0x02a2e, 0x02a2f,
  0x02a30, 0x02a31, 0x02a32, 0x02a33, 0x02a34, 0x02a35, 0x02a36, 0x02a37,
  0x02a38, 0x02a39, 0x02a3a, 0x02a3b, 0x02a3c, 0x02a3d, 0x02a3e, 0x02a3f,
  0x02a40, 0x02a41, 0x02a42, 0x02a43, 0x02a44, 0x02a45, 0x02a46, 0x02a47,
  0x02a48, 0x02a49, 0x02a4a, 0x02a4b, 0x02a4c, 0x02a4d, 0x02a4e, 0x02a4f,
  0x02a50, 0x02a51, 0x02a52, 0x02a53, 0x02a54, 0x02a55, 0x02a56, 0x02a57,
  0x02a58, 0x02a59, 0x02a5a, 0x02a5b, 0x02a5c, 0x02a5d, 0x02a5e, 0x02a5f,
  0x02a60, 0x02a61, 0x02a62, 0x02a63, 0x02a64, 0x02a65, 0x02a66, 0x02a67,
  0x02a68, 0x02a69, 0x02a6a, 0x02a6b, 0x02a6c, 0x02a6d, 0x02a6e, 0x02a6f,
  0x02a70, 0x02a71, 0x02a72, 0x02a73, 0x02a74, 0x02a75, 0x02a76, 0x02a77,
  0x02a78, 0x02a79, 0x02a7a, 0x02a7b, 0x02a7c, 0x02a7d, 0x02a7e, 0x02a7f,
  0x02a80, 0x02a81, 0x02a82, 0x02a83, 0x02a84, 0x02a85, 0x02a86, 0x02a87,
  0x02a88, 0x02a89, 0x02a8a, 0x02a8b, 0x02a8c, 0x02a8d, 0x02a8e, 0x02a8f,
  0x02a90, 0x02a91, 0x02a92, 0x02a93, 0x02a94, 0x02a95, 0x02a96, 0x02a97,
  0x02a98, 0x02a99, 0x02a9a, 0x02a9b, 0x02a9c, 0x02a9d, 0x02a9e, 0x02a9f,
  0x02aa0, 0x02aa1, 0x02aa2, 0x02aa3, 0x02aa4, 0x02aa5, 0x02aa6, 0x02aa7,
  0x02aa8, 0x02aa9, 0x02aaa, 0x02aab, 0x02aac, 0x02aad, 0x02aae, 0x02aaf,
  0x02ab0, 0x02ab1, 0x02ab2, 0x02ab3, 0x02ab4, 0x02ab5, 0x02ab6, 0x02ab7,
  0x02ab8, 0x02ab9, 0x02aba, 0x02abb, 0x02abc, 0x02abd, 0x02abe, 0x02abf,
  0x02ac0, 0x02ac1, 0x02ac2, 0x02ac3, 0x02ac4, 0x02ac5, 0x02ac6, 0x02ac7,
  0x02ac8, 0x02ac9, 0x02aca, 0x02acb, 0x02acc, 0x02acd, 0x02ace, 0x02acf,
  0x02ad0, 0x02ad1, 0x02ad2, 0x02ad3, 0x02ad4, 0x02ad5, 0x02ad6, 0x02ad7,
  0x02ad8, 0x02ad9, 0x02ada, 0x02adb, 0x02adc, 0x02adc, 0x02ade, 0x02adf,
  0x02ae0, 0x02ae1, 0x02ae2, 0x02ae3, 0x02ae4, 0x02ae5, 0x02ae6, 0x02ae7,
  0x02ae8, 0x02ae9, 0x02aea, 0x02aeb, 0x02aec, 0x02aed, 0x02aee, 0x02aef,
  0x02af0, 0x02af1, 0x02af2, 0x02af3, 0x02af4, 0x02af5, 0x02af6, 0x02af7,
  0x02af8, 0x02af9, 0x02afa, 0x02afb, 0x02afc, 0x02afd, 0x02afe, 0x02aff
};

static uint32_t unicode_ci_page_2e[] = {
  0x02e00, 0x02e01, 0x02e02, 0x02e03, 0x02e04, 0x02e05, 0x02e06, 0x02e07,
  0x02e08, 0x02e09, 0x02e0a, 0x02e0b, 0x02e0c, 0x02e0d, 0x02e0e, 0x02e0f,
  0x02e10, 0x02e11, 0x02e12, 0x02e13, 0x02e14, 0x02e15, 0x02e16, 0x02e17,
  0x02e18, 0x02e19, 0x02e1a, 0x02e1b, 0x02e1c, 0x02e1d, 0x02e1e, 0x02e1f,
  0x02e20, 0x02e21, 0x02e22, 0x02e23, 0x02e24, 0x02e25, 0x02e26, 0x02e27,
  0x02e28, 0x02e29, 0x02e2a, 0x02e2b, 0x02e2c, 0x02e2d, 0x02e2e, 0x02e2f,
  0x02e30, 0x02e31, 0x02e32, 0x02e33, 0x02e34, 0x02e35, 0x02e36, 0x02e37,
  0x02e38, 0x02e39, 0x02e3a, 0x02e3b, 0x02e3c, 0x02e3d, 0x02e3e, 0x02e3f,
  0x02e40, 0x02e41, 0x02e42, 0x02e43, 0x02e44, 0x02e45, 0x02e46, 0x02e47,
  0x02e48, 0x02e49, 0x02e4a, 0x02e4b, 0x02e4c, 0x02e4d, 0x02e4e, 0x02e4f,
  0x02e50, 0x02e51, 0x02e52, 0x02e53, 0x02e54, 0x02e55, 0x02e56, 0x02e57,
  0x02e58, 0x02e59, 0x02e5a, 0x02e5b, 0x02e5c, 0x02e5d, 0x02e5e, 0x02e5f,
  0x02e60, 0x02e61, 0x02e62, 0x02e63, 0x02e64, 0x02e65, 0x02e66, 0x02e67,
  0x02e68, 0x02e69, 0x02e6a, 0x02e6b, 0x02e6c, 0x02e6d, 0x02e6e, 0x02e6f,
  0x02e70, 0x02e71, 0x02e72, 0x02e73, 0x02e74, 0x02e75, 0x02e76, 0x02e77,
  0x02e78, 0x02e79, 0x02e7a, 0x02e7b, 0x02e7c, 0x02e7d, 0x02e7e, 0x02e7f,
  0x02e80, 0x02e81, 0x02e82, 0x02e83, 0x0319a, 0x02e85, 0x02e86, 0x02f0f,
  0x02f11, 0x02e89, 0x02f18, 0x02e8b, 0x02f29, 0x02f29, 0x02e8e, 0x02e8f,
  0x02e8e, 0x02e8f, 0x02e92, 0x02e93, 0x02e94, 0x02e95, 0x02e96, 0x02f3c,
  0x02e98, 0x02e99, 0x02e9a, 0x02e9b, 0x02f47, 0x02f49, 0x02e9e, 0x02e9f,
  0x02ea0, 0x02ea1, 0x02ea2, 0x02ea3, 0x02ea4, 0x02ea4, 0x02ea6, 0x02f5c,
  0x02ea8, 0x02ea9, 0x02eaa, 0x02f6c, 0x02f70, 0x02ead, 0x02f75, 0x02eaf,
  0x02eb0, 0x02eb1, 0x02eb2, 0x02eb1, 0x02eb1, 0x02eb2, 0x02eb7, 0x02eb7,
  0x02eb8, 0x02eb9, 0x02eba, 0x02f80, 0x02f81, 0x02f85, 0x02ebe, 0x02ebe,
  0x02ebe, 0x02ec1, 0x02ec2, 0x02ec3, 0x02ec4, 0x02ec5, 0x02f93, 0x02f93,
  0x02ec8, 0x02ec9, 0x02f9c, 0x02ecb, 0x02ecc, 0x02ecc, 0x02ecc, 0x02fa2,
  0x02ed0, 0x02fa7, 0x02ed2, 0x02ed3, 0x02ed4, 0x02fa9, 0x02ed6, 0x02fac,
  0x02ed8, 0x02ed9, 0x02eda, 0x02edb, 0x02edc, 0x02fb7, 0x02ede, 0x02ede,
  0x02ee0, 0x02fb8, 0x02ee2, 0x02fbb, 0x02fc1, 0x02ee5, 0x02ee6, 0x02ee7,
  0x02ee8, 0x02ee9, 0x02eea, 0x02eeb, 0x02eec, 0x02eed, 0x02eee, 0x02eef,
  0x02ef0, 0x02ef2, 0x02ef2, 0x02ef3, 0x02ef4, 0x02ef5, 0x02ef6, 0x02ef7,
  0x02ef8, 0x02ef9, 0x02efa, 0x02efb, 0x02efc, 0x02efd, 0x02efe, 0x02eff
};

static uint32_t unicode_ci_page_2f[] = {
  0x03192, 0x02f01, 0x02e80, 0x02f03, 0x0319a, 0x02f05, 0x03193, 0x02f07,
  0x0319f, 0x02f09, 0x02f0a, 0x02f0b, 0x02e86, 0x02f0d, 0x02f0e, 0x02f0f,
  0x02f10, 0x02f11, 0x02f12, 0x02f13, 0x02f14, 0x02f15, 0x02f16, 0x02f17,
  0x02f18, 0x02e8b, 0x02e81, 0x02f1b, 0x02f1c, 0x02f1d, 0x02f1e, 0x02f1f,
  0x02f20, 0x02f21, 0x02f22, 0x02f23, 0x02f24, 0x02f25, 0x02f26, 0x02f27,
  0x02f28, 0x02f29, 0x02e8e, 0x02f2b, 0x02f2c, 0x02f2d, 0x02f2e, 0x02f2f,
  0x02f30, 0x02f31, 0x02f32, 0x02e93, 0x02f34, 0x02f35, 0x02f36, 0x02f37,
  0x02f38, 0x02e95, 0x02f3a, 0x02f3b, 0x02f3c, 0x02f3d, 0x02f3e, 0x02f3f,
  0x02f40, 0x02f41, 0x02f42, 0x02f43, 0x02f44, 0x02f45, 0x02f46, 0x02f47,
  0x02f48, 0x02f49, 0x02f4a, 0x02f4b, 0x02f4c, 0x02f4d, 0x02f4e, 0x02f4f,
  0x02f50, 0x02f51, 0x02f52, 0x02f53, 0x02f54, 0x02f55, 0x02f56, 0x02f57,
  0x02f58, 0x02f59, 0x02f5a, 0x02f5b, 0x02f5c, 0x02f5d, 0x02f5e, 0x02f5f,
  0x02f60, 0x02f61, 0x02f62, 0x02f63, 0x02f64, 0x02f65, 0x02eaa, 0x02f67,
  0x02f68, 0x02f69, 0x02f6a, 0x02f6b, 0x02f6c, 0x02f6d, 0x02f6e, 0x02f6f,
  0x02f70, 0x02f71, 0x02f72, 0x02f73, 0x02f74, 0x02f75, 0x02f76, 0x02f77,
  0x02f78, 0x02f79, 0x02eb7, 0x02f7b, 0x02f7c, 0x02f7d, 0x02f7e, 0x02f7f,
  0x02f80, 0x02f81, 0x02f82, 0x02f83, 0x02f84, 0x02f85, 0x02f86, 0x02f87,
  0x02f88, 0x02f89, 0x02f8a, 0x02f8b, 0x02f8c, 0x02f8d, 0x02f8e, 0x02f8f,
  0x02f90, 0x02f91, 0x02f92, 0x02f93, 0x02f94, 0x02f95, 0x02f96, 0x02f97,
  0x02f98, 0x02f99, 0x02f9a, 0x02f9b, 0x02f9c, 0x02f9d, 0x02f9e, 0x02f9f,
  0x02fa0, 0x02fa1, 0x02fa2, 0x02fa3, 0x02fa4, 0x02fa5, 0x02fa6, 0x02fa7,
  0x02fa8, 0x02fa9, 0x02faa, 0x02fab, 0x02fac, 0x02fad, 0x02fae, 0x02faf,
  0x02fb0, 0x02fb1, 0x02fb2, 0x02fb3, 0x02fb4, 0x02fb5, 0x02fb6, 0x02fb7,
  0x02fb8, 0x02fb9, 0x02fba, 0x02fbb, 0x02fbc, 0x02fbd, 0x02fbe, 0x02fbf,
  0x02fc0, 0x02fc1, 0x02fc2, 0x02fc3, 0x02ee7, 0x02fc5, 0x02fc6, 0x02fc7,
  0x02fc8, 0x02fc9, 0x02fca, 0x02fcb, 0x02fcc, 0x02fcd, 0x02fce, 0x02fcf,
  0x02fd0, 0x02eeb, 0x02eed, 0x02eef, 0x02ef2, 0x02fd5, 0x02fd6, 0x02fd7,
  0x02fd8, 0x02fd9, 0x02fda, 0x02fdb, 0x02fdc, 0x02fdd, 0x02fde, 0x02fdf,
  0x02fe0, 0x02fe1, 0x02fe2, 0x02fe3, 0x02fe4, 0x02fe5, 0x02fe6, 0x02fe7,
  0x02fe8, 0x02fe9, 0x02fea, 0x02feb, 0x02fec, 0x02fed, 0x02fee, 0x02fef,
  0x02ff0, 0x02ff1, 0x02ff2, 0x02ff3, 0x02ff4, 0x02ff5, 0x02ff6, 0x02ff7,
  0x02ff8, 0x02ff9, 0x02ffa, 0x02ffb, 0x02ffc, 0x02ffd, 0x02ffe, 0x02fff
};

static uint32_t unicode_ci_page_30[] = {
  0x00020, 0x03001, 0x03002, 0x03003, 0x03004, 0x03005, 0x03006, 0x00030,
  0x02329, 0x0232a, 0x0300a, 0x0300b, 0x0300c, 0x0300d, 0x0300e, 0x0300f,
  0x03010, 0x03011, 0x03012, 0x03013, 0x03014, 0x03015, 0x03016, 0x03017,
  0x03018, 0x03019, 0x0301a, 0x0301b, 0x0301c, 0x0301d, 0x0301e, 0x0301f,
  0x03020, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x03030, 0x03031, 0x03031, 0x03033, 0x03033, 0x03035, 0x03012, 0x03037,
  0x02f17, 0x03039, 0x0303a, 0x0303b, 0x0303c, 0x0303d, 0x0303e, 0x0303f,
  0x03040, 0x03042, 0x03042, 0x03044, 0x03044, 0x03046, 0x03046, 0x03048,
  0x03048, 0x0304a, 0x0304a, 0x0304b, 0x0304b, 0x0304d, 0x0304d, 0x0304f,
  0x0304f, 0x03051, 0x03051, 0x03053, 0x03053, 0x03055, 0x03055, 0x03057,
  0x03057, 0x03059, 0x03059, 0x0305b, 0x0305b, 0x0305d, 0x0305d, 0x0305f,
  0x0305f, 0x03061, 0x03061, 0x03064, 0x03064, 0x03064, 0x03066, 0x03066,
  0x03068, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d, 0x0306e, 0x0306f,
  0x0306f, 0x0306f, 0x03072, 0x03072, 0x03072, 0x03075, 0x03075, 0x03075,
  0x03078, 0x03078, 0x03078, 0x0307b, 0x0307b, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03084, 0x03086, 0x03086, 0x03088,
  0x03088, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x03093, 0x03046, 0x0304b, 0x03051, 0x03097,
  0x03098, 0x00000, 0x00000, 0x0309b, 0x0309c, 0x0309d, 0x0309d, 0x0309f,
  0x030a0, 0x03042, 0x03042, 0x03044, 0x03044, 0x03046, 0x03046, 0x03048,
  0x03048, 0x0304a, 0x0304a, 0x0304b, 0x0304b, 0x0304d, 0x0304d, 0x0304f,
  0x0304f, 0x03051, 0x03051, 0x03053, 0x03053, 0x03055, 0x03055, 0x03057,
  0x03057, 0x03059, 0x03059, 0x0305b, 0x0305b, 0x0305d, 0x0305d, 0x0305f,
  0x0305f, 0x03061, 0x03061, 0x03064, 0x03064, 0x03064, 0x03066, 0x03066,
  0x03068, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d, 0x0306e, 0x0306f,
  0x0306f, 0x0306f, 0x03072, 0x03072, 0x03072, 0x03075, 0x03075, 0x03075,
  0x03078, 0x03078, 0x03078, 0x0307b, 0x0307b, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03084, 0x03086, 0x03086, 0x03088,
  0x03088, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x03093, 0x03046, 0x0304b, 0x03051, 0x0308f,
  0x03090, 0x03091, 0x03092, 0x030fb, 0x030fc, 0x030fd, 0x030fd, 0x030ff
};

static uint32_t unicode_ci_page_31[] = {
  0x03100, 0x03101, 0x03102, 0x03103, 0x03104, 0x03105, 0x03106, 0x03107,
  0x03108, 0x03109, 0x0310a, 0x0310b, 0x0310c, 0x0310d, 0x0310e, 0x0310f,
  0x03110, 0x03111, 0x03112, 0x03113, 0x03114, 0x03115, 0x03116, 0x03117,
  0x03118, 0x03119, 0x0311a, 0x0311b, 0x0311c, 0x0311d, 0x0311e, 0x0311f,
  0x03120, 0x03121, 0x03122, 0x03123, 0x03124, 0x03125, 0x03126, 0x03127,
  0x03128, 0x03129, 0x0312a, 0x0312b, 0x0312c, 0x0312d, 0x0312e, 0x0312f,
  0x03130, 0x01100, 0x01101, 0x011aa, 0x01102, 0x011ac, 0x011ad, 0x01103,
  0x01104, 0x01105, 0x011b0, 0x011b1, 0x011b2, 0x011b3, 0x011b4, 0x011b5,
  0x0111a, 0x01106, 0x01107, 0x01108, 0x01121, 0x01109, 0x0110a, 0x0110b,
  0x0110c, 0x0110d, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x01161,
  0x01162, 0x01163, 0x01164, 0x01165, 0x01166, 0x01167, 0x01168, 0x01169,
  0x0116a, 0x0116b, 0x0116c, 0x0116d, 0x0116e, 0x0116f, 0x01170, 0x01171,
  0x01172, 0x01173, 0x01174, 0x01175, 0x01160, 0x01114, 0x01115, 0x011c7,
  0x011c8, 0x011cc, 0x011ce, 0x011d3, 0x011d7, 0x011d9, 0x0111c, 0x011dd,
  0x011df, 0x0111d, 0x0111e, 0x01120, 0x01122, 0x01123, 0x01127, 0x01129,
  0x0112b, 0x0112c, 0x0112d, 0x0112e, 0x0112f, 0x01132, 0x01136, 0x01140,
  0x01147, 0x0114c, 0x011f1, 0x011f2, 0x01157, 0x01158, 0x01159, 0x01184,
  0x01185, 0x01188, 0x01191, 0x01192, 0x01194, 0x0119e, 0x011a1, 0x0318f,
  0x03190, 0x03191, 0x03192, 0x03193, 0x03194, 0x03195, 0x03196, 0x03197,
  0x03198, 0x03199, 0x0319a, 0x0319b, 0x0319c, 0x0319d, 0x0319e, 0x0319f,
  0x03105, 0x03117, 0x03110, 0x0310d, 0x031a4, 0x031a4, 0x031a6, 0x0311b,
  0x03128, 0x0311a, 0x03127, 0x03128, 0x031ac, 0x031ad, 0x0311e, 0x03120,
  0x031b0, 0x031b1, 0x031b2, 0x03127, 0x03106, 0x0310a, 0x0310e, 0x0310f,
  0x031b8, 0x031b9, 0x031ba, 0x031bb, 0x031bc, 0x031bd, 0x031be, 0x031bf,
  0x031c0, 0x031c1, 0x031c2, 0x031c3, 0x031c4, 0x031c5, 0x031c6, 0x031c7,
  0x031c8, 0x031c9, 0x031ca, 0x031cb, 0x031cc, 0x031cd, 0x031ce, 0x031cf,
  0x031d0, 0x031d1, 0x031d2, 0x031d3, 0x031d4, 0x031d5, 0x031d6, 0x031d7,
  0x031d8, 0x031d9, 0x031da, 0x031db, 0x031dc, 0x031dd, 0x031de, 0x031df,
  0x031e0, 0x031e1, 0x031e2, 0x031e3, 0x031e4, 0x031e5, 0x031e6, 0x031e7,
  0x031e8, 0x031e9, 0x031ea, 0x031eb, 0x031ec, 0x031ed, 0x031ee, 0x031ef,
  0x0304f, 0x03057, 0x03059, 0x03068, 0x0306c, 0x0306f, 0x03072, 0x03075,
  0x03078, 0x0307b, 0x03080, 0x03089, 0x0308a, 0x0308b, 0x0308c, 0x031ff
};

static uint32_t unicode_ci_page_32[] = {
  0x03200, 0x03201, 0x03202, 0x03203, 0x03204, 0x03205, 0x03206, 0x03207,
  0x03208, 0x03209, 0x0320a, 0x0320b, 0x0320c, 0x0320d, 0x0320e, 0x0320f,
  0x03210, 0x03211, 0x03212, 0x03213, 0x03214, 0x03215, 0x03216, 0x03217,
  0x03218, 0x03219, 0x0321a, 0x0321b, 0x0321c, 0x0321d, 0x0321e, 0x0321f,
  0x03220, 0x03221, 0x03222, 0x03223, 0x03224, 0x03225, 0x03226, 0x03227,
  0x03228, 0x03229, 0x0322a, 0x0322b, 0x0322c, 0x0322d, 0x0322e, 0x0322f,
  0x03230, 0x03231, 0x03232, 0x03233, 0x03234, 0x03235, 0x03236, 0x03237,
  0x03238, 0x03239, 0x0323a, 0x0323b, 0x0323c, 0x0323d, 0x0323e, 0x0323f,
  0x03240, 0x03241, 0x03242, 0x03243, 0x03244, 0x03245, 0x03246, 0x03247,
  0x03248, 0x03249, 0x0324a, 0x0324b, 0x0324c, 0x0324d, 0x0324e, 0x0324f,
  0x03250, 0x03251, 0x03252, 0x03253, 0x03254, 0x03255, 0x03256, 0x03257,
  0x03258, 0x03259, 0x0325a, 0x0325b, 0x0325c, 0x0325d, 0x0325e, 0x0325f,
  0x01100, 0x01102, 0x01103, 0x01105, 0x01106, 0x01107, 0x01109, 0x0110b,
  0x0110c, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x0326e, 0x0326f,
  0x03270, 0x03271, 0x03272, 0x03273, 0x03274, 0x03275, 0x03276, 0x03277,
  0x03278, 0x03279, 0x0327a, 0x0327b, 0x0327c, 0x0327d, 0x0327e, 0x0327f,
  0x03192, 0x03193, 0x03194, 0x03195, 0x03284, 0x03285, 0x03286, 0x02f0b,
  0x03288, 0x02f17, 0x02f49, 0x02f55, 0x02f54, 0x02f4a, 0x02fa6, 0x02f1f,
  0x02f47, 0x03291, 0x03292, 0x03293, 0x03294, 0x03295, 0x03296, 0x03297,
  0x03298, 0x03299, 0x0329a, 0x02f25, 0x0329c, 0x0329d, 0x0329e, 0x0329f,
  0x032a0, 0x032a1, 0x032a2, 0x032a3, 0x03196, 0x03197, 0x03198, 0x032a7,
  0x032a8, 0x032a9, 0x032aa, 0x032ab, 0x032ac, 0x032ad, 0x032ae, 0x032af,
  0x032b0, 0x032b1, 0x032b2, 0x032b3, 0x032b4, 0x032b5, 0x032b6, 0x032b7,
  0x032b8, 0x032b9, 0x032ba, 0x032bb, 0x032bc, 0x032bd, 0x032be, 0x032bf,
  0x032c0, 0x032c1, 0x032c2, 0x032c3, 0x032c4, 0x032c5, 0x032c6, 0x032c7,
  0x032c8, 0x032c9, 0x032ca, 0x032cb, 0x032cc, 0x032cd, 0x032ce, 0x032cf,
  0x03042, 0x03044, 0x03046, 0x03048, 0x0304a, 0x0304b, 0x0304d, 0x0304f,
  0x03051, 0x03053, 0x03055, 0x03057, 0x03059, 0x0305b, 0x0305d, 0x0305f,
  0x03061, 0x03064, 0x03066, 0x03068, 0x0306a, 0x0306b, 0x0306c, 0x0306d,
  0x0306e, 0x0306f, 0x03072, 0x03075, 0x03078, 0x0307b, 0x0307e, 0x0307f,
  0x03080, 0x03081, 0x03082, 0x03084, 0x03086, 0x03088, 0x03089, 0x0308a,
  0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x03090, 0x03091, 0x03092, 0x032ff
};

static uint32_t unicode_ci_page_33[] = {
  0x03300, 0x03301, 0x03302, 0x03303, 0x03304, 0x03305, 0x03306, 0x03307,
  0x03308, 0x03309, 0x0330a, 0x0330b, 0x0330c, 0x0330d, 0x0330e, 0x0330f,
  0x03310, 0x03311, 0x03312, 0x03313, 0x03314, 0x03315, 0x03316, 0x03317,
  0x03318, 0x03319, 0x0331a, 0x0331b, 0x0331c, 0x0331d, 0x0331e, 0x0331f,
  0x03320, 0x03321, 0x03322, 0x03323, 0x03324, 0x03325, 0x03326, 0x03327,
  0x03328, 0x03329, 0x0332a, 0x0332b, 0x0332c, 0x0332d, 0x0332e, 0x0332f,
  0x03330, 0x03331, 0x03332, 0x03333, 0x03334, 0x03335, 0x03336, 0x03337,
  0x03338, 0x03339, 0x0333a, 0x0333b, 0x0333c, 0x0333d, 0x0333e, 0x0333f,
  0x03340, 0x03341, 0x03342, 0x03343, 0x03344, 0x03345, 0x03346, 0x03347,
  0x03348, 0x03349, 0x0334a, 0x0334b, 0x0334c, 0x0334d, 0x0334e, 0x0334f,
  0x03350, 0x03351, 0x03352, 0x03353, 0x03354, 0x03355, 0x03356, 0x03357,
  0x03358, 0x03359, 0x0335a, 0x0335b, 0x0335c, 0x0335d, 0x0335e, 0x0335f,
  0x03360, 0x03361, 0x03362, 0x03363, 0x03364, 0x03365, 0x03366, 0x03367,
  0x03368, 0x03369, 0x0336a, 0x0336b, 0x0336c, 0x0336d, 0x0336e, 0x0336f,
  0x03370, 0x03371, 0x03372, 0x03373, 0x03374, 0x03375, 0x03376, 0x03377,
  0x03378, 0x03379, 0x0337a, 0x0337b, 0x0337c, 0x0337d, 0x0337e, 0x0337f,
  0x03380, 0x03381, 0x03382, 0x03383, 0x03384, 0x03385, 0x03386, 0x03387,
  0x03388, 0x03389, 0x0338a, 0x0338b, 0x0338c, 0x0338d, 0x0338e, 0x0338f,
  0x03390, 0x03391, 0x03392, 0x03393, 0x03394, 0x03395, 0x03396, 0x03397,
  0x03398, 0x03399, 0x0339a, 0x0339b, 0x0339c, 0x0339d, 0x0339e, 0x0339f,
  0x033a0, 0x033a1, 0x033a2, 0x033a3, 0x033a4, 0x033a5, 0x033a6, 0x033a7,
  0x033a8, 0x03380, 0x033aa, 0x033ab, 0x033ac, 0x033ad, 0x033ae, 0x033af,
  0x033b0, 0x033b1, 0x033b2, 0x033b3, 0x033b4, 0x033b5, 0x033b6, 0x033b7,
  0x033b8, 0x033b7, 0x033ba, 0x033bb, 0x033bc, 0x033bd, 0x033be, 0x033bd,
  0x033c0, 0x033c1, 0x033c2, 0x033c3, 0x033c4, 0x033c5, 0x033c6, 0x033c7,
  0x033c8, 0x033c9, 0x033ca, 0x033cb, 0x033cc, 0x033cd, 0x0339e, 0x033cf,
  0x033d0, 0x033d1, 0x033d2, 0x033d3, 0x03386, 0x033d5, 0x033d6, 0x033d7,
  0x033d8, 0x033d9, 0x033da, 0x033db, 0x033dc, 0x033dd, 0x033de, 0x033df,
  0x033e0, 0x033e1, 0x033e2, 0x033e3, 0x033e4, 0x033e5, 0x033e6, 0x033e7,
  0x033e8, 0x033e9, 0x033ea, 0x033eb, 0x033ec, 0x033ed, 0x033ee, 0x033ef,
  0x033f0, 0x033f1, 0x033f2, 0x033f3, 0x033f4, 0x033f5, 0x033f6, 0x033f7,
  0x033f8, 0x033f9, 0x033fa, 0x033fb, 0x033fc, 0x033fd, 0x033fe, 0x033ff
};

static uint32_t unicode_ci_page_f9[] = {
  0x0f900, 0x0f901, 0x02f9e, 0x0f903, 0x0f904, 0x0f905, 0x0f906, 0x02ef2,
  0x02ef2, 0x0f909, 0x02fa6, 0x0f90b, 0x0f90c, 0x0f90d, 0x0f90e, 0x0f90f,
  0x0f910, 0x0f911, 0x0f912, 0x0f913, 0x0f914, 0x0f915, 0x0f916, 0x0f917,
  0x0f918, 0x0f919, 0x0f91a, 0x0f91b, 0x0f91c, 0x0f91d, 0x0f91e, 0x0f91f,
  0x0f920, 0x0f921, 0x0f922, 0x0f923, 0x0f924, 0x0f925, 0x0f926, 0x0f927,
  0x0f928, 0x0f929, 0x0f92a, 0x0f92b, 0x0f92c, 0x0f92d, 0x0f92e, 0x0f92f,
  0x0f930, 0x0f931, 0x0f932, 0x0f933, 0x02f7c, 0x0f935, 0x0f936, 0x0f937,
  0x0f938, 0x0f939, 0x0f93a, 0x0f93b, 0x0f93c, 0x0f93d, 0x0f93e, 0x0f93f,
  0x02fc5, 0x0f941, 0x0f942, 0x0f943, 0x0f944, 0x0f945, 0x0f946, 0x0f947,
  0x0f948, 0x0f949, 0x0f94a, 0x0f94b, 0x0f94c, 0x0f94d, 0x0f94e, 0x0f94f,
  0x0f950, 0x0f951, 0x0f952, 0x0f953, 0x0f954, 0x0f955, 0x0f956, 0x0f957,
  0x0f958, 0x0f959, 0x0f95a, 0x0f95b, 0x0f914, 0x0f95d, 0x0f95e, 0x0f95f,
  0x0f960, 0x0f961, 0x0f962, 0x0f963, 0x0f964, 0x0f965, 0x0f966, 0x0f967,
  0x0f968, 0x0f969, 0x0f96a, 0x0f96b, 0x0f96c, 0x0f96d, 0x0f96e, 0x0f96f,
  0x0f970, 0x02fa0, 0x0f972, 0x0f973, 0x0f974, 0x0f975, 0x0f976, 0x0f977,
  0x0f978, 0x0f979, 0x0f97a, 0x0f97b, 0x0f97c, 0x0f97d, 0x0f97e, 0x0f97f,
  0x0f980, 0x02f25, 0x0f982, 0x0f983, 0x0f984, 0x0f985, 0x0f986, 0x0f987,
  0x0f988, 0x0f989, 0x02f12, 0x0f98b, 0x0f98c, 0x0f98d, 0x0f98e, 0x0f98f,
  0x0f990, 0x0f991, 0x0f992, 0x0f993, 0x0f994, 0x0f995, 0x0f996, 0x0f997,
  0x0f998, 0x0f999, 0x0f99a, 0x0f99b, 0x0f99c, 0x0f99d, 0x0f99e, 0x0f99f,
  0x0f9a0, 0x0f96f, 0x0f9a2, 0x0f9a3, 0x0f9a4, 0x0f9a5, 0x0f9a6, 0x0f9a7,
  0x0f9a8, 0x0f9a9, 0x0f95f, 0x0f9ab, 0x0f9ac, 0x0f9ad, 0x0f9ae, 0x0f9af,
  0x0f9b0, 0x0f9b1, 0x0f9b2, 0x0f9b3, 0x0f9b4, 0x0f9b5, 0x0f9b6, 0x0f9b7,
  0x0f9b8, 0x0f9b9, 0x0f9ba, 0x0f9bb, 0x0f9bc, 0x0f9bd, 0x0f9be, 0x0f914,
  0x0f9c0, 0x0f9c1, 0x0f9c2, 0x0f9c3, 0x02eef, 0x0f9c5, 0x0f9c6, 0x0f9c7,
  0x0f9c8, 0x0f9c9, 0x0f9ca, 0x0f9cb, 0x0f9cc, 0x0f9cd, 0x0f9ce, 0x0f9cf,
  0x0f9d0, 0x03285, 0x0f9d2, 0x0f9d3, 0x0f9d4, 0x0f9d5, 0x0f9d6, 0x0f9d7,
  0x0f9d8, 0x0f9d9, 0x0f9da, 0x0f961, 0x0f9dc, 0x0f9dd, 0x0f9de, 0x0f9df,
  0x0f9e0, 0x0f9e1, 0x0f9e2, 0x0f9e3, 0x0f9e4, 0x0f9e5, 0x0f9e6, 0x0f9e7,
  0x0f9e8, 0x02fa5, 0x0f9ea, 0x0f9eb, 0x0f9ec, 0x0f9ed, 0x0f9ee, 0x0f9ef,
  0x0f9f0, 0x0f9f1, 0x0f9f2, 0x0f9f3, 0x0f9f4, 0x0f9f5, 0x0f9f6, 0x02f74,
  0x0f9f8, 0x0f9f9, 0x0f9fa, 0x0f9fb, 0x0f9fc, 0x0f9fd, 0x0f9fe, 0x0f9ff
};

static uint32_t unicode_ci_page_fa[] = {
  0x0fa00, 0x0fa01, 0x0fa02, 0x0fa03, 0x0fa04, 0x0fa05, 0x0fa06, 0x0fa07,
  0x02f8f, 0x0fa09, 0x02f92, 0x0fa0b, 0x0fa0c, 0x0fa0d, 0x0fa0e, 0x0fa0f,
  0x0fa10, 0x0fa11, 0x0fa12, 0x0fa13, 0x0fa14, 0x0fa15, 0x0fa16, 0x0fa17,
  0x0fa18, 0x0fa19, 0x0fa1a, 0x0fa1b, 0x0fa1c, 0x0fa1d, 0x02f7b, 0x0fa1f,
  0x0fa20, 0x0fa21, 0x0fa22, 0x0fa23, 0x0fa24, 0x0fa25, 0x0fa26, 0x0fa27,
  0x0fa28, 0x0fa29, 0x0fa2a, 0x0fa2b, 0x0fa2c, 0x0fa2d, 0x0fa2e, 0x0fa2f,
  0x0fa30, 0x0fa31, 0x0fa32, 0x0fa33, 0x0fa34, 0x0fa35, 0x0fa36, 0x0fa37,
  0x0fa38, 0x0fa39, 0x0fa3a, 0x0fa3b, 0x02f2c, 0x0fa3d, 0x0fa3e, 0x0fa3f,
  0x0fa40, 0x0fa41, 0x0fa42, 0x0fa43, 0x0fa44, 0x0fa45, 0x0fa46, 0x0fa47,
  0x0fa48, 0x02ea4, 0x0fa4a, 0x0fa4b, 0x03293, 0x0fa4d, 0x0fa4e, 0x0fa4f,
  0x0fa50, 0x03297, 0x0fa52, 0x0fa53, 0x0fa54, 0x0fa55, 0x0fa56, 0x0f996,
  0x0fa58, 0x0fa59, 0x0fa5a, 0x0fa5b, 0x0fa5c, 0x02ebe, 0x02ebe, 0x0fa5f,
  0x0fa60, 0x0fa61, 0x0fa62, 0x0fa63, 0x0fa64, 0x0fa65, 0x02ecc, 0x0fa25,
  0x0fa68, 0x0fa69, 0x0fa6a, 0x0fa6b, 0x0fa6c, 0x0fa6d, 0x0fa6e, 0x0fa6f,
  0x0fa70, 0x0fa71, 0x0fa72, 0x0fa73, 0x0fa74, 0x0fa75, 0x0fa76, 0x0fa77,
  0x0fa78, 0x0fa79, 0x0fa7a, 0x0fa7b, 0x0fa7c, 0x0fa7d, 0x0fa7e, 0x0fa7f,
  0x0fa80, 0x0fa81, 0x0fa82, 0x0fa83, 0x0fa84, 0x0fa85, 0x0fa86, 0x0fa87,
  0x0fa88, 0x0fa89, 0x0fa8a, 0x0fa8b, 0x0fa8c, 0x0fa8d, 0x0fa8e, 0x0fa8f,
  0x0fa90, 0x0fa91, 0x0fa92, 0x0fa93, 0x0fa94, 0x0fa95, 0x0fa96, 0x0fa97,
  0x0fa98, 0x0fa99, 0x0fa9a, 0x0fa9b, 0x0fa9c, 0x0fa9d, 0x0fa9e, 0x0fa9f,
  0x0faa0, 0x0faa1, 0x0faa2, 0x0faa3, 0x0faa4, 0x0faa5, 0x0faa6, 0x0faa7,
  0x0faa8, 0x0faa9, 0x0faaa, 0x0faab, 0x0faac, 0x0faad, 0x0faae, 0x0faaf,
  0x0fab0, 0x0fab1, 0x0fab2, 0x0fab3, 0x0fab4, 0x0fab5, 0x0fab6, 0x0fab7,
  0x0fab8, 0x0fab9, 0x0faba, 0x0fabb, 0x0fabc, 0x0fabd, 0x0fabe, 0x0fabf,
  0x0fac0, 0x0fac1, 0x0fac2, 0x0fac3, 0x0fac4, 0x0fac5, 0x0fac6, 0x0fac7,
  0x0fac8, 0x0fac9, 0x0faca, 0x0facb, 0x0facc, 0x0facd, 0x0face, 0x0facf,
  0x0fad0, 0x0fad1, 0x0fad2, 0x0fad3, 0x0fad4, 0x0fad5, 0x0fad6, 0x0fad7,
  0x0fad8, 0x0fad9, 0x0fada, 0x0fadb, 0x0fadc, 0x0fadd, 0x0fade, 0x0fadf,
  0x0fae0, 0x0fae1, 0x0fae2, 0x0fae3, 0x0fae4, 0x0fae5, 0x0fae6, 0x0fae7,
  0x0fae8, 0x0fae9, 0x0faea, 0x0faeb, 0x0faec, 0x0faed, 0x0faee, 0x0faef,
  0x0faf0, 0x0faf1, 0x0faf2, 0x0faf3, 0x0faf4, 0x0faf5, 0x0faf6, 0x0faf7,
  0x0faf8, 0x0faf9, 0x0fafa, 0x0fafb, 0x0fafc, 0x0fafd, 0x0fafe, 0x0faff
};

static uint32_t unicode_ci_page_fb[] = {
  0x0fb00, 0x0fb01, 0x0fb02, 0x0fb03, 0x0fb04, 0x0fb05, 0x0fb05, 0x0fb07,
  0x0fb08, 0x0fb09, 0x0fb0a, 0x0fb0b, 0x0fb0c, 0x0fb0d, 0x0fb0e, 0x0fb0f,
  0x0fb10, 0x0fb11, 0x0fb12, 0x0fb13, 0x0fb14, 0x0fb15, 0x0fb16, 0x0fb17,
  0x0fb18, 0x0fb19, 0x0fb1a, 0x0fb1b, 0x0fb1c, 0x005d9, 0x00000, 0x005f2,
  0x005e2, 0x005d0, 0x005d3, 0x005d4, 0x005da, 0x005dc, 0x005dd, 0x005e8,
  0x005ea, 0x0002b, 0x005e9, 0x005e9, 0x005e9, 0x005e9, 0x005d0, 0x005d0,
  0x005d0, 0x005d1, 0x005d2, 0x005d3, 0x005d4, 0x005d5, 0x005d6, 0x0fb37,
  0x005d8, 0x005d9, 0x005da, 0x005da, 0x005dc, 0x0fb3d, 0x005dd, 0x0fb3f,
  0x005df, 0x005e1, 0x0fb42, 0x005e3, 0x005e3, 0x0fb45, 0x005e5, 0x005e7,
  0x005e8, 0x005e9, 0x005ea, 0x005d5, 0x005d1, 0x005da, 0x005e3, 0x0fb4f,
  0x00671, 0x00671, 0x0067b, 0x0067b, 0x0067b, 0x0067b, 0x0067e, 0x0067e,
  0x0067e, 0x0067e, 0x00680, 0x00680, 0x00680, 0x00680, 0x0067a, 0x0067a,
  0x0067a, 0x0067a, 0x0067f, 0x0067f, 0x0067f, 0x0067f, 0x00679, 0x00679,
  0x00679, 0x00679, 0x006a4, 0x006a4, 0x006a4, 0x006a4, 0x006a6, 0x006a6,
  0x006a6, 0x006a6, 0x00684, 0x00684, 0x00684, 0x00684, 0x00683, 0x00683,
  0x00683, 0x00683, 0x00686, 0x00686, 0x00686, 0x00686, 0x00687, 0x00687,
  0x00687, 0x00687, 0x0068d, 0x0068d, 0x0068c, 0x0068c, 0x0068e, 0x0068e,
  0x00688, 0x00688, 0x00698, 0x00698, 0x00691, 0x00691, 0x006a9, 0x006a9,
  0x006a9, 0x006a9, 0x006af, 0x006af, 0x006af, 0x006af, 0x006b3, 0x006b3,
  0x006b3, 0x006b3, 0x006b1, 0x006b1, 0x006b1, 0x006b1, 0x006ba, 0x006ba,
  0x006bb, 0x006bb, 0x006bb, 0x006bb, 0x006c0, 0x006c0, 0x006c1, 0x006c1,
  0x006c1, 0x006c1, 0x006be, 0x006be, 0x006be, 0x006be, 0x006d2, 0x006d2,
  0x006d2, 0x006d2, 0x0fbb2, 0x0fbb3, 0x0fbb4, 0x0fbb5, 0x0fbb6, 0x0fbb7,
  0x0fbb8, 0x0fbb9, 0x0fbba, 0x0fbbb, 0x0fbbc, 0x0fbbd, 0x0fbbe, 0x0fbbf,
  0x0fbc0, 0x0fbc1, 0x0fbc2, 0x0fbc3, 0x0fbc4, 0x0fbc5, 0x0fbc6, 0x0fbc7,
  0x0fbc8, 0x0fbc9, 0x0fbca, 0x0fbcb, 0x0fbcc, 0x0fbcd, 0x0fbce, 0x0fbcf,
  0x0fbd0, 0x0fbd1, 0x0fbd2, 0x006ad, 0x006ad, 0x006ad, 0x006ad, 0x006c7,
  0x006c7, 0x006c6, 0x006c6, 0x006c8, 0x006c8, 0x00677, 0x006cb, 0x006cb,
  0x006c5, 0x006c5, 0x006c9, 0x006c9, 0x006d0, 0x006d0, 0x006d0, 0x006d0,
  0x00649, 0x00649, 0x0fbea, 0x0fbea, 0x0fbec, 0x0fbec, 0x0fbee, 0x0fbee,
  0x0fbf0, 0x0fbf0, 0x0fbf2, 0x0fbf2, 0x0fbf4, 0x0fbf4, 0x0fbf6, 0x0fbf6,
  0x0fbf6, 0x0fbf9, 0x0fbf9, 0x0fbf9, 0x006cc, 0x006cc, 0x006cc, 0x006cc
};

static uint32_t unicode_ci_page_fc[] = {
  0x0fc00, 0x0fc01, 0x0fc02, 0x0fbf9, 0x0fc04, 0x0fc05, 0x0fc06, 0x0fc07,
  0x0fc08, 0x0fc09, 0x0fc0a, 0x0fc0b, 0x0fc0c, 0x0fc0d, 0x0fc0e, 0x0fc0f,
  0x0fc10, 0x0fc11, 0x0fc12, 0x0fc13, 0x0fc14, 0x0fc15, 0x0fc16, 0x0fc17,
  0x0fc18, 0x0fc19, 0x0fc1a, 0x0fc1b, 0x0fc1c, 0x0fc1d, 0x0fc1e, 0x0fc1f,
  0x0fc20, 0x0fc21, 0x0fc22, 0x0fc23, 0x0fc24, 0x0fc25, 0x0fc26, 0x0fc27,
  0x0fc28, 0x0fc29, 0x0fc2a, 0x0fc2b, 0x0fc2c, 0x0fc2d, 0x0fc2e, 0x0fc2f,
  0x0fc30, 0x0fc31, 0x0fc32, 0x0fc33, 0x0fc34, 0x0fc35, 0x0fc36, 0x0fc37,
  0x0fc38, 0x0fc39, 0x0fc3a, 0x0fc3b, 0x0fc3c, 0x0fc3d, 0x0fc3e, 0x0fc3f,
  0x0fc40, 0x0fc41, 0x0fc42, 0x0fc43, 0x0fc44, 0x0fc45, 0x0fc46, 0x0fc47,
  0x0fc48, 0x0fc49, 0x0fc4a, 0x0fc4b, 0x0fc4c, 0x0fc4d, 0x0fc4e, 0x0fc4f,
  0x0fc50, 0x0fc51, 0x0fc52, 0x0fc53, 0x0fc54, 0x0fc55, 0x0fc56, 0x0fc57,
  0x0fc58, 0x0fc59, 0x0fc5a, 0x00630, 0x00631, 0x00649, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x0fc64, 0x0fc65, 0x0fc02, 0x0fc67,
  0x0fbf9, 0x0fc04, 0x0fc6a, 0x0fc6b, 0x0fc08, 0x0fc6d, 0x0fc09, 0x0fc0a,
  0x0fc70, 0x0fc71, 0x0fc0e, 0x0fc73, 0x0fc0f, 0x0fc10, 0x0fc76, 0x0fc77,
  0x0fc12, 0x0fc79, 0x0fc13, 0x0fc14, 0x0fc31, 0x0fc32, 0x0fc35, 0x0fc36,
  0x0fc37, 0x0fc3b, 0x0fc3c, 0x0fc3d, 0x0fc3e, 0x0fc42, 0x0fc43, 0x0fc44,
  0x0fc88, 0x0fc48, 0x0fc8a, 0x0fc8b, 0x0fc4e, 0x0fc8d, 0x0fc4f, 0x0fc50,
  0x00649, 0x0fc91, 0x0fc92, 0x0fc58, 0x0fc94, 0x0fc59, 0x0fc5a, 0x0fc00,
  0x0fc01, 0x0fc99, 0x0fc02, 0x0fc9b, 0x0fc05, 0x0fc06, 0x0fc07, 0x0fc08,
  0x0fca0, 0x0fc0b, 0x0fc0c, 0x0fc0d, 0x0fc0e, 0x0fca5, 0x0fc12, 0x0fc15,
  0x0fc16, 0x0fc17, 0x0fc18, 0x0fc19, 0x0fc1b, 0x0fc1c, 0x0fc1d, 0x0fc1e,
  0x0fc1f, 0x0fc20, 0x0fcb2, 0x0fc21, 0x0fc22, 0x0fc23, 0x0fc24, 0x0fc25,
  0x0fc26, 0x0fc28, 0x0fc29, 0x0fc2a, 0x0fc2b, 0x0fc2c, 0x0fc2d, 0x0fc2e,
  0x0fc2f, 0x0fc30, 0x0fc33, 0x0fc34, 0x0fc38, 0x0fc39, 0x0fc3a, 0x0fc3b,
  0x0fc3c, 0x0fc3f, 0x0fc40, 0x0fc41, 0x0fc42, 0x0fccd, 0x0fc45, 0x0fc46,
  0x0fc47, 0x0fc48, 0x0fc4b, 0x0fc4c, 0x0fc4d, 0x0fc4e, 0x0fcd6, 0x0fc51,
  0x0fc52, 0x00647, 0x0fc55, 0x0fc56, 0x0fc57, 0x0fc58, 0x0fcde, 0x0fc02,
  0x0fc9b, 0x0fc08, 0x0fca0, 0x0fc0e, 0x0fca5, 0x0fc12, 0x0fce6, 0x0fc1f,
  0x0fce8, 0x0fce9, 0x0fcea, 0x0fc3b, 0x0fc3c, 0x0fc42, 0x0fc4e, 0x0fcd6,
  0x0fc58, 0x0fcde, 0x00000, 0x00000, 0x00000, 0x0fcf5, 0x0fcf6, 0x0fcf7,
  0x0fcf8, 0x0fcf9, 0x0fcfa, 0x0fcfb, 0x0fcfc, 0x0fcfd, 0x0fcfe, 0x0fcff
};

static uint32_t unicode_ci_page_fd[] = {
  0x0fd00, 0x0fd01, 0x0fd02, 0x0fd03, 0x0fd04, 0x0fd05, 0x0fd06, 0x0fd07,
  0x0fd08, 0x0fd09, 0x0fd0a, 0x0fd0b, 0x0fce9, 0x0fd0d, 0x0fd0e, 0x0fd0f,
  0x0fd10, 0x0fcf5, 0x0fcf6, 0x0fcf7, 0x0fcf8, 0x0fcf9, 0x0fcfa, 0x0fcfb,
  0x0fcfc, 0x0fcfd, 0x0fcfe, 0x0fd1b, 0x0fd00, 0x0fd01, 0x0fd02, 0x0fd03,
  0x0fd04, 0x0fd05, 0x0fd06, 0x0fd07, 0x0fd08, 0x0fd09, 0x0fd0a, 0x0fd0b,
  0x0fce9, 0x0fd0d, 0x0fd0e, 0x0fd0f, 0x0fd10, 0x0fd09, 0x0fd0a, 0x0fd0b,
  0x0fce9, 0x0fce8, 0x0fcea, 0x0fc27, 0x0fc1c, 0x0fc1d, 0x0fc1e, 0x0fd09,
  0x0fd0a, 0x0fd0b, 0x0fc27, 0x0fc28, 0x00627, 0x00627, 0x0fd3e, 0x0fd3f,
  0x0fd40, 0x0fd41, 0x0fd42, 0x0fd43, 0x0fd44, 0x0fd45, 0x0fd46, 0x0fd47,
  0x0fd48, 0x0fd49, 0x0fd4a, 0x0fd4b, 0x0fd4c, 0x0fd4d, 0x0fd4e, 0x0fd4f,
  0x0fd50, 0x0fd51, 0x0fd51, 0x0fd53, 0x0fd54, 0x0fd55, 0x0fd56, 0x0fd57,
  0x0fd58, 0x0fd58, 0x0fd5a, 0x0fd5b, 0x0fd5c, 0x0fd5d, 0x0fd5e, 0x0fd5f,
  0x0fd5f, 0x0fd61, 0x0fd62, 0x0fd62, 0x0fd64, 0x0fd64, 0x0fd66, 0x0fd67,
  0x0fd67, 0x0fd69, 0x0fd6a, 0x0fd6a, 0x0fd6c, 0x0fd6c, 0x0fd6e, 0x0fd6f,
  0x0fd6f, 0x0fd71, 0x0fd71, 0x0fd73, 0x0fd74, 0x0fd75, 0x0fd76, 0x0fd76,
  0x0fd78, 0x0fd79, 0x0fd7a, 0x0fd7b, 0x0fd7c, 0x0fd7c, 0x0fd7e, 0x0fd7f,
  0x0fd80, 0x0fd81, 0x0fd82, 0x0fd83, 0x0fd83, 0x0fd85, 0x0fd85, 0x0fd87,
  0x0fd87, 0x0fd89, 0x0fd8a, 0x0fd8b, 0x0fd8c, 0x0fd8d, 0x0fd8e, 0x0fd8f,
  0x0fd90, 0x0fd91, 0x0fd92, 0x0fd93, 0x0fd94, 0x0fd95, 0x0fd96, 0x0fd97,
  0x0fd97, 0x0fd99, 0x0fd9a, 0x0fd9b, 0x0fd9c, 0x0fd9c, 0x0fd9e, 0x0fd9f,
  0x0fda0, 0x0fda1, 0x0fda2, 0x0fda3, 0x0fda4, 0x0fda5, 0x0fda6, 0x0fda7,
  0x0fda8, 0x0fda9, 0x0fdaa, 0x0fdab, 0x0fdac, 0x0fdad, 0x0fdae, 0x0fdaf,
  0x0fdb0, 0x0fdb1, 0x0fdb2, 0x0fdb3, 0x0fd7e, 0x0fd80, 0x0fdb6, 0x0fdb7,
  0x0fdb8, 0x0fdb9, 0x0fdba, 0x0fdbb, 0x0fdba, 0x0fdb8, 0x0fdbe, 0x0fdbf,
  0x0fdc0, 0x0fdc1, 0x0fdc2, 0x0fdbb, 0x0fd75, 0x0fd66, 0x0fdc6, 0x0fdc7,
  0x0fdc8, 0x0fdc9, 0x0fdca, 0x0fdcb, 0x0fdcc, 0x0fdcd, 0x0fdce, 0x0fdcf,
  0x0fdd0, 0x0fdd1, 0x0fdd2, 0x0fdd3, 0x0fdd4, 0x0fdd5, 0x0fdd6, 0x0fdd7,
  0x0fdd8, 0x0fdd9, 0x0fdda, 0x0fddb, 0x0fddc, 0x0fddd, 0x0fdde, 0x0fddf,
  0x0fde0, 0x0fde1, 0x0fde2, 0x0fde3, 0x0fde4, 0x0fde5, 0x0fde6, 0x0fde7,
  0x0fde8, 0x0fde9, 0x0fdea, 0x0fdeb, 0x0fdec, 0x0fded, 0x0fdee, 0x0fdef,
  0x0fdf0, 0x0fdf1, 0x0fdf2, 0x0fdf3, 0x0fdf4, 0x0fdf5, 0x0fdf6, 0x0fdf7,
  0x0fdf8, 0x0fdf9, 0x0fdfa, 0x0fdfb, 0x0fdfc, 0x0fdfd, 0x0fdfe, 0x0fdff
};

static uint32_t unicode_ci_page_fe[] = {
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x0fe10, 0x0fe11, 0x0fe12, 0x0fe13, 0x0fe14, 0x0fe15, 0x0fe16, 0x0fe17,
  0x0fe18, 0x0fe19, 0x0fe1a, 0x0fe1b, 0x0fe1c, 0x0fe1d, 0x0fe1e, 0x0fe1f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x0fe24, 0x0fe25, 0x0fe26, 0x0fe27,
  0x0fe28, 0x0fe29, 0x0fe2a, 0x0fe2b, 0x0fe2c, 0x0fe2d, 0x0fe2e, 0x0fe2f,
  0x02025, 0x02014, 0x02013, 0x0005f, 0x0005f, 0x00028, 0x00029, 0x0007b,
  0x0007d, 0x03014, 0x03015, 0x03010, 0x03011, 0x0300a, 0x0300b, 0x02329,
  0x0232a, 0x0300c, 0x0300d, 0x0300e, 0x0300f, 0x0fe45, 0x0fe46, 0x0005b,
  0x0005d, 0x0203e, 0x0203e, 0x0203e, 0x0203e, 0x0005f, 0x0005f, 0x0005f,
  0x0002c, 0x03001, 0x0002e, 0x0fe53, 0x0003b, 0x0003a, 0x0003f, 0x00021,
  0x02014, 0x00028, 0x00029, 0x0007b, 0x0007d, 0x03014, 0x03015, 0x00023,
  0x00026, 0x0002a, 0x0002b, 0x0002d, 0x0003c, 0x0003e, 0x0003d, 0x0fe67,
  0x0005c, 0x00024, 0x00025, 0x00040, 0x0fe6c, 0x0fe6d, 0x0fe6e, 0x0fe6f,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x0fe75, 0x00000, 0x00000,
  0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000, 0x00000,
  0x00621, 0x00622, 0x00622, 0x00623, 0x00623, 0x00624, 0x00624, 0x00625,
  0x00625, 0x00626, 0x00626, 0x00626, 0x00626, 0x00627, 0x00627, 0x00628,
  0x00628, 0x00628, 0x00628, 0x00629, 0x00629, 0x0062a, 0x0062a, 0x0062a,
  0x0062a, 0x0062b, 0x0062b, 0x0062b, 0x0062b, 0x0062c, 0x0062c, 0x0062c,
  0x0062c, 0x0062d, 0x0062d, 0x0062d, 0x0062d, 0x0062e, 0x0062e, 0x0062e,
  0x0062e, 0x0062f, 0x0062f, 0x00630, 0x00630, 0x00631, 0x00631, 0x00632,
  0x00632, 0x00633, 0x00633, 0x00633, 0x00633, 0x00634, 0x00634, 0x00634,
  0x00634, 0x00635, 0x00635, 0x00635, 0x00635, 0x00636, 0x00636, 0x00636,
  0x00636, 0x00637, 0x00637, 0x00637, 0x00637, 0x00638, 0x00638, 0x00638,
  0x00638, 0x00639, 0x00639, 0x00639, 0x00639, 0x0063a, 0x0063a, 0x0063a,
  0x0063a, 0x00641, 0x00641, 0x00641, 0x00641, 0x00642, 0x00642, 0x00642,
  0x00642, 0x00643, 0x00643, 0x00643, 0x00643, 0x00644, 0x00644, 0x00644,
  0x00644, 0x00645, 0x00645, 0x00645, 0x00645, 0x00646, 0x00646, 0x00646,
  0x00646, 0x00647, 0x00647, 0x00647, 0x00647, 0x00648, 0x00648, 0x00649,
  0x00649, 0x0064a, 0x0064a, 0x0064a, 0x0064a, 0x0fef5, 0x0fef5, 0x0fef7,
  0x0fef7, 0x0fef9, 0x0fef9, 0x0fefb, 0x0fefb, 0x0fefd, 0x0fefe, 0x0feff
};

static uint32_t unicode_ci_page_ff[] = {
  0x0ff00, 0x00021, 0x00022, 0x00023, 0x00024, 0x00025, 0x00026, 0x00027,
  0x00028, 0x00029, 0x0002a, 0x0002b, 0x0002c, 0x0002d, 0x0002e, 0x0002f,
  0x00030, 0x00031, 0x00032, 0x00033, 0x00034, 0x00035, 0x00036, 0x00037,
  0x00038, 0x00039, 0x0003a, 0x0003b, 0x0003c, 0x0003d, 0x0003e, 0x0003f,
  0x00040, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0005b, 0x0005c, 0x0005d, 0x0005e, 0x0005f,
  0x00060, 0x00041, 0x00042, 0x00043, 0x00044, 0x00045, 0x00046, 0x00047,
  0x00048, 0x00049, 0x0004a, 0x0004b, 0x0004c, 0x0004d, 0x0004e, 0x0004f,
  0x00050, 0x00051, 0x00052, 0x00053, 0x00054, 0x00055, 0x00056, 0x00057,
  0x00058, 0x00059, 0x0005a, 0x0007b, 0x0007c, 0x0007d, 0x0007e, 0x02985,
  0x02986, 0x03002, 0x0300c, 0x0300d, 0x03001, 0x030fb, 0x03092, 0x03042,
  0x03044, 0x03046, 0x03048, 0x0304a, 0x03084, 0x03086, 0x03088, 0x03064,
  0x030fc, 0x03042, 0x03044, 0x03046, 0x03048, 0x0304a, 0x0304b, 0x0304d,
  0x0304f, 0x03051, 0x03053, 0x03055, 0x03057, 0x03059, 0x0305b, 0x0305d,
  0x0305f, 0x03061, 0x03064, 0x03066, 0x03068, 0x0306a, 0x0306b, 0x0306c,
  0x0306d, 0x0306e, 0x0306f, 0x03072, 0x03075, 0x03078, 0x0307b, 0x0307e,
  0x0307f, 0x03080, 0x03081, 0x03082, 0x03084, 0x03086, 0x03088, 0x03089,
  0x0308a, 0x0308b, 0x0308c, 0x0308d, 0x0308f, 0x03093, 0x00000, 0x00000,
  0x01160, 0x01100, 0x01101, 0x011aa, 0x01102, 0x011ac, 0x011ad, 0x01103,
  0x01104, 0x01105, 0x011b0, 0x011b1, 0x011b2, 0x011b3, 0x011b4, 0x011b5,
  0x0111a, 0x01106, 0x01107, 0x01108, 0x01121, 0x01109, 0x0110a, 0x0110b,
  0x0110c, 0x0110d, 0x0110e, 0x0110f, 0x01110, 0x01111, 0x01112, 0x0ffbf,
  0x0ffc0, 0x0ffc1, 0x01161, 0x01162, 0x01163, 0x01164, 0x01165, 0x01166,
  0x0ffc8, 0x0ffc9, 0x01167, 0x01168, 0x01169, 0x0116a, 0x0116b, 0x0116c,
  0x0ffd0, 0x0ffd1, 0x0116d, 0x0116e, 0x0116f, 0x01170, 0x01171, 0x01172,
  0x0ffd8, 0x0ffd9, 0x01173, 0x01174, 0x01175, 0x0ffdd, 0x0ffde, 0x0ffdf,
  0x000a2, 0x000a3, 0x000ac, 0x000af, 0x000a6, 0x000a5, 0x020a9, 0x0ffe7,
  0x02502, 0x02190, 0x02191, 0x02192, 0x02193, 0x025a0, 0x025cb, 0x0ffef,
  0x0fff0, 0x0fff1, 0x0fff2, 0x0fff3, 0x0fff4, 0x0fff5, 0x0fff6, 0x0fff7,
  0x0fff8, 0x00000, 0x00000, 0x00000, 0x0fffc, 0x0fffd, 0x0fffe, 0x0ffff
};

static uint32_t *unicode_ci_table[256] = {
   unicode_ci_page_00,  unicode_ci_page_01,
   unicode_ci_page_02,  unicode_ci_page_03,
   unicode_ci_page_04,  unicode_ci_page_05,
   unicode_ci_page_06,  unicode_ci_page_07,
                 NULL,  unicode_ci_page_09,
   unicode_ci_page_0a,  unicode_ci_page_0b,
   unicode_ci_page_0c,  unicode_ci_page_0d,
   unicode_ci_page_0e,  unicode_ci_page_0f,
   unicode_ci_page_10,                NULL,
                 NULL,  unicode_ci_page_13,
                 NULL,                NULL,
   unicode_ci_page_16,  unicode_ci_page_17,
   unicode_ci_page_18,  unicode_ci_page_19,
                 NULL,                NULL,
                 NULL,  unicode_ci_page_1d,
   unicode_ci_page_1e,  unicode_ci_page_1f,
   unicode_ci_page_20,  unicode_ci_page_21,
   unicode_ci_page_22,                NULL,
   unicode_ci_page_24,                NULL,
                 NULL,  unicode_ci_page_27,
                 NULL,                NULL,
   unicode_ci_page_2a,                NULL,
                 NULL,                NULL,
   unicode_ci_page_2e,  unicode_ci_page_2f,
   unicode_ci_page_30,  unicode_ci_page_31,
   unicode_ci_page_32,  unicode_ci_page_33,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,                NULL,
                 NULL,  unicode_ci_page_f9,
   unicode_ci_page_fa,  unicode_ci_page_fb,
   unicode_ci_page_fc,  unicode_ci_page_fd,
   unicode_ci_page_fe,  unicode_ci_page_ff
};

#endif
