/* This file is automatically generated by Lemon from input grammar
** source file "../../groonga/lib/grn_ecmascript.lemon". */
/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
/************ Begin %include sections from the grammar ************************/
#line 4 "../../groonga/lib/grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT

  static void
  array_literal_end(efs_info *efsi, int n_elements)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_expr *e = (grn_expr *)(efsi->e);
    grn_obj *array_literal = grn_obj_open(ctx, GRN_VECTOR, 0, GRN_ID_NIL);
    if (!array_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][array-literal] couldn't create vector: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }
    grn_expr_take_obj(ctx, efsi->e, array_literal);

    int i;
    for (i = n_elements; i > 0; i--) {
      grn_expr_code *code = &(e->codes[e->codes_curr - i]);
      if (code->op != GRN_OP_PUSH) {
        ERR(GRN_FUNCTION_NOT_IMPLEMENTED,
            "[expr][array-literal] "
            "complex expression in array literal isn't supported yet: <%.*s>",
            (int)(efsi->str_end - efsi->str),
            efsi->str);
        return;
      }
      grn_obj *element = code->value;
      grn_vector_add_element_float(ctx,
                                   array_literal,
                                   GRN_TEXT_VALUE(element),
                                   GRN_TEXT_LEN(element),
                                   0,
                                   element->header.domain);
      if (ctx->rc != GRN_SUCCESS) {
        char message[GRN_CTX_MSGSIZE];
        grn_strncpy(message, sizeof(message), ctx->errbuf, sizeof(ctx->errbuf));
        ERR(ctx->rc,
            "[expr][array-literal] failed to add an element: %s",
            message);
        return;
      }
    }
    for (i = 0; i < n_elements; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 1;
    }

    grn_expr_append_obj(ctx, efsi->e, array_literal, GRN_OP_PUSH, 1);
  }

  static void
  object_literal_end(efs_info *efsi, int n_properties)
  {
    grn_ctx *ctx = efsi->ctx;
    grn_hash *object_literal =
      grn_hash_create(ctx,
                      NULL,
                      GRN_TABLE_MAX_KEY_SIZE,
                      sizeof(grn_obj),
                      GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
    if (!object_literal) {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "[expr][object-literal] couldn't create hash table: <%.*s>",
          (int)(efsi->str_end - efsi->str),
          efsi->str);
      return;
    }

    grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(object_literal));
    DB_OBJ(object_literal)->header.domain = GRN_DB_SHORT_TEXT;

    grn_expr *e = (grn_expr *)(efsi->e);
    int i;
    for (i = n_properties; i > 0; i--) {
      int base = e->codes_curr - (i * 3);
      grn_obj *name = e->codes[base].value;
      grn_obj *value = e->codes[base + 2].value;

      grn_obj *buf;
      int added;
      grn_id id = grn_hash_add(ctx,
                               object_literal,
                               GRN_TEXT_VALUE(name),
                               GRN_TEXT_LEN(name),
                               (void **)(&buf),
                               &added);
      if (id == GRN_ID_NIL) {
        grn_rc rc = ctx->rc;
        if (rc == GRN_SUCCESS) {
          rc = GRN_NO_MEMORY_AVAILABLE;
        }
        ERR(rc,
            "[expr][object-literal] failed to add a property: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      if (!added) {
        ERR(GRN_INVALID_ARGUMENT,
            "[expr][object-literal] duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(name),
            GRN_TEXT_VALUE(name));
        return;
      }

      switch (value->header.type) {
      case GRN_TABLE_HASH_KEY :
      case GRN_COLUMN_FIX_SIZE :
      case GRN_COLUMN_VAR_SIZE :
      case GRN_COLUMN_INDEX :
        GRN_OBJ_INIT(buf, GRN_PTR, 0, GRN_ID_NIL);
        GRN_PTR_SET(ctx, buf, value);
        break;
      case GRN_VECTOR :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        grn_vector_copy(ctx, value, buf);
        break;
      default :
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        break;
      }
    }
    for (i = 0; i < n_properties; i++) {
      grn_expr_dfi_pop(e);
      e->codes_curr -= 3;
    }
    grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(object_literal),
                        GRN_OP_PUSH, 1);
  }
#line 167 "../../groonga/lib/grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols.
***************** Begin token definitions *************************************/
#ifndef GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS
#define GRN_EXPR_TOKEN_START_OUTPUT_COLUMNS            1
#define GRN_EXPR_TOKEN_START_ADJUSTER                  2
#define GRN_EXPR_TOKEN_START_SORT_KEYS                 3
#define GRN_EXPR_TOKEN_START_OPTIONS                   4
#define GRN_EXPR_TOKEN_LOGICAL_AND                     5
#define GRN_EXPR_TOKEN_LOGICAL_AND_NOT                 6
#define GRN_EXPR_TOKEN_LOGICAL_OR                      7
#define GRN_EXPR_TOKEN_NEGATIVE                        8
#define GRN_EXPR_TOKEN_QSTRING                         9
#define GRN_EXPR_TOKEN_PARENL                         10
#define GRN_EXPR_TOKEN_PARENR                         11
#define GRN_EXPR_TOKEN_ADJUST                         12
#define GRN_EXPR_TOKEN_RELATIVE_OP                    13
#define GRN_EXPR_TOKEN_IDENTIFIER                     14
#define GRN_EXPR_TOKEN_BRACEL                         15
#define GRN_EXPR_TOKEN_BRACER                         16
#define GRN_EXPR_TOKEN_EVAL                           17
#define GRN_EXPR_TOKEN_COMMA                          18
#define GRN_EXPR_TOKEN_ASSIGN                         19
#define GRN_EXPR_TOKEN_STAR_ASSIGN                    20
#define GRN_EXPR_TOKEN_SLASH_ASSIGN                   21
#define GRN_EXPR_TOKEN_MOD_ASSIGN                     22
#define GRN_EXPR_TOKEN_PLUS_ASSIGN                    23
#define GRN_EXPR_TOKEN_MINUS_ASSIGN                   24
#define GRN_EXPR_TOKEN_SHIFTL_ASSIGN                  25
#define GRN_EXPR_TOKEN_SHIFTR_ASSIGN                  26
#define GRN_EXPR_TOKEN_SHIFTRR_ASSIGN                 27
#define GRN_EXPR_TOKEN_AND_ASSIGN                     28
#define GRN_EXPR_TOKEN_XOR_ASSIGN                     29
#define GRN_EXPR_TOKEN_OR_ASSIGN                      30
#define GRN_EXPR_TOKEN_QUESTION                       31
#define GRN_EXPR_TOKEN_COLON                          32
#define GRN_EXPR_TOKEN_BITWISE_OR                     33
#define GRN_EXPR_TOKEN_BITWISE_XOR                    34
#define GRN_EXPR_TOKEN_BITWISE_AND                    35
#define GRN_EXPR_TOKEN_EQUAL                          36
#define GRN_EXPR_TOKEN_NOT_EQUAL                      37
#define GRN_EXPR_TOKEN_LESS                           38
#define GRN_EXPR_TOKEN_GREATER                        39
#define GRN_EXPR_TOKEN_LESS_EQUAL                     40
#define GRN_EXPR_TOKEN_GREATER_EQUAL                  41
#define GRN_EXPR_TOKEN_IN                             42
#define GRN_EXPR_TOKEN_MATCH                          43
#define GRN_EXPR_TOKEN_NEAR                           44
#define GRN_EXPR_TOKEN_NEAR_NO_OFFSET                 45
#define GRN_EXPR_TOKEN_NEAR_PHRASE                    46
#define GRN_EXPR_TOKEN_ORDERED_NEAR_PHRASE            47
#define GRN_EXPR_TOKEN_SIMILAR                        48
#define GRN_EXPR_TOKEN_TERM_EXTRACT                   49
#define GRN_EXPR_TOKEN_QUORUM                         50
#define GRN_EXPR_TOKEN_LCP                            51
#define GRN_EXPR_TOKEN_PREFIX                         52
#define GRN_EXPR_TOKEN_SUFFIX                         53
#define GRN_EXPR_TOKEN_REGEXP                         54
#define GRN_EXPR_TOKEN_SHIFTL                         55
#define GRN_EXPR_TOKEN_SHIFTR                         56
#define GRN_EXPR_TOKEN_SHIFTRR                        57
#define GRN_EXPR_TOKEN_PLUS                           58
#define GRN_EXPR_TOKEN_MINUS                          59
#define GRN_EXPR_TOKEN_STAR                           60
#define GRN_EXPR_TOKEN_SLASH                          61
#define GRN_EXPR_TOKEN_MOD                            62
#define GRN_EXPR_TOKEN_DELETE                         63
#define GRN_EXPR_TOKEN_INCR                           64
#define GRN_EXPR_TOKEN_DECR                           65
#define GRN_EXPR_TOKEN_NOT                            66
#define GRN_EXPR_TOKEN_BITWISE_NOT                    67
#define GRN_EXPR_TOKEN_EXACT                          68
#define GRN_EXPR_TOKEN_PARTIAL                        69
#define GRN_EXPR_TOKEN_UNSPLIT                        70
#define GRN_EXPR_TOKEN_DECIMAL                        71
#define GRN_EXPR_TOKEN_HEX_INTEGER                    72
#define GRN_EXPR_TOKEN_STRING                         73
#define GRN_EXPR_TOKEN_BOOLEAN                        74
#define GRN_EXPR_TOKEN_NULL                           75
#define GRN_EXPR_TOKEN_BRACKETL                       76
#define GRN_EXPR_TOKEN_BRACKETR                       77
#define GRN_EXPR_TOKEN_DOT                            78
#define GRN_EXPR_TOKEN_NONEXISTENT_COLUMN             79
#endif
/**************** End token definitions ***************************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    grn_expr_parserCTX_*         As grn_expr_parserARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 119
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy11;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_PARAM ,efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi =yypParser->efsi ;
#define grn_expr_parserARG_STORE yypParser->efsi =efsi ;
#define grn_expr_parserCTX_SDECL
#define grn_expr_parserCTX_PDECL
#define grn_expr_parserCTX_PARAM
#define grn_expr_parserCTX_FETCH
#define grn_expr_parserCTX_STORE
#define YYNSTATE             160
#define YYNRULE              145
#define YYNRULE_WITH_ACTION  102
#define YYNTOKEN             80
#define YY_MAX_SHIFT         159
#define YY_MIN_SHIFTREDUCE   247
#define YY_MAX_SHIFTREDUCE   391
#define YY_ERROR_ACTION      392
#define YY_ACCEPT_ACTION     393
#define YY_NO_ACTION         394
#define YY_MIN_REDUCE        395
#define YY_MAX_REDUCE        539
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1957)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   395,    3,   79,    4,   94,  127,  474,  151,  399,  356,
 /*    10 */     2,  398,   60,   90,  141,    1,   85,   78,  393,   86,
 /*    20 */   125,  324,   85,   84,   82,   86,   82,  125,  125,   98,
 /*    30 */   138,  100,  154,  153,  152,  133,   95,  115,  129,  116,
 /*    40 */   116,  116,   98,   82,  488,  146,   82,  356,   81,  402,
 /*    50 */    91,   90,  159,   11,  329,   78,  467,  524,   73,   72,
 /*    60 */   404,   23,  404,   76,   75,   74,   71,   70,   68,   67,
 /*    70 */    66,  381,  382,  383,  384,  385,    8,  139,   77,   65,
 /*    80 */    64,   82,  404,   82,  139,  139,   98,  138,  100,  154,
 /*    90 */   153,  152,  133,   95,  115,  129,  116,  116,  116,   98,
 /*   100 */    82,  475,  151,   82,  144,  127,  474,  151,  356,    2,
 /*   110 */   387,   60,   90,  141,    1,  401,   78,   85,  131,   59,
 /*   120 */    58,   57,   82,   85,   82,  131,  131,   98,  138,  100,
 /*   130 */   154,  153,  152,  133,   95,  115,  129,  116,  116,  116,
 /*   140 */    98,   82,  501,    9,   82,   69,  400,  379,   80,   34,
 /*   150 */    33,  397,   31,   62,   61,  396,   32,   73,   72,  255,
 /*   160 */     6,   29,   76,   75,   74,   71,   70,   68,   67,   66,
 /*   170 */   381,  382,  383,  384,  385,    8,   93,   92,   88,   87,
 /*   180 */   356,   81,  357,   91,   90,  159,   11,   25,   78,   39,
 /*   190 */    38,   73,   72,  337,  317,  318,   76,   75,   74,   71,
 /*   200 */    70,   68,   67,   66,  381,  382,  383,  384,  385,    8,
 /*   210 */   124,    7,  338,   82,  500,   82,  487,  487,   98,  138,
 /*   220 */   100,  154,  153,  152,  133,   95,  115,  129,  116,  116,
 /*   230 */   116,   98,   82,  378,    9,   82,   69,  142,  379,   80,
 /*   240 */    29,  482,  123,   80,  122,   82,  320,   82,  496,  496,
 /*   250 */    98,  138,  100,  154,  153,  152,  133,   95,  115,  129,
 /*   260 */   116,  116,  116,   98,   82,   29,  535,   82,  499,   89,
 /*   270 */   502,  342,   83,  123,  146,  143,  492,   10,  341,  150,
 /*   280 */   145,   30,   73,   63,  498,   35,    5,   76,   75,   74,
 /*   290 */    71,   70,   68,   67,   66,  381,  382,  383,  384,  385,
 /*   300 */     8,  388,   29,  346,   82,   27,   82,  487,  487,   98,
 /*   310 */   138,  100,  154,  153,  152,  133,   95,  115,  129,  116,
 /*   320 */   116,  116,   98,   82,  328,   24,   82,   37,   36,   26,
 /*   330 */   394,  394,  484,   82,  394,   82,  496,  496,   98,  138,
 /*   340 */   100,  154,  153,  152,  133,   95,  115,  129,  116,  116,
 /*   350 */   116,   98,   82,  394,  394,   82,  394,  394,  394,  394,
 /*   360 */   394,  394,  394,  394,  493,  394,  394,  394,  394,  394,
 /*   370 */    82,  394,   82,  479,  479,   98,  138,  100,  154,  153,
 /*   380 */   152,  133,   95,  115,  129,  116,  116,  116,   98,   82,
 /*   390 */   394,  394,   82,  394,  394,  394,   82,  126,   82,  470,
 /*   400 */   470,   98,  138,  100,  154,  153,  152,  133,   95,  115,
 /*   410 */   129,  116,  116,  116,   98,   82,  131,  394,   82,  128,
 /*   420 */    82,  394,   82,  131,  131,   98,  138,  100,  154,  153,
 /*   430 */   152,  133,   95,  115,  129,  116,  116,  116,   98,   82,
 /*   440 */   394,  394,   82,  394,  394,  394,  394,  394,  134,  394,
 /*   450 */   394,  394,   82,  394,   82,  134,  134,   98,  138,  100,
 /*   460 */   154,  153,  152,  133,   95,  115,  129,  116,  116,  116,
 /*   470 */    98,   82,  139,  394,   82,  394,   82,  394,   82,  139,
 /*   480 */   139,   98,  138,  100,  154,  153,  152,  133,   95,  115,
 /*   490 */   129,  116,  116,  116,   98,   82,  394,    9,   82,   69,
 /*   500 */   394,  379,   80,   82,  394,   82,  417,  417,   98,  138,
 /*   510 */   100,  154,  153,  152,  133,   95,  115,  129,  116,  116,
 /*   520 */   116,   98,   82,  394,  394,   82,   56,   55,   54,   53,
 /*   530 */    52,   51,   50,   49,   48,   47,   46,   45,   44,   43,
 /*   540 */    42,   41,   40,  394,  394,   73,   72,  394,  394,  394,
 /*   550 */    76,   75,   74,   71,   70,   68,   67,   66,  381,  382,
 /*   560 */   383,  384,  385,    8,  394,    9,  347,   69,  394,  379,
 /*   570 */    80,   82,  394,   82,  416,  416,   98,  138,  100,  154,
 /*   580 */   153,  152,  133,   95,  115,  129,  116,  116,  116,   98,
 /*   590 */    82,  497,  394,   82,  394,  394,   93,   92,   88,   87,
 /*   600 */   356,   81,  394,   91,   90,  159,   11,    9,   78,  394,
 /*   610 */   394,  379,   80,   73,   72,  394,  394,  394,   76,   75,
 /*   620 */    74,   71,   70,   68,   67,   66,  381,  382,  140,  384,
 /*   630 */   385,    8,    9,  394,   69,  394,  379,   80,   82,  394,
 /*   640 */    82,  415,  415,   98,  138,  100,  154,  153,  152,  133,
 /*   650 */    95,  115,  129,  116,  116,  116,   98,   82,  394,  394,
 /*   660 */    82,  394,  394,  394,  394,  394,  394,  394,  381,  382,
 /*   670 */   383,  384,  385,    8,  394,  394,  394,  394,  394,  394,
 /*   680 */    73,   72,  394,  394,  394,   76,   75,   74,   71,   70,
 /*   690 */    68,   67,   66,  381,  382,  383,  384,  385,    8,  394,
 /*   700 */   394,   82,  394,   82,  414,  414,   98,  138,  100,  154,
 /*   710 */   153,  152,  133,   95,  115,  129,  116,  116,  116,   98,
 /*   720 */    82,  394,   82,   82,   82,  413,  413,   98,  138,  100,
 /*   730 */   154,  153,  152,  133,   95,  115,  129,  116,  116,  116,
 /*   740 */    98,   82,  394,   82,   82,   82,  412,  412,   98,  138,
 /*   750 */   100,  154,  153,  152,  133,   95,  115,  129,  116,  116,
 /*   760 */   116,   98,   82,  394,  394,   82,  394,  394,   82,  394,
 /*   770 */    82,  411,  411,   98,  138,  100,  154,  153,  152,  133,
 /*   780 */    95,  115,  129,  116,  116,  116,   98,   82,  394,   82,
 /*   790 */    82,   82,  410,  410,   98,  138,  100,  154,  153,  152,
 /*   800 */   133,   95,  115,  129,  116,  116,  116,   98,   82,  394,
 /*   810 */    82,   82,   82,  409,  409,   98,  138,  100,  154,  153,
 /*   820 */   152,  133,   95,  115,  129,  116,  116,  116,   98,   82,
 /*   830 */   394,   82,   82,   82,  408,  408,   98,  138,  100,  154,
 /*   840 */   153,  152,  133,   95,  115,  129,  116,  116,  116,   98,
 /*   850 */    82,  394,  394,   82,  394,  394,   82,  394,   82,  407,
 /*   860 */   407,   98,  138,  100,  154,  153,  152,  133,   95,  115,
 /*   870 */   129,  116,  116,  116,   98,   82,  394,   82,   82,   82,
 /*   880 */   480,  480,   98,  138,  100,  154,  153,  152,  133,   95,
 /*   890 */   115,  129,  116,  116,  116,   98,   82,  394,   82,   82,
 /*   900 */    82,  534,  534,   98,  138,  100,  154,  153,  152,  133,
 /*   910 */    95,  115,  129,  116,  116,  116,   98,   82,  394,   82,
 /*   920 */    82,   82,  471,  471,   98,  138,  100,  154,  153,  152,
 /*   930 */   133,   95,  115,  129,  116,  116,  116,   98,   82,  394,
 /*   940 */   394,   82,  394,  394,   82,  394,   82,  418,  418,   98,
 /*   950 */   138,  100,  154,  153,  152,  133,   95,  115,  129,  116,
 /*   960 */   116,  116,   98,   82,  394,   82,   82,   82,  158,  158,
 /*   970 */    98,  138,  100,  154,  153,  152,  133,   95,  115,  129,
 /*   980 */   116,  116,  116,   98,   82,  394,   82,   82,   82,  406,
 /*   990 */   406,   98,  138,  100,  154,  153,  152,  133,   95,  115,
 /*  1000 */   129,  116,  116,  116,   98,   82,  394,   82,   82,   82,
 /*  1010 */   405,  405,   98,  138,  100,  154,  153,  152,  133,   95,
 /*  1020 */   115,  129,  116,  116,  116,   98,   82,  394,  394,   82,
 /*  1030 */   394,  394,   82,  394,   82,  394,  394,  135,  394,   99,
 /*  1040 */   154,  153,  152,  133,   95,  115,  129,  116,  116,  116,
 /*  1050 */   135,   82,  394,   82,   82,   82,  394,  394,  135,  394,
 /*  1060 */   394,  147,  153,  152,  133,   95,  115,  129,  116,  116,
 /*  1070 */   116,  135,   82,  394,   82,   82,   82,  394,  394,  135,
 /*  1080 */   394,  394,  148,  153,  152,  133,   95,  115,  129,  116,
 /*  1090 */   116,  116,  135,   82,  394,   82,   82,   82,  394,  394,
 /*  1100 */   135,  394,  394,  149,  153,  152,  133,   95,  115,  129,
 /*  1110 */   116,  116,  116,  135,   82,  394,  394,   82,  394,  394,
 /*  1120 */    82,  394,   82,  394,  394,  135,  394,  394,  157,  153,
 /*  1130 */   152,  133,   95,  115,  129,  116,  116,  116,  135,   82,
 /*  1140 */   394,   82,   82,   82,  394,  394,  135,  394,  394,  394,
 /*  1150 */   156,  152,  133,   95,  115,  129,  116,  116,  116,  135,
 /*  1160 */    82,  394,   82,   82,   82,  394,  394,  135,  394,  394,
 /*  1170 */   394,  394,  155,  133,   95,  115,  129,  116,  116,  116,
 /*  1180 */   135,   82,  394,  394,   82,  394,  394,   28,   22,   21,
 /*  1190 */    20,   19,   18,   17,   16,   15,   14,   13,   12,   82,
 /*  1200 */   394,   82,  394,  394,  135,  394,  394,  394,  394,  394,
 /*  1210 */   137,   95,  115,  129,  116,  116,  116,  135,   82,  394,
 /*  1220 */   394,   82,   82,  394,   82,  394,  394,  135,  394,  394,
 /*  1230 */   394,  394,  317,  318,   96,  115,  129,  116,  116,  116,
 /*  1240 */   135,   82,  394,   82,   82,   82,  394,  394,  135,  394,
 /*  1250 */   394,  394,  394,  394,  394,   97,  115,  129,  116,  116,
 /*  1260 */   116,  135,   82,  394,   82,   82,   82,  394,  394,  135,
 /*  1270 */   394,  394,  394,  394,  394,  394,  394,  101,  129,  116,
 /*  1280 */   116,  116,  135,   82,  394,   82,   82,   82,  394,  394,
 /*  1290 */   135,  394,  394,  394,  394,  394,  394,  394,  102,  129,
 /*  1300 */   116,  116,  116,  135,   82,  394,   82,   82,   82,  394,
 /*  1310 */   394,  135,  394,  394,  394,  394,  394,  394,  394,  103,
 /*  1320 */   129,  116,  116,  116,  135,   82,  394,   82,   82,   82,
 /*  1330 */   394,  394,  135,  394,  394,  394,  394,  394,  394,  394,
 /*  1340 */   104,  129,  116,  116,  116,  135,   82,  394,   82,   82,
 /*  1350 */    82,  394,  394,  135,  394,  394,  394,  394,  394,  394,
 /*  1360 */   394,  105,  129,  116,  116,  116,  135,   82,  394,   82,
 /*  1370 */    82,   82,  394,  394,  135,  394,  394,  394,  394,  394,
 /*  1380 */   394,  394,  106,  129,  116,  116,  116,  135,   82,  394,
 /*  1390 */    82,   82,   82,  394,  394,  135,  394,  394,  394,  394,
 /*  1400 */   394,  394,  394,  107,  129,  116,  116,  116,  135,   82,
 /*  1410 */   394,   82,   82,   82,  394,  394,  135,  394,  394,  394,
 /*  1420 */   394,  394,  394,  394,  108,  129,  116,  116,  116,  135,
 /*  1430 */    82,  394,   82,   82,   82,  394,  394,  135,  394,  394,
 /*  1440 */   394,  394,  394,  394,  394,  109,  129,  116,  116,  116,
 /*  1450 */   135,   82,  394,   82,   82,   82,  394,  394,  135,  394,
 /*  1460 */   394,  394,  394,  394,  394,  394,  110,  129,  116,  116,
 /*  1470 */   116,  135,   82,  394,   82,   82,   82,  394,  394,  135,
 /*  1480 */   394,  394,  394,  394,  394,  394,  394,  111,  129,  116,
 /*  1490 */   116,  116,  135,   82,  394,   82,   82,   82,  394,  394,
 /*  1500 */   135,  394,  394,  394,  394,  394,  394,  394,  112,  129,
 /*  1510 */   116,  116,  116,  135,   82,  394,   82,   82,   82,  394,
 /*  1520 */   394,  135,  394,  394,  394,  394,  394,  394,  394,  113,
 /*  1530 */   129,  116,  116,  116,  135,   82,  394,   82,   82,   82,
 /*  1540 */   394,  394,  135,  394,  394,  394,  394,  394,  394,  394,
 /*  1550 */   114,  129,  116,  116,  116,  135,   82,  394,   82,   82,
 /*  1560 */    82,  394,  394,  135,  394,  394,  394,  394,  394,  394,
 /*  1570 */   394,  117,  129,  116,  116,  116,  135,   82,  394,   82,
 /*  1580 */    82,   82,  394,  394,  135,  394,  394,  394,  394,  394,
 /*  1590 */   394,  394,  119,  129,  116,  116,  116,  135,   82,  394,
 /*  1600 */    82,   82,   82,  394,  394,  135,  394,  394,  394,  394,
 /*  1610 */   394,  394,  394,  121,  129,  116,  116,  116,  135,   82,
 /*  1620 */   394,   82,   82,   82,  394,  394,  135,  394,  394,  394,
 /*  1630 */   394,  394,  394,  394,  394,  130,  116,  116,  116,  135,
 /*  1640 */    82,  394,   82,   82,   82,  394,  394,  135,  394,  394,
 /*  1650 */   394,  394,  394,  394,  394,  394,  132,  116,  116,  116,
 /*  1660 */   135,   82,  394,   82,   82,   82,  394,  394,  135,  394,
 /*  1670 */   394,  394,  394,  394,  394,  394,  394,  136,  116,  116,
 /*  1680 */   116,  135,   82,  394,  394,   82,   82,  400,   82,  394,
 /*  1690 */   394,  135,  394,  394,  394,  394,  394,  394,  394,  394,
 /*  1700 */   394,  394,  461,  461,  135,   82,  394,   82,   82,   82,
 /*  1710 */   394,  394,  135,  394,  394,  394,  394,  394,  394,  394,
 /*  1720 */   394,  394,  118,  118,  118,  135,   82,  394,   82,   82,
 /*  1730 */    82,  394,  394,  135,  394,   82,  394,   82,  394,  394,
 /*  1740 */   135,  394,  394,  120,  120,  120,  135,   82,  394,  394,
 /*  1750 */    82,  458,  458,  135,   82,  394,   82,   82,   82,  394,
 /*  1760 */   394,  135,  394,  394,  394,   82,  394,   82,  394,  394,
 /*  1770 */   135,  394,  453,  453,  135,   82,  394,  394,   82,  394,
 /*  1780 */   394,  452,  452,  135,   82,  394,  394,   82,  394,  394,
 /*  1790 */    82,  394,   82,  394,  394,  135,  394,   82,  394,   82,
 /*  1800 */   394,  394,  135,  394,  394,  394,  464,  464,  135,   82,
 /*  1810 */   394,  394,   82,  463,  463,  135,   82,  394,   82,   82,
 /*  1820 */    82,  394,  394,  135,  394,   82,  394,   82,  394,  394,
 /*  1830 */   135,  394,  394,  394,  462,  462,  135,   82,  394,  394,
 /*  1840 */    82,  461,  461,  135,   82,  394,   82,   82,   82,  394,
 /*  1850 */   394,  135,  394,   82,  394,   82,  394,  394,  135,  394,
 /*  1860 */   394,  394,  460,  460,  135,   82,  394,  394,   82,  459,
 /*  1870 */   459,  135,   82,  394,  394,   82,  394,  394,   82,  394,
 /*  1880 */    82,  394,  394,  135,  394,   82,  394,   82,  394,  394,
 /*  1890 */   135,  394,  394,  394,  457,  457,  135,   82,  394,  394,
 /*  1900 */    82,  456,  456,  135,   82,  394,   82,   82,   82,  394,
 /*  1910 */   394,  135,  394,   82,  394,   82,  394,  394,  135,  394,
 /*  1920 */   394,  394,  455,  455,  135,   82,  394,  394,   82,  454,
 /*  1930 */   454,  135,   82,  394,   82,   82,   82,  394,  394,  135,
 /*  1940 */   394,  394,  394,  394,  394,  394,  394,  394,  394,  394,
 /*  1950 */   451,  451,  135,   82,  394,  394,   82,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    88,    1,    2,    3,    4,  111,  112,  113,   88,    9,
 /*    10 */    10,   88,   12,   13,   14,   15,   82,   17,   81,   82,
 /*    20 */    83,   16,   88,   18,   87,   88,   89,   90,   91,   92,
 /*    30 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*    40 */   103,  104,  105,  106,  116,  117,  109,    9,   10,   88,
 /*    50 */    12,   13,   14,   15,   11,   17,  107,  108,   58,   59,
 /*    60 */    87,   18,   89,   63,   64,   65,   66,   67,   68,   69,
 /*    70 */    70,   71,   72,   73,   74,   75,   76,   83,   60,   61,
 /*    80 */    62,   87,  109,   89,   90,   91,   92,   93,   94,   95,
 /*    90 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   100 */   106,  112,  113,  109,   14,  111,  112,  113,    9,   10,
 /*   110 */    73,   12,   13,   14,   15,   88,   17,   82,   83,   55,
 /*   120 */    56,   57,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   130 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   140 */   105,  106,    0,   10,  109,   12,   88,   14,   15,    5,
 /*   150 */     6,   88,    8,   58,   59,   88,   12,   58,   59,   16,
 /*   160 */    18,   18,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   170 */    71,   72,   73,   74,   75,   76,    5,    6,    7,    8,
 /*   180 */     9,   10,   11,   12,   13,   14,   15,   18,   17,   36,
 /*   190 */    37,   58,   59,   60,   64,   65,   63,   64,   65,   66,
 /*   200 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   210 */    84,   10,   79,   87,    0,   89,   90,   91,   92,   93,
 /*   220 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   230 */   104,  105,  106,   11,   10,  109,   12,   87,   14,   15,
 /*   240 */    18,  115,   85,   15,   86,   87,   77,   89,   90,   91,
 /*   250 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   260 */   102,  103,  104,  105,  106,   18,   32,  109,    0,   13,
 /*   270 */     0,   73,   58,  116,  117,   43,  118,   76,   71,   78,
 /*   280 */    60,    7,   58,   59,    0,   33,   18,   63,   64,   65,
 /*   290 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   300 */    76,   14,   18,   79,   87,   31,   89,   90,   91,   92,
 /*   310 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   320 */   103,  104,  105,  106,   77,   32,  109,   35,   34,   32,
 /*   330 */   119,  119,  115,   87,  119,   89,   90,   91,   92,   93,
 /*   340 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   350 */   104,  105,  106,  119,  119,  109,  119,  119,  119,  119,
 /*   360 */   119,  119,  119,  119,  118,  119,  119,  119,  119,  119,
 /*   370 */    87,  119,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   380 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   390 */   119,  119,  109,  119,  119,  119,   87,  114,   89,   90,
 /*   400 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   410 */   101,  102,  103,  104,  105,  106,   83,  119,  109,  110,
 /*   420 */    87,  119,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   430 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   440 */   119,  119,  109,  119,  119,  119,  119,  119,   83,  119,
 /*   450 */   119,  119,   87,  119,   89,   90,   91,   92,   93,   94,
 /*   460 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   470 */   105,  106,   83,  119,  109,  119,   87,  119,   89,   90,
 /*   480 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   490 */   101,  102,  103,  104,  105,  106,  119,   10,  109,   12,
 /*   500 */   119,   14,   15,   87,  119,   89,   90,   91,   92,   93,
 /*   510 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   520 */   104,  105,  106,  119,  119,  109,   38,   39,   40,   41,
 /*   530 */    42,   43,   44,   45,   46,   47,   48,   49,   50,   51,
 /*   540 */    52,   53,   54,  119,  119,   58,   59,  119,  119,  119,
 /*   550 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   560 */    73,   74,   75,   76,  119,   10,   79,   12,  119,   14,
 /*   570 */    15,   87,  119,   89,   90,   91,   92,   93,   94,   95,
 /*   580 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   590 */   106,    0,  119,  109,  119,  119,    5,    6,    7,    8,
 /*   600 */     9,   10,  119,   12,   13,   14,   15,   10,   17,  119,
 /*   610 */   119,   14,   15,   58,   59,  119,  119,  119,   63,   64,
 /*   620 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   630 */    75,   76,   10,  119,   12,  119,   14,   15,   87,  119,
 /*   640 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   650 */    99,  100,  101,  102,  103,  104,  105,  106,  119,  119,
 /*   660 */   109,  119,  119,  119,  119,  119,  119,  119,   71,   72,
 /*   670 */    73,   74,   75,   76,  119,  119,  119,  119,  119,  119,
 /*   680 */    58,   59,  119,  119,  119,   63,   64,   65,   66,   67,
 /*   690 */    68,   69,   70,   71,   72,   73,   74,   75,   76,  119,
 /*   700 */   119,   87,  119,   89,   90,   91,   92,   93,   94,   95,
 /*   710 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   720 */   106,  119,   87,  109,   89,   90,   91,   92,   93,   94,
 /*   730 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   740 */   105,  106,  119,   87,  109,   89,   90,   91,   92,   93,
 /*   750 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   760 */   104,  105,  106,  119,  119,  109,  119,  119,   87,  119,
 /*   770 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   780 */    99,  100,  101,  102,  103,  104,  105,  106,  119,   87,
 /*   790 */   109,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   800 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  119,
 /*   810 */    87,  109,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   820 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*   830 */   119,   87,  109,   89,   90,   91,   92,   93,   94,   95,
 /*   840 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*   850 */   106,  119,  119,  109,  119,  119,   87,  119,   89,   90,
 /*   860 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*   870 */   101,  102,  103,  104,  105,  106,  119,   87,  109,   89,
 /*   880 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   890 */   100,  101,  102,  103,  104,  105,  106,  119,   87,  109,
 /*   900 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   910 */    99,  100,  101,  102,  103,  104,  105,  106,  119,   87,
 /*   920 */   109,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   930 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  119,
 /*   940 */   119,  109,  119,  119,   87,  119,   89,   90,   91,   92,
 /*   950 */    93,   94,   95,   96,   97,   98,   99,  100,  101,  102,
 /*   960 */   103,  104,  105,  106,  119,   87,  109,   89,   90,   91,
 /*   970 */    92,   93,   94,   95,   96,   97,   98,   99,  100,  101,
 /*   980 */   102,  103,  104,  105,  106,  119,   87,  109,   89,   90,
 /*   990 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  100,
 /*  1000 */   101,  102,  103,  104,  105,  106,  119,   87,  109,   89,
 /*  1010 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*  1020 */   100,  101,  102,  103,  104,  105,  106,  119,  119,  109,
 /*  1030 */   119,  119,   87,  119,   89,  119,  119,   92,  119,   94,
 /*  1040 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1050 */   105,  106,  119,   87,  109,   89,  119,  119,   92,  119,
 /*  1060 */   119,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*  1070 */   104,  105,  106,  119,   87,  109,   89,  119,  119,   92,
 /*  1080 */   119,  119,   95,   96,   97,   98,   99,  100,  101,  102,
 /*  1090 */   103,  104,  105,  106,  119,   87,  109,   89,  119,  119,
 /*  1100 */    92,  119,  119,   95,   96,   97,   98,   99,  100,  101,
 /*  1110 */   102,  103,  104,  105,  106,  119,  119,  109,  119,  119,
 /*  1120 */    87,  119,   89,  119,  119,   92,  119,  119,   95,   96,
 /*  1130 */    97,   98,   99,  100,  101,  102,  103,  104,  105,  106,
 /*  1140 */   119,   87,  109,   89,  119,  119,   92,  119,  119,  119,
 /*  1150 */    96,   97,   98,   99,  100,  101,  102,  103,  104,  105,
 /*  1160 */   106,  119,   87,  109,   89,  119,  119,   92,  119,  119,
 /*  1170 */   119,  119,   97,   98,   99,  100,  101,  102,  103,  104,
 /*  1180 */   105,  106,  119,  119,  109,  119,  119,   19,   20,   21,
 /*  1190 */    22,   23,   24,   25,   26,   27,   28,   29,   30,   87,
 /*  1200 */   119,   89,  119,  119,   92,  119,  119,  119,  119,  119,
 /*  1210 */    98,   99,  100,  101,  102,  103,  104,  105,  106,  119,
 /*  1220 */   119,  109,   87,  119,   89,  119,  119,   92,  119,  119,
 /*  1230 */   119,  119,   64,   65,   99,  100,  101,  102,  103,  104,
 /*  1240 */   105,  106,  119,   87,  109,   89,  119,  119,   92,  119,
 /*  1250 */   119,  119,  119,  119,  119,   99,  100,  101,  102,  103,
 /*  1260 */   104,  105,  106,  119,   87,  109,   89,  119,  119,   92,
 /*  1270 */   119,  119,  119,  119,  119,  119,  119,  100,  101,  102,
 /*  1280 */   103,  104,  105,  106,  119,   87,  109,   89,  119,  119,
 /*  1290 */    92,  119,  119,  119,  119,  119,  119,  119,  100,  101,
 /*  1300 */   102,  103,  104,  105,  106,  119,   87,  109,   89,  119,
 /*  1310 */   119,   92,  119,  119,  119,  119,  119,  119,  119,  100,
 /*  1320 */   101,  102,  103,  104,  105,  106,  119,   87,  109,   89,
 /*  1330 */   119,  119,   92,  119,  119,  119,  119,  119,  119,  119,
 /*  1340 */   100,  101,  102,  103,  104,  105,  106,  119,   87,  109,
 /*  1350 */    89,  119,  119,   92,  119,  119,  119,  119,  119,  119,
 /*  1360 */   119,  100,  101,  102,  103,  104,  105,  106,  119,   87,
 /*  1370 */   109,   89,  119,  119,   92,  119,  119,  119,  119,  119,
 /*  1380 */   119,  119,  100,  101,  102,  103,  104,  105,  106,  119,
 /*  1390 */    87,  109,   89,  119,  119,   92,  119,  119,  119,  119,
 /*  1400 */   119,  119,  119,  100,  101,  102,  103,  104,  105,  106,
 /*  1410 */   119,   87,  109,   89,  119,  119,   92,  119,  119,  119,
 /*  1420 */   119,  119,  119,  119,  100,  101,  102,  103,  104,  105,
 /*  1430 */   106,  119,   87,  109,   89,  119,  119,   92,  119,  119,
 /*  1440 */   119,  119,  119,  119,  119,  100,  101,  102,  103,  104,
 /*  1450 */   105,  106,  119,   87,  109,   89,  119,  119,   92,  119,
 /*  1460 */   119,  119,  119,  119,  119,  119,  100,  101,  102,  103,
 /*  1470 */   104,  105,  106,  119,   87,  109,   89,  119,  119,   92,
 /*  1480 */   119,  119,  119,  119,  119,  119,  119,  100,  101,  102,
 /*  1490 */   103,  104,  105,  106,  119,   87,  109,   89,  119,  119,
 /*  1500 */    92,  119,  119,  119,  119,  119,  119,  119,  100,  101,
 /*  1510 */   102,  103,  104,  105,  106,  119,   87,  109,   89,  119,
 /*  1520 */   119,   92,  119,  119,  119,  119,  119,  119,  119,  100,
 /*  1530 */   101,  102,  103,  104,  105,  106,  119,   87,  109,   89,
 /*  1540 */   119,  119,   92,  119,  119,  119,  119,  119,  119,  119,
 /*  1550 */   100,  101,  102,  103,  104,  105,  106,  119,   87,  109,
 /*  1560 */    89,  119,  119,   92,  119,  119,  119,  119,  119,  119,
 /*  1570 */   119,  100,  101,  102,  103,  104,  105,  106,  119,   87,
 /*  1580 */   109,   89,  119,  119,   92,  119,  119,  119,  119,  119,
 /*  1590 */   119,  119,  100,  101,  102,  103,  104,  105,  106,  119,
 /*  1600 */    87,  109,   89,  119,  119,   92,  119,  119,  119,  119,
 /*  1610 */   119,  119,  119,  100,  101,  102,  103,  104,  105,  106,
 /*  1620 */   119,   87,  109,   89,  119,  119,   92,  119,  119,  119,
 /*  1630 */   119,  119,  119,  119,  119,  101,  102,  103,  104,  105,
 /*  1640 */   106,  119,   87,  109,   89,  119,  119,   92,  119,  119,
 /*  1650 */   119,  119,  119,  119,  119,  119,  101,  102,  103,  104,
 /*  1660 */   105,  106,  119,   87,  109,   89,  119,  119,   92,  119,
 /*  1670 */   119,  119,  119,  119,  119,  119,  119,  101,  102,  103,
 /*  1680 */   104,  105,  106,  119,  119,  109,   87,   88,   89,  119,
 /*  1690 */   119,   92,  119,  119,  119,  119,  119,  119,  119,  119,
 /*  1700 */   119,  119,  103,  104,  105,  106,  119,   87,  109,   89,
 /*  1710 */   119,  119,   92,  119,  119,  119,  119,  119,  119,  119,
 /*  1720 */   119,  119,  102,  103,  104,  105,  106,  119,   87,  109,
 /*  1730 */    89,  119,  119,   92,  119,   87,  119,   89,  119,  119,
 /*  1740 */    92,  119,  119,  102,  103,  104,  105,  106,  119,  119,
 /*  1750 */   109,  103,  104,  105,  106,  119,   87,  109,   89,  119,
 /*  1760 */   119,   92,  119,  119,  119,   87,  119,   89,  119,  119,
 /*  1770 */    92,  119,  103,  104,  105,  106,  119,  119,  109,  119,
 /*  1780 */   119,  103,  104,  105,  106,  119,  119,  109,  119,  119,
 /*  1790 */    87,  119,   89,  119,  119,   92,  119,   87,  119,   89,
 /*  1800 */   119,  119,   92,  119,  119,  119,  103,  104,  105,  106,
 /*  1810 */   119,  119,  109,  103,  104,  105,  106,  119,   87,  109,
 /*  1820 */    89,  119,  119,   92,  119,   87,  119,   89,  119,  119,
 /*  1830 */    92,  119,  119,  119,  103,  104,  105,  106,  119,  119,
 /*  1840 */   109,  103,  104,  105,  106,  119,   87,  109,   89,  119,
 /*  1850 */   119,   92,  119,   87,  119,   89,  119,  119,   92,  119,
 /*  1860 */   119,  119,  103,  104,  105,  106,  119,  119,  109,  103,
 /*  1870 */   104,  105,  106,  119,  119,  109,  119,  119,   87,  119,
 /*  1880 */    89,  119,  119,   92,  119,   87,  119,   89,  119,  119,
 /*  1890 */    92,  119,  119,  119,  103,  104,  105,  106,  119,  119,
 /*  1900 */   109,  103,  104,  105,  106,  119,   87,  109,   89,  119,
 /*  1910 */   119,   92,  119,   87,  119,   89,  119,  119,   92,  119,
 /*  1920 */   119,  119,  103,  104,  105,  106,  119,  119,  109,  103,
 /*  1930 */   104,  105,  106,  119,   87,  109,   89,  119,  119,   92,
 /*  1940 */   119,  119,  119,  119,  119,  119,  119,  119,  119,  119,
 /*  1950 */   103,  104,  105,  106,  119,  119,  109,   80,   80,   80,
 /*  1960 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  1970 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  1980 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  1990 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  2000 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  2010 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  2020 */    80,   80,   80,   80,   80,   80,   80,   80,   80,   80,
 /*  2030 */    80,   80,   80,   80,   80,   80,   80,
};
#define YY_SHIFT_COUNT    (159)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1168)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */     0,  555,   99,  133,  224,  133,  224,  622,  622,  622,
 /*    10 */   622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
 /*    20 */   622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
 /*    30 */   622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
 /*    40 */   622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
 /*    50 */   622,  622,  622,  622,  622,  622,  622,  622,  622,  622,
 /*    60 */    99,  622,  622,  487,  622,  622,  622,  622,  622,  622,
 /*    70 */   622,  622,  622,  622,  622,  622,  622,  622,  597,   90,
 /*    80 */    37,   38,  201,   90,   37,  171,  591,   38,   38,   38,
 /*    90 */    38,   38,   38,   38,  228,  488,  488,  488, 1168,  144,
 /*   100 */   144,   64,   64,   64,   64,   64,   64,   64,   64,   64,
 /*   110 */    64,   64,   64,   64,   64,   64,   18,   64,   18,   64,
 /*   120 */    18,   64,  142,  214,  268,  284,   43,    5,  169,   95,
 /*   130 */    95,  222,   95,  153,  247,  130,   95,  153,  274,  143,
 /*   140 */   234,  256,  270,  198,  232,  207,  220,  252,  252,  252,
 /*   150 */   287,  293,  292,  294,  252,  292,  294,  252,  297,  256,
};
#define YY_REDUCE_COUNT (94)
#define YY_REDUCE_MIN   (-106)
#define YY_REDUCE_MAX   (1847)
static const short yy_reduce_ofst[] = {
 /*     0 */   -63,   -6,   35,  126,  158,  217,  246,  283,  309,  333,
 /*    10 */   365,  389,  416,  484,  551,  614,  635,  656,  681,  702,
 /*    20 */   723,  744,  769,  790,  811,  832,  857,  878,  899,  920,
 /*    30 */   945,  966,  987, 1008, 1033, 1054, 1075, 1112, 1135, 1156,
 /*    40 */  1177, 1198, 1219, 1240, 1261, 1282, 1303, 1324, 1345, 1366,
 /*    50 */  1387, 1408, 1429, 1450, 1471, 1492, 1513, 1534, 1555, 1576,
 /*    60 */  1599, 1620, 1641, 1648, 1669, 1678, 1703, 1710, 1731, 1738,
 /*    70 */  1759, 1766, 1648, 1791, 1798, 1819, 1826, 1847,  -27,  157,
 /*    80 */  -106,  -66,  -51,  -72,  -11,  -88,  -88,  -80,  -77,  -39,
 /*    90 */    27,   58,   63,   67,  150,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   392,  473,  392,  481,  491,  483,  392,  478,  469,  392,
 /*    10 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    20 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    30 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    40 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    50 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    60 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  392,
 /*    70 */   392,  392,  392,  392,  392,  392,  392,  392,  392,  537,
 /*    80 */   473,  392,  522,  392,  392,  392,  392,  392,  392,  392,
 /*    90 */   392,  392,  392,  392,  392,  514,  428,  427,  520,  419,
 /*   100 */   509,  445,  444,  443,  442,  441,  440,  439,  438,  437,
 /*   110 */   436,  435,  434,  433,  432,  515,  517,  431,  450,  430,
 /*   120 */   449,  429,  392,  392,  392,  392,  392,  392,  392,  516,
 /*   130 */   448,  392,  447,  513,  392,  520,  446,  426,  508,  392,
 /*   140 */   531,  527,  392,  392,  392,  392,  539,  423,  422,  421,
 /*   150 */   392,  392,  512,  511,  510,  425,  424,  420,  392,  392,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
  grn_expr_parserCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
#include <assert.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "START_OUTPUT_COLUMNS",
  /*    2 */ "START_ADJUSTER",
  /*    3 */ "START_SORT_KEYS",
  /*    4 */ "START_OPTIONS",
  /*    5 */ "LOGICAL_AND",
  /*    6 */ "LOGICAL_AND_NOT",
  /*    7 */ "LOGICAL_OR",
  /*    8 */ "NEGATIVE",
  /*    9 */ "QSTRING",
  /*   10 */ "PARENL",
  /*   11 */ "PARENR",
  /*   12 */ "ADJUST",
  /*   13 */ "RELATIVE_OP",
  /*   14 */ "IDENTIFIER",
  /*   15 */ "BRACEL",
  /*   16 */ "BRACER",
  /*   17 */ "EVAL",
  /*   18 */ "COMMA",
  /*   19 */ "ASSIGN",
  /*   20 */ "STAR_ASSIGN",
  /*   21 */ "SLASH_ASSIGN",
  /*   22 */ "MOD_ASSIGN",
  /*   23 */ "PLUS_ASSIGN",
  /*   24 */ "MINUS_ASSIGN",
  /*   25 */ "SHIFTL_ASSIGN",
  /*   26 */ "SHIFTR_ASSIGN",
  /*   27 */ "SHIFTRR_ASSIGN",
  /*   28 */ "AND_ASSIGN",
  /*   29 */ "XOR_ASSIGN",
  /*   30 */ "OR_ASSIGN",
  /*   31 */ "QUESTION",
  /*   32 */ "COLON",
  /*   33 */ "BITWISE_OR",
  /*   34 */ "BITWISE_XOR",
  /*   35 */ "BITWISE_AND",
  /*   36 */ "EQUAL",
  /*   37 */ "NOT_EQUAL",
  /*   38 */ "LESS",
  /*   39 */ "GREATER",
  /*   40 */ "LESS_EQUAL",
  /*   41 */ "GREATER_EQUAL",
  /*   42 */ "IN",
  /*   43 */ "MATCH",
  /*   44 */ "NEAR",
  /*   45 */ "NEAR_NO_OFFSET",
  /*   46 */ "NEAR_PHRASE",
  /*   47 */ "ORDERED_NEAR_PHRASE",
  /*   48 */ "SIMILAR",
  /*   49 */ "TERM_EXTRACT",
  /*   50 */ "QUORUM",
  /*   51 */ "LCP",
  /*   52 */ "PREFIX",
  /*   53 */ "SUFFIX",
  /*   54 */ "REGEXP",
  /*   55 */ "SHIFTL",
  /*   56 */ "SHIFTR",
  /*   57 */ "SHIFTRR",
  /*   58 */ "PLUS",
  /*   59 */ "MINUS",
  /*   60 */ "STAR",
  /*   61 */ "SLASH",
  /*   62 */ "MOD",
  /*   63 */ "DELETE",
  /*   64 */ "INCR",
  /*   65 */ "DECR",
  /*   66 */ "NOT",
  /*   67 */ "BITWISE_NOT",
  /*   68 */ "EXACT",
  /*   69 */ "PARTIAL",
  /*   70 */ "UNSPLIT",
  /*   71 */ "DECIMAL",
  /*   72 */ "HEX_INTEGER",
  /*   73 */ "STRING",
  /*   74 */ "BOOLEAN",
  /*   75 */ "NULL",
  /*   76 */ "BRACKETL",
  /*   77 */ "BRACKETR",
  /*   78 */ "DOT",
  /*   79 */ "NONEXISTENT_COLUMN",
  /*   80 */ "suppress_unused_variable_warning",
  /*   81 */ "input",
  /*   82 */ "query",
  /*   83 */ "expression",
  /*   84 */ "output_columns",
  /*   85 */ "adjuster",
  /*   86 */ "sort_keys",
  /*   87 */ "object_literal",
  /*   88 */ "query_element",
  /*   89 */ "primary_expression",
  /*   90 */ "assignment_expression",
  /*   91 */ "conditional_expression",
  /*   92 */ "lefthand_side_expression",
  /*   93 */ "logical_or_expression",
  /*   94 */ "logical_and_expression",
  /*   95 */ "bitwise_or_expression",
  /*   96 */ "bitwise_xor_expression",
  /*   97 */ "bitwise_and_expression",
  /*   98 */ "equality_expression",
  /*   99 */ "relational_expression",
  /*  100 */ "shift_expression",
  /*  101 */ "additive_expression",
  /*  102 */ "multiplicative_expression",
  /*  103 */ "unary_expression",
  /*  104 */ "postfix_expression",
  /*  105 */ "call_expression",
  /*  106 */ "member_expression",
  /*  107 */ "arguments",
  /*  108 */ "member_expression_part",
  /*  109 */ "array_literal",
  /*  110 */ "element_list",
  /*  111 */ "property_list",
  /*  112 */ "property",
  /*  113 */ "property_name",
  /*  114 */ "argument_list",
  /*  115 */ "output_column",
  /*  116 */ "adjust_expression",
  /*  117 */ "adjust_match_expression",
  /*  118 */ "sort_key",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query ::= query NEGATIVE query_element",
 /*   5 */ "query_element ::= ADJUST query_element",
 /*   6 */ "query_element ::= RELATIVE_OP query_element",
 /*   7 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   8 */ "query_element ::= BRACEL expression BRACER",
 /*   9 */ "query_element ::= EVAL primary_expression",
 /*  10 */ "expression ::= expression COMMA assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  23 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  24 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  25 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  26 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  27 */ "logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression",
 /*  28 */ "logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression",
 /*  29 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  30 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  31 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  32 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  33 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  34 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  35 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  36 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  37 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  38 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  39 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  40 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  41 */ "relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression",
 /*  42 */ "relational_expression ::= relational_expression NEAR_PHRASE shift_expression",
 /*  43 */ "relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression",
 /*  44 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  45 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  46 */ "relational_expression ::= relational_expression QUORUM shift_expression",
 /*  47 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  48 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  49 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  50 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  51 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  52 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  53 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  54 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  55 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  56 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  57 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  58 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  59 */ "unary_expression ::= DELETE unary_expression",
 /*  60 */ "unary_expression ::= INCR unary_expression",
 /*  61 */ "unary_expression ::= DECR unary_expression",
 /*  62 */ "unary_expression ::= PLUS unary_expression",
 /*  63 */ "unary_expression ::= MINUS unary_expression",
 /*  64 */ "unary_expression ::= NOT unary_expression",
 /*  65 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  66 */ "unary_expression ::= ADJUST unary_expression",
 /*  67 */ "unary_expression ::= EXACT unary_expression",
 /*  68 */ "unary_expression ::= PARTIAL unary_expression",
 /*  69 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  70 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  71 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  72 */ "call_expression ::= member_expression arguments",
 /*  73 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /*  74 */ "element_list ::=",
 /*  75 */ "element_list ::= assignment_expression",
 /*  76 */ "element_list ::= element_list COMMA assignment_expression",
 /*  77 */ "object_literal ::= BRACEL property_list BRACER",
 /*  78 */ "property_list ::=",
 /*  79 */ "property_list ::= property",
 /*  80 */ "property_list ::= property_list COMMA property",
 /*  81 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  82 */ "arguments ::= PARENL argument_list PARENR",
 /*  83 */ "argument_list ::=",
 /*  84 */ "argument_list ::= assignment_expression",
 /*  85 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  86 */ "output_columns ::=",
 /*  87 */ "output_columns ::= output_column",
 /*  88 */ "output_columns ::= output_columns COMMA",
 /*  89 */ "output_columns ::= output_columns COMMA output_column",
 /*  90 */ "output_column ::= STAR",
 /*  91 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  92 */ "output_column ::= assignment_expression",
 /*  93 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  94 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  95 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  96 */ "sort_keys ::=",
 /*  97 */ "sort_keys ::= sort_key",
 /*  98 */ "sort_keys ::= sort_keys COMMA sort_key",
 /*  99 */ "sort_key ::= NONEXISTENT_COLUMN",
 /* 100 */ "sort_key ::= MINUS NONEXISTENT_COLUMN",
 /* 101 */ "sort_key ::= assignment_expression",
 /* 102 */ "input ::= query",
 /* 103 */ "input ::= expression",
 /* 104 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /* 105 */ "input ::= START_ADJUSTER adjuster",
 /* 106 */ "input ::= START_SORT_KEYS sort_keys",
 /* 107 */ "input ::= START_OPTIONS object_literal",
 /* 108 */ "query ::= query_element",
 /* 109 */ "query_element ::= QSTRING",
 /* 110 */ "query_element ::= PARENL query PARENR",
 /* 111 */ "expression ::= assignment_expression",
 /* 112 */ "assignment_expression ::= conditional_expression",
 /* 113 */ "conditional_expression ::= logical_or_expression",
 /* 114 */ "logical_or_expression ::= logical_and_expression",
 /* 115 */ "logical_and_expression ::= bitwise_or_expression",
 /* 116 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /* 117 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /* 118 */ "bitwise_and_expression ::= equality_expression",
 /* 119 */ "equality_expression ::= relational_expression",
 /* 120 */ "relational_expression ::= shift_expression",
 /* 121 */ "shift_expression ::= additive_expression",
 /* 122 */ "additive_expression ::= multiplicative_expression",
 /* 123 */ "multiplicative_expression ::= unary_expression",
 /* 124 */ "unary_expression ::= postfix_expression",
 /* 125 */ "postfix_expression ::= lefthand_side_expression",
 /* 126 */ "lefthand_side_expression ::= call_expression",
 /* 127 */ "lefthand_side_expression ::= member_expression",
 /* 128 */ "member_expression ::= primary_expression",
 /* 129 */ "member_expression ::= member_expression member_expression_part",
 /* 130 */ "primary_expression ::= object_literal",
 /* 131 */ "primary_expression ::= PARENL expression PARENR",
 /* 132 */ "primary_expression ::= IDENTIFIER",
 /* 133 */ "primary_expression ::= array_literal",
 /* 134 */ "primary_expression ::= DECIMAL",
 /* 135 */ "primary_expression ::= HEX_INTEGER",
 /* 136 */ "primary_expression ::= STRING",
 /* 137 */ "primary_expression ::= BOOLEAN",
 /* 138 */ "primary_expression ::= NULL",
 /* 139 */ "property ::= property_name COLON assignment_expression",
 /* 140 */ "property_name ::= STRING",
 /* 141 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 142 */ "adjuster ::=",
 /* 143 */ "adjuster ::= adjust_expression",
 /* 144 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void grn_expr_parserInit(void *yypRawParser grn_expr_parserCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  grn_expr_parserCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) grn_expr_parserCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    grn_expr_parserCTX_STORE
    grn_expr_parserInit(yypParser grn_expr_parserCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 80: /* suppress_unused_variable_warning */
{
#line 146 "../../groonga/lib/grn_ecmascript.lemon"

  (void)efsi;

#line 1375 "../../groonga/lib/grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void grn_expr_parserFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef grn_expr_parser_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  grn_expr_parserFinalize(p);
  (*freeProc)(p);
}
#endif /* grn_expr_parser_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int grn_expr_parserCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<(int)(sizeof(yy_action)/sizeof(yy_action[0])) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH
   grn_expr_parserCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument var */
   grn_expr_parserCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
    82,  /* (0) query ::= query query_element */
    82,  /* (1) query ::= query LOGICAL_AND query_element */
    82,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
    82,  /* (3) query ::= query LOGICAL_OR query_element */
    82,  /* (4) query ::= query NEGATIVE query_element */
    88,  /* (5) query_element ::= ADJUST query_element */
    88,  /* (6) query_element ::= RELATIVE_OP query_element */
    88,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
    88,  /* (8) query_element ::= BRACEL expression BRACER */
    88,  /* (9) query_element ::= EVAL primary_expression */
    83,  /* (10) expression ::= expression COMMA assignment_expression */
    90,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
    90,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
    90,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
    90,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
    90,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
    90,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
    90,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
    90,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
    90,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
    90,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
    90,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
    90,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
    91,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
    93,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
    94,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
    94,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
    94,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
    94,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
    95,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
    96,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
    97,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
    98,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
    98,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
    99,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
    99,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
    99,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
    99,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
    99,  /* (38) relational_expression ::= relational_expression IN shift_expression */
    99,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
    99,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
    99,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
    99,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
    99,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
    99,  /* (44) relational_expression ::= relational_expression SIMILAR shift_expression */
    99,  /* (45) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
    99,  /* (46) relational_expression ::= relational_expression QUORUM shift_expression */
    99,  /* (47) relational_expression ::= relational_expression LCP shift_expression */
    99,  /* (48) relational_expression ::= relational_expression PREFIX shift_expression */
    99,  /* (49) relational_expression ::= relational_expression SUFFIX shift_expression */
    99,  /* (50) relational_expression ::= relational_expression REGEXP shift_expression */
   100,  /* (51) shift_expression ::= shift_expression SHIFTL additive_expression */
   100,  /* (52) shift_expression ::= shift_expression SHIFTR additive_expression */
   100,  /* (53) shift_expression ::= shift_expression SHIFTRR additive_expression */
   101,  /* (54) additive_expression ::= additive_expression PLUS multiplicative_expression */
   101,  /* (55) additive_expression ::= additive_expression MINUS multiplicative_expression */
   102,  /* (56) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   102,  /* (57) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   102,  /* (58) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   103,  /* (59) unary_expression ::= DELETE unary_expression */
   103,  /* (60) unary_expression ::= INCR unary_expression */
   103,  /* (61) unary_expression ::= DECR unary_expression */
   103,  /* (62) unary_expression ::= PLUS unary_expression */
   103,  /* (63) unary_expression ::= MINUS unary_expression */
   103,  /* (64) unary_expression ::= NOT unary_expression */
   103,  /* (65) unary_expression ::= BITWISE_NOT unary_expression */
   103,  /* (66) unary_expression ::= ADJUST unary_expression */
   103,  /* (67) unary_expression ::= EXACT unary_expression */
   103,  /* (68) unary_expression ::= PARTIAL unary_expression */
   103,  /* (69) unary_expression ::= UNSPLIT unary_expression */
   104,  /* (70) postfix_expression ::= lefthand_side_expression INCR */
   104,  /* (71) postfix_expression ::= lefthand_side_expression DECR */
   105,  /* (72) call_expression ::= member_expression arguments */
   109,  /* (73) array_literal ::= BRACKETL element_list BRACKETR */
   110,  /* (74) element_list ::= */
   110,  /* (75) element_list ::= assignment_expression */
   110,  /* (76) element_list ::= element_list COMMA assignment_expression */
    87,  /* (77) object_literal ::= BRACEL property_list BRACER */
   111,  /* (78) property_list ::= */
   111,  /* (79) property_list ::= property */
   111,  /* (80) property_list ::= property_list COMMA property */
   108,  /* (81) member_expression_part ::= BRACKETL expression BRACKETR */
   107,  /* (82) arguments ::= PARENL argument_list PARENR */
   114,  /* (83) argument_list ::= */
   114,  /* (84) argument_list ::= assignment_expression */
   114,  /* (85) argument_list ::= argument_list COMMA assignment_expression */
    84,  /* (86) output_columns ::= */
    84,  /* (87) output_columns ::= output_column */
    84,  /* (88) output_columns ::= output_columns COMMA */
    84,  /* (89) output_columns ::= output_columns COMMA output_column */
   115,  /* (90) output_column ::= STAR */
   115,  /* (91) output_column ::= NONEXISTENT_COLUMN */
   115,  /* (92) output_column ::= assignment_expression */
    85,  /* (93) adjuster ::= adjuster PLUS adjust_expression */
   116,  /* (94) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   117,  /* (95) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    86,  /* (96) sort_keys ::= */
    86,  /* (97) sort_keys ::= sort_key */
    86,  /* (98) sort_keys ::= sort_keys COMMA sort_key */
   118,  /* (99) sort_key ::= NONEXISTENT_COLUMN */
   118,  /* (100) sort_key ::= MINUS NONEXISTENT_COLUMN */
   118,  /* (101) sort_key ::= assignment_expression */
    81,  /* (102) input ::= query */
    81,  /* (103) input ::= expression */
    81,  /* (104) input ::= START_OUTPUT_COLUMNS output_columns */
    81,  /* (105) input ::= START_ADJUSTER adjuster */
    81,  /* (106) input ::= START_SORT_KEYS sort_keys */
    81,  /* (107) input ::= START_OPTIONS object_literal */
    82,  /* (108) query ::= query_element */
    88,  /* (109) query_element ::= QSTRING */
    88,  /* (110) query_element ::= PARENL query PARENR */
    83,  /* (111) expression ::= assignment_expression */
    90,  /* (112) assignment_expression ::= conditional_expression */
    91,  /* (113) conditional_expression ::= logical_or_expression */
    93,  /* (114) logical_or_expression ::= logical_and_expression */
    94,  /* (115) logical_and_expression ::= bitwise_or_expression */
    95,  /* (116) bitwise_or_expression ::= bitwise_xor_expression */
    96,  /* (117) bitwise_xor_expression ::= bitwise_and_expression */
    97,  /* (118) bitwise_and_expression ::= equality_expression */
    98,  /* (119) equality_expression ::= relational_expression */
    99,  /* (120) relational_expression ::= shift_expression */
   100,  /* (121) shift_expression ::= additive_expression */
   101,  /* (122) additive_expression ::= multiplicative_expression */
   102,  /* (123) multiplicative_expression ::= unary_expression */
   103,  /* (124) unary_expression ::= postfix_expression */
   104,  /* (125) postfix_expression ::= lefthand_side_expression */
    92,  /* (126) lefthand_side_expression ::= call_expression */
    92,  /* (127) lefthand_side_expression ::= member_expression */
   106,  /* (128) member_expression ::= primary_expression */
   106,  /* (129) member_expression ::= member_expression member_expression_part */
    89,  /* (130) primary_expression ::= object_literal */
    89,  /* (131) primary_expression ::= PARENL expression PARENR */
    89,  /* (132) primary_expression ::= IDENTIFIER */
    89,  /* (133) primary_expression ::= array_literal */
    89,  /* (134) primary_expression ::= DECIMAL */
    89,  /* (135) primary_expression ::= HEX_INTEGER */
    89,  /* (136) primary_expression ::= STRING */
    89,  /* (137) primary_expression ::= BOOLEAN */
    89,  /* (138) primary_expression ::= NULL */
   112,  /* (139) property ::= property_name COLON assignment_expression */
   113,  /* (140) property_name ::= STRING */
   108,  /* (141) member_expression_part ::= DOT IDENTIFIER */
    85,  /* (142) adjuster ::= */
    85,  /* (143) adjuster ::= adjust_expression */
   116,  /* (144) adjust_expression ::= adjust_match_expression */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -2,  /* (0) query ::= query query_element */
   -3,  /* (1) query ::= query LOGICAL_AND query_element */
   -3,  /* (2) query ::= query LOGICAL_AND_NOT query_element */
   -3,  /* (3) query ::= query LOGICAL_OR query_element */
   -3,  /* (4) query ::= query NEGATIVE query_element */
   -2,  /* (5) query_element ::= ADJUST query_element */
   -2,  /* (6) query_element ::= RELATIVE_OP query_element */
   -3,  /* (7) query_element ::= IDENTIFIER RELATIVE_OP query_element */
   -3,  /* (8) query_element ::= BRACEL expression BRACER */
   -2,  /* (9) query_element ::= EVAL primary_expression */
   -3,  /* (10) expression ::= expression COMMA assignment_expression */
   -3,  /* (11) assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
   -3,  /* (12) assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
   -3,  /* (13) assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
   -3,  /* (14) assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
   -3,  /* (15) assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
   -3,  /* (16) assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
   -3,  /* (17) assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
   -3,  /* (18) assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
   -3,  /* (19) assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
   -3,  /* (20) assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
   -3,  /* (21) assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
   -3,  /* (22) assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
   -5,  /* (23) conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
   -3,  /* (24) logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */
   -3,  /* (25) logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */
   -3,  /* (26) logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */
   -3,  /* (27) logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
   -3,  /* (28) logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
   -3,  /* (29) bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
   -3,  /* (30) bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
   -3,  /* (31) bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
   -3,  /* (32) equality_expression ::= equality_expression EQUAL relational_expression */
   -3,  /* (33) equality_expression ::= equality_expression NOT_EQUAL relational_expression */
   -3,  /* (34) relational_expression ::= relational_expression LESS shift_expression */
   -3,  /* (35) relational_expression ::= relational_expression GREATER shift_expression */
   -3,  /* (36) relational_expression ::= relational_expression LESS_EQUAL shift_expression */
   -3,  /* (37) relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
   -3,  /* (38) relational_expression ::= relational_expression IN shift_expression */
   -3,  /* (39) relational_expression ::= relational_expression MATCH shift_expression */
   -3,  /* (40) relational_expression ::= relational_expression NEAR shift_expression */
   -3,  /* (41) relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
   -3,  /* (42) relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
   -3,  /* (43) relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
   -3,  /* (44) relational_expression ::= relational_expression SIMILAR shift_expression */
   -3,  /* (45) relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
   -3,  /* (46) relational_expression ::= relational_expression QUORUM shift_expression */
   -3,  /* (47) relational_expression ::= relational_expression LCP shift_expression */
   -3,  /* (48) relational_expression ::= relational_expression PREFIX shift_expression */
   -3,  /* (49) relational_expression ::= relational_expression SUFFIX shift_expression */
   -3,  /* (50) relational_expression ::= relational_expression REGEXP shift_expression */
   -3,  /* (51) shift_expression ::= shift_expression SHIFTL additive_expression */
   -3,  /* (52) shift_expression ::= shift_expression SHIFTR additive_expression */
   -3,  /* (53) shift_expression ::= shift_expression SHIFTRR additive_expression */
   -3,  /* (54) additive_expression ::= additive_expression PLUS multiplicative_expression */
   -3,  /* (55) additive_expression ::= additive_expression MINUS multiplicative_expression */
   -3,  /* (56) multiplicative_expression ::= multiplicative_expression STAR unary_expression */
   -3,  /* (57) multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
   -3,  /* (58) multiplicative_expression ::= multiplicative_expression MOD unary_expression */
   -2,  /* (59) unary_expression ::= DELETE unary_expression */
   -2,  /* (60) unary_expression ::= INCR unary_expression */
   -2,  /* (61) unary_expression ::= DECR unary_expression */
   -2,  /* (62) unary_expression ::= PLUS unary_expression */
   -2,  /* (63) unary_expression ::= MINUS unary_expression */
   -2,  /* (64) unary_expression ::= NOT unary_expression */
   -2,  /* (65) unary_expression ::= BITWISE_NOT unary_expression */
   -2,  /* (66) unary_expression ::= ADJUST unary_expression */
   -2,  /* (67) unary_expression ::= EXACT unary_expression */
   -2,  /* (68) unary_expression ::= PARTIAL unary_expression */
   -2,  /* (69) unary_expression ::= UNSPLIT unary_expression */
   -2,  /* (70) postfix_expression ::= lefthand_side_expression INCR */
   -2,  /* (71) postfix_expression ::= lefthand_side_expression DECR */
   -2,  /* (72) call_expression ::= member_expression arguments */
   -3,  /* (73) array_literal ::= BRACKETL element_list BRACKETR */
    0,  /* (74) element_list ::= */
   -1,  /* (75) element_list ::= assignment_expression */
   -3,  /* (76) element_list ::= element_list COMMA assignment_expression */
   -3,  /* (77) object_literal ::= BRACEL property_list BRACER */
    0,  /* (78) property_list ::= */
   -1,  /* (79) property_list ::= property */
   -3,  /* (80) property_list ::= property_list COMMA property */
   -3,  /* (81) member_expression_part ::= BRACKETL expression BRACKETR */
   -3,  /* (82) arguments ::= PARENL argument_list PARENR */
    0,  /* (83) argument_list ::= */
   -1,  /* (84) argument_list ::= assignment_expression */
   -3,  /* (85) argument_list ::= argument_list COMMA assignment_expression */
    0,  /* (86) output_columns ::= */
   -1,  /* (87) output_columns ::= output_column */
   -2,  /* (88) output_columns ::= output_columns COMMA */
   -3,  /* (89) output_columns ::= output_columns COMMA output_column */
   -1,  /* (90) output_column ::= STAR */
   -1,  /* (91) output_column ::= NONEXISTENT_COLUMN */
   -1,  /* (92) output_column ::= assignment_expression */
   -3,  /* (93) adjuster ::= adjuster PLUS adjust_expression */
   -3,  /* (94) adjust_expression ::= adjust_match_expression STAR DECIMAL */
   -3,  /* (95) adjust_match_expression ::= IDENTIFIER MATCH STRING */
    0,  /* (96) sort_keys ::= */
   -1,  /* (97) sort_keys ::= sort_key */
   -3,  /* (98) sort_keys ::= sort_keys COMMA sort_key */
   -1,  /* (99) sort_key ::= NONEXISTENT_COLUMN */
   -2,  /* (100) sort_key ::= MINUS NONEXISTENT_COLUMN */
   -1,  /* (101) sort_key ::= assignment_expression */
   -1,  /* (102) input ::= query */
   -1,  /* (103) input ::= expression */
   -2,  /* (104) input ::= START_OUTPUT_COLUMNS output_columns */
   -2,  /* (105) input ::= START_ADJUSTER adjuster */
   -2,  /* (106) input ::= START_SORT_KEYS sort_keys */
   -2,  /* (107) input ::= START_OPTIONS object_literal */
   -1,  /* (108) query ::= query_element */
   -1,  /* (109) query_element ::= QSTRING */
   -3,  /* (110) query_element ::= PARENL query PARENR */
   -1,  /* (111) expression ::= assignment_expression */
   -1,  /* (112) assignment_expression ::= conditional_expression */
   -1,  /* (113) conditional_expression ::= logical_or_expression */
   -1,  /* (114) logical_or_expression ::= logical_and_expression */
   -1,  /* (115) logical_and_expression ::= bitwise_or_expression */
   -1,  /* (116) bitwise_or_expression ::= bitwise_xor_expression */
   -1,  /* (117) bitwise_xor_expression ::= bitwise_and_expression */
   -1,  /* (118) bitwise_and_expression ::= equality_expression */
   -1,  /* (119) equality_expression ::= relational_expression */
   -1,  /* (120) relational_expression ::= shift_expression */
   -1,  /* (121) shift_expression ::= additive_expression */
   -1,  /* (122) additive_expression ::= multiplicative_expression */
   -1,  /* (123) multiplicative_expression ::= unary_expression */
   -1,  /* (124) unary_expression ::= postfix_expression */
   -1,  /* (125) postfix_expression ::= lefthand_side_expression */
   -1,  /* (126) lefthand_side_expression ::= call_expression */
   -1,  /* (127) lefthand_side_expression ::= member_expression */
   -1,  /* (128) member_expression ::= primary_expression */
   -2,  /* (129) member_expression ::= member_expression member_expression_part */
   -1,  /* (130) primary_expression ::= object_literal */
   -3,  /* (131) primary_expression ::= PARENL expression PARENR */
   -1,  /* (132) primary_expression ::= IDENTIFIER */
   -1,  /* (133) primary_expression ::= array_literal */
   -1,  /* (134) primary_expression ::= DECIMAL */
   -1,  /* (135) primary_expression ::= HEX_INTEGER */
   -1,  /* (136) primary_expression ::= STRING */
   -1,  /* (137) primary_expression ::= BOOLEAN */
   -1,  /* (138) primary_expression ::= NULL */
   -3,  /* (139) property ::= property_name COLON assignment_expression */
   -1,  /* (140) property_name ::= STRING */
   -2,  /* (141) member_expression_part ::= DOT IDENTIFIER */
    0,  /* (142) adjuster ::= */
   -1,  /* (143) adjuster ::= adjust_expression */
   -1,  /* (144) adjust_expression ::= adjust_match_expression */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  grn_expr_parserTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  grn_expr_parserCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 189 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 2005 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 25: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==25);
#line 192 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 2013 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 26: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==26);
#line 195 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 2021 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 24: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==24);
#line 198 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 2029 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 4: /* query ::= query NEGATIVE query_element */
#line 201 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 2);
}
#line 2038 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 5: /* query_element ::= ADJUST query_element */
#line 210 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
}
#line 2046 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 6: /* query_element ::= RELATIVE_OP query_element */
#line 214 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 2054 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 7: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 218 "../../groonga/lib/grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR_NO_OFFSET :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_NEAR_PHRASE :
  case GRN_OP_ORDERED_NEAR_PHRASE :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
      int additional_last_interval;
      GRN_INT32_POP(&efsi->additional_last_interval_stack,
                    additional_last_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  case GRN_OP_QUORUM :
    {
      int quorum_threshold;
      GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    }
    break;
  default :
    break;
  }
}
#line 2097 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 8: /* query_element ::= BRACEL expression BRACER */
      case 9: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==9);
#line 257 "../../groonga/lib/grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 2105 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 10: /* expression ::= expression COMMA assignment_expression */
#line 265 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 2112 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 270 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 2119 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 273 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 2126 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 276 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 2133 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 279 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 2140 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 282 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 2147 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 285 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 2154 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 288 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 2161 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 291 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 2168 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 294 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 2175 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 297 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 2182 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 300 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 2189 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 303 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 2196 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 23: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 308 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 2205 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 27: /* logical_and_expression ::= logical_and_expression ADJUST bitwise_or_expression */
#line 326 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_AND, 2);
}
#line 2214 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 28: /* logical_and_expression ::= logical_and_expression NEGATIVE bitwise_or_expression */
#line 331 "../../groonga/lib/grn_ecmascript.lemon"
{
  float weight;
  GRN_FLOAT32_POP(&efsi->weight_stack, weight);
  grn_expr_append_const_float32(efsi->ctx, efsi->e, weight, GRN_OP_ADJUST, 2);
}
#line 2223 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 29: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 338 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 2230 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 30: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 343 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 2237 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 31: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 348 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 2244 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 32: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 353 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 2251 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 33: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 356 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 2258 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression LESS shift_expression */
#line 361 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 2265 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 364 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 2272 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 367 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 2279 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 370 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 2286 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression IN shift_expression */
#line 373 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 2293 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 95: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==95);
#line 376 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 2301 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 379 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 2314 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression NEAR_NO_OFFSET shift_expression */
#line 388 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_NO_OFFSET, 2);
}
#line 2321 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression NEAR_PHRASE shift_expression */
#line 391 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR_PHRASE, 4);
}
#line 2339 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression ORDERED_NEAR_PHRASE shift_expression */
#line 405 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
    int additional_last_interval;
    GRN_INT32_POP(&efsi->additional_last_interval_stack,
                  additional_last_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, additional_last_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ORDERED_NEAR_PHRASE, 4);
}
#line 2357 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 44: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 419 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int similarity_threshold;
    GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, similarity_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 3);
}
#line 2370 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 45: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 428 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 2377 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression QUORUM shift_expression */
#line 431 "../../groonga/lib/grn_ecmascript.lemon"
{
  {
    int quorum_threshold;
    GRN_INT32_POP(&efsi->quorum_threshold_stack, quorum_threshold);
    grn_expr_append_const_int(efsi->ctx, efsi->e, quorum_threshold,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_QUORUM, 3);
}
#line 2390 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression LCP shift_expression */
#line 440 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 2397 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 443 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 2404 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 446 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 2411 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 449 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 2418 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 51: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 454 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 2425 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 52: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 457 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 2432 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 53: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 460 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 2439 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 54: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 93: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==93);
#line 465 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 2447 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 55: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 468 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 2454 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 56: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 94: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==94);
#line 473 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 2462 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 57: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 476 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 2469 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 58: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 479 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 2476 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= DELETE unary_expression */
#line 484 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 2483 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= INCR unary_expression */
#line 487 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 2504 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= DECR unary_expression */
#line 504 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 2525 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= PLUS unary_expression */
#line 521 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 2532 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 63: /* unary_expression ::= MINUS unary_expression */
#line 524 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 2539 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 64: /* unary_expression ::= NOT unary_expression */
#line 527 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 2546 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 65: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 530 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 2553 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 66: /* unary_expression ::= ADJUST unary_expression */
#line 533 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 2560 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 67: /* unary_expression ::= EXACT unary_expression */
#line 536 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 2567 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 68: /* unary_expression ::= PARTIAL unary_expression */
#line 539 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 2574 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 69: /* unary_expression ::= UNSPLIT unary_expression */
#line 542 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 2581 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 70: /* postfix_expression ::= lefthand_side_expression INCR */
#line 547 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 2602 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 71: /* postfix_expression ::= lefthand_side_expression DECR */
#line 564 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 2623 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 72: /* call_expression ::= member_expression arguments */
#line 585 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 2630 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 73: /* array_literal ::= BRACKETL element_list BRACKETR */
#line 602 "../../groonga/lib/grn_ecmascript.lemon"
{
  array_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2637 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 74: /* element_list ::= */
      case 78: /* property_list ::= */ yytestcase(yyruleno==78);
      case 86: /* output_columns ::= */ yytestcase(yyruleno==86);
      case 96: /* sort_keys ::= */ yytestcase(yyruleno==96);
#line 606 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2647 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 75: /* element_list ::= assignment_expression */
      case 79: /* property_list ::= property */ yytestcase(yyruleno==79);
      case 92: /* output_column ::= assignment_expression */ yytestcase(yyruleno==92);
      case 101: /* sort_key ::= assignment_expression */ yytestcase(yyruleno==101);
#line 609 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2657 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 76: /* element_list ::= element_list COMMA assignment_expression */
      case 80: /* property_list ::= property_list COMMA property */ yytestcase(yyruleno==80);
#line 612 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1;
}
#line 2665 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 77: /* object_literal ::= BRACEL property_list BRACER */
#line 616 "../../groonga/lib/grn_ecmascript.lemon"
{
  object_literal_end(efsi, yymsp[-1].minor.yy0);
}
#line 2673 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 81: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 633 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2680 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 82: /* arguments ::= PARENL argument_list PARENR */
#line 638 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2685 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 83: /* argument_list ::= */
#line 639 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2690 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 84: /* argument_list ::= assignment_expression */
#line 640 "../../groonga/lib/grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2695 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 85: /* argument_list ::= argument_list COMMA assignment_expression */
#line 641 "../../groonga/lib/grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2700 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 87: /* output_columns ::= output_column */
      case 97: /* sort_keys ::= sort_key */ yytestcase(yyruleno==97);
#line 646 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2709 "../../groonga/lib/grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 88: /* output_columns ::= output_columns COMMA */
#line 651 "../../groonga/lib/grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2717 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 89: /* output_columns ::= output_columns COMMA output_column */
      case 98: /* sort_keys ::= sort_keys COMMA sort_key */ yytestcase(yyruleno==98);
#line 656 "../../groonga/lib/grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2735 "../../groonga/lib/grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 90: /* output_column ::= STAR */
#line 669 "../../groonga/lib/grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      grn_expr_take_obj(ctx, expr, column);
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        grn_expr_take_obj(ctx, expr, column);
      }
    }

    if (grn_enable_reference_count) {
      grn_obj_unlink(ctx, table);
    }
    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2789 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 91: /* output_column ::= NONEXISTENT_COLUMN */
      case 99: /* sort_key ::= NONEXISTENT_COLUMN */ yytestcase(yyruleno==99);
#line 718 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2797 "../../groonga/lib/grn_ecmascript.c"
        break;
      case 100: /* sort_key ::= MINUS NONEXISTENT_COLUMN */
#line 764 "../../groonga/lib/grn_ecmascript.lemon"
{
  yymsp[-1].minor.yy0 = 0;
}
#line 2804 "../../groonga/lib/grn_ecmascript.c"
        break;
      default:
      /* (102) input ::= query */ yytestcase(yyruleno==102);
      /* (103) input ::= expression */ yytestcase(yyruleno==103);
      /* (104) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==104);
      /* (105) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==105);
      /* (106) input ::= START_SORT_KEYS sort_keys */ yytestcase(yyruleno==106);
      /* (107) input ::= START_OPTIONS object_literal */ yytestcase(yyruleno==107);
      /* (108) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=108);
      /* (109) query_element ::= QSTRING */ yytestcase(yyruleno==109);
      /* (110) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==110);
      /* (111) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=111);
      /* (112) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=112);
      /* (113) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==113);
      /* (114) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==114);
      /* (115) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==115);
      /* (116) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==116);
      /* (117) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==117);
      /* (118) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==118);
      /* (119) equality_expression ::= relational_expression */ yytestcase(yyruleno==119);
      /* (120) relational_expression ::= shift_expression */ yytestcase(yyruleno==120);
      /* (121) shift_expression ::= additive_expression */ yytestcase(yyruleno==121);
      /* (122) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==122);
      /* (123) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=123);
      /* (124) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=124);
      /* (125) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==125);
      /* (126) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=126);
      /* (127) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==127);
      /* (128) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=128);
      /* (129) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==129);
      /* (130) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=130);
      /* (131) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==131);
      /* (132) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==132);
      /* (133) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=133);
      /* (134) primary_expression ::= DECIMAL */ yytestcase(yyruleno==134);
      /* (135) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==135);
      /* (136) primary_expression ::= STRING */ yytestcase(yyruleno==136);
      /* (137) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==137);
      /* (138) primary_expression ::= NULL */ yytestcase(yyruleno==138);
      /* (139) property ::= property_name COLON assignment_expression */ yytestcase(yyruleno==139);
      /* (140) property_name ::= STRING */ yytestcase(yyruleno==140);
      /* (141) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==141);
      /* (142) adjuster ::= */ yytestcase(yyruleno==142);
      /* (143) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=143);
      /* (144) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==144);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 152 "../../groonga/lib/grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      char errbuf[GRN_CTX_MSGSIZE];
      grn_strcpy(errbuf, GRN_CTX_MSGSIZE, ctx->errbuf);
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2937 "../../groonga/lib/grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH
  grn_expr_parserCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE /* Suppress warning about unused %extra_argument variable */
  grn_expr_parserCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  grn_expr_parserCTX_FETCH
  grn_expr_parserARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  while(1){ /* Exit by "break" */
    assert( yypParser->yytos>=yypParser->yystack );
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      unsigned int yyruleno = yyact - YY_MIN_REDUCE; /* Reduce by this rule */
      assert( yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) );
#ifndef NDEBUG
      if( yyTraceFILE ){
        int yysize = yyRuleInfoNRhs[yyruleno];
        if( yysize ){
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
            yyTracePrompt,
            yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
            yypParser->yytos[yysize].stateno);
        }else{
          fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
            yyTracePrompt, yyruleno, yyRuleName[yyruleno],
            yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
        }
      }
#endif /* NDEBUG */

      /* Check that the stack is large enough to grow by a single entry
      ** if the RHS of the rule is empty.  This ensures that there is room
      ** enough on the stack to push the LHS value */
      if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
        if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
          yypParser->yyhwm++;
          assert( yypParser->yyhwm ==
                  (int)(yypParser->yytos - yypParser->yystack));
        }
#endif
#if YYSTACKDEPTH>0 
        if( yypParser->yytos>=yypParser->yystackEnd ){
          yyStackOverflow(yypParser);
          break;
        }
#else
        if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
          if( yyGrowStack(yypParser) ){
            yyStackOverflow(yypParser);
            break;
          }
        }
#endif
      }
      yyact = yy_reduce(yypParser,yyruleno,yymajor,yyminor grn_expr_parserCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int grn_expr_parserFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
