/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 3 "ecmascript.y"

#define assert GRN_ASSERT
#line 11 "ecmascript.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    grn_expr_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 107
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE 211
#define YYNRULE 122
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1762)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   334,   74,  104,   76,  207,  177,  180,  201,   82,  118,
 /*    10 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  166,
 /*    20 */   197,  183,   72,    2,   25,  176,  172,  208,    1,   32,
 /*    30 */    77,  120,    4,   33,   69,   73,  110,  138,  207,  177,
 /*    40 */   180,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*    50 */    96,  108,   97,  166,  197,  183,   72,  176,  172,  176,
 /*    60 */   172,  208,    1,   34,   77,  120,    4,   24,   69,    6,
 /*    70 */    29,   64,   63,   52,   51,   50,   67,   66,   65,   62,
 /*    80 */    61,   60,   59,   58,   57,  171,  170,  169,  168,  167,
 /*    90 */     3,    7,   26,  153,  173,   81,  208,   70,  164,   77,
 /*   100 */   131,    9,  175,   69,  107,   64,   63,  203,   28,   28,
 /*   110 */    67,   66,   65,   62,   61,   60,   59,   58,   57,  171,
 /*   120 */   170,  169,  168,  167,    3,    7,   31,   30,  173,   81,
 /*   130 */   152,    8,  164,  122,   64,   63,   23,   36,   35,   67,
 /*   140 */    66,   65,   62,   61,   60,   59,   58,   57,  171,  170,
 /*   150 */   169,  168,  167,    3,  165,   49,   48,   47,   46,   45,
 /*   160 */    44,   43,   42,   41,   40,   39,   38,   37,   64,   63,
 /*   170 */    54,   53,   10,   67,   66,   65,   62,   61,   60,   59,
 /*   180 */    58,   57,  171,  170,  169,  168,  167,    3,  158,  119,
 /*   190 */   185,  184,  177,  180,  201,   82,  118,  117,  126,  125,
 /*   200 */   124,  112,   83,   96,  108,   97,  166,  197,  183,   72,
 /*   210 */   161,  123,  176,  172,  159,   28,  107,  177,  154,  201,
 /*   220 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   230 */    97,  166,  197,  183,   72,  209,  206,  176,  172,   11,
 /*   240 */    80,   68,   56,   55,  103,  335,  177,  133,  201,   82,
 /*   250 */   118,  117,  126,  125,  124,  112,   83,   96,  108,   97,
 /*   260 */   166,  197,  183,   72,  155,  205,  176,  172,  159,  204,
 /*   270 */   159,  179,  119,  137,  132,  177,  180,  201,   82,  118,
 /*   280 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  166,
 /*   290 */   197,  183,   72,  210,  113,  176,  172,  177,  180,  201,
 /*   300 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   310 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  110,
 /*   320 */   156,  335,  177,  180,  201,   82,  118,  117,  126,  125,
 /*   330 */   124,  112,   83,   96,  108,   97,  166,  197,  183,   72,
 /*   340 */   335,  335,  176,  172,  177,  150,  201,   82,  118,  117,
 /*   350 */   126,  125,  124,  112,   83,   96,  108,   97,  166,  197,
 /*   360 */   183,   72,  335,    7,  176,  172,  173,   81,  182,  181,
 /*   370 */   335,  106,  177,  133,  201,   82,  118,  117,  126,  125,
 /*   380 */   124,  112,   83,   96,  108,   97,  166,  197,  183,   72,
 /*   390 */   212,    7,  176,  172,  173,   81,  213,  162,  155,   71,
 /*   400 */   135,   73,  335,   28,  207,  335,   64,   63,  134,    5,
 /*   410 */   335,   67,   66,   65,   62,   61,   60,   59,   58,   57,
 /*   420 */   171,  170,  169,  168,  167,    3,    7,  335,  335,  173,
 /*   430 */    81,  335,  335,  335,   64,   63,  335,  335,  335,   67,
 /*   440 */    66,   65,   62,   61,   60,   59,   58,   57,  171,  170,
 /*   450 */   169,  168,  167,    3,  211,  335,   79,   78,   75,  208,
 /*   460 */    70,  335,   77,  131,    9,  335,   69,  335,  335,   64,
 /*   470 */    63,  335,  335,  335,   67,   66,   65,   62,   61,   60,
 /*   480 */    59,   58,   57,  171,  170,  169,  168,  167,    3,  177,
 /*   490 */   202,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   500 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*   510 */   172,  335,  177,  200,  201,   82,  118,  117,  126,  125,
 /*   520 */   124,  112,   83,   96,  108,   97,  166,  197,  183,   72,
 /*   530 */   335,  335,  176,  172,  335,   79,   78,   75,  208,   70,
 /*   540 */   136,   77,  131,    9,  335,   69,  335,  177,  130,  201,
 /*   550 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   560 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*   570 */   199,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   580 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*   590 */   172,  177,  160,  201,   82,  118,  117,  126,  125,  124,
 /*   600 */   112,   83,   96,  108,   97,  166,  197,  183,   72,  335,
 /*   610 */   335,  176,  172,  335,  335,  335,  335,  335,  335,  335,
 /*   620 */   335,  335,  335,  335,  335,  177,  151,  201,   82,  118,
 /*   630 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  166,
 /*   640 */   197,  183,   72,  335,  335,  176,  172,  177,  149,  201,
 /*   650 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   660 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*   670 */   148,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   680 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*   690 */   172,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*   700 */   335,  335,  335,  177,  147,  201,   82,  118,  117,  126,
 /*   710 */   125,  124,  112,   83,   96,  108,   97,  166,  197,  183,
 /*   720 */    72,  335,  335,  176,  172,  177,  146,  201,   82,  118,
 /*   730 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  166,
 /*   740 */   197,  183,   72,  335,  335,  176,  172,  177,  145,  201,
 /*   750 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   760 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  335,
 /*   770 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*   780 */   335,  177,  144,  201,   82,  118,  117,  126,  125,  124,
 /*   790 */   112,   83,   96,  108,   97,  166,  197,  183,   72,  335,
 /*   800 */   335,  176,  172,  177,  143,  201,   82,  118,  117,  126,
 /*   810 */   125,  124,  112,   83,   96,  108,   97,  166,  197,  183,
 /*   820 */    72,  335,  335,  176,  172,  177,  142,  201,   82,  118,
 /*   830 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  166,
 /*   840 */   197,  183,   72,  335,  335,  176,  172,  335,  335,  335,
 /*   850 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  177,
 /*   860 */   141,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   870 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*   880 */   172,  177,  140,  201,   82,  118,  117,  126,  125,  124,
 /*   890 */   112,   83,   96,  108,   97,  166,  197,  183,   72,  335,
 /*   900 */   335,  176,  172,  177,  139,  201,   82,  118,  117,  126,
 /*   910 */   125,  124,  112,   83,   96,  108,   97,  166,  197,  183,
 /*   920 */    72,  335,  335,  176,  172,  335,  335,  335,  335,  335,
 /*   930 */   335,  335,  335,  335,  335,  335,  335,  177,  163,  201,
 /*   940 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   950 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*   960 */   157,  201,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   970 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*   980 */   172,  177,  335,  335,  114,  335,  105,  126,  125,  124,
 /*   990 */   112,   83,   96,  108,   97,  166,  197,  183,   72,  335,
 /*  1000 */   335,  176,  172,  335,  335,  335,  335,  335,  335,  335,
 /*  1010 */   335,  335,  335,  335,  335,  177,  335,  335,  114,  335,
 /*  1020 */   335,  129,  125,  124,  112,   83,   96,  108,   97,  166,
 /*  1030 */   197,  183,   72,  335,  335,  176,  172,  177,  335,  335,
 /*  1040 */   114,  335,  335,  121,  125,  124,  112,   83,   96,  108,
 /*  1050 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*  1060 */   335,  335,  114,  335,  335,  335,  128,  124,  112,   83,
 /*  1070 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*  1080 */   172,   27,   22,   21,   20,   19,   18,   17,   16,   15,
 /*  1090 */    14,   13,   12,  177,  335,  335,  114,  335,  335,  335,
 /*  1100 */   335,  127,  112,   83,   96,  108,   97,  166,  197,  183,
 /*  1110 */    72,  335,  335,  176,  172,  177,  335,  335,  114,  335,
 /*  1120 */   335,  335,  185,  184,  116,   83,   96,  108,   97,  166,
 /*  1130 */   197,  183,   72,  335,  335,  176,  172,  177,  335,  335,
 /*  1140 */   114,  335,  335,  335,  335,  335,  335,   85,   96,  108,
 /*  1150 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*  1160 */   335,  335,  114,  335,  335,  335,  335,  335,  335,   84,
 /*  1170 */    96,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*  1180 */   172,  177,  335,  335,  114,  335,  335,  335,  335,  335,
 /*  1190 */   335,  335,  102,  108,   97,  166,  197,  183,   72,  335,
 /*  1200 */   177,  176,  172,  114,  335,  335,  335,  335,  335,  335,
 /*  1210 */   335,  100,  108,   97,  166,  197,  183,   72,  335,  335,
 /*  1220 */   176,  172,  335,  335,  335,  177,  335,  335,  114,  335,
 /*  1230 */   335,  335,  335,  335,  335,  335,   98,  108,   97,  166,
 /*  1240 */   197,  183,   72,  335,  335,  176,  172,  177,  335,  335,
 /*  1250 */   114,  335,  335,  335,  335,  335,  335,  335,   95,  108,
 /*  1260 */    97,  166,  197,  183,   72,  335,  335,  176,  172,  335,
 /*  1270 */   177,  335,  335,  114,  335,  335,  335,  335,  335,  335,
 /*  1280 */   335,   94,  108,   97,  166,  197,  183,   72,  335,  177,
 /*  1290 */   176,  172,  114,  335,  335,  335,  335,  335,  335,  335,
 /*  1300 */    93,  108,   97,  166,  197,  183,   72,  335,  335,  176,
 /*  1310 */   172,  335,  335,  335,  177,  335,  335,  114,  335,  335,
 /*  1320 */   335,  335,  335,  335,  335,   92,  108,   97,  166,  197,
 /*  1330 */   183,   72,  335,  335,  176,  172,  177,  335,  335,  114,
 /*  1340 */   335,  335,  335,  335,  335,  335,  335,   91,  108,   97,
 /*  1350 */   166,  197,  183,   72,  335,  335,  176,  172,  335,  177,
 /*  1360 */   335,  335,  114,  335,  335,  335,  335,  335,  335,  335,
 /*  1370 */    90,  108,   97,  166,  197,  183,   72,  335,  177,  176,
 /*  1380 */   172,  114,  335,  335,  335,  335,  335,  335,  335,   89,
 /*  1390 */   108,   97,  166,  197,  183,   72,  335,  335,  176,  172,
 /*  1400 */   335,  335,  335,  177,  335,  335,  114,  335,  335,  335,
 /*  1410 */   335,  335,  335,  335,   88,  108,   97,  166,  197,  183,
 /*  1420 */    72,  335,  335,  176,  172,  177,  335,  335,  114,  335,
 /*  1430 */   335,  335,  335,  335,  335,  335,   87,  108,   97,  166,
 /*  1440 */   197,  183,   72,  335,  335,  176,  172,  335,  177,  335,
 /*  1450 */   335,  114,  335,  335,  335,  335,  335,  335,  335,   86,
 /*  1460 */   108,   97,  166,  197,  183,   72,  335,  177,  176,  172,
 /*  1470 */   114,  335,  335,  335,  335,  335,  335,  335,  335,  115,
 /*  1480 */    97,  166,  197,  183,   72,  335,    7,  176,  172,  173,
 /*  1490 */    81,  335,  177,  335,  335,  114,  335,  335,  335,  335,
 /*  1500 */   335,  335,  335,  335,  111,   97,  166,  197,  183,   72,
 /*  1510 */   335,  335,  176,  172,  177,  335,  335,  114,  335,  335,
 /*  1520 */   335,  335,  335,  335,  335,  335,  109,   97,  166,  197,
 /*  1530 */   183,   72,  335,  335,  176,  172,  335,  177,  335,  335,
 /*  1540 */   114,  335,  335,  171,  170,  169,  168,  167,    3,  335,
 /*  1550 */   101,  166,  197,  183,   72,  335,  335,  176,  172,  177,
 /*  1560 */   335,  335,  114,  335,  335,  335,  335,  177,  335,  335,
 /*  1570 */   114,  335,   99,  166,  197,  183,   72,  335,  335,  176,
 /*  1580 */   172,  198,  197,  183,   72,  335,  177,  176,  172,  114,
 /*  1590 */   335,  335,  335,  335,  335,  177,  335,  335,  114,  335,
 /*  1600 */   196,  197,  183,   72,  335,  177,  176,  172,  114,  195,
 /*  1610 */   197,  183,   72,  335,  335,  176,  172,  335,  335,  194,
 /*  1620 */   197,  183,   72,  335,  177,  176,  172,  114,  335,  335,
 /*  1630 */   335,  335,  177,  335,  335,  114,  335,  335,  193,  197,
 /*  1640 */   183,   72,  335,  335,  176,  172,  192,  197,  183,   72,
 /*  1650 */   335,  177,  176,  172,  114,  335,  335,  335,  335,  177,
 /*  1660 */   335,  335,  114,  335,  335,  191,  197,  183,   72,  335,
 /*  1670 */   335,  176,  172,  190,  197,  183,   72,  335,  177,  176,
 /*  1680 */   172,  114,  335,  335,  335,  335,  177,  335,  335,  114,
 /*  1690 */   335,  335,  189,  197,  183,   72,  335,  335,  176,  172,
 /*  1700 */   188,  197,  183,   72,  335,  177,  176,  172,  114,  335,
 /*  1710 */   335,  335,  335,  177,  335,  335,  114,  335,  335,  187,
 /*  1720 */   197,  183,   72,  335,  335,  176,  172,  186,  197,  183,
 /*  1730 */    72,  335,  177,  176,  172,  114,  335,  335,  335,  335,
 /*  1740 */   177,  335,  335,  114,  335,  335,  178,  197,  183,   72,
 /*  1750 */   335,  335,  176,  172,  174,  197,  183,   72,  335,  335,
 /*  1760 */   176,  172,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    72,   73,   74,    8,   76,   77,   78,   79,   80,   81,
 /*    10 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*    20 */    92,   93,   94,    1,   27,   97,   98,    5,    6,   28,
 /*    30 */     8,    9,   10,   29,   12,   73,   74,   77,   76,   77,
 /*    40 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*    50 */    88,   89,   90,   91,   92,   93,   94,   97,   98,   97,
 /*    60 */    98,    5,    6,   30,    8,    9,   10,   27,   12,    6,
 /*    70 */     4,   49,   50,   46,   47,   48,   54,   55,   56,   57,
 /*    80 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*    90 */    68,    6,   26,    9,    9,   10,    5,    6,   13,    8,
 /*   100 */     9,   10,    7,   12,  101,   49,   50,   11,   13,   13,
 /*   110 */    54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   120 */    64,   65,   66,   67,   68,    6,    2,    3,    9,   10,
 /*   130 */     7,   68,   13,   70,   49,   50,   13,   31,   32,   54,
 /*   140 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   150 */    65,   66,   67,   68,   69,   33,   34,   35,   36,   37,
 /*   160 */    38,   39,   40,   41,   42,   43,   44,   45,   49,   50,
 /*   170 */    49,   50,   99,   54,   55,   56,   57,   58,   59,   60,
 /*   180 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   74,
 /*   190 */    55,   56,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   200 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   210 */   102,  103,   97,   98,    9,   13,  101,   77,   78,   79,
 /*   220 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   230 */    90,   91,   92,   93,   94,   76,   76,   97,   98,   99,
 /*   240 */   100,   51,   52,   53,   75,  106,   77,   78,   79,   80,
 /*   250 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   260 */    91,   92,   93,   94,   13,   76,   97,   98,   63,   76,
 /*   270 */    65,   69,   74,   76,  105,   77,   78,   79,   80,   81,
 /*   280 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   290 */    92,   93,   94,   76,   74,   97,   98,   77,   78,   79,
 /*   300 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   310 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   74,
 /*   320 */    69,  106,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   330 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   340 */   106,  106,   97,   98,   77,   78,   79,   80,   81,   82,
 /*   350 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   360 */    93,   94,  106,    6,   97,   98,    9,   10,   95,   96,
 /*   370 */   106,  104,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   380 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   390 */     0,    6,   97,   98,    9,   10,    0,   11,   13,   13,
 /*   400 */   105,   73,  106,   13,   76,  106,   49,   50,   51,   13,
 /*   410 */   106,   54,   55,   56,   57,   58,   59,   60,   61,   62,
 /*   420 */    63,   64,   65,   66,   67,   68,    6,  106,  106,    9,
 /*   430 */    10,  106,  106,  106,   49,   50,  106,  106,  106,   54,
 /*   440 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   450 */    65,   66,   67,   68,    0,  106,    2,    3,    4,    5,
 /*   460 */     6,  106,    8,    9,   10,  106,   12,  106,  106,   49,
 /*   470 */    50,  106,  106,  106,   54,   55,   56,   57,   58,   59,
 /*   480 */    60,   61,   62,   63,   64,   65,   66,   67,   68,   77,
 /*   490 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   500 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*   510 */    98,  106,   77,   78,   79,   80,   81,   82,   83,   84,
 /*   520 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   530 */   106,  106,   97,   98,  106,    2,    3,    4,    5,    6,
 /*   540 */     7,    8,    9,   10,  106,   12,  106,   77,   78,   79,
 /*   550 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   560 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*   570 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   580 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*   590 */    98,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   600 */    86,   87,   88,   89,   90,   91,   92,   93,   94,  106,
 /*   610 */   106,   97,   98,  106,  106,  106,  106,  106,  106,  106,
 /*   620 */   106,  106,  106,  106,  106,   77,   78,   79,   80,   81,
 /*   630 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   640 */    92,   93,   94,  106,  106,   97,   98,   77,   78,   79,
 /*   650 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   660 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*   670 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   680 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*   690 */    98,  106,  106,  106,  106,  106,  106,  106,  106,  106,
 /*   700 */   106,  106,  106,   77,   78,   79,   80,   81,   82,   83,
 /*   710 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   720 */    94,  106,  106,   97,   98,   77,   78,   79,   80,   81,
 /*   730 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   740 */    92,   93,   94,  106,  106,   97,   98,   77,   78,   79,
 /*   750 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   760 */    90,   91,   92,   93,   94,  106,  106,   97,   98,  106,
 /*   770 */   106,  106,  106,  106,  106,  106,  106,  106,  106,  106,
 /*   780 */   106,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   790 */    86,   87,   88,   89,   90,   91,   92,   93,   94,  106,
 /*   800 */   106,   97,   98,   77,   78,   79,   80,   81,   82,   83,
 /*   810 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   820 */    94,  106,  106,   97,   98,   77,   78,   79,   80,   81,
 /*   830 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   840 */    92,   93,   94,  106,  106,   97,   98,  106,  106,  106,
 /*   850 */   106,  106,  106,  106,  106,  106,  106,  106,  106,   77,
 /*   860 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   870 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*   880 */    98,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   890 */    86,   87,   88,   89,   90,   91,   92,   93,   94,  106,
 /*   900 */   106,   97,   98,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   920 */    94,  106,  106,   97,   98,  106,  106,  106,  106,  106,
 /*   930 */   106,  106,  106,  106,  106,  106,  106,   77,   78,   79,
 /*   940 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   950 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*   960 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   970 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*   980 */    98,   77,  106,  106,   80,  106,   82,   83,   84,   85,
 /*   990 */    86,   87,   88,   89,   90,   91,   92,   93,   94,  106,
 /*  1000 */   106,   97,   98,  106,  106,  106,  106,  106,  106,  106,
 /*  1010 */   106,  106,  106,  106,  106,   77,  106,  106,   80,  106,
 /*  1020 */   106,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  1030 */    92,   93,   94,  106,  106,   97,   98,   77,  106,  106,
 /*  1040 */    80,  106,  106,   83,   84,   85,   86,   87,   88,   89,
 /*  1050 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*  1060 */   106,  106,   80,  106,  106,  106,   84,   85,   86,   87,
 /*  1070 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*  1080 */    98,   14,   15,   16,   17,   18,   19,   20,   21,   22,
 /*  1090 */    23,   24,   25,   77,  106,  106,   80,  106,  106,  106,
 /*  1100 */   106,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1110 */    94,  106,  106,   97,   98,   77,  106,  106,   80,  106,
 /*  1120 */   106,  106,   55,   56,   86,   87,   88,   89,   90,   91,
 /*  1130 */    92,   93,   94,  106,  106,   97,   98,   77,  106,  106,
 /*  1140 */    80,  106,  106,  106,  106,  106,  106,   87,   88,   89,
 /*  1150 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*  1160 */   106,  106,   80,  106,  106,  106,  106,  106,  106,   87,
 /*  1170 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*  1180 */    98,   77,  106,  106,   80,  106,  106,  106,  106,  106,
 /*  1190 */   106,  106,   88,   89,   90,   91,   92,   93,   94,  106,
 /*  1200 */    77,   97,   98,   80,  106,  106,  106,  106,  106,  106,
 /*  1210 */   106,   88,   89,   90,   91,   92,   93,   94,  106,  106,
 /*  1220 */    97,   98,  106,  106,  106,   77,  106,  106,   80,  106,
 /*  1230 */   106,  106,  106,  106,  106,  106,   88,   89,   90,   91,
 /*  1240 */    92,   93,   94,  106,  106,   97,   98,   77,  106,  106,
 /*  1250 */    80,  106,  106,  106,  106,  106,  106,  106,   88,   89,
 /*  1260 */    90,   91,   92,   93,   94,  106,  106,   97,   98,  106,
 /*  1270 */    77,  106,  106,   80,  106,  106,  106,  106,  106,  106,
 /*  1280 */   106,   88,   89,   90,   91,   92,   93,   94,  106,   77,
 /*  1290 */    97,   98,   80,  106,  106,  106,  106,  106,  106,  106,
 /*  1300 */    88,   89,   90,   91,   92,   93,   94,  106,  106,   97,
 /*  1310 */    98,  106,  106,  106,   77,  106,  106,   80,  106,  106,
 /*  1320 */   106,  106,  106,  106,  106,   88,   89,   90,   91,   92,
 /*  1330 */    93,   94,  106,  106,   97,   98,   77,  106,  106,   80,
 /*  1340 */   106,  106,  106,  106,  106,  106,  106,   88,   89,   90,
 /*  1350 */    91,   92,   93,   94,  106,  106,   97,   98,  106,   77,
 /*  1360 */   106,  106,   80,  106,  106,  106,  106,  106,  106,  106,
 /*  1370 */    88,   89,   90,   91,   92,   93,   94,  106,   77,   97,
 /*  1380 */    98,   80,  106,  106,  106,  106,  106,  106,  106,   88,
 /*  1390 */    89,   90,   91,   92,   93,   94,  106,  106,   97,   98,
 /*  1400 */   106,  106,  106,   77,  106,  106,   80,  106,  106,  106,
 /*  1410 */   106,  106,  106,  106,   88,   89,   90,   91,   92,   93,
 /*  1420 */    94,  106,  106,   97,   98,   77,  106,  106,   80,  106,
 /*  1430 */   106,  106,  106,  106,  106,  106,   88,   89,   90,   91,
 /*  1440 */    92,   93,   94,  106,  106,   97,   98,  106,   77,  106,
 /*  1450 */   106,   80,  106,  106,  106,  106,  106,  106,  106,   88,
 /*  1460 */    89,   90,   91,   92,   93,   94,  106,   77,   97,   98,
 /*  1470 */    80,  106,  106,  106,  106,  106,  106,  106,  106,   89,
 /*  1480 */    90,   91,   92,   93,   94,  106,    6,   97,   98,    9,
 /*  1490 */    10,  106,   77,  106,  106,   80,  106,  106,  106,  106,
 /*  1500 */   106,  106,  106,  106,   89,   90,   91,   92,   93,   94,
 /*  1510 */   106,  106,   97,   98,   77,  106,  106,   80,  106,  106,
 /*  1520 */   106,  106,  106,  106,  106,  106,   89,   90,   91,   92,
 /*  1530 */    93,   94,  106,  106,   97,   98,  106,   77,  106,  106,
 /*  1540 */    80,  106,  106,   63,   64,   65,   66,   67,   68,  106,
 /*  1550 */    90,   91,   92,   93,   94,  106,  106,   97,   98,   77,
 /*  1560 */   106,  106,   80,  106,  106,  106,  106,   77,  106,  106,
 /*  1570 */    80,  106,   90,   91,   92,   93,   94,  106,  106,   97,
 /*  1580 */    98,   91,   92,   93,   94,  106,   77,   97,   98,   80,
 /*  1590 */   106,  106,  106,  106,  106,   77,  106,  106,   80,  106,
 /*  1600 */    91,   92,   93,   94,  106,   77,   97,   98,   80,   91,
 /*  1610 */    92,   93,   94,  106,  106,   97,   98,  106,  106,   91,
 /*  1620 */    92,   93,   94,  106,   77,   97,   98,   80,  106,  106,
 /*  1630 */   106,  106,   77,  106,  106,   80,  106,  106,   91,   92,
 /*  1640 */    93,   94,  106,  106,   97,   98,   91,   92,   93,   94,
 /*  1650 */   106,   77,   97,   98,   80,  106,  106,  106,  106,   77,
 /*  1660 */   106,  106,   80,  106,  106,   91,   92,   93,   94,  106,
 /*  1670 */   106,   97,   98,   91,   92,   93,   94,  106,   77,   97,
 /*  1680 */    98,   80,  106,  106,  106,  106,   77,  106,  106,   80,
 /*  1690 */   106,  106,   91,   92,   93,   94,  106,  106,   97,   98,
 /*  1700 */    91,   92,   93,   94,  106,   77,   97,   98,   80,  106,
 /*  1710 */   106,  106,  106,   77,  106,  106,   80,  106,  106,   91,
 /*  1720 */    92,   93,   94,  106,  106,   97,   98,   91,   92,   93,
 /*  1730 */    94,  106,   77,   97,   98,   80,  106,  106,  106,  106,
 /*  1740 */    77,  106,  106,   80,  106,  106,   91,   92,   93,   94,
 /*  1750 */   106,  106,   97,   98,   91,   92,   93,   94,  106,  106,
 /*  1760 */    97,   98,
};
#define YY_SHIFT_USE_DFLT (-6)
#define YY_SHIFT_COUNT (131)
#define YY_SHIFT_MIN   (-5)
#define YY_SHIFT_MAX   (1480)
static const short yy_shift_ofst[] = {
 /*     0 */    22,   56,  357,  385,  420,  357,  420,  420,  420,  420,
 /*    10 */   119,   85,  420,  420,  420,  420,  420,  420,  420,  420,
 /*    20 */   420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
 /*    30 */   420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
 /*    40 */   420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
 /*    50 */   420,  420,  420,  420,  420,  420,  420,  420,  420,  420,
 /*    60 */   420,  420,  420,  420,  420,  420,  420,  420,  420, 1480,
 /*    70 */    91,  205,   63,  533,  454,   91,   91,   91,   91,   91,
 /*    80 */   251,   -6, 1067,  122,  122,  122,   27,   27,   27,   27,
 /*    90 */    27,   27,   27,   27,   27,   27,   27,  190,   27,  190,
 /*   100 */    27,  190,   27,  396,  390,  124,  123,  386,  121,  121,
 /*   110 */    95,  121,  106,  202,  135,  121,  106,  124,   66,   96,
 /*   120 */    -5,    1,   84,   40,   33,    4,    1,   33,    4,    1,
 /*   130 */    -3,   -5,
};
#define YY_REDUCE_USE_DFLT (-73)
#define YY_REDUCE_COUNT (81)
#define YY_REDUCE_MIN   (-72)
#define YY_REDUCE_MAX   (1663)
static const short yy_reduce_ofst[] = {
 /*     0 */   -72,  -38,  169,  140,  115,  295,  267,  245,  220,  198,
 /*    10 */   882,  860,  826,  804,  782,  748,  726,  704,  670,  648,
 /*    20 */   626,  592,  570,  548,  514,  492,  470,  435,  412,  904,
 /*    30 */   960,  938,  982, 1016, 1038, 1082, 1060, 1371, 1348, 1326,
 /*    40 */  1301, 1282, 1259, 1237, 1212, 1193, 1170, 1148, 1123, 1104,
 /*    50 */  1437, 1415, 1390, 1482, 1460, 1663, 1655, 1636, 1628, 1609,
 /*    60 */  1601, 1582, 1574, 1555, 1547, 1528, 1518, 1509, 1490,  -40,
 /*    70 */   328,  108,  273,  217,  217,  197,  193,  189,  160,  159,
 /*    80 */    73,    3,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   333,  333,  333,  333,  319,  333,  326,  333,  333,  333,
 /*    10 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    20 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    30 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    40 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    50 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    60 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*    70 */   333,  333,  297,  333,  333,  333,  333,  333,  333,  333,
 /*    80 */   333,  319,  293,  253,  255,  254,  269,  268,  267,  266,
 /*    90 */   265,  264,  263,  262,  261,  260,  256,  274,  259,  276,
 /*   100 */   258,  275,  257,  333,  333,  243,  333,  333,  270,  273,
 /*   110 */   333,  272,  251,  333,  293,  271,  252,  242,  240,  333,
 /*   120 */   303,  246,  333,  333,  249,  247,  244,  250,  248,  245,
 /*   130 */   333,  333,  329,  332,  331,  330,  220,  218,  224,  239,
 /*   140 */   238,  237,  236,  235,  234,  233,  232,  231,  230,  229,
 /*   150 */   327,  328,  325,  324,  315,  313,  312,  317,  311,  322,
 /*   160 */   321,  320,  318,  316,  314,  310,  277,  309,  308,  307,
 /*   170 */   306,  305,  304,  303,  280,  302,  301,  299,  279,  323,
 /*   180 */   225,  300,  298,  296,  295,  294,  292,  291,  290,  289,
 /*   190 */   288,  287,  286,  285,  284,  283,  282,  281,  278,  241,
 /*   200 */   228,  227,  226,  223,  222,  221,  217,  214,  219,  216,
 /*   210 */   215,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "LOGICAL_AND",   "LOGICAL_AND_NOT",
  "LOGICAL_OR",    "QSTRING",       "PARENL",        "PARENR",      
  "RELATIVE_OP",   "IDENTIFIER",    "BRACEL",        "BRACER",      
  "EVAL",          "COMMA",         "ASSIGN",        "STAR_ASSIGN", 
  "SLASH_ASSIGN",  "MOD_ASSIGN",    "PLUS_ASSIGN",   "MINUS_ASSIGN",
  "SHIFTL_ASSIGN",  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",  "AND_ASSIGN",  
  "XOR_ASSIGN",    "OR_ASSIGN",     "QUESTION",      "COLON",       
  "BITWISE_OR",    "BITWISE_XOR",   "BITWISE_AND",   "EQUAL",       
  "NOT_EQUAL",     "LESS",          "GREATER",       "LESS_EQUAL",  
  "GREATER_EQUAL",  "IN",            "MATCH",         "NEAR",        
  "NEAR2",         "SIMILAR",       "TERM_EXTRACT",  "LCP",         
  "PREFIX",        "SUFFIX",        "SHIFTL",        "SHIFTR",      
  "SHIFTRR",       "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "MOD",           "DELETE",        "INCR",        
  "DECR",          "NOT",           "BITWISE_NOT",   "ADJUST",      
  "EXACT",         "PARTIAL",       "UNSPLIT",       "DECIMAL",     
  "HEX_INTEGER",   "STRING",        "BOOLEAN",       "NULL",        
  "BRACKETL",      "BRACKETR",      "DOT",           "error",       
  "input",         "query",         "expression",    "output_columns",
  "query_element",  "primary_expression",  "assignment_expression",  "conditional_expression",
  "lefthand_side_expression",  "logical_or_expression",  "logical_and_expression",  "bitwise_or_expression",
  "bitwise_xor_expression",  "bitwise_and_expression",  "equality_expression",  "relational_expression",
  "shift_expression",  "additive_expression",  "multiplicative_expression",  "unary_expression",
  "postfix_expression",  "call_expression",  "member_expression",  "arguments",   
  "member_expression_part",  "object_literal",  "array_literal",  "elision",     
  "element_list",  "property_name_and_value_list",  "property_name_and_value",  "property_name",
  "argument_list",  "output_column",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= query",
 /*   1 */ "input ::= expression",
 /*   2 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*   3 */ "query ::= query_element",
 /*   4 */ "query ::= query query_element",
 /*   5 */ "query ::= query LOGICAL_AND query_element",
 /*   6 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   7 */ "query ::= query LOGICAL_OR query_element",
 /*   8 */ "query_element ::= QSTRING",
 /*   9 */ "query_element ::= PARENL query PARENR",
 /*  10 */ "query_element ::= RELATIVE_OP query_element",
 /*  11 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*  12 */ "query_element ::= BRACEL expression BRACER",
 /*  13 */ "query_element ::= EVAL primary_expression",
 /*  14 */ "expression ::= assignment_expression",
 /*  15 */ "expression ::= expression COMMA assignment_expression",
 /*  16 */ "assignment_expression ::= conditional_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  23 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  24 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  25 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  26 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  27 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  28 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  29 */ "conditional_expression ::= logical_or_expression",
 /*  30 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  31 */ "logical_or_expression ::= logical_and_expression",
 /*  32 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  33 */ "logical_and_expression ::= bitwise_or_expression",
 /*  34 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  35 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  36 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /*  37 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  38 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /*  39 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  40 */ "bitwise_and_expression ::= equality_expression",
 /*  41 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  42 */ "equality_expression ::= relational_expression",
 /*  43 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  44 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  45 */ "relational_expression ::= shift_expression",
 /*  46 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  47 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  48 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  49 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  50 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  51 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  52 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  53 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  54 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  55 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  56 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  57 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  58 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  59 */ "shift_expression ::= additive_expression",
 /*  60 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  61 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  62 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  63 */ "additive_expression ::= multiplicative_expression",
 /*  64 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  65 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  66 */ "multiplicative_expression ::= unary_expression",
 /*  67 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  68 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  69 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  70 */ "unary_expression ::= postfix_expression",
 /*  71 */ "unary_expression ::= DELETE unary_expression",
 /*  72 */ "unary_expression ::= INCR unary_expression",
 /*  73 */ "unary_expression ::= DECR unary_expression",
 /*  74 */ "unary_expression ::= PLUS unary_expression",
 /*  75 */ "unary_expression ::= MINUS unary_expression",
 /*  76 */ "unary_expression ::= NOT unary_expression",
 /*  77 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  78 */ "unary_expression ::= ADJUST unary_expression",
 /*  79 */ "unary_expression ::= EXACT unary_expression",
 /*  80 */ "unary_expression ::= PARTIAL unary_expression",
 /*  81 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  82 */ "postfix_expression ::= lefthand_side_expression",
 /*  83 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  84 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  85 */ "lefthand_side_expression ::= call_expression",
 /*  86 */ "lefthand_side_expression ::= member_expression",
 /*  87 */ "call_expression ::= member_expression arguments",
 /*  88 */ "member_expression ::= primary_expression",
 /*  89 */ "member_expression ::= member_expression member_expression_part",
 /*  90 */ "primary_expression ::= object_literal",
 /*  91 */ "primary_expression ::= PARENL expression PARENR",
 /*  92 */ "primary_expression ::= IDENTIFIER",
 /*  93 */ "primary_expression ::= array_literal",
 /*  94 */ "primary_expression ::= DECIMAL",
 /*  95 */ "primary_expression ::= HEX_INTEGER",
 /*  96 */ "primary_expression ::= STRING",
 /*  97 */ "primary_expression ::= BOOLEAN",
 /*  98 */ "primary_expression ::= NULL",
 /*  99 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 100 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 101 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 102 */ "elision ::= COMMA",
 /* 103 */ "elision ::= elision COMMA",
 /* 104 */ "element_list ::= assignment_expression",
 /* 105 */ "element_list ::= elision assignment_expression",
 /* 106 */ "element_list ::= element_list elision assignment_expression",
 /* 107 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /* 108 */ "property_name_and_value_list ::=",
 /* 109 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 110 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /* 111 */ "property_name ::= IDENTIFIER|STRING|DECIMAL",
 /* 112 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /* 113 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 114 */ "arguments ::= PARENL argument_list PARENR",
 /* 115 */ "argument_list ::=",
 /* 116 */ "argument_list ::= assignment_expression",
 /* 117 */ "argument_list ::= argument_list COMMA assignment_expression",
 /* 118 */ "output_columns ::= output_column",
 /* 119 */ "output_columns ::= output_columns COMMA output_column",
 /* 120 */ "output_column ::= STAR",
 /* 121 */ "output_column ::= assignment_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from grn_expr_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   grn_expr_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 72, 1 },
  { 72, 1 },
  { 72, 2 },
  { 73, 1 },
  { 73, 2 },
  { 73, 3 },
  { 73, 3 },
  { 73, 3 },
  { 76, 1 },
  { 76, 3 },
  { 76, 2 },
  { 76, 3 },
  { 76, 3 },
  { 76, 2 },
  { 74, 1 },
  { 74, 3 },
  { 78, 1 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 78, 3 },
  { 79, 1 },
  { 79, 5 },
  { 81, 1 },
  { 81, 3 },
  { 82, 1 },
  { 82, 3 },
  { 82, 3 },
  { 83, 1 },
  { 83, 3 },
  { 84, 1 },
  { 84, 3 },
  { 85, 1 },
  { 85, 3 },
  { 86, 1 },
  { 86, 3 },
  { 86, 3 },
  { 87, 1 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 87, 3 },
  { 88, 1 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 89, 1 },
  { 89, 3 },
  { 89, 3 },
  { 90, 1 },
  { 90, 3 },
  { 90, 3 },
  { 90, 3 },
  { 91, 1 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 91, 2 },
  { 92, 1 },
  { 92, 2 },
  { 92, 2 },
  { 80, 1 },
  { 80, 1 },
  { 93, 2 },
  { 94, 1 },
  { 94, 2 },
  { 77, 1 },
  { 77, 3 },
  { 77, 1 },
  { 77, 1 },
  { 77, 1 },
  { 77, 1 },
  { 77, 1 },
  { 77, 1 },
  { 77, 1 },
  { 98, 3 },
  { 98, 4 },
  { 98, 3 },
  { 99, 1 },
  { 99, 2 },
  { 100, 1 },
  { 100, 2 },
  { 100, 3 },
  { 97, 3 },
  { 101, 0 },
  { 101, 3 },
  { 102, 3 },
  { 103, 1 },
  { 96, 3 },
  { 96, 2 },
  { 95, 3 },
  { 104, 0 },
  { 104, 1 },
  { 104, 3 },
  { 75, 1 },
  { 75, 3 },
  { 105, 1 },
  { 105, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 4: /* query ::= query query_element */
#line 30 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1305 "ecmascript.c"
        break;
      case 5: /* query ::= query LOGICAL_AND query_element */
      case 34: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==34);
#line 33 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1313 "ecmascript.c"
        break;
      case 6: /* query ::= query LOGICAL_AND_NOT query_element */
      case 35: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==35);
#line 36 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1321 "ecmascript.c"
        break;
      case 7: /* query ::= query LOGICAL_OR query_element */
      case 32: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==32);
#line 39 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1329 "ecmascript.c"
        break;
      case 10: /* query_element ::= RELATIVE_OP query_element */
#line 46 "ecmascript.y"
{
  int mode;
  GRN_UINT32_POP(&efsi->mode_stack, mode);
}
#line 1337 "ecmascript.c"
        break;
      case 11: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 50 "ecmascript.y"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_UINT32_POP(&efsi->mode_stack, mode);
}
#line 1347 "ecmascript.c"
        break;
      case 12: /* query_element ::= BRACEL expression BRACER */
      case 13: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==13);
#line 56 "ecmascript.y"
{
  efsi->flags = efsi->default_flags;
}
#line 1355 "ecmascript.c"
        break;
      case 15: /* expression ::= expression COMMA assignment_expression */
      case 119: /* output_columns ::= output_columns COMMA output_column */ yytestcase(yyruleno==119);
#line 64 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1363 "ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 69 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1370 "ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 72 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1377 "ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 75 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1384 "ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 78 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1391 "ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 81 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1398 "ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 84 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1405 "ecmascript.c"
        break;
      case 23: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 87 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1412 "ecmascript.c"
        break;
      case 24: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 90 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1419 "ecmascript.c"
        break;
      case 25: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 93 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1426 "ecmascript.c"
        break;
      case 26: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 96 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1433 "ecmascript.c"
        break;
      case 27: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 99 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1440 "ecmascript.c"
        break;
      case 28: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 102 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1447 "ecmascript.c"
        break;
      case 30: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 107 "ecmascript.y"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1456 "ecmascript.c"
        break;
      case 37: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 127 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1463 "ecmascript.c"
        break;
      case 39: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 132 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1470 "ecmascript.c"
        break;
      case 41: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 137 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1477 "ecmascript.c"
        break;
      case 43: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 142 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1484 "ecmascript.c"
        break;
      case 44: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 145 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1491 "ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression LESS shift_expression */
#line 150 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1498 "ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 153 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1505 "ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 156 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1512 "ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 159 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1519 "ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression IN shift_expression */
#line 162 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1526 "ecmascript.c"
        break;
      case 51: /* relational_expression ::= relational_expression MATCH shift_expression */
#line 165 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1533 "ecmascript.c"
        break;
      case 52: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 168 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 2);
}
#line 1540 "ecmascript.c"
        break;
      case 53: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 171 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1547 "ecmascript.c"
        break;
      case 54: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 174 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 2);
}
#line 1554 "ecmascript.c"
        break;
      case 55: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 177 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1561 "ecmascript.c"
        break;
      case 56: /* relational_expression ::= relational_expression LCP shift_expression */
#line 180 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1568 "ecmascript.c"
        break;
      case 57: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 183 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1575 "ecmascript.c"
        break;
      case 58: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 186 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1582 "ecmascript.c"
        break;
      case 60: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 191 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1589 "ecmascript.c"
        break;
      case 61: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 194 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1596 "ecmascript.c"
        break;
      case 62: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 197 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1603 "ecmascript.c"
        break;
      case 64: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
#line 202 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1610 "ecmascript.c"
        break;
      case 65: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 205 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1617 "ecmascript.c"
        break;
      case 67: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
#line 210 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1624 "ecmascript.c"
        break;
      case 68: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 213 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1631 "ecmascript.c"
        break;
      case 69: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 216 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1638 "ecmascript.c"
        break;
      case 71: /* unary_expression ::= DELETE unary_expression */
#line 221 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1645 "ecmascript.c"
        break;
      case 72: /* unary_expression ::= INCR unary_expression */
#line 224 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1666 "ecmascript.c"
        break;
      case 73: /* unary_expression ::= DECR unary_expression */
#line 241 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1687 "ecmascript.c"
        break;
      case 74: /* unary_expression ::= PLUS unary_expression */
#line 258 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1694 "ecmascript.c"
        break;
      case 75: /* unary_expression ::= MINUS unary_expression */
#line 261 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1701 "ecmascript.c"
        break;
      case 76: /* unary_expression ::= NOT unary_expression */
#line 264 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1708 "ecmascript.c"
        break;
      case 77: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 267 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1715 "ecmascript.c"
        break;
      case 78: /* unary_expression ::= ADJUST unary_expression */
#line 270 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1722 "ecmascript.c"
        break;
      case 79: /* unary_expression ::= EXACT unary_expression */
#line 273 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1729 "ecmascript.c"
        break;
      case 80: /* unary_expression ::= PARTIAL unary_expression */
#line 276 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1736 "ecmascript.c"
        break;
      case 81: /* unary_expression ::= UNSPLIT unary_expression */
#line 279 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1743 "ecmascript.c"
        break;
      case 83: /* postfix_expression ::= lefthand_side_expression INCR */
#line 284 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 1764 "ecmascript.c"
        break;
      case 84: /* postfix_expression ::= lefthand_side_expression DECR */
#line 301 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 1785 "ecmascript.c"
        break;
      case 87: /* call_expression ::= member_expression arguments */
#line 322 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 1792 "ecmascript.c"
        break;
      case 114: /* arguments ::= PARENL argument_list PARENR */
#line 361 "ecmascript.y"
{ yygotominor.yy0 = yymsp[-1].minor.yy0; }
#line 1797 "ecmascript.c"
        break;
      case 115: /* argument_list ::= */
#line 362 "ecmascript.y"
{ yygotominor.yy0 = 0; }
#line 1802 "ecmascript.c"
        break;
      case 116: /* argument_list ::= assignment_expression */
#line 363 "ecmascript.y"
{ yygotominor.yy0 = 1; }
#line 1807 "ecmascript.c"
        break;
      case 117: /* argument_list ::= argument_list COMMA assignment_expression */
#line 364 "ecmascript.y"
{ yygotominor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 1812 "ecmascript.c"
        break;
      case 120: /* output_column ::= STAR */
#line 371 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ALL_COLUMNS, 0);
}
#line 1819 "ecmascript.c"
        break;
      default:
      /* (0) input ::= query */ yytestcase(yyruleno==0);
      /* (1) input ::= expression */ yytestcase(yyruleno==1);
      /* (2) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==2);
      /* (3) query ::= query_element */ yytestcase(yyruleno==3);
      /* (8) query_element ::= QSTRING */ yytestcase(yyruleno==8);
      /* (9) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==9);
      /* (14) expression ::= assignment_expression */ yytestcase(yyruleno==14);
      /* (16) assignment_expression ::= conditional_expression */ yytestcase(yyruleno==16);
      /* (29) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==29);
      /* (31) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==31);
      /* (33) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==33);
      /* (36) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==36);
      /* (38) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==38);
      /* (40) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==40);
      /* (42) equality_expression ::= relational_expression */ yytestcase(yyruleno==42);
      /* (45) relational_expression ::= shift_expression */ yytestcase(yyruleno==45);
      /* (59) shift_expression ::= additive_expression */ yytestcase(yyruleno==59);
      /* (63) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==63);
      /* (66) multiplicative_expression ::= unary_expression */ yytestcase(yyruleno==66);
      /* (70) unary_expression ::= postfix_expression */ yytestcase(yyruleno==70);
      /* (82) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==82);
      /* (85) lefthand_side_expression ::= call_expression */ yytestcase(yyruleno==85);
      /* (86) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==86);
      /* (88) member_expression ::= primary_expression */ yytestcase(yyruleno==88);
      /* (89) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==89);
      /* (90) primary_expression ::= object_literal */ yytestcase(yyruleno==90);
      /* (91) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==91);
      /* (92) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==92);
      /* (93) primary_expression ::= array_literal */ yytestcase(yyruleno==93);
      /* (94) primary_expression ::= DECIMAL */ yytestcase(yyruleno==94);
      /* (95) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==95);
      /* (96) primary_expression ::= STRING */ yytestcase(yyruleno==96);
      /* (97) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==97);
      /* (98) primary_expression ::= NULL */ yytestcase(yyruleno==98);
      /* (99) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==99);
      /* (100) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==100);
      /* (101) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==101);
      /* (102) elision ::= COMMA */ yytestcase(yyruleno==102);
      /* (103) elision ::= elision COMMA */ yytestcase(yyruleno==103);
      /* (104) element_list ::= assignment_expression */ yytestcase(yyruleno==104);
      /* (105) element_list ::= elision assignment_expression */ yytestcase(yyruleno==105);
      /* (106) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==106);
      /* (107) object_literal ::= BRACEL property_name_and_value_list BRACER */ yytestcase(yyruleno==107);
      /* (108) property_name_and_value_list ::= */ yytestcase(yyruleno==108);
      /* (109) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==109);
      /* (110) property_name_and_value ::= property_name COLON assignment_expression */ yytestcase(yyruleno==110);
      /* (111) property_name ::= IDENTIFIER|STRING|DECIMAL */ yytestcase(yyruleno==111);
      /* (112) member_expression_part ::= BRACKETL expression BRACKETR */ yytestcase(yyruleno==112);
      /* (113) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==113);
      /* (118) output_columns ::= output_column */ yytestcase(yyruleno==118);
      /* (121) output_column ::= assignment_expression */ yytestcase(yyruleno==121);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 11 "ecmascript.y"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj buf;
    if (ctx->rc == GRN_SUCCESS) {
      GRN_TEXT_INIT(&buf, 0);
      GRN_TEXT_PUT(ctx, &buf, efsi->str, efsi->str_end - efsi->str);
      GRN_TEXT_PUTC(ctx, &buf, '\0');
      ERR(GRN_SYNTAX_ERROR, "Syntax error! (%s)", GRN_TEXT_VALUE(&buf));
      GRN_OBJ_FIN(ctx, &buf);
    }
  }
#line 1945 "ecmascript.c"
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
