/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>
#line 3 "ecmascript.y"

#define assert GRN_ASSERT
#line 11 "ecmascript.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    grn_expr_parserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 108
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE 212
#define YYNRULE 124
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1756)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   337,   74,  104,   76,  208,  178,  181,  202,   82,  118,
 /*    10 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  167,
 /*    20 */   198,  184,   72,    2,   25,  177,  173,  209,    1,   32,
 /*    30 */    77,  120,    4,   33,   69,   73,  110,  139,  208,  178,
 /*    40 */   181,  202,   82,  118,  117,  126,  125,  124,  112,   83,
 /*    50 */    96,  108,   97,  167,  198,  184,   72,  177,  173,  177,
 /*    60 */   173,  209,    1,   34,   77,  120,    4,   24,   69,    6,
 /*    70 */    29,   64,   63,   52,   51,   50,   67,   66,   65,   62,
 /*    80 */    61,   60,   59,   58,   57,  172,  171,  170,  169,  168,
 /*    90 */     3,    7,   26,  154,  174,   81,  209,   70,  165,   77,
 /*   100 */   131,    9,  176,   69,  107,   64,   63,  204,   28,   28,
 /*   110 */    67,   66,   65,   62,   61,   60,   59,   58,   57,  172,
 /*   120 */   171,  170,  169,  168,    3,    7,   31,   30,  174,   81,
 /*   130 */    10,    8,  165,  122,   64,   63,   54,   53,  160,   67,
 /*   140 */    66,   65,   62,   61,   60,   59,   58,   57,  172,  171,
 /*   150 */   170,  169,  168,    3,  166,    7,   36,   35,  174,   81,
 /*   160 */   210,  153,   68,   56,   55,  186,  185,   23,   64,   63,
 /*   170 */   163,  207,   71,   67,   66,   65,   62,   61,   60,   59,
 /*   180 */    58,   57,  172,  171,  170,  169,  168,    3,  159,  213,
 /*   190 */    28,  206,  160,  205,  160,  183,  182,  138,   64,   63,
 /*   200 */   135,  338,   28,   67,   66,   65,   62,   61,   60,   59,
 /*   210 */    58,   57,  172,  171,  170,  169,  168,    3,  119,  211,
 /*   220 */   134,  178,  181,  202,   82,  118,  117,  126,  125,  124,
 /*   230 */   112,   83,   96,  108,   97,  167,  198,  184,   72,  156,
 /*   240 */   338,  177,  173,  162,  123,  107,  180,  178,  155,  202,
 /*   250 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   260 */    97,  167,  198,  184,   72,  338,  338,  177,  173,   11,
 /*   270 */    80,   73,  338,  338,  208,  103,  338,  178,  133,  202,
 /*   280 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   290 */    97,  167,  198,  184,   72,  157,  338,  177,  173,  338,
 /*   300 */   338,  338,  338,  119,  338,  132,  178,  181,  202,   82,
 /*   310 */   118,  117,  126,  125,  124,  112,   83,   96,  108,   97,
 /*   320 */   167,  198,  184,   72,  338,  113,  177,  173,  178,  181,
 /*   330 */   202,   82,  118,  117,  126,  125,  124,  112,   83,   96,
 /*   340 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*   350 */   338,  110,  338,  338,  178,  181,  202,   82,  118,  117,
 /*   360 */   126,  125,  124,  112,   83,   96,  108,   97,  167,  198,
 /*   370 */   184,   72,  338,  338,  177,  173,  178,  151,  202,   82,
 /*   380 */   118,  117,  126,  125,  124,  112,   83,   96,  108,   97,
 /*   390 */   167,  198,  184,   72,  338,    7,  177,  173,  174,   81,
 /*   400 */   338,  338,  156,  106,  178,  133,  202,   82,  118,  117,
 /*   410 */   126,  125,  124,  112,   83,   96,  108,   97,  167,  198,
 /*   420 */   184,   72,  214,    7,  177,  173,  174,   81,  338,  338,
 /*   430 */   338,  338,  136,  338,  338,    5,  338,  338,   64,   63,
 /*   440 */   338,  338,  338,   67,   66,   65,   62,   61,   60,   59,
 /*   450 */    58,   57,  172,  171,  170,  169,  168,    3,  338,  338,
 /*   460 */   338,  338,  338,  338,  338,  338,   64,   63,  338,  338,
 /*   470 */   338,   67,   66,   65,   62,   61,   60,   59,   58,   57,
 /*   480 */   172,  171,  170,  169,  168,    3,  178,  203,  202,   82,
 /*   490 */   118,  117,  126,  125,  124,  112,   83,   96,  108,   97,
 /*   500 */   167,  198,  184,   72,  338,  338,  177,  173,  338,  338,
 /*   510 */   338,  178,  201,  202,   82,  118,  117,  126,  125,  124,
 /*   520 */   112,   83,   96,  108,   97,  167,  198,  184,   72,  338,
 /*   530 */   338,  177,  173,  178,  130,  202,   82,  118,  117,  126,
 /*   540 */   125,  124,  112,   83,   96,  108,   97,  167,  198,  184,
 /*   550 */    72,  338,  338,  177,  173,  178,  200,  202,   82,  118,
 /*   560 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  167,
 /*   570 */   198,  184,   72,  338,  338,  177,  173,  178,  161,  202,
 /*   580 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   590 */    97,  167,  198,  184,   72,  338,  338,  177,  173,  178,
 /*   600 */   152,  202,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   610 */    96,  108,   97,  167,  198,  184,   72,  338,  338,  177,
 /*   620 */   173,  178,  150,  202,   82,  118,  117,  126,  125,  124,
 /*   630 */   112,   83,   96,  108,   97,  167,  198,  184,   72,  338,
 /*   640 */   338,  177,  173,  178,  149,  202,   82,  118,  117,  126,
 /*   650 */   125,  124,  112,   83,   96,  108,   97,  167,  198,  184,
 /*   660 */    72,  338,  338,  177,  173,  178,  148,  202,   82,  118,
 /*   670 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  167,
 /*   680 */   198,  184,   72,  338,  338,  177,  173,  178,  147,  202,
 /*   690 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   700 */    97,  167,  198,  184,   72,  338,  338,  177,  173,  178,
 /*   710 */   146,  202,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   720 */    96,  108,   97,  167,  198,  184,   72,  338,  338,  177,
 /*   730 */   173,  178,  145,  202,   82,  118,  117,  126,  125,  124,
 /*   740 */   112,   83,   96,  108,   97,  167,  198,  184,   72,  338,
 /*   750 */   338,  177,  173,  178,  144,  202,   82,  118,  117,  126,
 /*   760 */   125,  124,  112,   83,   96,  108,   97,  167,  198,  184,
 /*   770 */    72,  338,  338,  177,  173,  178,  143,  202,   82,  118,
 /*   780 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  167,
 /*   790 */   198,  184,   72,  338,  338,  177,  173,  178,  142,  202,
 /*   800 */    82,  118,  117,  126,  125,  124,  112,   83,   96,  108,
 /*   810 */    97,  167,  198,  184,   72,  338,  338,  177,  173,  178,
 /*   820 */   141,  202,   82,  118,  117,  126,  125,  124,  112,   83,
 /*   830 */    96,  108,   97,  167,  198,  184,   72,  338,  338,  177,
 /*   840 */   173,  178,  140,  202,   82,  118,  117,  126,  125,  124,
 /*   850 */   112,   83,   96,  108,   97,  167,  198,  184,   72,  338,
 /*   860 */   338,  177,  173,  178,  164,  202,   82,  118,  117,  126,
 /*   870 */   125,  124,  112,   83,   96,  108,   97,  167,  198,  184,
 /*   880 */    72,  338,  338,  177,  173,  178,  158,  202,   82,  118,
 /*   890 */   117,  126,  125,  124,  112,   83,   96,  108,   97,  167,
 /*   900 */   198,  184,   72,  338,  178,  177,  173,  114,  338,  105,
 /*   910 */   126,  125,  124,  112,   83,   96,  108,   97,  167,  198,
 /*   920 */   184,   72,  338,  178,  177,  173,  114,  338,  338,  129,
 /*   930 */   125,  124,  112,   83,   96,  108,   97,  167,  198,  184,
 /*   940 */    72,  338,  178,  177,  173,  114,  338,  338,  121,  125,
 /*   950 */   124,  112,   83,   96,  108,   97,  167,  198,  184,   72,
 /*   960 */   338,  338,  177,  173,  178,  338,  338,  114,  338,  338,
 /*   970 */   338,  128,  124,  112,   83,   96,  108,   97,  167,  198,
 /*   980 */   184,   72,  338,  338,  177,  173,   27,   22,   21,   20,
 /*   990 */    19,   18,   17,   16,   15,   14,   13,   12,  178,  338,
 /*  1000 */   338,  114,  338,  338,  338,  338,  127,  112,   83,   96,
 /*  1010 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1020 */   338,  338,  338,  338,  338,  338,  338,  186,  185,   49,
 /*  1030 */    48,   47,   46,   45,   44,   43,   42,   41,   40,   39,
 /*  1040 */    38,   37,  178,  338,  338,  114,  338,  338,  338,  338,
 /*  1050 */   338,  116,   83,   96,  108,   97,  167,  198,  184,   72,
 /*  1060 */   338,  338,  177,  173,  178,  338,  338,  114,  338,  338,
 /*  1070 */   338,  338,  338,  338,   85,   96,  108,   97,  167,  198,
 /*  1080 */   184,   72,  338,  338,  177,  173,  178,  338,  338,  114,
 /*  1090 */   338,  338,  338,  338,  338,  338,   84,   96,  108,   97,
 /*  1100 */   167,  198,  184,   72,  338,  338,  177,  173,  178,  338,
 /*  1110 */   338,  114,  338,  338,  338,  338,  338,  338,  338,  102,
 /*  1120 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1130 */   178,  338,  338,  114,  338,  338,  338,  338,  338,  338,
 /*  1140 */   338,  100,  108,   97,  167,  198,  184,   72,  338,  338,
 /*  1150 */   177,  173,  338,  178,  338,  338,  114,  338,  338,  338,
 /*  1160 */   338,  338,  338,  338,   98,  108,   97,  167,  198,  184,
 /*  1170 */    72,  338,  338,  177,  173,  178,  338,  338,  114,  338,
 /*  1180 */   338,  338,  338,  338,  338,  338,   95,  108,   97,  167,
 /*  1190 */   198,  184,   72,  338,  338,  177,  173,  338,  178,  338,
 /*  1200 */   338,  114,  338,  338,  338,  338,  338,  338,  338,   94,
 /*  1210 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1220 */   178,  338,  338,  114,  338,  338,  338,  338,  338,  338,
 /*  1230 */   338,   93,  108,   97,  167,  198,  184,   72,  338,  338,
 /*  1240 */   177,  173,  338,  178,  338,  338,  114,  338,  338,  338,
 /*  1250 */   338,  338,  338,  338,   92,  108,   97,  167,  198,  184,
 /*  1260 */    72,  338,  338,  177,  173,  178,  338,  338,  114,  338,
 /*  1270 */   338,  338,  338,  338,  338,  338,   91,  108,   97,  167,
 /*  1280 */   198,  184,   72,  338,  338,  177,  173,  338,  178,  338,
 /*  1290 */   338,  114,  338,  338,  338,  338,  338,  338,  338,   90,
 /*  1300 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1310 */   178,  338,  338,  114,  338,  338,  338,  338,  338,  338,
 /*  1320 */   338,   89,  108,   97,  167,  198,  184,   72,  338,  338,
 /*  1330 */   177,  173,  338,  178,  338,  338,  114,  338,  338,  338,
 /*  1340 */   338,  338,  338,  338,   88,  108,   97,  167,  198,  184,
 /*  1350 */    72,  338,  338,  177,  173,  178,  338,  338,  114,  338,
 /*  1360 */   338,  338,  338,  338,  338,  338,   87,  108,   97,  167,
 /*  1370 */   198,  184,   72,  338,  338,  177,  173,  338,  178,  338,
 /*  1380 */   338,  114,  338,  338,  338,  338,  338,  338,  338,   86,
 /*  1390 */   108,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1400 */   212,  338,   79,   78,   75,  209,   70,  338,   77,  131,
 /*  1410 */     9,  338,   69,   79,   78,   75,  209,   70,  137,   77,
 /*  1420 */   131,    9,  338,   69,  178,  338,  338,  114,  338,  338,
 /*  1430 */   338,  338,  338,  338,  338,  338,  115,   97,  167,  198,
 /*  1440 */   184,   72,  338,  338,  177,  173,  178,    7,  338,  114,
 /*  1450 */   174,   81,  338,  338,  338,  338,  338,  338,  111,   97,
 /*  1460 */   167,  198,  184,   72,  338,  338,  177,  173,  178,  338,
 /*  1470 */   338,  114,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  1480 */   109,   97,  167,  198,  184,   72,  338,  338,  177,  173,
 /*  1490 */   338,  338,  338,  338,  338,  338,  338,  178,  338,  338,
 /*  1500 */   114,  338,  338,  338,  172,  171,  170,  169,  168,    3,
 /*  1510 */   101,  167,  198,  184,   72,  338,  178,  177,  173,  114,
 /*  1520 */   338,  338,  338,  338,  178,  338,  338,  114,  338,   99,
 /*  1530 */   167,  198,  184,   72,  338,  338,  177,  173,  199,  198,
 /*  1540 */   184,   72,  338,  338,  177,  173,  178,  338,  338,  114,
 /*  1550 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  1560 */   197,  198,  184,   72,  338,  338,  177,  173,  178,  338,
 /*  1570 */   338,  114,  338,  338,  338,  338,  178,  338,  338,  114,
 /*  1580 */   338,  338,  196,  198,  184,   72,  338,  338,  177,  173,
 /*  1590 */   195,  198,  184,   72,  338,  178,  177,  173,  114,  338,
 /*  1600 */   338,  338,  338,  178,  338,  338,  114,  338,  338,  194,
 /*  1610 */   198,  184,   72,  338,  338,  177,  173,  193,  198,  184,
 /*  1620 */    72,  338,  338,  177,  173,  178,  338,  338,  114,  338,
 /*  1630 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  192,
 /*  1640 */   198,  184,   72,  338,  338,  177,  173,  178,  338,  338,
 /*  1650 */   114,  338,  338,  338,  338,  178,  338,  338,  114,  338,
 /*  1660 */   338,  191,  198,  184,   72,  338,  338,  177,  173,  190,
 /*  1670 */   198,  184,   72,  338,  178,  177,  173,  114,  338,  338,
 /*  1680 */   338,  338,  178,  338,  338,  114,  338,  338,  189,  198,
 /*  1690 */   184,   72,  338,  338,  177,  173,  188,  198,  184,   72,
 /*  1700 */   338,  338,  177,  173,  178,  338,  338,  114,  338,  338,
 /*  1710 */   338,  338,  338,  338,  338,  338,  338,  338,  187,  198,
 /*  1720 */   184,   72,  338,  338,  177,  173,  178,  338,  338,  114,
 /*  1730 */   338,  338,  338,  338,  178,  338,  338,  114,  338,  338,
 /*  1740 */   179,  198,  184,   72,  338,  338,  177,  173,  175,  198,
 /*  1750 */   184,   72,  338,  338,  177,  173,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    73,   74,   75,    8,   77,   78,   79,   80,   81,   82,
 /*    10 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*    20 */    93,   94,   95,    1,   27,   98,   99,    5,    6,   28,
 /*    30 */     8,    9,   10,   29,   12,   74,   75,   78,   77,   78,
 /*    40 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    50 */    89,   90,   91,   92,   93,   94,   95,   98,   99,   98,
 /*    60 */    99,    5,    6,   30,    8,    9,   10,   27,   12,    6,
 /*    70 */     4,   49,   50,   46,   47,   48,   54,   55,   56,   57,
 /*    80 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*    90 */    68,    6,   26,    9,    9,   10,    5,    6,   13,    8,
 /*   100 */     9,   10,    7,   12,  102,   49,   50,   11,   13,   13,
 /*   110 */    54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   120 */    64,   65,   66,   67,   68,    6,    2,    3,    9,   10,
 /*   130 */   100,   68,   13,   70,   49,   50,   49,   50,    9,   54,
 /*   140 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   150 */    65,   66,   67,   68,   69,    6,   31,   32,    9,   10,
 /*   160 */    77,    7,   51,   52,   53,   55,   56,   13,   49,   50,
 /*   170 */    11,   77,   13,   54,   55,   56,   57,   58,   59,   60,
 /*   180 */    61,   62,   63,   64,   65,   66,   67,   68,   69,    0,
 /*   190 */    13,   77,   63,   77,   65,   96,   97,   77,   49,   50,
 /*   200 */    51,  107,   13,   54,   55,   56,   57,   58,   59,   60,
 /*   210 */    61,   62,   63,   64,   65,   66,   67,   68,   75,   77,
 /*   220 */    71,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   230 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   13,
 /*   240 */   107,   98,   99,  103,  104,  102,   69,   78,   79,   80,
 /*   250 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   260 */    91,   92,   93,   94,   95,  107,  107,   98,   99,  100,
 /*   270 */   101,   74,  107,  107,   77,   76,  107,   78,   79,   80,
 /*   280 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   290 */    91,   92,   93,   94,   95,   69,  107,   98,   99,  107,
 /*   300 */   107,  107,  107,   75,  107,  106,   78,   79,   80,   81,
 /*   310 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   320 */    92,   93,   94,   95,  107,   75,   98,   99,   78,   79,
 /*   330 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   340 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*   350 */   107,   75,  107,  107,   78,   79,   80,   81,   82,   83,
 /*   360 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   370 */    94,   95,  107,  107,   98,   99,   78,   79,   80,   81,
 /*   380 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   390 */    92,   93,   94,   95,  107,    6,   98,   99,    9,   10,
 /*   400 */   107,  107,   13,  105,   78,   79,   80,   81,   82,   83,
 /*   410 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   420 */    94,   95,    0,    6,   98,   99,    9,   10,  107,  107,
 /*   430 */   107,  107,  106,  107,  107,   13,  107,  107,   49,   50,
 /*   440 */   107,  107,  107,   54,   55,   56,   57,   58,   59,   60,
 /*   450 */    61,   62,   63,   64,   65,   66,   67,   68,  107,  107,
 /*   460 */   107,  107,  107,  107,  107,  107,   49,   50,  107,  107,
 /*   470 */   107,   54,   55,   56,   57,   58,   59,   60,   61,   62,
 /*   480 */    63,   64,   65,   66,   67,   68,   78,   79,   80,   81,
 /*   490 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   500 */    92,   93,   94,   95,  107,  107,   98,   99,  107,  107,
 /*   510 */   107,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   520 */    87,   88,   89,   90,   91,   92,   93,   94,   95,  107,
 /*   530 */   107,   98,   99,   78,   79,   80,   81,   82,   83,   84,
 /*   540 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   550 */    95,  107,  107,   98,   99,   78,   79,   80,   81,   82,
 /*   560 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   570 */    93,   94,   95,  107,  107,   98,   99,   78,   79,   80,
 /*   580 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   590 */    91,   92,   93,   94,   95,  107,  107,   98,   99,   78,
 /*   600 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   610 */    89,   90,   91,   92,   93,   94,   95,  107,  107,   98,
 /*   620 */    99,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   630 */    87,   88,   89,   90,   91,   92,   93,   94,   95,  107,
 /*   640 */   107,   98,   99,   78,   79,   80,   81,   82,   83,   84,
 /*   650 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   660 */    95,  107,  107,   98,   99,   78,   79,   80,   81,   82,
 /*   670 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   680 */    93,   94,   95,  107,  107,   98,   99,   78,   79,   80,
 /*   690 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   700 */    91,   92,   93,   94,   95,  107,  107,   98,   99,   78,
 /*   710 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   720 */    89,   90,   91,   92,   93,   94,   95,  107,  107,   98,
 /*   730 */    99,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   740 */    87,   88,   89,   90,   91,   92,   93,   94,   95,  107,
 /*   750 */   107,   98,   99,   78,   79,   80,   81,   82,   83,   84,
 /*   760 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   770 */    95,  107,  107,   98,   99,   78,   79,   80,   81,   82,
 /*   780 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   790 */    93,   94,   95,  107,  107,   98,   99,   78,   79,   80,
 /*   800 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   810 */    91,   92,   93,   94,   95,  107,  107,   98,   99,   78,
 /*   820 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   830 */    89,   90,   91,   92,   93,   94,   95,  107,  107,   98,
 /*   840 */    99,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   850 */    87,   88,   89,   90,   91,   92,   93,   94,   95,  107,
 /*   860 */   107,   98,   99,   78,   79,   80,   81,   82,   83,   84,
 /*   870 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   880 */    95,  107,  107,   98,   99,   78,   79,   80,   81,   82,
 /*   890 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   900 */    93,   94,   95,  107,   78,   98,   99,   81,  107,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   920 */    94,   95,  107,   78,   98,   99,   81,  107,  107,   84,
 /*   930 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   940 */    95,  107,   78,   98,   99,   81,  107,  107,   84,   85,
 /*   950 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   960 */   107,  107,   98,   99,   78,  107,  107,   81,  107,  107,
 /*   970 */   107,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*   980 */    94,   95,  107,  107,   98,   99,   14,   15,   16,   17,
 /*   990 */    18,   19,   20,   21,   22,   23,   24,   25,   78,  107,
 /*  1000 */   107,   81,  107,  107,  107,  107,   86,   87,   88,   89,
 /*  1010 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1020 */   107,  107,  107,  107,  107,  107,  107,   55,   56,   33,
 /*  1030 */    34,   35,   36,   37,   38,   39,   40,   41,   42,   43,
 /*  1040 */    44,   45,   78,  107,  107,   81,  107,  107,  107,  107,
 /*  1050 */   107,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  1060 */   107,  107,   98,   99,   78,  107,  107,   81,  107,  107,
 /*  1070 */   107,  107,  107,  107,   88,   89,   90,   91,   92,   93,
 /*  1080 */    94,   95,  107,  107,   98,   99,   78,  107,  107,   81,
 /*  1090 */   107,  107,  107,  107,  107,  107,   88,   89,   90,   91,
 /*  1100 */    92,   93,   94,   95,  107,  107,   98,   99,   78,  107,
 /*  1110 */   107,   81,  107,  107,  107,  107,  107,  107,  107,   89,
 /*  1120 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1130 */    78,  107,  107,   81,  107,  107,  107,  107,  107,  107,
 /*  1140 */   107,   89,   90,   91,   92,   93,   94,   95,  107,  107,
 /*  1150 */    98,   99,  107,   78,  107,  107,   81,  107,  107,  107,
 /*  1160 */   107,  107,  107,  107,   89,   90,   91,   92,   93,   94,
 /*  1170 */    95,  107,  107,   98,   99,   78,  107,  107,   81,  107,
 /*  1180 */   107,  107,  107,  107,  107,  107,   89,   90,   91,   92,
 /*  1190 */    93,   94,   95,  107,  107,   98,   99,  107,   78,  107,
 /*  1200 */   107,   81,  107,  107,  107,  107,  107,  107,  107,   89,
 /*  1210 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1220 */    78,  107,  107,   81,  107,  107,  107,  107,  107,  107,
 /*  1230 */   107,   89,   90,   91,   92,   93,   94,   95,  107,  107,
 /*  1240 */    98,   99,  107,   78,  107,  107,   81,  107,  107,  107,
 /*  1250 */   107,  107,  107,  107,   89,   90,   91,   92,   93,   94,
 /*  1260 */    95,  107,  107,   98,   99,   78,  107,  107,   81,  107,
 /*  1270 */   107,  107,  107,  107,  107,  107,   89,   90,   91,   92,
 /*  1280 */    93,   94,   95,  107,  107,   98,   99,  107,   78,  107,
 /*  1290 */   107,   81,  107,  107,  107,  107,  107,  107,  107,   89,
 /*  1300 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1310 */    78,  107,  107,   81,  107,  107,  107,  107,  107,  107,
 /*  1320 */   107,   89,   90,   91,   92,   93,   94,   95,  107,  107,
 /*  1330 */    98,   99,  107,   78,  107,  107,   81,  107,  107,  107,
 /*  1340 */   107,  107,  107,  107,   89,   90,   91,   92,   93,   94,
 /*  1350 */    95,  107,  107,   98,   99,   78,  107,  107,   81,  107,
 /*  1360 */   107,  107,  107,  107,  107,  107,   89,   90,   91,   92,
 /*  1370 */    93,   94,   95,  107,  107,   98,   99,  107,   78,  107,
 /*  1380 */   107,   81,  107,  107,  107,  107,  107,  107,  107,   89,
 /*  1390 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1400 */     0,  107,    2,    3,    4,    5,    6,  107,    8,    9,
 /*  1410 */    10,  107,   12,    2,    3,    4,    5,    6,    7,    8,
 /*  1420 */     9,   10,  107,   12,   78,  107,  107,   81,  107,  107,
 /*  1430 */   107,  107,  107,  107,  107,  107,   90,   91,   92,   93,
 /*  1440 */    94,   95,  107,  107,   98,   99,   78,    6,  107,   81,
 /*  1450 */     9,   10,  107,  107,  107,  107,  107,  107,   90,   91,
 /*  1460 */    92,   93,   94,   95,  107,  107,   98,   99,   78,  107,
 /*  1470 */   107,   81,  107,  107,  107,  107,  107,  107,  107,  107,
 /*  1480 */    90,   91,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1490 */   107,  107,  107,  107,  107,  107,  107,   78,  107,  107,
 /*  1500 */    81,  107,  107,  107,   63,   64,   65,   66,   67,   68,
 /*  1510 */    91,   92,   93,   94,   95,  107,   78,   98,   99,   81,
 /*  1520 */   107,  107,  107,  107,   78,  107,  107,   81,  107,   91,
 /*  1530 */    92,   93,   94,   95,  107,  107,   98,   99,   92,   93,
 /*  1540 */    94,   95,  107,  107,   98,   99,   78,  107,  107,   81,
 /*  1550 */   107,  107,  107,  107,  107,  107,  107,  107,  107,  107,
 /*  1560 */    92,   93,   94,   95,  107,  107,   98,   99,   78,  107,
 /*  1570 */   107,   81,  107,  107,  107,  107,   78,  107,  107,   81,
 /*  1580 */   107,  107,   92,   93,   94,   95,  107,  107,   98,   99,
 /*  1590 */    92,   93,   94,   95,  107,   78,   98,   99,   81,  107,
 /*  1600 */   107,  107,  107,   78,  107,  107,   81,  107,  107,   92,
 /*  1610 */    93,   94,   95,  107,  107,   98,   99,   92,   93,   94,
 /*  1620 */    95,  107,  107,   98,   99,   78,  107,  107,   81,  107,
 /*  1630 */   107,  107,  107,  107,  107,  107,  107,  107,  107,   92,
 /*  1640 */    93,   94,   95,  107,  107,   98,   99,   78,  107,  107,
 /*  1650 */    81,  107,  107,  107,  107,   78,  107,  107,   81,  107,
 /*  1660 */   107,   92,   93,   94,   95,  107,  107,   98,   99,   92,
 /*  1670 */    93,   94,   95,  107,   78,   98,   99,   81,  107,  107,
 /*  1680 */   107,  107,   78,  107,  107,   81,  107,  107,   92,   93,
 /*  1690 */    94,   95,  107,  107,   98,   99,   92,   93,   94,   95,
 /*  1700 */   107,  107,   98,   99,   78,  107,  107,   81,  107,  107,
 /*  1710 */   107,  107,  107,  107,  107,  107,  107,  107,   92,   93,
 /*  1720 */    94,   95,  107,  107,   98,   99,   78,  107,  107,   81,
 /*  1730 */   107,  107,  107,  107,   78,  107,  107,   81,  107,  107,
 /*  1740 */    92,   93,   94,   95,  107,  107,   98,   99,   92,   93,
 /*  1750 */    94,   95,  107,  107,   98,   99,
};
#define YY_SHIFT_USE_DFLT (-6)
#define YY_SHIFT_COUNT (131)
#define YY_SHIFT_MIN   (-5)
#define YY_SHIFT_MAX   (1441)
static const short yy_shift_ofst[] = {
 /*     0 */    22,   56,  149,  389,  417,  149,  417,  417,  417,  417,
 /*    10 */   119,   85,  417,  417,  417,  417,  417,  417,  417,  417,
 /*    20 */   417,  417,  417,  417,  417,  417,  417,  417,  417,  417,
 /*    30 */   417,  417,  417,  417,  417,  417,  417,  417,  417,  417,
 /*    40 */   417,  417,  417,  417,  417,  417,  417,  417,  417,  417,
 /*    50 */   417,  417,  417,  417,  417,  417,  417,  417,  417,  417,
 /*    60 */   417,  417,  417,  417,  417,  417,  417,  417,  417, 1441,
 /*    70 */    91,  129,   63, 1411, 1400,   91,   91,   91,   91,   91,
 /*    80 */   226,   -6,  972,  996,  996,  996,   27,   27,   27,   27,
 /*    90 */    27,   27,   27,   27,   27,   27,   27,  111,   27,  111,
 /*   100 */    27,  111,   27,  422,  189,  124,  154,  159,   87,   87,
 /*   110 */    95,   87,  125,  177,  110,   87,  125,  124,   66,   96,
 /*   120 */    -5,    1,   84,   40,   33,    4,    1,   33,    4,    1,
 /*   130 */    -3,   -5,
};
#define YY_REDUCE_USE_DFLT (-74)
#define YY_REDUCE_COUNT (81)
#define YY_REDUCE_MIN   (-73)
#define YY_REDUCE_MAX   (1656)
static const short yy_reduce_ofst[] = {
 /*     0 */   -73,  -39,  199,  169,  143,  326,  298,  276,  250,  228,
 /*    10 */   807,  785,  763,  741,  719,  697,  675,  653,  631,  609,
 /*    20 */   587,  565,  543,  521,  499,  477,  455,  433,  408,  826,
 /*    30 */   864,  845,  886,  920,  964, 1008,  986, 1300, 1277, 1255,
 /*    40 */  1232, 1210, 1187, 1165, 1142, 1120, 1097, 1075, 1052, 1030,
 /*    50 */  1390, 1368, 1346, 1438, 1419, 1656, 1648, 1626, 1604, 1596,
 /*    60 */  1577, 1569, 1547, 1525, 1517, 1498, 1490, 1468, 1446,  -41,
 /*    70 */   197,  140,   99,  142,  142,  120,  116,  114,   94,   83,
 /*    80 */    30,    2,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   336,  336,  330,  336,  320,  336,  327,  336,  336,  336,
 /*    10 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    20 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    30 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    40 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    50 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    60 */   336,  336,  336,  336,  336,  336,  336,  336,  336,  336,
 /*    70 */   336,  336,  298,  336,  336,  336,  336,  336,  336,  336,
 /*    80 */   336,  320,  294,  254,  256,  255,  270,  269,  268,  267,
 /*    90 */   266,  265,  264,  263,  262,  261,  257,  275,  260,  277,
 /*   100 */   259,  276,  258,  336,  336,  244,  336,  336,  271,  274,
 /*   110 */   336,  273,  252,  336,  294,  272,  253,  243,  241,  336,
 /*   120 */   304,  247,  336,  336,  250,  248,  245,  251,  249,  246,
 /*   130 */   336,  336,  331,  335,  334,  333,  332,  221,  219,  225,
 /*   140 */   240,  239,  238,  237,  236,  235,  234,  233,  232,  231,
 /*   150 */   230,  328,  329,  326,  325,  316,  314,  313,  318,  312,
 /*   160 */   323,  322,  321,  319,  317,  315,  311,  278,  310,  309,
 /*   170 */   308,  307,  306,  305,  304,  281,  303,  302,  300,  280,
 /*   180 */   324,  226,  301,  299,  297,  296,  295,  293,  292,  291,
 /*   190 */   290,  289,  288,  287,  286,  285,  284,  283,  282,  279,
 /*   200 */   242,  229,  228,  227,  224,  223,  222,  218,  215,  220,
 /*   210 */   217,  216,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "LOGICAL_AND",   "LOGICAL_AND_NOT",
  "LOGICAL_OR",    "QSTRING",       "PARENL",        "PARENR",      
  "RELATIVE_OP",   "IDENTIFIER",    "BRACEL",        "BRACER",      
  "EVAL",          "COMMA",         "ASSIGN",        "STAR_ASSIGN", 
  "SLASH_ASSIGN",  "MOD_ASSIGN",    "PLUS_ASSIGN",   "MINUS_ASSIGN",
  "SHIFTL_ASSIGN",  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",  "AND_ASSIGN",  
  "XOR_ASSIGN",    "OR_ASSIGN",     "QUESTION",      "COLON",       
  "BITWISE_OR",    "BITWISE_XOR",   "BITWISE_AND",   "EQUAL",       
  "NOT_EQUAL",     "LESS",          "GREATER",       "LESS_EQUAL",  
  "GREATER_EQUAL",  "IN",            "MATCH",         "NEAR",        
  "NEAR2",         "SIMILAR",       "TERM_EXTRACT",  "LCP",         
  "PREFIX",        "SUFFIX",        "SHIFTL",        "SHIFTR",      
  "SHIFTRR",       "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "MOD",           "DELETE",        "INCR",        
  "DECR",          "NOT",           "BITWISE_NOT",   "ADJUST",      
  "EXACT",         "PARTIAL",       "UNSPLIT",       "DECIMAL",     
  "HEX_INTEGER",   "STRING",        "BOOLEAN",       "NULL",        
  "BRACKETL",      "BRACKETR",      "DOT",           "NONEXISTENT_COLUMN",
  "error",         "input",         "query",         "expression",  
  "output_columns",  "query_element",  "primary_expression",  "assignment_expression",
  "conditional_expression",  "lefthand_side_expression",  "logical_or_expression",  "logical_and_expression",
  "bitwise_or_expression",  "bitwise_xor_expression",  "bitwise_and_expression",  "equality_expression",
  "relational_expression",  "shift_expression",  "additive_expression",  "multiplicative_expression",
  "unary_expression",  "postfix_expression",  "call_expression",  "member_expression",
  "arguments",     "member_expression_part",  "object_literal",  "array_literal",
  "elision",       "element_list",  "property_name_and_value_list",  "property_name_and_value",
  "property_name",  "argument_list",  "output_column",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= query",
 /*   1 */ "input ::= expression",
 /*   2 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*   3 */ "query ::= query_element",
 /*   4 */ "query ::= query query_element",
 /*   5 */ "query ::= query LOGICAL_AND query_element",
 /*   6 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   7 */ "query ::= query LOGICAL_OR query_element",
 /*   8 */ "query_element ::= QSTRING",
 /*   9 */ "query_element ::= PARENL query PARENR",
 /*  10 */ "query_element ::= RELATIVE_OP query_element",
 /*  11 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*  12 */ "query_element ::= BRACEL expression BRACER",
 /*  13 */ "query_element ::= EVAL primary_expression",
 /*  14 */ "expression ::= assignment_expression",
 /*  15 */ "expression ::= expression COMMA assignment_expression",
 /*  16 */ "assignment_expression ::= conditional_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  21 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  22 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  23 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  24 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  25 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  26 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  27 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  28 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  29 */ "conditional_expression ::= logical_or_expression",
 /*  30 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  31 */ "logical_or_expression ::= logical_and_expression",
 /*  32 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  33 */ "logical_and_expression ::= bitwise_or_expression",
 /*  34 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  35 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  36 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /*  37 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  38 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /*  39 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  40 */ "bitwise_and_expression ::= equality_expression",
 /*  41 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  42 */ "equality_expression ::= relational_expression",
 /*  43 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  44 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  45 */ "relational_expression ::= shift_expression",
 /*  46 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  47 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  48 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  49 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  50 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  51 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  52 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  53 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  54 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  55 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  56 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  57 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  58 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  59 */ "shift_expression ::= additive_expression",
 /*  60 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  61 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  62 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  63 */ "additive_expression ::= multiplicative_expression",
 /*  64 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  65 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  66 */ "multiplicative_expression ::= unary_expression",
 /*  67 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  68 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  69 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  70 */ "unary_expression ::= postfix_expression",
 /*  71 */ "unary_expression ::= DELETE unary_expression",
 /*  72 */ "unary_expression ::= INCR unary_expression",
 /*  73 */ "unary_expression ::= DECR unary_expression",
 /*  74 */ "unary_expression ::= PLUS unary_expression",
 /*  75 */ "unary_expression ::= MINUS unary_expression",
 /*  76 */ "unary_expression ::= NOT unary_expression",
 /*  77 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  78 */ "unary_expression ::= ADJUST unary_expression",
 /*  79 */ "unary_expression ::= EXACT unary_expression",
 /*  80 */ "unary_expression ::= PARTIAL unary_expression",
 /*  81 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  82 */ "postfix_expression ::= lefthand_side_expression",
 /*  83 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  84 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  85 */ "lefthand_side_expression ::= call_expression",
 /*  86 */ "lefthand_side_expression ::= member_expression",
 /*  87 */ "call_expression ::= member_expression arguments",
 /*  88 */ "member_expression ::= primary_expression",
 /*  89 */ "member_expression ::= member_expression member_expression_part",
 /*  90 */ "primary_expression ::= object_literal",
 /*  91 */ "primary_expression ::= PARENL expression PARENR",
 /*  92 */ "primary_expression ::= IDENTIFIER",
 /*  93 */ "primary_expression ::= array_literal",
 /*  94 */ "primary_expression ::= DECIMAL",
 /*  95 */ "primary_expression ::= HEX_INTEGER",
 /*  96 */ "primary_expression ::= STRING",
 /*  97 */ "primary_expression ::= BOOLEAN",
 /*  98 */ "primary_expression ::= NULL",
 /*  99 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 100 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 101 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 102 */ "elision ::= COMMA",
 /* 103 */ "elision ::= elision COMMA",
 /* 104 */ "element_list ::= assignment_expression",
 /* 105 */ "element_list ::= elision assignment_expression",
 /* 106 */ "element_list ::= element_list elision assignment_expression",
 /* 107 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /* 108 */ "property_name_and_value_list ::=",
 /* 109 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 110 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /* 111 */ "property_name ::= IDENTIFIER|STRING|DECIMAL",
 /* 112 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /* 113 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 114 */ "arguments ::= PARENL argument_list PARENR",
 /* 115 */ "argument_list ::=",
 /* 116 */ "argument_list ::= assignment_expression",
 /* 117 */ "argument_list ::= argument_list COMMA assignment_expression",
 /* 118 */ "output_columns ::=",
 /* 119 */ "output_columns ::= output_column",
 /* 120 */ "output_columns ::= output_columns COMMA output_column",
 /* 121 */ "output_column ::= STAR",
 /* 122 */ "output_column ::= NONEXISTENT_COLUMN",
 /* 123 */ "output_column ::= assignment_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from grn_expr_parserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   grn_expr_parserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 73, 1 },
  { 73, 1 },
  { 73, 2 },
  { 74, 1 },
  { 74, 2 },
  { 74, 3 },
  { 74, 3 },
  { 74, 3 },
  { 77, 1 },
  { 77, 3 },
  { 77, 2 },
  { 77, 3 },
  { 77, 3 },
  { 77, 2 },
  { 75, 1 },
  { 75, 3 },
  { 79, 1 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 79, 3 },
  { 80, 1 },
  { 80, 5 },
  { 82, 1 },
  { 82, 3 },
  { 83, 1 },
  { 83, 3 },
  { 83, 3 },
  { 84, 1 },
  { 84, 3 },
  { 85, 1 },
  { 85, 3 },
  { 86, 1 },
  { 86, 3 },
  { 87, 1 },
  { 87, 3 },
  { 87, 3 },
  { 88, 1 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 88, 3 },
  { 89, 1 },
  { 89, 3 },
  { 89, 3 },
  { 89, 3 },
  { 90, 1 },
  { 90, 3 },
  { 90, 3 },
  { 91, 1 },
  { 91, 3 },
  { 91, 3 },
  { 91, 3 },
  { 92, 1 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 92, 2 },
  { 93, 1 },
  { 93, 2 },
  { 93, 2 },
  { 81, 1 },
  { 81, 1 },
  { 94, 2 },
  { 95, 1 },
  { 95, 2 },
  { 78, 1 },
  { 78, 3 },
  { 78, 1 },
  { 78, 1 },
  { 78, 1 },
  { 78, 1 },
  { 78, 1 },
  { 78, 1 },
  { 78, 1 },
  { 99, 3 },
  { 99, 4 },
  { 99, 3 },
  { 100, 1 },
  { 100, 2 },
  { 101, 1 },
  { 101, 2 },
  { 101, 3 },
  { 98, 3 },
  { 102, 0 },
  { 102, 3 },
  { 103, 3 },
  { 104, 1 },
  { 97, 3 },
  { 97, 2 },
  { 96, 3 },
  { 105, 0 },
  { 105, 1 },
  { 105, 3 },
  { 76, 0 },
  { 76, 1 },
  { 76, 3 },
  { 106, 1 },
  { 106, 1 },
  { 106, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 4: /* query ::= query query_element */
#line 30 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1307 "ecmascript.c"
        break;
      case 5: /* query ::= query LOGICAL_AND query_element */
      case 34: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==34);
#line 33 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1315 "ecmascript.c"
        break;
      case 6: /* query ::= query LOGICAL_AND_NOT query_element */
      case 35: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==35);
#line 36 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1323 "ecmascript.c"
        break;
      case 7: /* query ::= query LOGICAL_OR query_element */
      case 32: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==32);
#line 39 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1331 "ecmascript.c"
        break;
      case 10: /* query_element ::= RELATIVE_OP query_element */
#line 46 "ecmascript.y"
{
  int mode;
  GRN_UINT32_POP(&efsi->mode_stack, mode);
}
#line 1339 "ecmascript.c"
        break;
      case 11: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 50 "ecmascript.y"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_UINT32_POP(&efsi->mode_stack, mode);
}
#line 1349 "ecmascript.c"
        break;
      case 12: /* query_element ::= BRACEL expression BRACER */
      case 13: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==13);
#line 56 "ecmascript.y"
{
  efsi->flags = efsi->default_flags;
}
#line 1357 "ecmascript.c"
        break;
      case 15: /* expression ::= expression COMMA assignment_expression */
#line 64 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1364 "ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 69 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1371 "ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 72 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1378 "ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 75 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1385 "ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 78 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1392 "ecmascript.c"
        break;
      case 21: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 81 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1399 "ecmascript.c"
        break;
      case 22: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 84 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1406 "ecmascript.c"
        break;
      case 23: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 87 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1413 "ecmascript.c"
        break;
      case 24: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 90 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1420 "ecmascript.c"
        break;
      case 25: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 93 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1427 "ecmascript.c"
        break;
      case 26: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 96 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1434 "ecmascript.c"
        break;
      case 27: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 99 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1441 "ecmascript.c"
        break;
      case 28: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 102 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1448 "ecmascript.c"
        break;
      case 30: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 107 "ecmascript.y"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1457 "ecmascript.c"
        break;
      case 37: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 127 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1464 "ecmascript.c"
        break;
      case 39: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 132 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1471 "ecmascript.c"
        break;
      case 41: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 137 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1478 "ecmascript.c"
        break;
      case 43: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 142 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1485 "ecmascript.c"
        break;
      case 44: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 145 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1492 "ecmascript.c"
        break;
      case 46: /* relational_expression ::= relational_expression LESS shift_expression */
#line 150 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1499 "ecmascript.c"
        break;
      case 47: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 153 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1506 "ecmascript.c"
        break;
      case 48: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 156 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1513 "ecmascript.c"
        break;
      case 49: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 159 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1520 "ecmascript.c"
        break;
      case 50: /* relational_expression ::= relational_expression IN shift_expression */
#line 162 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1527 "ecmascript.c"
        break;
      case 51: /* relational_expression ::= relational_expression MATCH shift_expression */
#line 165 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1534 "ecmascript.c"
        break;
      case 52: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 168 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 2);
}
#line 1541 "ecmascript.c"
        break;
      case 53: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 171 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1548 "ecmascript.c"
        break;
      case 54: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 174 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 2);
}
#line 1555 "ecmascript.c"
        break;
      case 55: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 177 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1562 "ecmascript.c"
        break;
      case 56: /* relational_expression ::= relational_expression LCP shift_expression */
#line 180 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1569 "ecmascript.c"
        break;
      case 57: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 183 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1576 "ecmascript.c"
        break;
      case 58: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 186 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1583 "ecmascript.c"
        break;
      case 60: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 191 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1590 "ecmascript.c"
        break;
      case 61: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 194 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1597 "ecmascript.c"
        break;
      case 62: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 197 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1604 "ecmascript.c"
        break;
      case 64: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
#line 202 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1611 "ecmascript.c"
        break;
      case 65: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 205 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1618 "ecmascript.c"
        break;
      case 67: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
#line 210 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1625 "ecmascript.c"
        break;
      case 68: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 213 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1632 "ecmascript.c"
        break;
      case 69: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 216 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1639 "ecmascript.c"
        break;
      case 71: /* unary_expression ::= DELETE unary_expression */
#line 221 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1646 "ecmascript.c"
        break;
      case 72: /* unary_expression ::= INCR unary_expression */
#line 224 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1667 "ecmascript.c"
        break;
      case 73: /* unary_expression ::= DECR unary_expression */
#line 241 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1688 "ecmascript.c"
        break;
      case 74: /* unary_expression ::= PLUS unary_expression */
#line 258 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1695 "ecmascript.c"
        break;
      case 75: /* unary_expression ::= MINUS unary_expression */
#line 261 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1702 "ecmascript.c"
        break;
      case 76: /* unary_expression ::= NOT unary_expression */
#line 264 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1709 "ecmascript.c"
        break;
      case 77: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 267 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1716 "ecmascript.c"
        break;
      case 78: /* unary_expression ::= ADJUST unary_expression */
#line 270 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1723 "ecmascript.c"
        break;
      case 79: /* unary_expression ::= EXACT unary_expression */
#line 273 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1730 "ecmascript.c"
        break;
      case 80: /* unary_expression ::= PARTIAL unary_expression */
#line 276 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1737 "ecmascript.c"
        break;
      case 81: /* unary_expression ::= UNSPLIT unary_expression */
#line 279 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1744 "ecmascript.c"
        break;
      case 83: /* postfix_expression ::= lefthand_side_expression INCR */
#line 284 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 1765 "ecmascript.c"
        break;
      case 84: /* postfix_expression ::= lefthand_side_expression DECR */
#line 301 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  DFI_POP(e, dfi_);
  const_p = CONSTP(dfi_->code->value);
  DFI_PUT(e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented (%.*s)",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 1786 "ecmascript.c"
        break;
      case 87: /* call_expression ::= member_expression arguments */
#line 322 "ecmascript.y"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 1793 "ecmascript.c"
        break;
      case 114: /* arguments ::= PARENL argument_list PARENR */
#line 361 "ecmascript.y"
{ yygotominor.yy0 = yymsp[-1].minor.yy0; }
#line 1798 "ecmascript.c"
        break;
      case 115: /* argument_list ::= */
#line 362 "ecmascript.y"
{ yygotominor.yy0 = 0; }
#line 1803 "ecmascript.c"
        break;
      case 116: /* argument_list ::= assignment_expression */
#line 363 "ecmascript.y"
{ yygotominor.yy0 = 1; }
#line 1808 "ecmascript.c"
        break;
      case 117: /* argument_list ::= argument_list COMMA assignment_expression */
#line 364 "ecmascript.y"
{ yygotominor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 1813 "ecmascript.c"
        break;
      case 118: /* output_columns ::= */
#line 366 "ecmascript.y"
{
  yygotominor.yy0 = 0;
}
#line 1820 "ecmascript.c"
        break;
      case 119: /* output_columns ::= output_column */
#line 369 "ecmascript.y"
{
  if (yymsp[0].minor.yy0) {
    yygotominor.yy0 = 0;
  } else {
    yygotominor.yy0 = 1;
  }
}
#line 1831 "ecmascript.c"
        break;
      case 120: /* output_columns ::= output_columns COMMA output_column */
#line 377 "ecmascript.y"
{
  if (yymsp[0].minor.yy0) {
    yygotominor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[-2].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yygotominor.yy0 = 1;
  }
}
#line 1845 "ecmascript.c"
        break;
      case 121: /* output_column ::= STAR */
#line 388 "ecmascript.y"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_expr *e = (grn_expr *)expr;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    grn_obj **columns;
    int i, n_columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    for (i = 0; i < n_columns; i++) {
      if (i > 0) {
        grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
      }
      grn_expr_append_const(ctx, expr, columns[i], GRN_OP_GET_VALUE, 1);
      GRN_PTR_PUT(ctx, &e->objs, columns[i]);
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    if (n_columns > 0) {
      yygotominor.yy0 = GRN_FALSE;
    } else {
      yygotominor.yy0 = GRN_TRUE;
    }
  } else {
    /* TODO: report error */
    yygotominor.yy0 = GRN_TRUE;
  }
}
#line 1886 "ecmascript.c"
        break;
      case 122: /* output_column ::= NONEXISTENT_COLUMN */
#line 425 "ecmascript.y"
{
  yygotominor.yy0 = GRN_TRUE;
}
#line 1893 "ecmascript.c"
        break;
      case 123: /* output_column ::= assignment_expression */
#line 428 "ecmascript.y"
{
  yygotominor.yy0 = GRN_FALSE;
}
#line 1900 "ecmascript.c"
        break;
      default:
      /* (0) input ::= query */ yytestcase(yyruleno==0);
      /* (1) input ::= expression */ yytestcase(yyruleno==1);
      /* (2) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==2);
      /* (3) query ::= query_element */ yytestcase(yyruleno==3);
      /* (8) query_element ::= QSTRING */ yytestcase(yyruleno==8);
      /* (9) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==9);
      /* (14) expression ::= assignment_expression */ yytestcase(yyruleno==14);
      /* (16) assignment_expression ::= conditional_expression */ yytestcase(yyruleno==16);
      /* (29) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==29);
      /* (31) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==31);
      /* (33) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==33);
      /* (36) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==36);
      /* (38) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==38);
      /* (40) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==40);
      /* (42) equality_expression ::= relational_expression */ yytestcase(yyruleno==42);
      /* (45) relational_expression ::= shift_expression */ yytestcase(yyruleno==45);
      /* (59) shift_expression ::= additive_expression */ yytestcase(yyruleno==59);
      /* (63) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==63);
      /* (66) multiplicative_expression ::= unary_expression */ yytestcase(yyruleno==66);
      /* (70) unary_expression ::= postfix_expression */ yytestcase(yyruleno==70);
      /* (82) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==82);
      /* (85) lefthand_side_expression ::= call_expression */ yytestcase(yyruleno==85);
      /* (86) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==86);
      /* (88) member_expression ::= primary_expression */ yytestcase(yyruleno==88);
      /* (89) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==89);
      /* (90) primary_expression ::= object_literal */ yytestcase(yyruleno==90);
      /* (91) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==91);
      /* (92) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==92);
      /* (93) primary_expression ::= array_literal */ yytestcase(yyruleno==93);
      /* (94) primary_expression ::= DECIMAL */ yytestcase(yyruleno==94);
      /* (95) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==95);
      /* (96) primary_expression ::= STRING */ yytestcase(yyruleno==96);
      /* (97) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==97);
      /* (98) primary_expression ::= NULL */ yytestcase(yyruleno==98);
      /* (99) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==99);
      /* (100) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==100);
      /* (101) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==101);
      /* (102) elision ::= COMMA */ yytestcase(yyruleno==102);
      /* (103) elision ::= elision COMMA */ yytestcase(yyruleno==103);
      /* (104) element_list ::= assignment_expression */ yytestcase(yyruleno==104);
      /* (105) element_list ::= elision assignment_expression */ yytestcase(yyruleno==105);
      /* (106) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==106);
      /* (107) object_literal ::= BRACEL property_name_and_value_list BRACER */ yytestcase(yyruleno==107);
      /* (108) property_name_and_value_list ::= */ yytestcase(yyruleno==108);
      /* (109) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==109);
      /* (110) property_name_and_value ::= property_name COLON assignment_expression */ yytestcase(yyruleno==110);
      /* (111) property_name ::= IDENTIFIER|STRING|DECIMAL */ yytestcase(yyruleno==111);
      /* (112) member_expression_part ::= BRACKETL expression BRACKETR */ yytestcase(yyruleno==112);
      /* (113) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==113);
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 11 "ecmascript.y"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj buf;
    if (ctx->rc == GRN_SUCCESS) {
      GRN_TEXT_INIT(&buf, 0);
      GRN_TEXT_PUT(ctx, &buf, efsi->str, efsi->str_end - efsi->str);
      GRN_TEXT_PUTC(ctx, &buf, '\0');
      ERR(GRN_SYNTAX_ERROR, "Syntax error! (%s)", GRN_TEXT_VALUE(&buf));
      GRN_OBJ_FIN(ctx, &buf);
    }
  }
#line 2024 "ecmascript.c"
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      assert( !yyendofinput );  /* Impossible to shift the $ token */
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
