/* -*- c-basic-offset: 2 -*- */
/*
  Copyright(C) 2011-2018 Kouhei Sutou <kou@clear-code.com>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#pragma once

#include "mrn_mysql.h"

#if MYSQL_VERSION_ID >= 50604
#  define MRN_HAVE_MYSQL_TYPE_TIMESTAMP2
#  define MRN_HAVE_MYSQL_TYPE_DATETIME2
#  define MRN_HAVE_MYSQL_TYPE_TIME2
#endif

#if MYSQL_VERSION_ID >= 50709 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_MYSQL_TYPE_JSON
#endif

#if MYSQL_VERSION_ID >= 100302 && defined(MRN_MARIADB_P)
#  define MRN_HAVE_MYSQL_TYPE_VARCHAR_COMPRESSED
#  define MRN_HAVE_MYSQL_TYPE_BLOB_COMPRESSED
#endif

#if MYSQL_VERSION_ID < 50603
  typedef MYSQL_ERROR Sql_condition;
#endif

#if defined(MRN_MARIADB_P)
#  if MYSQL_VERSION_ID < 100000
     typedef COST_VECT Cost_estimate;
#  endif
#endif

#ifndef MRN_MARIADB_P
  typedef char *range_id_t;
#endif

#if defined(MRN_MARIADB_P) || MYSQL_VERSION_ID < 80002
  typedef st_select_lex SELECT_LEX;
#endif

#if MYSQL_VERSION_ID >= 50609
#  define MRN_KEY_HAVE_USER_DEFINED_KEYPARTS
#endif

#ifdef MRN_KEY_HAVE_USER_DEFINED_KEYPARTS
#  define KEY_N_KEY_PARTS(key) (key)->user_defined_key_parts
#else
#  define KEY_N_KEY_PARTS(key) (key)->key_parts
#endif

#if (MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)) || \
    (MYSQL_VERSION_ID >= 100302)
#  define MRN_FOREIGN_KEY_USE_CONST_STRING
#endif

#ifdef MRN_FOREIGN_KEY_USE_CONST_STRING
  typedef LEX_CSTRING mrn_foreign_key_name;
#else
  typedef LEX_STRING mrn_foreign_key_name;
#endif

#if MYSQL_VERSION_ID >= 100302 && defined(MRN_MARIADB_P)
#  define MRN_KEY_NAME_IS_LEX_STRING
#  define MRN_FIELD_FIELD_NAME_IS_LEX_STRING
#  define MRN_FIELD_SET_USE_LEX_STRING
#  define MRN_CREATE_FIELD_USE_LEX_STRING
#endif

#ifdef MRN_KEY_NAME_IS_LEX_STRING
#  define KEY_NAME_PTR(key) ((key)->name.str)
#  define KEY_NAME_LENGTH(key) ((key)->name.length)
#  define KEY_NAME_EQUAL_KEY(key1, key2)                \
  ((key1)->name.length == (key2)->name.length &&        \
   strncmp((key1)->name.str,                            \
           (key2)->name.str,                            \
           (key1)->name.length) == 0)
#  define KEY_NAME_FORMAT "%.*s"
#  define KEY_NAME_FORMAT_VALUE(key)            \
  static_cast<int>((key)->name.length),         \
  (key)->name.str
#else
#  define KEY_NAME_PTR(key) (key)->name
#  define KEY_NAME_LENGTH(key) strlen((key)->name)
#  define KEY_NAME_EQUAL_KEY(key1, key2)        \
  strcmp((key1)->name, (key2)->name) == 0
#  define KEY_NAME_FORMAT "%s"
#  define KEY_NAME_FORMAT_VALUE(key) (key)->name
#endif
#define KEY_NAME(key) KEY_NAME_PTR(key), KEY_NAME_LENGTH(key)

#ifdef MRN_FIELD_FIELD_NAME_IS_LEX_STRING
#  define FIELD_NAME(field)                             \
  (field)->field_name.str, (field)->field_name.length
#  define FIELD_NAME_EQUAL(field, name)                                 \
  ((field)->field_name.length == strlen(name) &&                        \
   strncmp((field)->field_name.str, name, (field)->field_name.length) == 0)
#  define FIELD_NAME_EQUAL_STRING(field, string)                        \
  ((field)->field_name.length == string->length &&                      \
   strncmp((field)->field_name.str, string->str, string->length) == 0)
#  define FIELD_NAME_EQUAL_FIELD(field1, field2)                        \
  ((field1)->field_name.length == (field2)->field_name.length &&        \
   strncmp((field1)->field_name.str,                                    \
           (field2)->field_name.str,                                    \
           (field1)->field_name.length) == 0)
#  define FIELD_NAME_TO_LEX_STRING(thd, field)                          \
  thd_make_lex_string((thd),                                            \
                      NULL,                                             \
                      (field)->field_name.str,                          \
                      (field)->field_name.length,                       \
                      true);
#  define FIELD_NAME_FORMAT "%.*s"
#  define FIELD_NAME_FORMAT_VALUE(field)                                \
  static_cast<int>((field)->field_name.length), (field)->field_name.str
#else
#  define FIELD_NAME(field)                             \
  (field)->field_name, strlen((field)->field_name)
#  define FIELD_NAME_EQUAL(field, name)                                 \
  (strcmp((field)->field_name, name) == 0)
#  define FIELD_NAME_EQUAL_STRING(field, string)                        \
  (strlen((field)->field_name) == string->length &&                     \
   strncmp((field)->field_name, string->str, string->length) == 0)
#  define FIELD_NAME_EQUAL_FIELD(field1, field2)                        \
  (strcmp((field1)->field_name, (field2)->field_name) == 0)
#  define FIELD_NAME_TO_LEX_STRING(thd, field)          \
   thd_make_lex_string((thd),                           \
                       NULL,                            \
                       (field)->field_name,             \
                       strlen((field)->field_name),     \
                       true);
#  define FIELD_NAME_FORMAT "%s"
#  define FIELD_NAME_FORMAT_VALUE(field) (field)->field_name
#endif

#if (MYSQL_VERSION_ID >= 100302 && defined(MRN_MARIADB_P)) ||   \
  (MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P))
#  define MRN_KEY_PART_SPEC_FIELD_NAME_USE_CONST_STRING
#endif

#ifdef MRN_KEY_PART_SPEC_FIELD_NAME_USE_CONST_STRING
#  if (MYSQL_VERSION_ID >= 80013 && !defined(MRN_MARIADB_P))
     typedef char mrn_key_part_spec_field_name;
#  else
     typedef LEX_CSTRING mrn_key_part_spec_field_name;
#  endif
#else
  typedef LEX_STRING mrn_key_part_spec_field_name;
#endif

#if MYSQL_VERSION_ID >= 80013 && !defined(MRN_MARIADB_P)
#  define MRN_KEY_PART_SPEC_FIELD_NAME_USE_ACCESSSOR_FUNCTION
#  define MRN_KEY_PART_SPEC_FIELD_NAME(key_part_spec)			\
     (key_part_spec)->get_field_name()
#  define MRN_KEY_PART_SPEC_FIELD_NAME_FORMAT "%s"
#  define MRN_KEY_PART_SPEC_FIELD_NAME_VALUE(key_part_spec)		\
     (key_part_spec)
#  define MRN_FIELD_NAME_EQUAL_KEY_PART_SPEC_FIELD_NAME(field, name)	\
     (strcmp((field)->field_name, name) == 0)
#else
#  define MRN_KEY_PART_SPEC_FIELD_NAME(key_part_spec)			\
     &(key_part_spec)->field_name
#  define MRN_KEY_PART_SPEC_FIELD_NAME_FORMAT "%.*s"
#  define MRN_KEY_PART_SPEC_FIELD_NAME_VALUE(key_part_spec)		\
     static_cast<int>((key_part_spec)->length), (key_part_spec)->str
#  ifdef MRN_FIELD_FIELD_NAME_IS_LEX_STRING
#    define MRN_FIELD_NAME_EQUAL_KEY_PART_SPEC_FIELD_NAME(field, string)	\
       FIELD_NAME_EQUAL_STRING(field, string)
#  else
#    define MRN_FIELD_NAME_EQUAL_KEY_PART_SPEC_FIELD_NAME(field, string)	\
       (strlen((field)->field_name) == string->length &&			\
        strncmp((field)->field_name, string->str, string->length) == 0)
#  endif
#endif

#if MYSQL_VERSION_ID >= 100302 && defined(MRN_MARIADB_P)
#  define MRN_THD_MAKE_LEX_STRING_USE_CONST_STRING
#endif

#ifdef MRN_THD_MAKE_LEX_STRING_USE_CONST_STRING
  typedef MYSQL_CONST_LEX_STRING mrn_thd_lex_string;
#else
  typedef MYSQL_LEX_STRING mrn_thd_lex_string;
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100306
#  define mrn_init_alloc_root(root, name, block_size, pre_alloc_size, flags) \
  init_alloc_root(root, name, block_size, pre_alloc_size, flags)
#elif defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100000
#  define mrn_init_alloc_root(root, name, block_size, pre_alloc_size, flags) \
  init_alloc_root(root, block_size, pre_alloc_size, flags)
#elif MYSQL_VERSION_ID >= 50706
#  define mrn_init_alloc_root(root, name, block_size, pre_alloc_size, flags) \
  init_alloc_root(mrn_memory_key, root, block_size, pre_alloc_size)
#else
#  define mrn_init_alloc_root(root, name, block_size, pre_alloc_size, flags) \
  init_alloc_root(root, block_size, pre_alloc_size)
#endif

#if MYSQL_VERSION_ID < 100002 || !defined(MRN_MARIADB_P)
#  define GTS_TABLE 0
#endif

#if MYSQL_VERSION_ID >= 50607
#  if MYSQL_VERSION_ID >= 100007 && defined(MRN_MARIADB_P)
#    define MRN_GET_ERROR_MESSAGE thd_get_error_message(current_thd)
#    define MRN_GET_ERROR_NUMBER thd_get_error_number(current_thd)
#    define MRN_GET_CURRENT_ROW_FOR_WARNING(thd) thd_get_error_row(thd)
#  else
#    define MRN_GET_ERROR_MESSAGE current_thd->get_stmt_da()->message()
#    define MRN_GET_ERROR_NUMBER current_thd->get_stmt_da()->sql_errno()
#    if MYSQL_VERSION_ID >= 50706
#      define MRN_GET_CURRENT_ROW_FOR_WARNING(thd) \
  thd->get_stmt_da()->current_row_for_condition()
#    else
#      define MRN_GET_CURRENT_ROW_FOR_WARNING(thd) \
  thd->get_stmt_da()->current_row_for_warning()
#    endif
#  endif
#else
#  define MRN_GET_ERROR_MESSAGE current_thd->stmt_da->message()
#  define MRN_GET_ERROR_NUMBER current_thd->stmt_da->sql_errno()
#  define MRN_GET_CURRENT_ROW_FOR_WARNING(thd) thd->warning_info->current_row_for_warning()
#endif

#if MYSQL_VERSION_ID >= 50607 && !defined(MRN_MARIADB_P)
#  define MRN_ITEM_HAVE_ITEM_NAME
#endif

#if MYSQL_VERSION_ID >= 100302 && defined(MRN_MARIADB_P)
#  define MRN_ITEM_ITEM_NAME_IS_LEX_STRING
#endif

#if MYSQL_VERSION_ID < 100000
#  define MRN_HAVE_TABLE_DEF_CACHE
#  if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#    define MRN_TABLE_DEF_CACHE_TYPE_IS_MAP
#  endif

#  ifdef MRN_TABLE_DEF_CACHE_TYPE_IS_MAP
struct Table_share_deleter;
typedef
  malloc_unordered_map<std::string,
                       std::unique_ptr<TABLE_SHARE, Table_share_deleter>> *
  mrn_table_def_cache_type;
#  else
typedef HASH mrn_table_def_cache_type;
#  endif
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100009
#  define MRN_HAVE_TDC_ACQUIRE_SHARE
#  if MYSQL_VERSION_ID < 100200
#    define MRN_TDC_ACQUIRE_SHARE_REQUIRE_KEY
#  endif
#endif

#if MYSQL_VERSION_ID >= 50613
#  define MRN_HAVE_ALTER_INFO
#endif

#if MYSQL_VERSION_ID >= 50603
#  define MRN_HAVE_GET_TABLE_DEF_KEY
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100004
#  define MRN_TABLE_SHARE_HAVE_LOCK_SHARE
#endif

#ifndef TIME_FUZZY_DATE
/* For MariaDB 10. */
#  ifdef TIME_FUZZY_DATES
#    define TIME_FUZZY_DATE TIME_FUZZY_DATES
#  endif
#endif

#if MYSQL_VERSION_ID >= 100007 && defined(MRN_MARIADB_P)
#  define MRN_USE_MYSQL_DATA_HOME
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_SEVERITY_WARNING Sql_condition::SL_WARNING
#else
#  define MRN_SEVERITY_WARNING Sql_condition::WARN_LEVEL_WARN
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_PSI_MEMORY_KEY
#endif

#ifdef HAVE_PSI_INTERFACE
#  define MRN_HAVE_PSI_FILE_KEY
#endif

#ifdef MRN_HAVE_PSI_MEMORY_KEY
#  define mrn_my_malloc(size, flags) \
  my_malloc(mrn_memory_key, size, flags)
#  define mrn_my_strdup(string, flags) \
  my_strdup(mrn_memory_key, string, flags)
#  define mrn_my_strndup(string, size, flags) \
  my_strndup(mrn_memory_key, string, size, flags)
#  define mrn_my_multi_malloc(flags, ...) \
  my_multi_malloc(mrn_memory_key, flags, __VA_ARGS__)
#else
#  define mrn_my_malloc(size, flags) my_malloc(size, flags)
#  define mrn_my_strdup(string, flags) my_strdup(string, flags)
#  define mrn_my_strndup(string, size, flags) \
  my_strndup(string, size, flags)
#  define mrn_my_multi_malloc(flags, ...) \
  my_multi_malloc(flags, __VA_ARGS__)
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_STRING_FREE(string) string.mem_free();
#else
#  define MRN_STRING_FREE(string) string.free();
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_THD_DB_PATH(thd) ((thd)->db().str)
#elif defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100306
#  define MRN_THD_DB_PATH(thd) ((thd)->db.str)
#else
#  define MRN_THD_DB_PATH(thd) ((thd)->db)
#endif

#ifndef INT_MAX64
#  define INT_MAX64 LONGLONG_MAX
#endif

#ifdef UINT_MAX
#  define UINT_MAX64 UINT_MAX
#else
#  define UINT_MAX64 LONGLONG_MAX
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define mrn_my_stpmov(dst, src) my_stpmov(dst, src)
#else
#  define mrn_my_stpmov(dst, src) strmov(dst, src)
#endif

#if MYSQL_VERSION_ID >= 50607
#  if !defined(MRN_MARIADB_P)
#    define MRN_HAVE_SQL_OPTIMIZER_H
#  endif
#endif

#if MYSQL_VERSION_ID >= 50600 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_BINLOG_H
#endif

#if MYSQL_VERSION_ID >= 50720 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_MYSQL_PSI_MYSQL_MEMORY_H
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_SQL_DERROR_H
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_SPATIAL
#elif defined(HAVE_SPATIAL)
#  define MRN_HAVE_SPATIAL
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_FORMAT_STRING_LENGTH "zu"
#else
#  define MRN_FORMAT_STRING_LENGTH "u"
#endif

#ifdef MRN_MARIADB_P
#  define MRN_SUPPORT_CUSTOM_OPTIONS
#endif

#ifdef MRN_MARIADB_P
#  define MRN_HAVE_ITEM_EQUAL_FIELDS_ITERATOR
#endif

#if MYSQL_VERSION_ID >= 50706 && !defined(MRN_MARIADB_P)
#  define MRN_SELECT_LEX_GET_WHERE_COND(select_lex) \
  ((select_lex)->where_cond())
#  define MRN_SELECT_LEX_GET_HAVING_COND(select_lex) \
  ((select_lex)->having_cond())
#  define MRN_SELECT_LEX_GET_ACTIVE_OPTIONS(select_lex) \
  ((select_lex)->active_options())
#else
#  define MRN_SELECT_LEX_GET_WHERE_COND(select_lex) \
  ((select_lex)->where)
#  define MRN_SELECT_LEX_GET_HAVING_COND(select_lex) \
  ((select_lex)->having)
#  define MRN_SELECT_LEX_GET_ACTIVE_OPTIONS(select_lex) \
  ((select_lex)->options)
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100000
#  if MYSQL_VERSION_ID >= 100306
#    define mrn_init_sql_alloc(thd, name, mem_root)                     \
  init_sql_alloc(mem_root,                                              \
                 name,                                                  \
                 TABLE_ALLOC_BLOCK_SIZE,                                \
                 0,                                                     \
                 MYF(thd->slave_thread ? 0 : MY_THREAD_SPECIFIC))
#  elif MYSQL_VERSION_ID >= 100104
#    define mrn_init_sql_alloc(thd, name, mem_root)                     \
  init_sql_alloc(mem_root,                                              \
                 TABLE_ALLOC_BLOCK_SIZE,                                \
                 0,                                                     \
                 MYF(thd->slave_thread ? 0 : MY_THREAD_SPECIFIC))
#  else
#    define mrn_init_sql_alloc(thd, name, mem_root)      \
  init_sql_alloc(mem_root,                              \
                 TABLE_ALLOC_BLOCK_SIZE,                \
                 0,                                     \
                 MYF(0))
#  endif
#else
#  if MYSQL_VERSION_ID >= 50709
#    define mrn_init_sql_alloc(thd, name, mem_root)     \
  init_sql_alloc(mrn_memory_key,                        \
                 mem_root,                              \
                 TABLE_ALLOC_BLOCK_SIZE,                \
                 0)
#  else
#    define mrn_init_sql_alloc(thd, name, mem_root)     \
  init_sql_alloc(mem_root,                              \
                 TABLE_ALLOC_BLOCK_SIZE,                \
                 0)
#  endif
#endif

#ifdef MRN_MARIADB_P
#  define MRN_ABORT_ON_WARNING(thd) thd->abort_on_warning
#else
#  if MYSQL_VERSION_ID >= 50706
#    define MRN_ABORT_ON_WARNING(thd) thd->is_strict_mode()
#  else
#    define MRN_ABORT_ON_WARNING(thd) thd->abort_on_warning
#  endif
#endif

#define MRN_ERROR_CODE_DATA_TRUNCATE(thd)                               \
  (MRN_ABORT_ON_WARNING(thd) ? ER_WARN_DATA_OUT_OF_RANGE : WARN_DATA_TRUNCATED)

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100000
#  define mrn_strconvert(from_cs,               \
                         from,                  \
                         from_length,           \
                         to_cs,                 \
                         to,                    \
                         to_length,             \
                         errors)                \
  strconvert((from_cs),                         \
             (from),                            \
             (from_length),                     \
             (to_cs),                           \
             (to),                              \
             (to_length),                       \
             (errors))
#else
#  define mrn_strconvert(from_cs,               \
                         from,                  \
                         from_length,           \
                         to_cs,                 \
                         to,                    \
                         to_length,             \
                         errors)                \
  strconvert((from_cs),                         \
             (from),                            \
             (to_cs),                           \
             (to),                              \
             (to_length),                       \
             (errors))
#endif

#if MYSQL_VERSION_ID >= 50717 && !defined(MRN_MARIADB_P)
#  define mrn_is_directory_separator(c)         \
  is_directory_separator((c))
#else
#  define mrn_is_directory_separator(c)         \
  (c == FN_LIBCHAR || c == FN_LIBCHAR2)
#endif

#if ((MYSQL_VERSION_ID < 50636) || \
    (MYSQL_VERSION_ID >= 50700 && MYSQL_VERSION_ID < 50718)) && !defined(MRN_MARIADB_P)
#  define MRN_HAVE_MYSQL_FIELD_PART_OF_KEY_NOT_CLUSTERED
#endif

#if defined(MRN_MARIADB_P) &&                                           \
  ((MYSQL_VERSION_ID >= 100207) ||                                      \
   ((MYSQL_VERSION_ID >= 100126) && (MYSQL_VERSION_ID < 100200)) ||     \
   ((MYSQL_VERSION_ID >= 100032) && (MYSQL_VERSION_ID < 100100)) ||     \
   ((MYSQL_VERSION_ID >= 50557) && (MYSQL_VERSION_ID < 100000)))
#  define mrn_create_partition_name(out,                                \
                                    out_length,                         \
                                    in1,                                \
                                    in2,                                \
                                    name_variant,                       \
                                    translate)                          \
  create_partition_name(out, out_length, in1, in2, name_variant, translate)
#  define mrn_create_subpartition_name(out,             \
                                       out_length,      \
                                       in1,             \
                                       in2,             \
                                       in3,             \
                                       name_variant)    \
  create_subpartition_name(out, out_length, in1, in2, in3, name_variant)
#else
#  define mrn_create_partition_name(out,                                \
                                    out_length,                         \
                                    in1,                                \
                                    in2,                                \
                                    name_variant,                       \
                                    translate)                          \
  (create_partition_name(out, in1, in2, name_variant, translate), 0)
#  define mrn_create_subpartition_name(out,             \
                                       out_length,      \
                                       in1,             \
                                       in2,             \
                                       in3,             \
                                       name_variant)    \
  (create_subpartition_name(out, in1, in2, in3, name_variant), 0)
#endif

#if (!defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 80002)
#  define ITEM_SUM_GET_NEST_LEVEL(sum_item) (sum_item)->base_select->nest_level
#  define ITEM_SUM_GET_AGGR_LEVEL(sum_item) (sum_item)->aggr_select->nest_level
#  define ITEM_SUM_GET_MAX_AGGR_LEVEL(sum_item) (sum_item)->max_aggr_level
#else
#  define ITEM_SUM_GET_NEST_LEVEL(sum_item) (sum_item)->nest_level
#  define ITEM_SUM_GET_AGGR_LEVEL(sum_item) (sum_item)->aggr_level
#  define ITEM_SUM_GET_MAX_AGGR_LEVEL(sum_item) (sum_item)->max_arg_level
#endif

#if (!defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 80002)
  typedef bool mrn_bool;
#else
  typedef my_bool mrn_bool;
#endif

#define MRN_ALLOCATE_VARIABLE_LENGTH_ARRAYS(type, variable_name, variable_size) \
  type *variable_name =                                                 \
    (type *)mrn_my_malloc(sizeof(type) * (variable_size), MYF(MY_WME))
#define MRN_FREE_VARIABLE_LENGTH_ARRAYS(variable_name) \
  my_free(variable_name)

#if (defined(HA_CAN_VIRTUAL_COLUMNS) || defined(HA_GENERATED_COLUMNS))
#  define MRN_SUPPORT_GENERATED_COLUMNS
#endif

#ifdef MRN_MARIADB_P
#  if (MYSQL_VERSION_ID >= 100200)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) \
       (!field->stored_in_db())
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) \
       (field->vcol_info && field->vcol_info->is_stored())
#  elif (MYSQL_VERSION_ID >= 50500)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) \
       (!field->stored_in_db)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) \
       (field->vcol_info && field->vcol_info->is_stored())
#  else
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) false
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) false
#  endif
#else
#  if (MYSQL_VERSION_ID >= 50708)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) \
       (field->is_virtual_gcol())
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) \
       (field->is_gcol() && !field->is_virtual_gcol())
#  elif (MYSQL_VERSION_ID >= 50706)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) \
       (!field->stored_in_db)
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) \
       (field->gcol_info && field->gcol_info->get_field_stored())
#  else
#    define MRN_GENERATED_COLUMNS_FIELD_IS_VIRTUAL(field) false
#    define MRN_GENERATED_COLUMNS_FIELD_IS_STORED(field) false
#  endif
#endif

#ifdef MRN_MARIADB_P
#  if (MYSQL_VERSION_ID >= 100203)
#    define MRN_GENERATED_COLUMNS_UPDATE_VIRTUAL_FIELD(table, field) \
       (table->update_virtual_field(field))
#  else
#    define MRN_GENERATED_COLUMNS_UPDATE_VIRTUAL_FIELD(table, field) \
       (field->vcol_info->expr_item->save_in_field(field, 0))
#  endif
#endif

#ifdef MRN_PERCONA_P
#  if ((MYSQL_VERSION_ID >= 50634) && (MYSQL_VERSION_ID < 50700)) || \
      (MYSQL_VERSION_ID >= 50721)
#    define MRN_HAVE_DB_TYPE_ROCKSDB
#  endif
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100306
#  define MRN_TABLE_LIST_TABLE_NAME_DATA(table_list)    \
  (table_list)->table_name.str
#  define MRN_TABLE_LIST_TABLE_NAME_LENGTH(table_list)  \
  (table_list)->table_name.length
#else
#  define MRN_TABLE_LIST_TABLE_NAME_DATA(table_list)    \
  (table_list)->table_name
#  define MRN_TABLE_LIST_TABLE_NAME_LENGTH(table_list)  \
  (table_list)->table_name_length
#endif

#if defined(MRN_MARIADB_P) && MYSQL_VERSION_ID >= 100306
#  define mrn_table_list_init_one_table(table_list,                     \
                                        db_name,                        \
                                        db_name_length,                 \
                                        table_name,                     \
                                        table_name_length,              \
                                        alias,                          \
                                        lock_type) do {                 \
    LEX_CSTRING db_name_ = {db_name, db_name_length};                   \
    LEX_CSTRING table_name_ = {table_name, table_name_length};          \
    LEX_CSTRING alias_ = {alias, strlen(alias)};                        \
    (table_list)->init_one_table(&db_name_,                             \
                                 &table_name_,                          \
                                 &alias_,                               \
                                 lock_type);                            \
  } while(false)
#else
#  define mrn_table_list_init_one_table(table_list,             \
                                        db_name,                \
                                        db_name_length,         \
                                        table_name,             \
                                        table_name_length,      \
                                        alias,                  \
                                        lock_type)              \
  (table_list)->init_one_table(db_name,                         \
                               db_name_length,                  \
                               table_name,                      \
                               table_name_length,               \
                               alias,                           \
                               lock_type)
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
  typedef Key_spec mrn_key_spec;
#  define MRN_KEY_SPEC_LIST_EACH_BEGIN(spec_list, spec) do {            \
    for (size_t spec_i = 0; spec_i < spec_list.size(); ++spec_i) {      \
      const mrn_key_spec *spec = spec_list[spec_i];
#  define MRN_KEY_SPEC_LIST_EACH_END()          \
    }                                           \
  } while (false)
#else
  typedef Key mrn_key_spec;
#  define MRN_KEY_SPEC_LIST_EACH_BEGIN(spec_list, spec) do {    \
    List<mrn_key_spec> spec_list_ = spec_list;                  \
    List_iterator<mrn_key_spec> spec_iterator(spec_list_);      \
    const mrn_key_spec *spec;                                   \
    while ((spec = spec_iterator++))
#  define MRN_KEY_SPEC_LIST_EACH_END()          \
  } while (false)
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#  define MRN_KEY_PART_SPEC_LIST_N_ELEMENTS(spec_list)      \
  spec_list.size()
#  define MRN_KEY_PART_SPEC_LIST_EACH_BEGIN(spec_list, spec) do {       \
    for (size_t spec_i = 0; spec_i < spec_list.size(); ++spec_i) {      \
      const Key_part_spec *spec = spec_list[spec_i];
#  define MRN_KEY_PART_SPEC_LIST_EACH_END()     \
    }                                           \
  } while (false)
#else
#  define MRN_KEY_PART_SPEC_LIST_N_ELEMENTS(spec_list)      \
  spec_list.elements
#  define MRN_KEY_PART_SPEC_LIST_EACH_BEGIN(spec_list, spec) do {       \
    List<Key_part_spec> spec_list_ = spec_list;                         \
    List_iterator<Key_part_spec> spec_iterator(spec_list_);             \
    const Key_part_spec *spec;                                          \
    while ((spec = spec_iterator++))
#  define MRN_KEY_PART_SPEC_LIST_EACH_END()     \
  } while (false)
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
  typedef Foreign_key_spec mrn_foreign_key_spec;
#else
  typedef Foreign_key mrn_foreign_key_spec;
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
  class SELECT_LEX;
  typedef SELECT_LEX mrn_select_lex;
#else
  typedef st_select_lex mrn_select_lex;
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#  define MRN_FIELD_HAVE_AUTO_FLAGS
#endif

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#  define MRN_OPEN_TABLE_DEF_USE_TABLE_DEFINITION
#endif

#if MYSQL_VERSION_ID >= 100007 && defined(MRN_MARIADB_P)
#  define MRN_GET_ERR_MSG(code) my_get_err_msg(code)
#else
#  if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#    define MRN_GET_ERR_MSG(code) ER_DEFAULT(code)
#  else
#    define MRN_GET_ERR_MSG(code) ER(code)
#  endif
#endif

#define mrn_thd_set_ha_data(thd, hton, ha_data) \
  *thd_ha_data(thd, hton) = ha_data
// TODO
/* #define mrn_thd_set_ha_data(thd, hton, ha_data) \ */
/*    thd_set_ha_data(thd, hton, ha_data) */

#if MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P)
#  define mrn_destroy(pointer) destroy(pointer)
#else
#  define mrn_destroy(pointer) delete pointer
#endif

#if MYSQL_VERSION_ID >= 80013 && !defined(MRN_MARIADB_P)
#  define mrn_alloc_table_share(table_list, key, key_length) \
  alloc_table_share((table_list)->db,                        \
                    (table_list)->table_name,                \
                    (key),                                   \
                    (key_length),                            \
                    false)
#elif MYSQL_VERSION_ID >= 100306 && defined(MRN_MARIADB_P)
#  define mrn_alloc_table_share(table_list, key, key_length) \
  alloc_table_share((table_list)->db.str,                    \
                    (table_list)->table_name.str,            \
                    (key),                                   \
                    (key_length))
#elif (MYSQL_VERSION_ID >= 100002 && defined(MRN_MARIADB_P)) || \
  (MYSQL_VERSION_ID >= 80011 && !defined(MRN_MARIADB_P))
#  define mrn_alloc_table_share(table_list, key, key_length)    \
  alloc_table_share((table_list)->db,                           \
                    (table_list)->table_name,                   \
                    (key),                                      \
                    (key_length))
#else
#  define mrn_alloc_table_share(table_list, key, key_length)    \
  alloc_table_share((table_list), (key), (key_length))
#endif
