/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
/************ Begin %include sections from the grammar ************************/
#line 4 "grn_ecmascript.lemon"

#ifdef assert
#  undef assert
#endif
#define assert GRN_ASSERT
#line 34 "grn_ecmascript.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    grn_expr_parserTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is grn_expr_parserTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    grn_expr_parserARG_SDECL     A static variable declaration for the %extra_argument
**    grn_expr_parserARG_PDECL     A parameter declaration for the %extra_argument
**    grn_expr_parserARG_STORE     Code to store %extra_argument into yypParser
**    grn_expr_parserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_MIN_REDUCE      Maximum value for reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned char
#define YYNOCODE 114
#define YYACTIONTYPE unsigned short int
#define grn_expr_parserTOKENTYPE  int 
typedef union {
  int yyinit;
  grn_expr_parserTOKENTYPE yy0;
  void * yy165;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define grn_expr_parserARG_SDECL  efs_info *efsi ;
#define grn_expr_parserARG_PDECL , efs_info *efsi 
#define grn_expr_parserARG_FETCH  efs_info *efsi  = yypParser->efsi 
#define grn_expr_parserARG_STORE yypParser->efsi  = efsi 
#define YYNSTATE             142
#define YYNRULE              134
#define YY_MAX_SHIFT         141
#define YY_MIN_SHIFTREDUCE   227
#define YY_MAX_SHIFTREDUCE   360
#define YY_MIN_REDUCE        361
#define YY_MAX_REDUCE        494
#define YY_ERROR_ACTION      495
#define YY_ACCEPT_ACTION     496
#define YY_NO_ACTION         497
/************* End control #defines *******************************************/

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if:
**    (1)  The yy_shift_ofst[S]+X value is out of range, or
**    (2)  yy_lookahead[yy_shift_ofst[S]+X] is not equal to X, or
**    (3)  yy_shift_ofst[S] equal YY_SHIFT_USE_DFLT.
** (Implementation note: YY_SHIFT_USE_DFLT is chosen so that
** YY_SHIFT_USE_DFLT+X will be out of range for all possible lookaheads X.
** Hence only tests (1) and (2) need to be evaluated.)
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1759)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */     3,   71,  112,  112,  133,  316,    2,   77,   81,  126,
 /*    10 */     1,   77,   70,  496,   78,  109,  128,  234,   78,   74,
 /*    20 */   109,  109,   88,  123,  122,  136,  135,  134,  117,   85,
 /*    30 */   100,  113,  101,  101,  101,   88,   74,  234,  234,   74,
 /*    40 */    74,  316,   73,  356,   81,  141,    9,  227,   70,  230,
 /*    50 */    65,   64,   53,   52,   51,   68,   67,   66,   63,   62,
 /*    60 */    61,   60,   59,   58,  341,  342,  343,  344,  345,    4,
 /*    70 */   124,   69,   57,   56,   74,  124,  124,   88,  123,  122,
 /*    80 */   136,  135,  134,  117,   85,  100,  113,  101,  101,  101,
 /*    90 */    88,   74,  308,  130,   74,   74,  292,  336,  112,  112,
 /*   100 */   133,  316,    2,  232,   81,  126,    1,  107,   70,   77,
 /*   110 */   115,   31,   30,   77,   74,  115,  115,   88,  123,  122,
 /*   120 */   136,  135,  134,  117,   85,  100,  113,  101,  101,  101,
 /*   130 */    88,   74,  231,    7,   74,   74,  339,   72,  107,  130,
 /*   140 */   355,  133,  297,  293,  229,   76,   65,   64,   23,   55,
 /*   150 */    54,   68,   67,   66,   63,   62,   61,   60,   59,   58,
 /*   160 */   341,  342,  343,  344,  345,    4,   83,   82,   79,  316,
 /*   170 */    73,  317,   81,  141,    9,  338,   70,   65,   64,  305,
 /*   180 */   228,   28,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   190 */    58,  341,  342,  343,  344,  345,    4,  108,  349,  306,
 /*   200 */    74,  307,  307,   88,  123,  122,  136,  135,  134,  117,
 /*   210 */    85,  100,  113,  101,  101,  101,   88,   74,   10,    7,
 /*   220 */    74,   74,  339,   72,   36,   35,  350,    6,  302,   74,
 /*   230 */    84,   84,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   240 */   100,  113,  101,  101,  101,   88,   74,  447,  446,   74,
 /*   250 */    74,   11,   84,    7,  490,  348,  339,   72,  290,  291,
 /*   260 */   350,    5,   28,   65,   64,   28,   80,   29,   68,   67,
 /*   270 */    66,   63,   62,   61,   60,   59,   58,  341,  342,  343,
 /*   280 */   344,  345,    4,  347,    7,  310,  309,  339,   72,   26,
 /*   290 */     8,  349,  132,  233,  127,   28,  129,   65,   64,  448,
 /*   300 */    32,  357,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   310 */    58,  341,  342,  343,  344,  345,    4,  346,   24,   34,
 /*   320 */    25,  363,  296,   33,  363,  363,  363,  363,   65,   64,
 /*   330 */   363,  363,  363,   68,   67,   66,   63,   62,   61,   60,
 /*   340 */    59,   58,  341,  342,  343,  344,  345,    4,  363,  363,
 /*   350 */    75,   74,  307,  307,   88,  123,  122,  136,  135,  134,
 /*   360 */   117,   85,  100,  113,  101,  101,  101,   88,   74,  363,
 /*   370 */   363,   74,   74,  363,  363,  363,  363,  363,  363,  304,
 /*   380 */    74,  299,  299,   88,  123,  122,  136,  135,  134,  117,
 /*   390 */    85,  100,  113,  101,  101,  101,   88,   74,  363,  363,
 /*   400 */    74,   74,  363,  363,  363,  363,  363,  111,  115,  363,
 /*   410 */   363,  363,   74,  115,  115,   88,  123,  122,  136,  135,
 /*   420 */   134,  117,   85,  100,  113,  101,  101,  101,   88,   74,
 /*   430 */   118,  363,   74,   74,   74,  118,  118,   88,  123,  122,
 /*   440 */   136,  135,  134,  117,   85,  100,  113,  101,  101,  101,
 /*   450 */    88,   74,  363,    7,   74,   74,  339,   72,  124,  363,
 /*   460 */   363,  363,   74,  124,  124,   88,  123,  122,  136,  135,
 /*   470 */   134,  117,   85,  100,  113,  101,  101,  101,   88,   74,
 /*   480 */   363,    7,   74,   74,  339,   72,  363,  363,  363,  363,
 /*   490 */   363,  363,  363,  363,  363,  363,  363,   65,   64,  363,
 /*   500 */   363,  363,   68,   67,   66,   63,   62,   61,   60,   59,
 /*   510 */    58,  341,  342,  125,  344,  345,    4,  363,  363,  363,
 /*   520 */   363,  363,  363,  363,  363,   65,   64,  363,  363,  363,
 /*   530 */    68,   67,   66,   63,   62,   61,   60,   59,   58,  341,
 /*   540 */   342,  343,  344,  345,    4,   74,  353,  353,   88,  123,
 /*   550 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  101,
 /*   560 */   101,   88,   74,  363,  363,   74,   74,   74,  352,  352,
 /*   570 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   580 */   101,  101,  101,   88,   74,  363,  363,   74,   74,   74,
 /*   590 */   247,  247,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   600 */   100,  113,  101,  101,  101,   88,   74,  363,  363,   74,
 /*   610 */    74,  363,  363,   74,  246,  246,   88,  123,  122,  136,
 /*   620 */   135,  134,  117,   85,  100,  113,  101,  101,  101,   88,
 /*   630 */    74,  363,  363,   74,   74,   74,  245,  245,   88,  123,
 /*   640 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  101,
 /*   650 */   101,   88,   74,  363,  363,   74,   74,   74,  244,  244,
 /*   660 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   670 */   101,  101,  101,   88,   74,  363,  363,   74,   74,   74,
 /*   680 */   243,  243,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   690 */   100,  113,  101,  101,  101,   88,   74,  363,  363,   74,
 /*   700 */    74,   74,  242,  242,   88,  123,  122,  136,  135,  134,
 /*   710 */   117,   85,  100,  113,  101,  101,  101,   88,   74,  363,
 /*   720 */   363,   74,   74,   74,  241,  241,   88,  123,  122,  136,
 /*   730 */   135,  134,  117,   85,  100,  113,  101,  101,  101,   88,
 /*   740 */    74,  363,  363,   74,   74,   74,  240,  240,   88,  123,
 /*   750 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  101,
 /*   760 */   101,   88,   74,  363,  363,   74,   74,   74,  239,  239,
 /*   770 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   780 */   101,  101,  101,   88,   74,  363,  363,   74,   74,   74,
 /*   790 */   238,  238,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   800 */   100,  113,  101,  101,  101,   88,   74,  363,  363,   74,
 /*   810 */    74,   74,  237,  237,   88,  123,  122,  136,  135,  134,
 /*   820 */   117,   85,  100,  113,  101,  101,  101,   88,   74,  363,
 /*   830 */   363,   74,   74,   74,  300,  300,   88,  123,  122,  136,
 /*   840 */   135,  134,  117,   85,  100,  113,  101,  101,  101,   88,
 /*   850 */    74,  363,  363,   74,   74,   74,  295,  295,   88,  123,
 /*   860 */   122,  136,  135,  134,  117,   85,  100,  113,  101,  101,
 /*   870 */   101,   88,   74,  363,  363,   74,   74,   74,  248,  248,
 /*   880 */    88,  123,  122,  136,  135,  134,  117,   85,  100,  113,
 /*   890 */   101,  101,  101,   88,   74,  363,  363,   74,   74,   74,
 /*   900 */   140,  140,   88,  123,  122,  136,  135,  134,  117,   85,
 /*   910 */   100,  113,  101,  101,  101,   88,   74,  363,  363,   74,
 /*   920 */    74,   74,  236,  236,   88,  123,  122,  136,  135,  134,
 /*   930 */   117,   85,  100,  113,  101,  101,  101,   88,   74,  363,
 /*   940 */   363,   74,   74,   74,  235,  235,   88,  123,  122,  136,
 /*   950 */   135,  134,  117,   85,  100,  113,  101,  101,  101,   88,
 /*   960 */    74,  363,   74,   74,   74,  119,  363,  110,  136,  135,
 /*   970 */   134,  117,   85,  100,  113,  101,  101,  101,  119,   74,
 /*   980 */   363,   74,   74,   74,  119,  363,  363,  131,  135,  134,
 /*   990 */   117,   85,  100,  113,  101,  101,  101,  119,   74,  363,
 /*  1000 */   363,   74,   74,   74,  363,  363,  119,  363,  363,  139,
 /*  1010 */   135,  134,  117,   85,  100,  113,  101,  101,  101,  119,
 /*  1020 */    74,  363,  363,   74,   74,   74,  363,  363,  119,  363,
 /*  1030 */   363,  363,  138,  134,  117,   85,  100,  113,  101,  101,
 /*  1040 */   101,  119,   74,  363,  363,   74,   74,   74,  363,  363,
 /*  1050 */   119,  363,  363,  363,  363,  137,  117,   85,  100,  113,
 /*  1060 */   101,  101,  101,  119,   74,  363,  363,   74,   74,   50,
 /*  1070 */    49,   48,   47,   46,   45,   44,   43,   42,   41,   40,
 /*  1080 */    39,   38,   37,   27,   22,   21,   20,   19,   18,   17,
 /*  1090 */    16,   15,   14,   13,   12,   74,  363,  363,  119,  363,
 /*  1100 */   363,  363,  363,  363,  121,   85,  100,  113,  101,  101,
 /*  1110 */   101,  119,   74,  363,  363,   74,   74,  363,   74,  363,
 /*  1120 */   363,  119,  363,  363,  363,  290,  291,  363,   86,  100,
 /*  1130 */   113,  101,  101,  101,  119,   74,  363,  363,   74,   74,
 /*  1140 */    74,  363,  363,  119,  363,  363,  363,  363,  363,  363,
 /*  1150 */    87,  100,  113,  101,  101,  101,  119,   74,  363,   74,
 /*  1160 */    74,   74,  119,  363,  363,  363,  363,  363,  363,  363,
 /*  1170 */    89,  113,  101,  101,  101,  119,   74,  363,   74,   74,
 /*  1180 */    74,  119,  363,  363,  363,  363,  363,  363,  363,   90,
 /*  1190 */   113,  101,  101,  101,  119,   74,  363,  363,   74,   74,
 /*  1200 */   363,   74,  363,  363,  119,  363,  363,    7,  363,  363,
 /*  1210 */   339,   72,   91,  113,  101,  101,  101,  119,   74,  363,
 /*  1220 */   363,   74,   74,   74,  363,  363,  119,  363,  363,  363,
 /*  1230 */   363,  363,  363,  363,   92,  113,  101,  101,  101,  119,
 /*  1240 */    74,  363,   74,   74,   74,  119,  363,  363,  363,  363,
 /*  1250 */   363,  363,  363,   93,  113,  101,  101,  101,  119,   74,
 /*  1260 */   363,   74,   74,   74,  119,  341,  342,  343,  344,  345,
 /*  1270 */     4,  363,   94,  113,  101,  101,  101,  119,   74,  363,
 /*  1280 */   363,   74,   74,  363,   74,  363,  363,  119,  363,  363,
 /*  1290 */   363,  363,  363,  363,  363,   95,  113,  101,  101,  101,
 /*  1300 */   119,   74,  363,  363,   74,   74,   74,  363,  363,  119,
 /*  1310 */   363,  363,  363,  363,  363,  363,  363,   96,  113,  101,
 /*  1320 */   101,  101,  119,   74,  363,   74,   74,   74,  119,  363,
 /*  1330 */   363,  363,  363,  363,  363,  363,   97,  113,  101,  101,
 /*  1340 */   101,  119,   74,  363,   74,   74,   74,  119,  363,  363,
 /*  1350 */   363,  363,  363,  363,  363,   98,  113,  101,  101,  101,
 /*  1360 */   119,   74,  363,  363,   74,   74,  363,   74,  363,  363,
 /*  1370 */   119,  363,  363,  363,  363,  363,  363,  363,   99,  113,
 /*  1380 */   101,  101,  101,  119,   74,  363,  363,   74,   74,   74,
 /*  1390 */   363,  363,  119,  363,  363,  363,  363,  363,  363,  363,
 /*  1400 */   102,  113,  101,  101,  101,  119,   74,  363,   74,   74,
 /*  1410 */    74,  119,  363,  363,  363,  363,  363,  363,  363,  104,
 /*  1420 */   113,  101,  101,  101,  119,   74,  363,   74,   74,   74,
 /*  1430 */   119,  363,  363,  363,  363,  363,  363,  363,  106,  113,
 /*  1440 */   101,  101,  101,  119,   74,  363,  363,   74,   74,  363,
 /*  1450 */    74,  363,  363,  119,  363,  363,  363,  363,  363,  363,
 /*  1460 */   363,  363,  114,  101,  101,  101,  119,   74,  363,  363,
 /*  1470 */    74,   74,   74,  363,  363,  119,  363,  363,  363,  363,
 /*  1480 */   363,  363,  363,  363,  116,  101,  101,  101,  119,   74,
 /*  1490 */   363,   74,   74,   74,  119,  363,  363,  363,  363,  363,
 /*  1500 */   363,  363,  363,  120,  101,  101,  101,  119,   74,  363,
 /*  1510 */   363,   74,   74,  445,  363,  363,   83,   82,   79,  316,
 /*  1520 */    73,  363,   81,  141,    9,   74,   70,  363,  119,  363,
 /*  1530 */   363,  363,  363,  363,  363,  363,  363,  363,  103,  103,
 /*  1540 */   103,  119,   74,  363,  363,   74,   74,   74,  363,  363,
 /*  1550 */   119,  363,  363,  363,  363,   74,  363,  363,  119,  363,
 /*  1560 */   105,  105,  105,  119,   74,  363,  363,   74,   74,  278,
 /*  1570 */   278,  119,   74,  363,   74,   74,   74,  119,  363,  363,
 /*  1580 */   363,  363,  363,  363,  363,  363,  363,  363,  277,  277,
 /*  1590 */   119,   74,  363,  363,   74,   74,   74,  363,  363,  119,
 /*  1600 */   363,  363,  363,  363,  363,   74,  363,  363,  119,  363,
 /*  1610 */   289,  289,  119,   74,  363,  363,   74,   74,  363,  288,
 /*  1620 */   288,  119,   74,  363,   74,   74,   74,  119,  363,  363,
 /*  1630 */   363,  363,  363,   74,  363,  363,  119,  363,  287,  287,
 /*  1640 */   119,   74,  363,   74,   74,   74,  119,  286,  286,  119,
 /*  1650 */    74,  363,   74,   74,   74,  119,  363,  285,  285,  119,
 /*  1660 */    74,  363,  363,   74,   74,  363,  284,  284,  119,   74,
 /*  1670 */   363,   74,   74,   74,  119,  363,  363,  363,  363,   74,
 /*  1680 */   363,  363,  119,  363,  363,  283,  283,  119,   74,  363,
 /*  1690 */   363,   74,   74,  282,  282,  119,   74,  363,  363,   74,
 /*  1700 */    74,  363,   74,  363,  363,  119,  363,  363,  363,  363,
 /*  1710 */    74,  363,  363,  119,  363,  363,  281,  281,  119,   74,
 /*  1720 */   363,  363,   74,   74,  280,  280,  119,   74,  363,   74,
 /*  1730 */    74,   74,  119,  363,  363,  363,  363,   74,  363,  363,
 /*  1740 */   119,  363,  363,  279,  279,  119,   74,  363,  363,   74,
 /*  1750 */    74,  276,  276,  119,   74,  363,  363,   74,   74,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     1,    2,  106,  107,  108,    6,    7,   77,    9,   10,
 /*    10 */    11,   81,   13,   76,   77,   78,   10,   82,   81,   82,
 /*    20 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*    30 */    93,   94,   95,   96,   97,   98,   99,  102,  103,  102,
 /*    40 */   103,    6,    7,   67,    9,   10,   11,   81,   13,   81,
 /*    50 */    51,   52,   48,   49,   50,   56,   57,   58,   59,   60,
 /*    60 */    61,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    78,   53,   54,   55,   82,   83,   84,   85,   86,   87,
 /*    80 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*    90 */    98,   99,  111,  112,  102,  103,  100,  101,  106,  107,
 /*   100 */   108,    6,    7,   81,    9,   10,   11,   80,   13,   77,
 /*   110 */    78,    3,    4,   81,   82,   83,   84,   85,   86,   87,
 /*   120 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   130 */    98,   99,   81,    7,  102,  103,   10,   11,  111,  112,
 /*   140 */   107,  108,    8,   12,   81,   14,   51,   52,   14,   51,
 /*   150 */    52,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   160 */    65,   66,   67,   68,   69,   70,    3,    4,    5,    6,
 /*   170 */     7,    8,    9,   10,   11,    8,   13,   51,   52,   53,
 /*   180 */    81,   14,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   190 */    64,   65,   66,   67,   68,   69,   70,   79,   14,   73,
 /*   200 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   210 */    92,   93,   94,   95,   96,   97,   98,   99,  104,    7,
 /*   220 */   102,  103,   10,   11,   32,   33,   14,    7,  110,   82,
 /*   230 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   240 */    93,   94,   95,   96,   97,   98,   99,    0,    0,  102,
 /*   250 */   103,  104,  105,    7,   28,   71,   10,   11,   57,   58,
 /*   260 */    14,   14,   14,   51,   52,   14,    9,    5,   56,   57,
 /*   270 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   280 */    68,   69,   70,   71,    7,   67,   65,   10,   11,   27,
 /*   290 */    70,   14,   72,   12,   39,   14,   53,   51,   52,    0,
 /*   300 */    29,   10,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   310 */    64,   65,   66,   67,   68,   69,   70,   71,   28,   31,
 /*   320 */    28,  113,   71,   30,  113,  113,  113,  113,   51,   52,
 /*   330 */   113,  113,  113,   56,   57,   58,   59,   60,   61,   62,
 /*   340 */    63,   64,   65,   66,   67,   68,   69,   70,  113,  113,
 /*   350 */    51,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   360 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   370 */   113,  102,  103,  113,  113,  113,  113,  113,  113,  110,
 /*   380 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   390 */    92,   93,   94,   95,   96,   97,   98,   99,  113,  113,
 /*   400 */   102,  103,  113,  113,  113,  113,  113,  109,   78,  113,
 /*   410 */   113,  113,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   420 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   430 */    78,  113,  102,  103,   82,   83,   84,   85,   86,   87,
 /*   440 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   450 */    98,   99,  113,    7,  102,  103,   10,   11,   78,  113,
 /*   460 */   113,  113,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   470 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   480 */   113,    7,  102,  103,   10,   11,  113,  113,  113,  113,
 /*   490 */   113,  113,  113,  113,  113,  113,  113,   51,   52,  113,
 /*   500 */   113,  113,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   510 */    64,   65,   66,   67,   68,   69,   70,  113,  113,  113,
 /*   520 */   113,  113,  113,  113,  113,   51,   52,  113,  113,  113,
 /*   530 */    56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   540 */    66,   67,   68,   69,   70,   82,   83,   84,   85,   86,
 /*   550 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   560 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   570 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   580 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   590 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   600 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   610 */   103,  113,  113,   82,   83,   84,   85,   86,   87,   88,
 /*   620 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   630 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   640 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   650 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   660 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   670 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   680 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   690 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   700 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   710 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   720 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   730 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   740 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   750 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   760 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   770 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   780 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   790 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   800 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   810 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   820 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   830 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   840 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   850 */    99,  113,  113,  102,  103,   82,   83,   84,   85,   86,
 /*   860 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   870 */    97,   98,   99,  113,  113,  102,  103,   82,   83,   84,
 /*   880 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*   890 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*   900 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   910 */    93,   94,   95,   96,   97,   98,   99,  113,  113,  102,
 /*   920 */   103,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*   940 */   113,  102,  103,   82,   83,   84,   85,   86,   87,   88,
 /*   950 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   960 */    99,  113,   82,  102,  103,   85,  113,   87,   88,   89,
 /*   970 */    90,   91,   92,   93,   94,   95,   96,   97,   98,   99,
 /*   980 */   113,   82,  102,  103,   85,  113,  113,   88,   89,   90,
 /*   990 */    91,   92,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1000 */   113,  102,  103,   82,  113,  113,   85,  113,  113,   88,
 /*  1010 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*  1020 */    99,  113,  113,  102,  103,   82,  113,  113,   85,  113,
 /*  1030 */   113,  113,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1040 */    97,   98,   99,  113,  113,  102,  103,   82,  113,  113,
 /*  1050 */    85,  113,  113,  113,  113,   90,   91,   92,   93,   94,
 /*  1060 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   34,
 /*  1070 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*  1080 */    45,   46,   47,   15,   16,   17,   18,   19,   20,   21,
 /*  1090 */    22,   23,   24,   25,   26,   82,  113,  113,   85,  113,
 /*  1100 */   113,  113,  113,  113,   91,   92,   93,   94,   95,   96,
 /*  1110 */    97,   98,   99,  113,  113,  102,  103,  113,   82,  113,
 /*  1120 */   113,   85,  113,  113,  113,   57,   58,  113,   92,   93,
 /*  1130 */    94,   95,   96,   97,   98,   99,  113,  113,  102,  103,
 /*  1140 */    82,  113,  113,   85,  113,  113,  113,  113,  113,  113,
 /*  1150 */    92,   93,   94,   95,   96,   97,   98,   99,  113,   82,
 /*  1160 */   102,  103,   85,  113,  113,  113,  113,  113,  113,  113,
 /*  1170 */    93,   94,   95,   96,   97,   98,   99,  113,   82,  102,
 /*  1180 */   103,   85,  113,  113,  113,  113,  113,  113,  113,   93,
 /*  1190 */    94,   95,   96,   97,   98,   99,  113,  113,  102,  103,
 /*  1200 */   113,   82,  113,  113,   85,  113,  113,    7,  113,  113,
 /*  1210 */    10,   11,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1220 */   113,  102,  103,   82,  113,  113,   85,  113,  113,  113,
 /*  1230 */   113,  113,  113,  113,   93,   94,   95,   96,   97,   98,
 /*  1240 */    99,  113,   82,  102,  103,   85,  113,  113,  113,  113,
 /*  1250 */   113,  113,  113,   93,   94,   95,   96,   97,   98,   99,
 /*  1260 */   113,   82,  102,  103,   85,   65,   66,   67,   68,   69,
 /*  1270 */    70,  113,   93,   94,   95,   96,   97,   98,   99,  113,
 /*  1280 */   113,  102,  103,  113,   82,  113,  113,   85,  113,  113,
 /*  1290 */   113,  113,  113,  113,  113,   93,   94,   95,   96,   97,
 /*  1300 */    98,   99,  113,  113,  102,  103,   82,  113,  113,   85,
 /*  1310 */   113,  113,  113,  113,  113,  113,  113,   93,   94,   95,
 /*  1320 */    96,   97,   98,   99,  113,   82,  102,  103,   85,  113,
 /*  1330 */   113,  113,  113,  113,  113,  113,   93,   94,   95,   96,
 /*  1340 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1350 */   113,  113,  113,  113,  113,   93,   94,   95,   96,   97,
 /*  1360 */    98,   99,  113,  113,  102,  103,  113,   82,  113,  113,
 /*  1370 */    85,  113,  113,  113,  113,  113,  113,  113,   93,   94,
 /*  1380 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   82,
 /*  1390 */   113,  113,   85,  113,  113,  113,  113,  113,  113,  113,
 /*  1400 */    93,   94,   95,   96,   97,   98,   99,  113,   82,  102,
 /*  1410 */   103,   85,  113,  113,  113,  113,  113,  113,  113,   93,
 /*  1420 */    94,   95,   96,   97,   98,   99,  113,   82,  102,  103,
 /*  1430 */    85,  113,  113,  113,  113,  113,  113,  113,   93,   94,
 /*  1440 */    95,   96,   97,   98,   99,  113,  113,  102,  103,  113,
 /*  1450 */    82,  113,  113,   85,  113,  113,  113,  113,  113,  113,
 /*  1460 */   113,  113,   94,   95,   96,   97,   98,   99,  113,  113,
 /*  1470 */   102,  103,   82,  113,  113,   85,  113,  113,  113,  113,
 /*  1480 */   113,  113,  113,  113,   94,   95,   96,   97,   98,   99,
 /*  1490 */   113,   82,  102,  103,   85,  113,  113,  113,  113,  113,
 /*  1500 */   113,  113,  113,   94,   95,   96,   97,   98,   99,  113,
 /*  1510 */   113,  102,  103,    0,  113,  113,    3,    4,    5,    6,
 /*  1520 */     7,  113,    9,   10,   11,   82,   13,  113,   85,  113,
 /*  1530 */   113,  113,  113,  113,  113,  113,  113,  113,   95,   96,
 /*  1540 */    97,   98,   99,  113,  113,  102,  103,   82,  113,  113,
 /*  1550 */    85,  113,  113,  113,  113,   82,  113,  113,   85,  113,
 /*  1560 */    95,   96,   97,   98,   99,  113,  113,  102,  103,   96,
 /*  1570 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1580 */   113,  113,  113,  113,  113,  113,  113,  113,   96,   97,
 /*  1590 */    98,   99,  113,  113,  102,  103,   82,  113,  113,   85,
 /*  1600 */   113,  113,  113,  113,  113,   82,  113,  113,   85,  113,
 /*  1610 */    96,   97,   98,   99,  113,  113,  102,  103,  113,   96,
 /*  1620 */    97,   98,   99,  113,   82,  102,  103,   85,  113,  113,
 /*  1630 */   113,  113,  113,   82,  113,  113,   85,  113,   96,   97,
 /*  1640 */    98,   99,  113,   82,  102,  103,   85,   96,   97,   98,
 /*  1650 */    99,  113,   82,  102,  103,   85,  113,   96,   97,   98,
 /*  1660 */    99,  113,  113,  102,  103,  113,   96,   97,   98,   99,
 /*  1670 */   113,   82,  102,  103,   85,  113,  113,  113,  113,   82,
 /*  1680 */   113,  113,   85,  113,  113,   96,   97,   98,   99,  113,
 /*  1690 */   113,  102,  103,   96,   97,   98,   99,  113,  113,  102,
 /*  1700 */   103,  113,   82,  113,  113,   85,  113,  113,  113,  113,
 /*  1710 */    82,  113,  113,   85,  113,  113,   96,   97,   98,   99,
 /*  1720 */   113,  113,  102,  103,   96,   97,   98,   99,  113,   82,
 /*  1730 */   102,  103,   85,  113,  113,  113,  113,   82,  113,  113,
 /*  1740 */    85,  113,  113,   96,   97,   98,   99,  113,  113,  102,
 /*  1750 */   103,   96,   97,   98,   99,  113,  113,  102,  103,
};
#define YY_SHIFT_USE_DFLT (1759)
#define YY_SHIFT_COUNT    (141)
#define YY_SHIFT_MIN      (-24)
#define YY_SHIFT_MAX      (1513)
static const short yy_shift_ofst[] = {
 /*     0 */    -1,  446,   95,  126,  277,  126,  474,  474,  474,  474,
 /*    10 */   212,  246,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    20 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    30 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    40 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    50 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    60 */   474,  474,  474,  474,  474,  474,  474,  474,  474,  474,
 /*    70 */  1200,    6,  -24,   35,  220,    6,  -24,  163, 1513,   35,
 /*    80 */    35,   35,   35,   35,  184, 1035, 1035, 1035, 1068,    4,
 /*    90 */     4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
 /*   100 */     4,   18,    4,   18,    4,   18,    4,  299,  247,  248,
 /*   110 */   108,  134,  131,   98,   98,  167,   98,  192,  251,  201,
 /*   120 */    98,  192,  108,  262,  281,  226,  257,  218,  255,  221,
 /*   130 */   243,  271,  291,  290,  288,  293,  271,  288,  293,  271,
 /*   140 */   292,  257,
};
#define YY_REDUCE_USE_DFLT (-105)
#define YY_REDUCE_COUNT (84)
#define YY_REDUCE_MIN   (-104)
#define YY_REDUCE_MAX   (1655)
static const short yy_reduce_ofst[] = {
 /*     0 */   -63,   -8,   32,  118,  147,  269,  298,  330,  352,  380,
 /*    10 */   463,  485,  507,  531,  553,  575,  597,  619,  641,  663,
 /*    20 */   685,  707,  729,  751,  773,  795,  817,  839,  861,  880,
 /*    30 */   899,  921,  943,  965, 1013, 1036, 1058, 1077, 1096, 1119,
 /*    40 */  1141, 1160, 1179, 1202, 1224, 1243, 1262, 1285, 1307, 1326,
 /*    50 */  1345, 1368, 1390, 1409, 1443, 1465, 1473, 1492, 1514, 1523,
 /*    60 */  1542, 1551, 1561, 1570, 1589, 1597, 1620, 1628, 1647, 1655,
 /*    70 */   -65,   27, -104,  -70,   -4,  -19,   33,  -34,  -34,  -32,
 /*    80 */    22,   51,   63,   99,  114,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   495,  428,  495,  435,  495,  437,  432,  495,  495,  495,
 /*    10 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    20 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    30 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    40 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    50 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    60 */   495,  495,  495,  495,  495,  495,  495,  495,  495,  495,
 /*    70 */   495,  492,  428,  495,  468,  495,  495,  495,  495,  495,
 /*    80 */   495,  495,  495,  495,  495,  460,  390,  389,  466,  404,
 /*    90 */   403,  402,  401,  400,  399,  398,  397,  396,  395,  394,
 /*   100 */   461,  463,  393,  409,  392,  408,  391,  495,  495,  495,
 /*   110 */   383,  495,  495,  462,  407,  495,  406,  459,  495,  466,
 /*   120 */   405,  388,  455,  454,  495,  477,  473,  495,  495,  495,
 /*   130 */   494,  385,  495,  495,  458,  457,  456,  387,  386,  384,
 /*   140 */   495,  495,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  grn_expr_parserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "START_OUTPUT_COLUMNS",  "START_ADJUSTER",  "LOGICAL_AND", 
  "LOGICAL_AND_NOT",  "LOGICAL_OR",    "QSTRING",       "PARENL",      
  "PARENR",        "RELATIVE_OP",   "IDENTIFIER",    "BRACEL",      
  "BRACER",        "EVAL",          "COMMA",         "ASSIGN",      
  "STAR_ASSIGN",   "SLASH_ASSIGN",  "MOD_ASSIGN",    "PLUS_ASSIGN", 
  "MINUS_ASSIGN",  "SHIFTL_ASSIGN",  "SHIFTR_ASSIGN",  "SHIFTRR_ASSIGN",
  "AND_ASSIGN",    "XOR_ASSIGN",    "OR_ASSIGN",     "QUESTION",    
  "COLON",         "BITWISE_OR",    "BITWISE_XOR",   "BITWISE_AND", 
  "EQUAL",         "NOT_EQUAL",     "LESS",          "GREATER",     
  "LESS_EQUAL",    "GREATER_EQUAL",  "IN",            "MATCH",       
  "NEAR",          "NEAR2",         "SIMILAR",       "TERM_EXTRACT",
  "LCP",           "PREFIX",        "SUFFIX",        "REGEXP",      
  "SHIFTL",        "SHIFTR",        "SHIFTRR",       "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "MOD",         
  "DELETE",        "INCR",          "DECR",          "NOT",         
  "BITWISE_NOT",   "ADJUST",        "EXACT",         "PARTIAL",     
  "UNSPLIT",       "DECIMAL",       "HEX_INTEGER",   "STRING",      
  "BOOLEAN",       "NULL",          "BRACKETL",      "BRACKETR",    
  "DOT",           "NONEXISTENT_COLUMN",  "error",         "suppress_unused_variable_warning",
  "input",         "query",         "expression",    "output_columns",
  "adjuster",      "query_element",  "primary_expression",  "assignment_expression",
  "conditional_expression",  "lefthand_side_expression",  "logical_or_expression",  "logical_and_expression",
  "bitwise_or_expression",  "bitwise_xor_expression",  "bitwise_and_expression",  "equality_expression",
  "relational_expression",  "shift_expression",  "additive_expression",  "multiplicative_expression",
  "unary_expression",  "postfix_expression",  "call_expression",  "member_expression",
  "arguments",     "member_expression_part",  "object_literal",  "array_literal",
  "elision",       "element_list",  "property_name_and_value_list",  "property_name_and_value",
  "property_name",  "argument_list",  "output_column",  "adjust_expression",
  "adjust_match_expression",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "query ::= query query_element",
 /*   1 */ "query ::= query LOGICAL_AND query_element",
 /*   2 */ "query ::= query LOGICAL_AND_NOT query_element",
 /*   3 */ "query ::= query LOGICAL_OR query_element",
 /*   4 */ "query_element ::= RELATIVE_OP query_element",
 /*   5 */ "query_element ::= IDENTIFIER RELATIVE_OP query_element",
 /*   6 */ "query_element ::= BRACEL expression BRACER",
 /*   7 */ "query_element ::= EVAL primary_expression",
 /*   8 */ "expression ::= expression COMMA assignment_expression",
 /*   9 */ "assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression",
 /*  10 */ "assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression",
 /*  11 */ "assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression",
 /*  12 */ "assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression",
 /*  13 */ "assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression",
 /*  14 */ "assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression",
 /*  15 */ "assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression",
 /*  16 */ "assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression",
 /*  17 */ "assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression",
 /*  18 */ "assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression",
 /*  19 */ "assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression",
 /*  20 */ "assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression",
 /*  21 */ "conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression",
 /*  22 */ "logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression",
 /*  23 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression",
 /*  24 */ "logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression",
 /*  25 */ "bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression",
 /*  26 */ "bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression",
 /*  27 */ "bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression",
 /*  28 */ "equality_expression ::= equality_expression EQUAL relational_expression",
 /*  29 */ "equality_expression ::= equality_expression NOT_EQUAL relational_expression",
 /*  30 */ "relational_expression ::= relational_expression LESS shift_expression",
 /*  31 */ "relational_expression ::= relational_expression GREATER shift_expression",
 /*  32 */ "relational_expression ::= relational_expression LESS_EQUAL shift_expression",
 /*  33 */ "relational_expression ::= relational_expression GREATER_EQUAL shift_expression",
 /*  34 */ "relational_expression ::= relational_expression IN shift_expression",
 /*  35 */ "relational_expression ::= relational_expression MATCH shift_expression",
 /*  36 */ "relational_expression ::= relational_expression NEAR shift_expression",
 /*  37 */ "relational_expression ::= relational_expression NEAR2 shift_expression",
 /*  38 */ "relational_expression ::= relational_expression SIMILAR shift_expression",
 /*  39 */ "relational_expression ::= relational_expression TERM_EXTRACT shift_expression",
 /*  40 */ "relational_expression ::= relational_expression LCP shift_expression",
 /*  41 */ "relational_expression ::= relational_expression PREFIX shift_expression",
 /*  42 */ "relational_expression ::= relational_expression SUFFIX shift_expression",
 /*  43 */ "relational_expression ::= relational_expression REGEXP shift_expression",
 /*  44 */ "shift_expression ::= shift_expression SHIFTL additive_expression",
 /*  45 */ "shift_expression ::= shift_expression SHIFTR additive_expression",
 /*  46 */ "shift_expression ::= shift_expression SHIFTRR additive_expression",
 /*  47 */ "additive_expression ::= additive_expression PLUS multiplicative_expression",
 /*  48 */ "additive_expression ::= additive_expression MINUS multiplicative_expression",
 /*  49 */ "multiplicative_expression ::= multiplicative_expression STAR unary_expression",
 /*  50 */ "multiplicative_expression ::= multiplicative_expression SLASH unary_expression",
 /*  51 */ "multiplicative_expression ::= multiplicative_expression MOD unary_expression",
 /*  52 */ "unary_expression ::= DELETE unary_expression",
 /*  53 */ "unary_expression ::= INCR unary_expression",
 /*  54 */ "unary_expression ::= DECR unary_expression",
 /*  55 */ "unary_expression ::= PLUS unary_expression",
 /*  56 */ "unary_expression ::= MINUS unary_expression",
 /*  57 */ "unary_expression ::= NOT unary_expression",
 /*  58 */ "unary_expression ::= BITWISE_NOT unary_expression",
 /*  59 */ "unary_expression ::= ADJUST unary_expression",
 /*  60 */ "unary_expression ::= EXACT unary_expression",
 /*  61 */ "unary_expression ::= PARTIAL unary_expression",
 /*  62 */ "unary_expression ::= UNSPLIT unary_expression",
 /*  63 */ "postfix_expression ::= lefthand_side_expression INCR",
 /*  64 */ "postfix_expression ::= lefthand_side_expression DECR",
 /*  65 */ "call_expression ::= member_expression arguments",
 /*  66 */ "object_literal ::= BRACEL property_name_and_value_list BRACER",
 /*  67 */ "property_name_and_value_list ::=",
 /*  68 */ "property_name_and_value ::= property_name COLON assignment_expression",
 /*  69 */ "member_expression_part ::= BRACKETL expression BRACKETR",
 /*  70 */ "arguments ::= PARENL argument_list PARENR",
 /*  71 */ "argument_list ::=",
 /*  72 */ "argument_list ::= assignment_expression",
 /*  73 */ "argument_list ::= argument_list COMMA assignment_expression",
 /*  74 */ "output_columns ::=",
 /*  75 */ "output_columns ::= output_column",
 /*  76 */ "output_columns ::= output_columns COMMA",
 /*  77 */ "output_columns ::= output_columns COMMA output_column",
 /*  78 */ "output_column ::= STAR",
 /*  79 */ "output_column ::= NONEXISTENT_COLUMN",
 /*  80 */ "output_column ::= assignment_expression",
 /*  81 */ "adjuster ::= adjuster PLUS adjust_expression",
 /*  82 */ "adjust_expression ::= adjust_match_expression STAR DECIMAL",
 /*  83 */ "adjust_match_expression ::= IDENTIFIER MATCH STRING",
 /*  84 */ "input ::= query",
 /*  85 */ "input ::= expression",
 /*  86 */ "input ::= START_OUTPUT_COLUMNS output_columns",
 /*  87 */ "input ::= START_ADJUSTER adjuster",
 /*  88 */ "query ::= query_element",
 /*  89 */ "query_element ::= QSTRING",
 /*  90 */ "query_element ::= PARENL query PARENR",
 /*  91 */ "expression ::= assignment_expression",
 /*  92 */ "assignment_expression ::= conditional_expression",
 /*  93 */ "conditional_expression ::= logical_or_expression",
 /*  94 */ "logical_or_expression ::= logical_and_expression",
 /*  95 */ "logical_and_expression ::= bitwise_or_expression",
 /*  96 */ "bitwise_or_expression ::= bitwise_xor_expression",
 /*  97 */ "bitwise_xor_expression ::= bitwise_and_expression",
 /*  98 */ "bitwise_and_expression ::= equality_expression",
 /*  99 */ "equality_expression ::= relational_expression",
 /* 100 */ "relational_expression ::= shift_expression",
 /* 101 */ "shift_expression ::= additive_expression",
 /* 102 */ "additive_expression ::= multiplicative_expression",
 /* 103 */ "multiplicative_expression ::= unary_expression",
 /* 104 */ "unary_expression ::= postfix_expression",
 /* 105 */ "postfix_expression ::= lefthand_side_expression",
 /* 106 */ "lefthand_side_expression ::= call_expression",
 /* 107 */ "lefthand_side_expression ::= member_expression",
 /* 108 */ "member_expression ::= primary_expression",
 /* 109 */ "member_expression ::= member_expression member_expression_part",
 /* 110 */ "primary_expression ::= object_literal",
 /* 111 */ "primary_expression ::= PARENL expression PARENR",
 /* 112 */ "primary_expression ::= IDENTIFIER",
 /* 113 */ "primary_expression ::= array_literal",
 /* 114 */ "primary_expression ::= DECIMAL",
 /* 115 */ "primary_expression ::= HEX_INTEGER",
 /* 116 */ "primary_expression ::= STRING",
 /* 117 */ "primary_expression ::= BOOLEAN",
 /* 118 */ "primary_expression ::= NULL",
 /* 119 */ "array_literal ::= BRACKETL elision BRACKETR",
 /* 120 */ "array_literal ::= BRACKETL element_list elision BRACKETR",
 /* 121 */ "array_literal ::= BRACKETL element_list BRACKETR",
 /* 122 */ "elision ::= COMMA",
 /* 123 */ "elision ::= elision COMMA",
 /* 124 */ "element_list ::= assignment_expression",
 /* 125 */ "element_list ::= elision assignment_expression",
 /* 126 */ "element_list ::= element_list elision assignment_expression",
 /* 127 */ "property_name_and_value_list ::= property_name_and_value",
 /* 128 */ "property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value",
 /* 129 */ "property_name ::= STRING",
 /* 130 */ "member_expression_part ::= DOT IDENTIFIER",
 /* 131 */ "adjuster ::=",
 /* 132 */ "adjuster ::= adjust_expression",
 /* 133 */ "adjust_expression ::= adjust_match_expression",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to grn_expr_parserAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to grn_expr_parser and grn_expr_parserFree.
*/
void *grn_expr_parserAlloc(void *(*mallocProc)(YYMALLOCARGTYPE)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( pParser ){
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yytos = NULL;
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    if( yyGrowStack(pParser) ){
      pParser->yystack = &pParser->yystk0;
      pParser->yystksz = 1;
    }
#endif
#ifndef YYNOERRORRECOVERY
    pParser->yyerrcnt = -1;
#endif
    pParser->yytos = pParser->yystack;
    pParser->yystack[0].stateno = 0;
    pParser->yystack[0].major = 0;
  }
  return pParser;
}

/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  grn_expr_parserARG_FETCH;
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
    case 75: /* suppress_unused_variable_warning */
{
#line 14 "grn_ecmascript.lemon"

  (void)efsi;

#line 988 "grn_ecmascript.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void grn_expr_parserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
#ifndef YYPARSEFREENEVERNULL
  if( pParser==0 ) return;
#endif
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int grn_expr_parserStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static unsigned int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yytos->stateno;
 
  if( stateno>=YY_MIN_REDUCE ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
  do{
    i = yy_shift_ofst[stateno];
    assert( iLookAhead!=YYNOCODE );
    i += iLookAhead;
    if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   grn_expr_parserARG_FETCH;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%sShift '%s', go to state %d\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%sShift '%s'\n",
         yyTracePrompt,yyTokenName[yypParser->yytos->major]);
    }
  }
}
#else
# define yyTraceShift(X,Y)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  grn_expr_parserTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH] ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState);
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 77, 2 },
  { 77, 3 },
  { 77, 3 },
  { 77, 3 },
  { 81, 2 },
  { 81, 3 },
  { 81, 3 },
  { 81, 2 },
  { 78, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 83, 3 },
  { 84, 5 },
  { 86, 3 },
  { 87, 3 },
  { 87, 3 },
  { 88, 3 },
  { 89, 3 },
  { 90, 3 },
  { 91, 3 },
  { 91, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 92, 3 },
  { 93, 3 },
  { 93, 3 },
  { 93, 3 },
  { 94, 3 },
  { 94, 3 },
  { 95, 3 },
  { 95, 3 },
  { 95, 3 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 96, 2 },
  { 97, 2 },
  { 97, 2 },
  { 98, 2 },
  { 102, 3 },
  { 106, 0 },
  { 107, 3 },
  { 101, 3 },
  { 100, 3 },
  { 109, 0 },
  { 109, 1 },
  { 109, 3 },
  { 79, 0 },
  { 79, 1 },
  { 79, 2 },
  { 79, 3 },
  { 110, 1 },
  { 110, 1 },
  { 110, 1 },
  { 80, 3 },
  { 111, 3 },
  { 112, 3 },
  { 76, 1 },
  { 76, 1 },
  { 76, 2 },
  { 76, 2 },
  { 77, 1 },
  { 81, 1 },
  { 81, 3 },
  { 78, 1 },
  { 83, 1 },
  { 84, 1 },
  { 86, 1 },
  { 87, 1 },
  { 88, 1 },
  { 89, 1 },
  { 90, 1 },
  { 91, 1 },
  { 92, 1 },
  { 93, 1 },
  { 94, 1 },
  { 95, 1 },
  { 96, 1 },
  { 97, 1 },
  { 85, 1 },
  { 85, 1 },
  { 99, 1 },
  { 99, 2 },
  { 82, 1 },
  { 82, 3 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 82, 1 },
  { 103, 3 },
  { 103, 4 },
  { 103, 3 },
  { 104, 1 },
  { 104, 2 },
  { 105, 1 },
  { 105, 2 },
  { 105, 3 },
  { 106, 1 },
  { 106, 3 },
  { 108, 1 },
  { 101, 2 },
  { 80, 0 },
  { 80, 1 },
  { 111, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno        /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  grn_expr_parserARG_FETCH;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    fprintf(yyTraceFILE, "%sReduce [%s], go to state %d.\n", yyTracePrompt,
      yyRuleName[yyruleno], yymsp[-yysize].stateno);
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=&yypParser->yystack[YYSTACKDEPTH-1] ){
      yyStackOverflow(yypParser);
      return;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        return;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* query ::= query query_element */
#line 53 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, grn_int32_value_at(&efsi->op_stack, -1), 2);
}
#line 1433 "grn_ecmascript.c"
        break;
      case 1: /* query ::= query LOGICAL_AND query_element */
      case 23: /* logical_and_expression ::= logical_and_expression LOGICAL_AND bitwise_or_expression */ yytestcase(yyruleno==23);
#line 56 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND, 2);
}
#line 1441 "grn_ecmascript.c"
        break;
      case 2: /* query ::= query LOGICAL_AND_NOT query_element */
      case 24: /* logical_and_expression ::= logical_and_expression LOGICAL_AND_NOT bitwise_or_expression */ yytestcase(yyruleno==24);
#line 59 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_NOT, 2);
}
#line 1449 "grn_ecmascript.c"
        break;
      case 3: /* query ::= query LOGICAL_OR query_element */
      case 22: /* logical_or_expression ::= logical_or_expression LOGICAL_OR logical_and_expression */ yytestcase(yyruleno==22);
#line 62 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR, 2);
}
#line 1457 "grn_ecmascript.c"
        break;
      case 4: /* query_element ::= RELATIVE_OP query_element */
#line 69 "grn_ecmascript.lemon"
{
  int mode;
  GRN_INT32_POP(&efsi->mode_stack, mode);
}
#line 1465 "grn_ecmascript.c"
        break;
      case 5: /* query_element ::= IDENTIFIER RELATIVE_OP query_element */
#line 73 "grn_ecmascript.lemon"
{
  int mode;
  grn_obj *c;
  GRN_PTR_POP(&efsi->column_stack, c);
  GRN_INT32_POP(&efsi->mode_stack, mode);
  switch (mode) {
  case GRN_OP_NEAR :
  case GRN_OP_NEAR2 :
    {
      int max_interval;
      GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    }
    break;
  case GRN_OP_SIMILAR :
    {
      int similarity_threshold;
      GRN_INT32_POP(&efsi->similarity_threshold_stack, similarity_threshold);
    }
    break;
  default :
    break;
  }
}
#line 1492 "grn_ecmascript.c"
        break;
      case 6: /* query_element ::= BRACEL expression BRACER */
      case 7: /* query_element ::= EVAL primary_expression */ yytestcase(yyruleno==7);
#line 96 "grn_ecmascript.lemon"
{
  efsi->flags = efsi->default_flags;
}
#line 1500 "grn_ecmascript.c"
        break;
      case 8: /* expression ::= expression COMMA assignment_expression */
#line 104 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
}
#line 1507 "grn_ecmascript.c"
        break;
      case 9: /* assignment_expression ::= lefthand_side_expression ASSIGN assignment_expression */
#line 109 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ASSIGN, 2);
}
#line 1514 "grn_ecmascript.c"
        break;
      case 10: /* assignment_expression ::= lefthand_side_expression STAR_ASSIGN assignment_expression */
#line 112 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR_ASSIGN, 2);
}
#line 1521 "grn_ecmascript.c"
        break;
      case 11: /* assignment_expression ::= lefthand_side_expression SLASH_ASSIGN assignment_expression */
#line 115 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH_ASSIGN, 2);
}
#line 1528 "grn_ecmascript.c"
        break;
      case 12: /* assignment_expression ::= lefthand_side_expression MOD_ASSIGN assignment_expression */
#line 118 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD_ASSIGN, 2);
}
#line 1535 "grn_ecmascript.c"
        break;
      case 13: /* assignment_expression ::= lefthand_side_expression PLUS_ASSIGN assignment_expression */
#line 121 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS_ASSIGN, 2);
}
#line 1542 "grn_ecmascript.c"
        break;
      case 14: /* assignment_expression ::= lefthand_side_expression MINUS_ASSIGN assignment_expression */
#line 124 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS_ASSIGN, 2);
}
#line 1549 "grn_ecmascript.c"
        break;
      case 15: /* assignment_expression ::= lefthand_side_expression SHIFTL_ASSIGN assignment_expression */
#line 127 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL_ASSIGN, 2);
}
#line 1556 "grn_ecmascript.c"
        break;
      case 16: /* assignment_expression ::= lefthand_side_expression SHIFTR_ASSIGN assignment_expression */
#line 130 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR_ASSIGN, 2);
}
#line 1563 "grn_ecmascript.c"
        break;
      case 17: /* assignment_expression ::= lefthand_side_expression SHIFTRR_ASSIGN assignment_expression */
#line 133 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR_ASSIGN, 2);
}
#line 1570 "grn_ecmascript.c"
        break;
      case 18: /* assignment_expression ::= lefthand_side_expression AND_ASSIGN assignment_expression */
#line 136 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_AND_ASSIGN, 2);
}
#line 1577 "grn_ecmascript.c"
        break;
      case 19: /* assignment_expression ::= lefthand_side_expression XOR_ASSIGN assignment_expression */
#line 139 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_XOR_ASSIGN, 2);
}
#line 1584 "grn_ecmascript.c"
        break;
      case 20: /* assignment_expression ::= lefthand_side_expression OR_ASSIGN assignment_expression */
#line 142 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_OR_ASSIGN, 2);
}
#line 1591 "grn_ecmascript.c"
        break;
      case 21: /* conditional_expression ::= logical_or_expression QUESTION assignment_expression COLON assignment_expression */
#line 147 "grn_ecmascript.lemon"
{
  grn_expr *e = (grn_expr *)efsi->e;
  e->codes[yymsp[-3].minor.yy0].nargs = yymsp[-1].minor.yy0 - yymsp[-3].minor.yy0;
  e->codes[yymsp[-1].minor.yy0].nargs = e->codes_curr - yymsp[-1].minor.yy0 - 1;
}
#line 1600 "grn_ecmascript.c"
        break;
      case 25: /* bitwise_or_expression ::= bitwise_or_expression BITWISE_OR bitwise_xor_expression */
#line 167 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_OR, 2);
}
#line 1607 "grn_ecmascript.c"
        break;
      case 26: /* bitwise_xor_expression ::= bitwise_xor_expression BITWISE_XOR bitwise_and_expression */
#line 172 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_XOR, 2);
}
#line 1614 "grn_ecmascript.c"
        break;
      case 27: /* bitwise_and_expression ::= bitwise_and_expression BITWISE_AND equality_expression */
#line 177 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_AND, 2);
}
#line 1621 "grn_ecmascript.c"
        break;
      case 28: /* equality_expression ::= equality_expression EQUAL relational_expression */
#line 182 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EQUAL, 2);
}
#line 1628 "grn_ecmascript.c"
        break;
      case 29: /* equality_expression ::= equality_expression NOT_EQUAL relational_expression */
#line 185 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT_EQUAL, 2);
}
#line 1635 "grn_ecmascript.c"
        break;
      case 30: /* relational_expression ::= relational_expression LESS shift_expression */
#line 190 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS, 2);
}
#line 1642 "grn_ecmascript.c"
        break;
      case 31: /* relational_expression ::= relational_expression GREATER shift_expression */
#line 193 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER, 2);
}
#line 1649 "grn_ecmascript.c"
        break;
      case 32: /* relational_expression ::= relational_expression LESS_EQUAL shift_expression */
#line 196 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LESS_EQUAL, 2);
}
#line 1656 "grn_ecmascript.c"
        break;
      case 33: /* relational_expression ::= relational_expression GREATER_EQUAL shift_expression */
#line 199 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GREATER_EQUAL, 2);
}
#line 1663 "grn_ecmascript.c"
        break;
      case 34: /* relational_expression ::= relational_expression IN shift_expression */
#line 202 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_IN, 2);
}
#line 1670 "grn_ecmascript.c"
        break;
      case 35: /* relational_expression ::= relational_expression MATCH shift_expression */
      case 83: /* adjust_match_expression ::= IDENTIFIER MATCH STRING */ yytestcase(yyruleno==83);
#line 205 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MATCH, 2);
}
#line 1678 "grn_ecmascript.c"
        break;
      case 36: /* relational_expression ::= relational_expression NEAR shift_expression */
#line 208 "grn_ecmascript.lemon"
{
  {
    int max_interval;
    GRN_INT32_POP(&efsi->max_interval_stack, max_interval);
    grn_expr_append_const_int(efsi->ctx, efsi->e, max_interval,
                              GRN_OP_PUSH, 1);
  }
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR, 3);
}
#line 1691 "grn_ecmascript.c"
        break;
      case 37: /* relational_expression ::= relational_expression NEAR2 shift_expression */
#line 217 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NEAR2, 2);
}
#line 1698 "grn_ecmascript.c"
        break;
      case 38: /* relational_expression ::= relational_expression SIMILAR shift_expression */
#line 220 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SIMILAR, 2);
}
#line 1705 "grn_ecmascript.c"
        break;
      case 39: /* relational_expression ::= relational_expression TERM_EXTRACT shift_expression */
#line 223 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_TERM_EXTRACT, 2);
}
#line 1712 "grn_ecmascript.c"
        break;
      case 40: /* relational_expression ::= relational_expression LCP shift_expression */
#line 226 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_LCP, 2);
}
#line 1719 "grn_ecmascript.c"
        break;
      case 41: /* relational_expression ::= relational_expression PREFIX shift_expression */
#line 229 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PREFIX, 2);
}
#line 1726 "grn_ecmascript.c"
        break;
      case 42: /* relational_expression ::= relational_expression SUFFIX shift_expression */
#line 232 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SUFFIX, 2);
}
#line 1733 "grn_ecmascript.c"
        break;
      case 43: /* relational_expression ::= relational_expression REGEXP shift_expression */
#line 235 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_REGEXP, 2);
}
#line 1740 "grn_ecmascript.c"
        break;
      case 44: /* shift_expression ::= shift_expression SHIFTL additive_expression */
#line 240 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTL, 2);
}
#line 1747 "grn_ecmascript.c"
        break;
      case 45: /* shift_expression ::= shift_expression SHIFTR additive_expression */
#line 243 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTR, 2);
}
#line 1754 "grn_ecmascript.c"
        break;
      case 46: /* shift_expression ::= shift_expression SHIFTRR additive_expression */
#line 246 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SHIFTRR, 2);
}
#line 1761 "grn_ecmascript.c"
        break;
      case 47: /* additive_expression ::= additive_expression PLUS multiplicative_expression */
      case 81: /* adjuster ::= adjuster PLUS adjust_expression */ yytestcase(yyruleno==81);
#line 251 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 2);
}
#line 1769 "grn_ecmascript.c"
        break;
      case 48: /* additive_expression ::= additive_expression MINUS multiplicative_expression */
#line 254 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 2);
}
#line 1776 "grn_ecmascript.c"
        break;
      case 49: /* multiplicative_expression ::= multiplicative_expression STAR unary_expression */
      case 82: /* adjust_expression ::= adjust_match_expression STAR DECIMAL */ yytestcase(yyruleno==82);
#line 259 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_STAR, 2);
}
#line 1784 "grn_ecmascript.c"
        break;
      case 50: /* multiplicative_expression ::= multiplicative_expression SLASH unary_expression */
#line 262 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_SLASH, 2);
}
#line 1791 "grn_ecmascript.c"
        break;
      case 51: /* multiplicative_expression ::= multiplicative_expression MOD unary_expression */
#line 265 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MOD, 2);
}
#line 1798 "grn_ecmascript.c"
        break;
      case 52: /* unary_expression ::= DELETE unary_expression */
#line 270 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DELETE, 1);
}
#line 1805 "grn_ecmascript.c"
        break;
      case 53: /* unary_expression ::= INCR unary_expression */
#line 273 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR, 1);
  }
}
#line 1826 "grn_ecmascript.c"
        break;
      case 54: /* unary_expression ::= DECR unary_expression */
#line 290 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR, 1);
  }
}
#line 1847 "grn_ecmascript.c"
        break;
      case 55: /* unary_expression ::= PLUS unary_expression */
#line 307 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PLUS, 1);
}
#line 1854 "grn_ecmascript.c"
        break;
      case 56: /* unary_expression ::= MINUS unary_expression */
#line 310 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_MINUS, 1);
}
#line 1861 "grn_ecmascript.c"
        break;
      case 57: /* unary_expression ::= NOT unary_expression */
#line 313 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_NOT, 1);
}
#line 1868 "grn_ecmascript.c"
        break;
      case 58: /* unary_expression ::= BITWISE_NOT unary_expression */
#line 316 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_BITWISE_NOT, 1);
}
#line 1875 "grn_ecmascript.c"
        break;
      case 59: /* unary_expression ::= ADJUST unary_expression */
#line 319 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_ADJUST, 1);
}
#line 1882 "grn_ecmascript.c"
        break;
      case 60: /* unary_expression ::= EXACT unary_expression */
#line 322 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_EXACT, 1);
}
#line 1889 "grn_ecmascript.c"
        break;
      case 61: /* unary_expression ::= PARTIAL unary_expression */
#line 325 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_PARTIAL, 1);
}
#line 1896 "grn_ecmascript.c"
        break;
      case 62: /* unary_expression ::= UNSPLIT unary_expression */
#line 328 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_UNSPLIT, 1);
}
#line 1903 "grn_ecmascript.c"
        break;
      case 63: /* postfix_expression ::= lefthand_side_expression INCR */
#line 333 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be incremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_INCR_POST, 1);
  }
}
#line 1924 "grn_ecmascript.c"
        break;
      case 64: /* postfix_expression ::= lefthand_side_expression DECR */
#line 350 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_expr_dfi *dfi_;
  unsigned int const_p;

  dfi_ = grn_expr_dfi_pop(e);
  const_p = CONSTP(dfi_->code->value);
  grn_expr_dfi_put(ctx, e, dfi_->type, dfi_->domain, dfi_->code);
  if (const_p) {
    ERR(GRN_SYNTAX_ERROR,
        "constant can't be decremented: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_DECR_POST, 1);
  }
}
#line 1945 "grn_ecmascript.c"
        break;
      case 65: /* call_expression ::= member_expression arguments */
#line 371 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_CALL, yymsp[0].minor.yy0);
}
#line 1952 "grn_ecmascript.c"
        break;
      case 66: /* object_literal ::= BRACEL property_name_and_value_list BRACER */
#line 399 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr_take_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal));
  grn_expr_append_obj(ctx, efsi->e, (grn_obj *)(efsi->object_literal),
                      GRN_OP_PUSH, 1);
  efsi->object_literal = NULL;
}
#line 1963 "grn_ecmascript.c"
        break;
      case 67: /* property_name_and_value_list ::= */
#line 407 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;

  efsi->object_literal =
    grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                    GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  }
}
#line 1979 "grn_ecmascript.c"
        break;
      case 68: /* property_name_and_value ::= property_name COLON assignment_expression */
#line 422 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_expr *e = (grn_expr *)(efsi->e);
  grn_obj *property = e->codes[e->codes_curr - 3].value;
  grn_obj *value = e->codes[e->codes_curr - 1].value;

  if (!efsi->object_literal) {
     efsi->object_literal =
       grn_hash_create(ctx, NULL, GRN_TABLE_MAX_KEY_SIZE, sizeof(grn_obj),
                       GRN_OBJ_KEY_VAR_SIZE|GRN_OBJ_TEMPORARY|GRN_HASH_TINY);
  }

  if (!efsi->object_literal) {
    ERR(GRN_NO_MEMORY_AVAILABLE,
        "couldn't create hash table for parsing object literal: <%.*s>",
        (int)(efsi->str_end - efsi->str), efsi->str);
  } else {
    grn_obj *buf;
    int added;
    if (grn_hash_add(ctx, (grn_hash *)efsi->object_literal,
                     GRN_TEXT_VALUE(property), GRN_TEXT_LEN(property),
                     (void **)&buf, &added)) {
      if (added) {
        GRN_OBJ_INIT(buf, value->header.type, 0, value->header.domain);
        GRN_TEXT_PUT(ctx, buf, GRN_TEXT_VALUE(value), GRN_TEXT_LEN(value));
        grn_expr_dfi_pop(e);
        e->codes_curr -= 3;
      } else {
        ERR(GRN_INVALID_ARGUMENT,
            "duplicated property name: <%.*s>",
            (int)GRN_TEXT_LEN(property),
            GRN_TEXT_VALUE(property));
      }
    } else {
      ERR(GRN_NO_MEMORY_AVAILABLE,
          "failed to add a property to object literal: <%.*s>",
          (int)GRN_TEXT_LEN(property),
          GRN_TEXT_VALUE(property));
    }
  }
}
#line 2024 "grn_ecmascript.c"
        break;
      case 69: /* member_expression_part ::= BRACKETL expression BRACKETR */
#line 466 "grn_ecmascript.lemon"
{
  grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_GET_MEMBER, 2);
}
#line 2031 "grn_ecmascript.c"
        break;
      case 70: /* arguments ::= PARENL argument_list PARENR */
#line 471 "grn_ecmascript.lemon"
{ yymsp[-2].minor.yy0 = yymsp[-1].minor.yy0; }
#line 2036 "grn_ecmascript.c"
        break;
      case 71: /* argument_list ::= */
#line 472 "grn_ecmascript.lemon"
{ yymsp[1].minor.yy0 = 0; }
#line 2041 "grn_ecmascript.c"
        break;
      case 72: /* argument_list ::= assignment_expression */
#line 473 "grn_ecmascript.lemon"
{ yymsp[0].minor.yy0 = 1; }
#line 2046 "grn_ecmascript.c"
        break;
      case 73: /* argument_list ::= argument_list COMMA assignment_expression */
#line 474 "grn_ecmascript.lemon"
{ yylhsminor.yy0 = yymsp[-2].minor.yy0 + 1; }
#line 2051 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 74: /* output_columns ::= */
#line 476 "grn_ecmascript.lemon"
{
  yymsp[1].minor.yy0 = 0;
}
#line 2059 "grn_ecmascript.c"
        break;
      case 75: /* output_columns ::= output_column */
#line 479 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[0].minor.yy0;
}
#line 2066 "grn_ecmascript.c"
  yymsp[0].minor.yy0 = yylhsminor.yy0;
        break;
      case 76: /* output_columns ::= output_columns COMMA */
#line 484 "grn_ecmascript.lemon"
{
  yylhsminor.yy0 = yymsp[-1].minor.yy0;
}
#line 2074 "grn_ecmascript.c"
  yymsp[-1].minor.yy0 = yylhsminor.yy0;
        break;
      case 77: /* output_columns ::= output_columns COMMA output_column */
#line 489 "grn_ecmascript.lemon"
{
  if (yymsp[-2].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[0].minor.yy0;
  } else if (yymsp[0].minor.yy0 == 0) {
    yylhsminor.yy0 = yymsp[-2].minor.yy0;
  } else {
    if (yymsp[0].minor.yy0 == 1) {
      grn_expr_append_op(efsi->ctx, efsi->e, GRN_OP_COMMA, 2);
    }
    yylhsminor.yy0 = 1;
  }
}
#line 2091 "grn_ecmascript.c"
  yymsp[-2].minor.yy0 = yylhsminor.yy0;
        break;
      case 78: /* output_column ::= STAR */
#line 502 "grn_ecmascript.lemon"
{
  grn_ctx *ctx = efsi->ctx;
  grn_obj *expr = efsi->e;
  grn_obj *variable = grn_expr_get_var_by_offset(ctx, expr, 0);
  if (variable) {
    grn_id table_id = GRN_OBJ_GET_DOMAIN(variable);
    grn_obj *table = grn_ctx_at(ctx, table_id);
    grn_obj columns_buffer;
    int n_columns;
    grn_obj **columns;

    GRN_PTR_INIT(&columns_buffer, GRN_OBJ_VECTOR, GRN_ID_NIL);
    grn_obj_columns(ctx, table, "*", strlen("*"), &columns_buffer);
    n_columns = GRN_BULK_VSIZE(&columns_buffer) / sizeof(grn_obj *);
    columns = (grn_obj **)GRN_BULK_HEAD(&columns_buffer);

    if (n_columns == 0) {
      /* do nothing */
    } else if (n_columns == 1) {
      grn_obj *column = columns[0];
      grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
      if (column->header.type == GRN_ACCESSOR) {
        grn_expr_take_obj(ctx, expr, column);
      }
    } else {
      grn_expr *e = (grn_expr *)expr;
      grn_bool have_column;
      int i;

      have_column = (e->codes_curr > 0);
      for (i = 0; i < n_columns; i++) {
        grn_obj *column = columns[i];
        grn_expr_append_const(ctx, expr, column, GRN_OP_GET_VALUE, 1);
        if (have_column || i > 0) {
          grn_expr_append_op(ctx, expr, GRN_OP_COMMA, 2);
        }
        if (column->header.type == GRN_ACCESSOR) {
          grn_expr_take_obj(ctx, expr, column);
        }
      }
    }

    GRN_OBJ_FIN(ctx, &columns_buffer);

    yymsp[0].minor.yy0 = n_columns;
  } else {
    /* TODO: report error */
    yymsp[0].minor.yy0 = 0;
  }
}
#line 2146 "grn_ecmascript.c"
        break;
      case 79: /* output_column ::= NONEXISTENT_COLUMN */
#line 552 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 0;
}
#line 2153 "grn_ecmascript.c"
        break;
      case 80: /* output_column ::= assignment_expression */
#line 555 "grn_ecmascript.lemon"
{
  yymsp[0].minor.yy0 = 1;
}
#line 2160 "grn_ecmascript.c"
        break;
      default:
      /* (84) input ::= query */ yytestcase(yyruleno==84);
      /* (85) input ::= expression */ yytestcase(yyruleno==85);
      /* (86) input ::= START_OUTPUT_COLUMNS output_columns */ yytestcase(yyruleno==86);
      /* (87) input ::= START_ADJUSTER adjuster */ yytestcase(yyruleno==87);
      /* (88) query ::= query_element (OPTIMIZED OUT) */ assert(yyruleno!=88);
      /* (89) query_element ::= QSTRING */ yytestcase(yyruleno==89);
      /* (90) query_element ::= PARENL query PARENR */ yytestcase(yyruleno==90);
      /* (91) expression ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=91);
      /* (92) assignment_expression ::= conditional_expression (OPTIMIZED OUT) */ assert(yyruleno!=92);
      /* (93) conditional_expression ::= logical_or_expression */ yytestcase(yyruleno==93);
      /* (94) logical_or_expression ::= logical_and_expression */ yytestcase(yyruleno==94);
      /* (95) logical_and_expression ::= bitwise_or_expression */ yytestcase(yyruleno==95);
      /* (96) bitwise_or_expression ::= bitwise_xor_expression */ yytestcase(yyruleno==96);
      /* (97) bitwise_xor_expression ::= bitwise_and_expression */ yytestcase(yyruleno==97);
      /* (98) bitwise_and_expression ::= equality_expression */ yytestcase(yyruleno==98);
      /* (99) equality_expression ::= relational_expression */ yytestcase(yyruleno==99);
      /* (100) relational_expression ::= shift_expression */ yytestcase(yyruleno==100);
      /* (101) shift_expression ::= additive_expression */ yytestcase(yyruleno==101);
      /* (102) additive_expression ::= multiplicative_expression */ yytestcase(yyruleno==102);
      /* (103) multiplicative_expression ::= unary_expression (OPTIMIZED OUT) */ assert(yyruleno!=103);
      /* (104) unary_expression ::= postfix_expression (OPTIMIZED OUT) */ assert(yyruleno!=104);
      /* (105) postfix_expression ::= lefthand_side_expression */ yytestcase(yyruleno==105);
      /* (106) lefthand_side_expression ::= call_expression (OPTIMIZED OUT) */ assert(yyruleno!=106);
      /* (107) lefthand_side_expression ::= member_expression */ yytestcase(yyruleno==107);
      /* (108) member_expression ::= primary_expression (OPTIMIZED OUT) */ assert(yyruleno!=108);
      /* (109) member_expression ::= member_expression member_expression_part */ yytestcase(yyruleno==109);
      /* (110) primary_expression ::= object_literal (OPTIMIZED OUT) */ assert(yyruleno!=110);
      /* (111) primary_expression ::= PARENL expression PARENR */ yytestcase(yyruleno==111);
      /* (112) primary_expression ::= IDENTIFIER */ yytestcase(yyruleno==112);
      /* (113) primary_expression ::= array_literal (OPTIMIZED OUT) */ assert(yyruleno!=113);
      /* (114) primary_expression ::= DECIMAL */ yytestcase(yyruleno==114);
      /* (115) primary_expression ::= HEX_INTEGER */ yytestcase(yyruleno==115);
      /* (116) primary_expression ::= STRING */ yytestcase(yyruleno==116);
      /* (117) primary_expression ::= BOOLEAN */ yytestcase(yyruleno==117);
      /* (118) primary_expression ::= NULL */ yytestcase(yyruleno==118);
      /* (119) array_literal ::= BRACKETL elision BRACKETR */ yytestcase(yyruleno==119);
      /* (120) array_literal ::= BRACKETL element_list elision BRACKETR */ yytestcase(yyruleno==120);
      /* (121) array_literal ::= BRACKETL element_list BRACKETR */ yytestcase(yyruleno==121);
      /* (122) elision ::= COMMA */ yytestcase(yyruleno==122);
      /* (123) elision ::= elision COMMA */ yytestcase(yyruleno==123);
      /* (124) element_list ::= assignment_expression (OPTIMIZED OUT) */ assert(yyruleno!=124);
      /* (125) element_list ::= elision assignment_expression */ yytestcase(yyruleno==125);
      /* (126) element_list ::= element_list elision assignment_expression */ yytestcase(yyruleno==126);
      /* (127) property_name_and_value_list ::= property_name_and_value (OPTIMIZED OUT) */ assert(yyruleno!=127);
      /* (128) property_name_and_value_list ::= property_name_and_value_list COMMA property_name_and_value */ yytestcase(yyruleno==128);
      /* (129) property_name ::= STRING */ yytestcase(yyruleno==129);
      /* (130) member_expression_part ::= DOT IDENTIFIER */ yytestcase(yyruleno==130);
      /* (131) adjuster ::= */ yytestcase(yyruleno==131);
      /* (132) adjuster ::= adjust_expression (OPTIMIZED OUT) */ assert(yyruleno!=132);
      /* (133) adjust_expression ::= adjust_match_expression */ yytestcase(yyruleno==133);
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact <= YY_MAX_SHIFTREDUCE ){
    if( yyact>YY_MAX_SHIFT ){
      yyact += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
    }
    yymsp -= yysize-1;
    yypParser->yytos = yymsp;
    yymsp->stateno = (YYACTIONTYPE)yyact;
    yymsp->major = (YYCODETYPE)yygoto;
    yyTraceShift(yypParser, yyact);
  }else{
    assert( yyact == YY_ACCEPT_ACTION );
    yypParser->yytos -= yysize;
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  grn_expr_parserTOKENTYPE yyminor         /* The minor type of the error token */
){
  grn_expr_parserARG_FETCH;
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 20 "grn_ecmascript.lemon"

  {
    grn_ctx *ctx = efsi->ctx;
    grn_obj message;
    GRN_TEXT_INIT(&message, 0);
    GRN_TEXT_PUT(ctx, &message, efsi->str, efsi->cur - efsi->str);
    GRN_TEXT_PUTC(ctx, &message, '|');
    if (efsi->cur < efsi->str_end) {
      GRN_TEXT_PUTC(ctx, &message, efsi->cur[0]);
      GRN_TEXT_PUTC(ctx, &message, '|');
      GRN_TEXT_PUT(ctx, &message,
                   efsi->cur + 1, efsi->str_end - (efsi->cur + 1));
    } else {
      GRN_TEXT_PUTC(ctx, &message, '|');
    }
    if (ctx->rc == GRN_SUCCESS) {
      ERR(GRN_SYNTAX_ERROR, "Syntax error: <%.*s>",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message));
    } else {
      ERR(ctx->rc, "Syntax error: <%.*s>: %s",
          (int)GRN_TEXT_LEN(&message), GRN_TEXT_VALUE(&message),
          ctx->errbuf);
    }
    GRN_OBJ_FIN(ctx, &message);
  }
#line 2295 "grn_ecmascript.c"
/************ End %syntax_error code ******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  grn_expr_parserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  grn_expr_parserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "grn_expr_parserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void grn_expr_parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  grn_expr_parserTOKENTYPE yyminor       /* The value for the token */
  grn_expr_parserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  unsigned int yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  yypParser = (yyParser*)yyp;
  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  grn_expr_parserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput '%s'\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      yymajor = YYNOCODE;
    }else if( yyact <= YY_MAX_REDUCE ){
      yy_reduce(yypParser,yyact-YY_MIN_REDUCE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && yymx != YYERRORSYMBOL
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) >= YY_MIN_REDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;
      
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}
