# PGroonga（ぴーじーるんが）

## リリース情報

[news.md](news.md)を参照してください。

## 概要

PGroongaはPostgreSQLからインデックスとして
[Groonga](http://groonga.org/ja/)を使うための拡張機能です。

PostgreSQLは標準では日本語で全文検索できませんが、PGroongaを使うと日本
語で高速に全文検索できるようになります。日本語で全文検索機能を実現する
ための類似の拡張機能は次のものがあります。

  * [pg_trgm](https://www.postgresql.jp/document/current/html/pgtrgm.html)
    * PostgreSQLに付属しているがデフォルトではインストールされない。
    * 日本語に対応させるにはソースコードを変更する必要がある。
  * [pg_bigm](http://pgbigm.sourceforge.jp/)
    * ソースコードを変更しなくても日本語に対応している。
    * 正確な全文検索機能を使うには
      [Recheck機能](http://pgbigm.sourceforge.jp/pg_bigm-1-1.html#enable_recheck)
      を有効にする必要がある。
    * Recheck機能を有効にするとインデックスを使った検索をしてから、イ
      ンデックスを使って見つかったレコードに対してシーケンシャルに検索
      をするのでインデックスを使った検索でのヒット件数が多くなると遅く
      なりやすい。
    * Recheck機能を無効にするとキーワードが含まれていないレコードもヒッ
      トする可能性がある。

PGroongaはpg\_trgmのようにソースコードを変更しなくても日本語に対応して
います。

PGroongaはpg\_bigmのようにRecheck機能を使わなくてもインデックスを使っ
た検索だけで正確な検索結果を返せます。そのため、インデックスを使った検
索でヒット件数が多くてもpg\_bigmほど遅くなりません。（仕組みの上は。要
ベンチマーク。協力者募集。）

ただし、PGroongaは現時点ではWALに対応していない(*)ためクラッシュリカバ
リー機能やレプリケーションに対応していません。（pg\_trgmとpg\_bigmは対
応しています。正確に言うとpg\_trgmとpg\_bigmが対応しているわけではなく、
pg\_trgmとpg\_bigmが使っているGINやGiSTが対応しています。）

(*) PostgreSQLは拡張機能として実装したインデックスがWALに対応するため
のAPIを提供していません。PostgreSQL本体がそんなAPIを提供したらWALに対
応する予定です。

## サポートしているPostgreSQLのバージョン

  * PostgreSQL 9.3
  * PostgreSQL 9.4

## インストール

次の環境用のパッケージを用意しています。

  * Debian GNU/Linux Jessie
  * Ubuntu 14.04
  * Ubuntu 14.10
  * Ubuntu 15.04
  * CentOS 5
  * CentOS 6
  * CentOS 7
  * Windows 32bit + PostgreSQL 9.4.2
  * Windows 64bit + PostgreSQL 9.4.2

その他の環境ではソースからインストールしてください。

それぞれの環境でのインストール方法の詳細は以降のセクションで説明します。

### Debian GNU/Linux Jessieにインストール

GroongaのAPTリポジトリーを追加します。

`/etc/apt/sources.list.d/groonga.list`:

    deb http://packages.groonga.org/debian/ jessie main
    deb-src http://packages.groonga.org/debian/ jessie main

`postgresql-9.4-pgroonga`パッケージをインストールします。

    % sudo apt-get update
    % sudo apt-get install -y --allow-unauthenticated groonga-keyring
    % sudo apt-get update
    % sudo apt-get install -y -V postgresql-9.4-pgroonga

[MeCab](http://taku910.github.io/mecab/)ベースのトークナイザーを使いた
い場合は`groonga-tokenizer-mecab`パッケージもインストールします。

    % sudo apt-get install -y groonga-tokenizer-mecab

データベースを作成します。

    % sudo -u postgres -H psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % sudo -u postgres -H psql -d pgroonga_test --command 'CREATE EXTENSION pgroonga'

これでインストールは完了です。

### Ubuntu 14.04にインストール

`postgresql-9.3-pgroonga`パッケージをインストールします。

    % sudo apt-get install -y software-properties-common
    % sudo add-apt-repository -y universe
    % sudo add-apt-repository -y ppa:groonga/ppa
    % sudo apt-get update
    % sudo apt-get install -y postgresql-9.3-pgroonga

[MeCab](http://taku910.github.io/mecab/)ベースのトークナイザーを使いた
い場合は`groonga-tokenizer-mecab`パッケージもインストールします。

    % sudo apt-get install -y groonga-tokenizer-mecab

データベースを作成します。

    % sudo -u postgres -H psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % sudo -u postgres -H psql -d pgroonga_test --command 'CREATE EXTENSION pgroonga'

これでインストールは完了です。

### Ubuntu 14.10またはUbuntu 15.04にインストール

`postgresql-9.4-pgroonga`パッケージをインストールします。

    % sudo apt-get install -y software-properties-common
    % sudo add-apt-repository -y universe
    % sudo add-apt-repository -y ppa:groonga/ppa
    % sudo apt-get update
    % sudo apt-get install -y postgresql-9.4-pgroonga

[MeCab](http://taku910.github.io/mecab/)ベースのトークナイザーを使いた
い場合は`groonga-tokenizer-mecab`パッケージもインストールします。

    % sudo apt-get install -y groonga-tokenizer-mecab

データベースを作成します。

    % sudo -u postgres -H psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % sudo -u postgres -H psql -d pgroonga_test --command 'CREATE EXTENSION pgroonga'

これでインストールは完了です。

### CentOS 5または6にインストール

`postgresql-pgroonga`パッケージをインストールします。

    % sudo rpm -ivh http://yum.postgresql.org/9.4/redhat/rhel-$(rpm -qf --queryformat="%{VERSION}" /etc/redhat-release)-$(rpm -qf --queryformat="%{ARCH}" /etc/redhat-release)/pgdg-centos94-9.4-1.noarch.rpm
    % sudo rpm -ivh http://packages.groonga.org/centos/groonga-release-1.1.0-1.noarch.rpm
    % sudo yum makecache
    % sudo yum install -y postgresql94-pgroonga

[MeCab](http://taku910.github.io/mecab/)ベースのトークナイザーを使いた
い場合は`groonga-tokenizer-mecab`パッケージもインストールします。

    % sudo yum install -y groonga-tokenizer-mecab

PostgreSQLを起動します。

    % sudo -H /sbin/service postgresql-9.4 initdb
    % sudo -H /sbin/chkconfig postgresql-9.4 on
    % sudo -H /sbin/service postgresql-9.4 start

データベースを作成します。

    % sudo -u postgres -H psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % sudo -u postgres -H psql -d pgroonga_test --command 'CREATE EXTENSION pgroonga'

これでインストールは完了です。

### CentOS 7にインストール

`postgresql-pgroonga`パッケージをインストールします。

    % sudo rpm -ivh http://yum.postgresql.org/9.4/redhat/rhel-$(rpm -qf --queryformat="%{VERSION}" /etc/redhat-release)-$(rpm -qf --queryformat="%{ARCH}" /etc/redhat-release)/pgdg-centos94-9.4-1.noarch.rpm
    % sudo rpm -ivh http://packages.groonga.org/centos/groonga-release-1.1.0-1.noarch.rpm
    % sudo yum makecache
    % sudo yum install -y postgresql94-pgroonga

[MeCab](http://taku910.github.io/mecab/)ベースのトークナイザーを使いた
い場合は`groonga-tokenizer-mecab`パッケージもインストールします。

    % sudo yum install -y groonga-tokenizer-mecab

PostgreSQLを起動します。

    % sudo -H /usr/pgsql-9.4/bin/postgresql94-setup initdb
    % sudo -H systemctl enable postgresql-9.4
    % sudo -H systemctl start postgresql-9.4

データベースを作成します。

    % sudo -u postgres -H psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % sudo -u postgres -H psql -d pgroonga_test --command 'CREATE EXTENSION pgroonga'

これでインストールは完了です。

### Windowsにインストール

PostgreSQLをインストールします。PostgreSQL 9.4.2-1のものであれば
[インストーラーバージョン](http://www.enterprisedb.com/products-services-training/pgdownload)
でも
[zipバージョン](http://www.enterprisedb.com/products-services-training/pgbindownload)
でも構いません。

PGroongaのパッケージをダウンロードします。

  * [32bit版](http://packages.groonga.org/windows/pgroonga/pgroonga-0.9.0-postgresql-9.4.2-1-x86.zip)
  * [64bit版](http://packages.groonga.org/windows/pgroonga/pgroonga-0.9.0-postgresql-9.4.2-1-x64.zip)

PGroongaのパッケージを展開します。展開先としてPostgreSQLのフォルダーを
指定します。PostgreSQLのフォルダーはインストーラーを使ってPostgreSQLを
インストールした場合は`C:\Program Files\PostgreSQL\9.4`です。zipを使っ
てインストールした場合は`%アーカイブを展開したフォルダー%\pgsql`です。

データベースを作成します。

    postgres=# CREATE DATABASE pgroonga_test;

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    postgres=# \c pgroonga_test
    pgroonga_test=# CREATE EXTENSION pgroonga;

これでインストールは完了です。

### ソースからインストール

Windowsの場合とそれ以外の場合でソースからのインストール方法が違います。

まず、Windows以外の場合を説明し、その後、Windowsの場合を説明します。

#### Windows以外の場合

まずPostgreSQLをインストールします。

次に[Groongaをインストール](http://groonga.org/ja/docs/install.html)し
ます。パッケージでのインストールがオススメです。

パッケージでインストールするときは次のパッケージをインストールしてください。

  * `groonga-devel`: CentOSの場合
  * `libgroonga-dev`: Debian GNU/Linux, Ubuntuの場合

PGroongaのソースを展開します。

リリース版の場合:

    % wget http://packages.groonga.org/source/pgroonga/pgroonga-0.9.0.tar.gz
    % tar xvf pgroonga-0.9.0.tar.gz
    % cd pgroonga-0.9.0

未リリースの最新版の場合:

    % git clone https://github.com/pgroonga/pgroonga.git
    % cd pgroonga

PGroongaをビルドしてインストールします。

    % make
    % sudo make install

データベースを作成します。

    % psql --command 'CREATE DATABASE pgroonga_test'

（ここで`pgroonga_test`用のユーザーを作成して、そのユーザーで接続する
べき。）

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    % psql -d db --command 'CREATE EXTENSION pgroonga;'

これでインストールは完了です。

#### Windowsの場合

Windowsでソースからインストールするために必要なものは次の通りです。ま
ずはこれらをインストールしてください。

  * PostgreSQL（インストーラーバージョンでもzipバージョンでも構いません。）
    * [インストーラーバージョン](http://www.enterprisedb.com/products-services-training/pgdownload)
    * [zipバージョン](http://www.enterprisedb.com/products-services-training/pgbindownload)
  * [Microsoft Visual Studio Express 2013 for Windows Desktop](https://www.visualstudio.com/downloads/#d-2013-express)
  * [CMake](http://www.cmake.org/)

次にWindows用のPGroongaのソースアーカイブをpackages.groonga.orgからダ
ウンロードしてください。zipがWindows用のソースアーカイブです。Windows
用のソースアーカイブにはGroongaがバンドルされています。

  * http://packages.groonga.org/source/pgroonga/pgroonga-0.9.0.zip

ソースアーカイブを展開し、ソースフォルダーへ移動します。

    > cd c:\Users\%USERNAME%\Downloads\pgroonga-0.9.0

`cmake`でビルドオプションを設定します。以下のコマンドラインは64bit用の
PostgreSQL用にビルドするためのものです。32bit用のPostgreSQL用にをビル
ドする場合は代わりに`-G "Visual Studio 12 2013"`パラメーターを指定して
ください。

    pgroonga-0.9.0> cmake . -G "Visual Studio 12 2013 Win64" -DCMAKE_INSTALL_PREFIX=%PostgreSQLをインストールしたフォルダー%

`%PostgreSQLをインストールしたフォルダー%`はインストーラーを使って
PostgreSQLをインストールした場合は`C:\Program Files\PostgreSQL\9.4`で
す。zipを使ってインストールした場合は`%アーカイブを展開したフォルダー
%\pgsql`です。

ビルドします。

    pgroonga-0.9.0> cmake --build . --config Release

インストールします。インストールする場所によっては管理者権限が必要にな
ります。（PostgreSQLをインストーラーでインストールしている場合は管理者
権限が必要でしょう。）

    pgroonga-0.9.0> cmake --build . --config Release --target Install

データベースを作成します。

    postgres=# CREATE DATABASE pgroonga_test;

データベースに接続して`CREATE EXTENSION pgroonga`を実行します。

    postgres=# \c pgroonga_test
    pgroonga_test=# CREATE EXTENSION pgroonga;

これでインストールは完了です。

## アップデート

古いバージョンから新しいバージョンにアップデートする場合は、新しいバー
ジョンのPGroongaをインストール後、次のSQLを実行してください。

    pgroonga_test=# ALTER EXTENSION pgroonga UPDATE;

これですでにPGroongaがインストール済みのデータベースでも新しいバージョ
ンのPGroongaを使えます。

アップデートをサポートしているのは0.9.0からです。

## 使い方

PGroongaは全文検索はもちろん、数値や文字列の等価条件（`=`）や比較条件
（`<`や`>=`など）にも使えます。

まずは全文検索の使い方について説明し、次に等価条件や比較条件で使う方法
を説明します。

### 全文検索

#### 基本的な使い方

`text`型のカラムを作って`pgroonga`インデックスを作成します。
（`varchar`型に対して全文検索をする場合は追加で
`pgroonga.varchar_fulltext_search_ops`演算子クラスを指定する必要があり
ます。）

```sql
CREATE TABLE memos (
  id integer,
  content text
);

CREATE INDEX pgroonga_content_index ON memos USING pgroonga (content);
```

データを投入します。

```sql
INSERT INTO memos VALUES (1, 'PostgreSQLはリレーショナル・データベース管理システムです。');
INSERT INTO memos VALUES (2, 'Groongaは日本語対応の高速な全文検索エンジンです。');
INSERT INTO memos VALUES (3, 'PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。');
INSERT INTO memos VALUES (4, 'groongaコマンドがあります。');
```

検索します。ここではシーケンシャルスキャンではなくインデックスを使った
全文検索を使いたいので、シーケンシャルスキャン機能を無効にします。（あ
るいはもっとたくさんのデータを投入します。）

```sql
SET enable_seqscan = off;
```

##### `%%`演算子

全文検索をするときは`%%`演算子を使います。

```sql
SELECT * FROM memos WHERE content %% '全文検索';
--  id |                      content
-- ----+---------------------------------------------------
--   2 | Groongaは日本語対応の高速な全文検索エンジンです。
-- (1 行)
```

##### `@@`演算子

`キーワード1 OR キーワード2`のようにクエリー構文を使って全文検索をする
ときは`@@`演算子を使います。

```sql
SELECT * FROM memos WHERE content @@ 'PGroonga OR PostgreSQL';
--  id |                                  content
-- ----+---------------------------------------------------------------------------
--   3 | PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。
--   1 | PostgreSQLはリレーショナル・データベース管理システムです。
-- (2 行)
```

クエリー構文の詳細は
[Groognaのドキュメント](http://groonga.org/ja/docs/reference/grn_expr/query_syntax.html)
を参照してください。

ただし、`カラム名:@キーワード`というように「`カラム名:`」から始まる構
文は無効にしてあります。そのため、前方一致検索をしたい場合は「`カラム
名:^値`」という構文は使えず、「`値*`」という構文だけが使えます。

注意してください。

##### `LIKE`演算子

既存のSQLを変更しなくても使えるように`column LIKE '%キーワード%'`と書
くと`column @@ 'キーワード'`と同等の処理になるようになっています。

なお、`'キーワード%'`や`'%キーワード'`のように最初と最後に`%`がついて
いない場合は必ず検索結果が空になります。このようなパターンはインデック
スを使って検索できないからです。気をつけてください。

本来の`LIKE`演算子は元の文字列そのものに対して検索しますが、`@@`演算子
は正規化後の文字列に対して全文検索検索を実行します。そのため、インデッ
クスを使わない場合の`LIKE`演算子の結果（本来の`LIKE`演算子の結果）とイ
ンデックスを使った場合の`LIKE`演算子の結果は異なります。

たとえば、本来の`LIKE`演算子ではアルファベットの大文字小文字を区別した
りいわゆる全角・半角を区別しますが、インデックスを使った場合は区別なく
検索します。

本来の`LIKE`演算子の結果:

```sql
SET enable_seqscan = on;
SET enable_indexscan = off;
SET enable_bitmapscan = off;
SELECT * FROM memos WHERE content LIKE '%groonga%';
--  id |           content           
-- ----+-----------------------------
--   4 | groongaコマンドがあります。
-- (1 行)
```

インデックスを使った`LIKE`演算子の結果:

```sql
SET enable_seqscan = off;
SET enable_indexscan = on;
SET enable_bitmapscan = on;
SELECT * FROM memos WHERE content LIKE '%groonga%';
--  id |                                  content                                  
-- ----+---------------------------------------------------------------------------
--   2 | Groongaは日本語対応の高速な全文検索エンジンです。
--   3 | PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。
--   4 | groongaコマンドがあります。
-- (3 行)
```

インデックスを使った場合でも本来の`LIKE`演算子と同様の結果にしたい場合
は次のようにトークナイザー（後述）とノーマライザー（後述）を設定してイ
ンデックスを作成してください。

  * トークナイザー: `TokenBigramSplitSymbolAlphaDigit`
  * ノーマライザー: なし

具体的には次のようにインデックスを作成します。

```sql
CREATE INDEX pgroonga_content_index
          ON memos
       USING pgroonga (content)
        WITH (tokenizer='TokenBigramSplitSymbolAlphaDigit',
              normalizer='');
```

このようなインデックスを作っているときはインデックスを使った`LIKE`演算
子でも本来の`LIKE`演算子と同様の挙動になります。

```sql
SET enable_seqscan = off;
SET enable_indexscan = on;
SET enable_bitmapscan = on;
SELECT * FROM memos WHERE content LIKE '%groonga%';
--  id |           content           
-- ----+-----------------------------
--   4 | groongaコマンドがあります。
-- (1 行)
```

多くの場合、デフォルトの設定の全文検索結果の方が本来の`LIKE`演算子の方
の検索結果よりもユーザーが求めている結果に近くなります。本当に本来の
`LIKE`演算子の挙動の方が適切か検討した上で使ってください。

##### `pgroonga.score`関数

`pgroonga.score`関数を使うと該当レコードがどの程度クエリーに適合してい
るかを数値で取得することができます。

`pgroonga.score`関数を使うためにはインデックス対象にプライマリーキーの
カラムも含めなければいけません。プライマリーキーのカラムが含まれていな
い場合は常に`0`を返します。

また、全文検索をシーケンシャルスキャンで実行しているときも`0`になりま
す。

スコアーが返るはずなのに`0`が返るときは次の2点を確認してください。

  * プライマリーキーのカラムがインデックス対象に含まれているか
  * インデックスを使って全文検索を実行しているか

以下はインデックス対象にプライマリーキーを含めているスキーマの例です。

```sql
CREATE TABLE score_memos (
  id integer PRIMARY KEY,
  content text
);

CREATE INDEX pgroonga_score_memos_content_index
          ON score_memos
       USING pgroonga (id, content);
```

データを投入します。

```sql
INSERT INTO score_memos VALUES (1, 'PostgreSQLはリレーショナル・データベース管理システムです。');
INSERT INTO score_memos VALUES (2, 'Groongaは日本語対応の高速な全文検索エンジンです。');
INSERT INTO score_memos VALUES (3, 'PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。');
INSERT INTO score_memos VALUES (4, 'groongaコマンドがあります。');
```

必ずインデックスを使って全文検索をするためにシーケンシャルスキャン機能
を無効にします。（あるいはもっとたくさんのデータを投入します。）

```sql
SET enable_seqscan = off;
```

全文検索し、スコアーも表示します。

```sql
SELECT *, pgroonga.score(score_memos)
  FROM score_memos
 WHERE content %% 'PGroonga' OR content %% 'PostgreSQL';
--  id |                                  content                                  | score 
-- ----+---------------------------------------------------------------------------+-------
--   1 | PostgreSQLはリレーショナル・データベース管理システムです。                |     1
--   3 | PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。 |     2
-- (2 行)
```

`ORDER BY`句で`pgroonga.score`関数を使うことにより、適合度が高い順に並
び替えることができます。

```sql
SELECT *, pgroonga.score(score_memos)
  FROM score_memos
 WHERE content %% 'PGroonga' OR content %% 'PostgreSQL'
 ORDER BY pgroonga.score(score_memos) DESC;
--  id |                                  content                                  | score 
-- ----+---------------------------------------------------------------------------+-------
--   3 | PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。 |     2
--   1 | PostgreSQLはリレーショナル・データベース管理システムです。                |     1
-- (2 行)
```

現時点では適合度は「キーワードを含んでいる数」になります。Groongaには
キーワードや検索対象カラム毎に重みをつける機能や適合度の計算方法をカス
タマイズする機能があります。しかし、PostgreSQLらしく指定するAPIを思い
ついていないためPGroongaから使うことはできません。

#### 全文検索結果表示

全文検索とは直接関係ありませんが、全文検索した結果を表示するときに有用
な機能を紹介します。

##### `pgroonga.snippet_html`関数

`pgroonga.snippet_html`関数を使うと該当テキスト中からキーワードが含ま
れている箇所の周辺テキストを抽出できます。Web検索エンジンは検索結果に
この情報を含めていることが多いので見たことがあるはずです。

例として、次のテキスト（Groongaの説明文）を使います。

> Groonga is a fast and accurate full text search engine based on
> inverted index. One of the characteristics of Groonga is that a
> newly registered document instantly appears in search results.
> Also, Groonga allows updates without read locks. These characteristics
> result in superior performance on real-time applications.


このテキストの中には「`fast`」というキーワードが含まれています。
`pgroonga.snippet_html`を使うと「`fast`」周辺のテキストを抽出します。
キーワードは「`<span class="keyword">`」と「`</span>`」で囲まれます。
`pgroonga.snippet_html`の`html`はHTMLとして出力するという意味だという
ことです。

> Groonga is a <span class="keyword">fast</span> and accurate full
> text search engine based on inverted index. One of the
> characteristics of Groonga is that a newly registered document
> instantly appears in search results. Also, Gro

なお、この機能はPGroongaで検索した結果以外にも使えます。そのため、次の
ように`FROM`なしの`SELECT`でも使えます。なお、
[`unnest`](http://www.postgresql.org/docs/current/static/functions-array.html)
は配列を行にするPostgreSQLの関数です。

```sql
SELECT unnest(pgroonga.snippet_html(
  'Groonga is a fast and accurate full text search engine based on ' ||
  'inverted index. One of the characteristics of Groonga is that a ' ||
  'newly registered document instantly appears in search results. ' ||
  'Also, Groonga allows updates without read locks. These characteristics ' ||
  'result in superior performance on real-time applications.' ||
  '\n' ||
  '\n' ||
  'Groonga is also a column-oriented database management system (DBMS). ' ||
  'Compared with well-known row-oriented systems, such as MySQL and ' ||
  'PostgreSQL, column-oriented systems are more suited for aggregate ' ||
  'queries. Due to this advantage, Groonga can cover weakness of ' ||
  'row-oriented systems.',
  ARRAY['fast', 'PostgreSQL']));
                                                                                 --                                unnest                                                                                                                 
-- ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  Groonga is a <span class="keyword">fast</span> and accurate full text search engine based on inverted index. One of the characteristics of Groonga is that a newly registered document instantly appears in search results. Also, Gro
--  ase management system (DBMS). Compared with well-known row-oriented systems, such as MySQL and <span class="keyword">PostgreSQL</span>, column-oriented systems are more suited for aggregate queries. Due to this advantage, Groonga
-- (2 rows)
```

`pgroonga.snippet_html`の使い方は次の通りです。

```text
pgroonga.snippet_html(target, ARRAY[keyword1, keyword2, ...])
```

`target`は`text`型の値でキーワード抽出対象のテキストを指定します。

`keyword1`, `keyword2`, `...`は`text`型の配列で、抽出対象のテキストを
指定します。1つ以上指定してします。

`pgroonga.snippet_html`は`text`型の配列を返します。

配列の各要素にはキーワード周辺のテキストが含まれています。キーワードは
「`<span class="keyword">`」と「`</span>`」で囲まれ、元のテキストに含
まれる`<`, `>`, `&`, `"`はHTMLエスケープされます。

各要素に含まれる元テキストは最大200バイトになります。文字数ではなくバ
イト数です。これに加えて「`<span class="keyword">`」と「`</span>`」が
増え、`<`や`>`を`&lt;`, `&gt;`などに変換するので、各要素のテキストは
200バイト以上になることがあります。

#### カスタマイズ

`CREATE INDEX`の`WITH`でトークナイザーとノーマライザーをカスタマイズす
ることができます。デフォルトで適切なトークナイザーとノーマライザーが設
定されているので、通常はカスタマイズする必要はありません。上級者向けの
機能です。

なお、デフォルトのトークナイザーとノーマライザーは次の通りです。

  * トークナイザー: `TokenBigram`: Bigramベースのトークナイザーです。
  * ノーマライザー: [NormalizerAuto](http://groonga.org/ja/docs/reference/normalizers.html#normalizer-auto): エンコーディングに合わせて適切な正規化を行います。たとえば、UTF-8の場合はUnicodeのNFKCベースの正規化を行います。

トークナイザーをカスタマイズするときは`tokenizer='トークナイザー名'`を
指定します。例えば、[MeCab](http://taku910.github.io/mecab/)ベースのトー
クナイザーを指定する場合は次のように`tokenizer='TokenMecab'`を指定しま
す。（`TokenMecab`を使う場合は`groonga-tokenizer-mecab`パッケージをイ
ンストールしておく必要があります。）

```sql
CREATE TABLE memos (
  id integer,
  content text
);

CREATE INDEX pgroonga_content_index
          ON memos
       USING pgroonga (content)
        WITH (tokenizer='TokenMecab');
```

次のように`tokenizer=''`を指定することでトークナイザーを無効にできます。
トークナイザーを無効にするとカラムの値そのもの、あるいは値の前方一致検
索でのみヒットするようになります。これは、タグ検索や名前検索などに有用
です。（タグ検索には`tokenizer='TokenDelimit'`も有用です。）

```sql
CREATE TABLE memos (
  id integer,
  tag text
);

CREATE INDEX pgroonga_tag_index
          ON memos
       USING pgroonga (tag)
        WITH (tokenizer='');
```

ノーマライザーをカスタマイズするときは`normalizer='ノーマライザー名'`を
指定します。通常は指定する必要はありません。

次のように`normalizer=''`を指定することでノーマライザーを無効にできま
す。ノーマライザーを無効にするとカラムの値そのものでのみヒットするよう
になります。正規化によりノイズが増える場合は有用な機能です。

```sql
CREATE TABLE memos (
  id integer,
  tag text
);

CREATE INDEX pgroonga_tag_index
          ON memos
       USING pgroonga (tag)
        WITH (normalizer='');
```

### 等価・比較

等価・比較条件のためにPGroongaを使う方法は文字列型とそれ以外の型でイン
デックスの作成方法が少し違います。なお、検索条件（`WHERE`）の書き方は
B-treeを使ったインデックスなどのときと同じです。

文字列型以外での方の使い方が簡単なのでそちらから説明します。その後、文
字列型での使い方を説明します。

#### 数値など文字列型以外の型

文字列型以外の型を使うときは`USING`に`pgroonga`を指定してください。

```sql
CREATE TABLE ids (
  id integer
);

CREATE INDEX pgroonga_id_index ON ids USING pgroonga (id);
```

あとはB-treeを使ったインデックスなどのときと同じです。

データを投入します。

```sql
INSERT INTO ids VALUES (1);
INSERT INTO ids VALUES (2);
INSERT INTO ids VALUES (3);
```

シーケンシャルスキャンを無効にします。

```sql
SET enable_seqscan = off;
```

検索します。

```sql
SELECT * FROM ids WHERE id <= 2;
--  id
-- ----
--   1
--   2
-- (2 行)
```

#### 文字列型

文字列型に対して等価・比較条件を使う場合は`varchar`型に対してインデッ
クスを作成してください。最大バイト数が4096バイト以下になるように
`varchar`に最大文字数を指定してください。エンコーディングによって文字
数とバイト数の関係が変わることに注意してください。UTF-8を使っている場
合は最大文字数は1023になります。

```sql
CREATE TABLE tags (
  id integer,
  tag varchar(1023)
);

CREATE INDEX pgroonga_tag_index ON tags USING pgroonga (tag);
```

あとはB-treeを使ったインデックスなどのときと同じです。

データを投入します。

```sql
INSERT INTO tags VALUES (1, 'PostgreSQL');
INSERT INTO tags VALUES (2, 'Groonga');
INSERT INTO tags VALUES (3, 'Groonga');
```

シーケンシャルスキャンを無効にします。

```sql
SET enable_seqscan = off;
```

検索します。

```sql
SELECT * FROM tags WHERE tag = 'Groonga';
--  id |   tag
-- ----+---------
--   2 | Groonga
--   3 | Groonga
-- (2 行)
--
```

### 配列を使う

PGroongaでは`text`型または`varchar`型の配列に対するインデックスを作成
することもできます。

`text`型の配列の場合はそれぞれの要素に対して全文検索できます。

`varchar`型の配列の場合はそれぞれの要素に対して完全一致検索できます。
タグ検索などで有用です。

#### `text`型の配列

インデックスを作成するときに`USING pgroonga`を指定します。

```sql
CREATE TABLE docs (
  id integer,
  sections text[]
);

CREATE INDEX pgroonga_sections_index ON docs USING pgroonga (sections);
```

データを投入します。

```sql
INSERT INTO docs
     VALUES (1,
             ARRAY['PostgreSQLはリレーショナル・データベース管理システムです。',
                   'PostgreSQLは部分的に全文検索をサポートしています。']);
INSERT INTO docs
     VALUES (2,
             ARRAY['Groongaは日本語対応の高速な全文検索エンジンです。',
                   'Groongaは他のシステムに組み込むことができます。']);
INSERT INTO docs
     VALUES (3,
             ARRAY['PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。',
                   'PostgreSQLに高機能な全文検索機能を追加します。']);
```

`%%`演算子または`@@`演算子を使って全文検索できます。キーワードが何番目
の要素にあっても全文検索できます。

```sql
SELECT * FROM docs WHERE sections %% '全文検索';
--  id |                                                          sections                                                          
-- ----+----------------------------------------------------------------------------------------------------------------------------
--   1 | {PostgreSQLはリレーショナル・データベース管理システムです。,PostgreSQLは部分的に全文検索をサポートしています。}
--   2 | {Groongaは日本語対応の高速な全文検索エンジンです。,Groongaは他のシステムに組み込むことができます。}
--   3 | {PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。,PostgreSQLに高機能な全文検索機能を追加します。}
-- (3 行)
```

#### `varchar`型の配列

インデックスを作成するときに`USING pgroonga`を指定します。

```sql
CREATE TABLE products (
  id integer,
  name text,
  tags varchar(1023)[]
);

CREATE INDEX pgroonga_tags_index ON products USING pgroonga (tags);
```

データを投入します。

```sql
INSERT INTO products
     VALUES (1,
             'PostgreSQL',
             ARRAY['PostgreSQL', 'RDBMS']);
INSERT INTO products
     VALUES (2,
             'Groonga',
             ARRAY['Groonga', 'full-text search']);
INSERT INTO products
     VALUES (3,
             'PGroonga',
             ARRAY['PostgreSQL', 'Groonga', 'full-text search']);
```

`%%`演算子を使うと、配列の中に完全一致した要素があるかを検索できます。

```sql
SELECT * FROM products WHERE tags %% 'PostgreSQL';
--  id |    name    |                  tags                   
-- ----+------------+-----------------------------------------
--   1 | PostgreSQL | {PostgreSQL,RDBMS}
--   3 | PGroonga   | {PostgreSQL,Groonga,"full-text search"}
-- (2 行)
```

### `jsonb`を使う

PGroongaは`jsonb`型のデータもサポートしています。PGroongaのインデック
スを作成することにより高速に検索できます。

PGroongaは`jsonb`の検索のために次の2つの演算子を提供しています。

  * `@>`演算子
  * `@@`演算子

[`@>`演算子はPostgreSQLが標準で提供している演算子](http://www.postgresql.org/docs/current/static/functions-json.html#FUNCTIONS-JSONB-OP-TABLE)
です。右辺が左辺のサブセットなら真になります。

`@>`演算子はGINでも高速化できる演算子です。インデックス作成時間は
PGroongaとGINでそれほど変わりませんが、検索時間はPGroongaの方が少し速
いです。

`@@`演算子はPGroonga独自の演算子です。GINではインデックスを使えない複
雑な検索条件も記述できます。もし、
[JsQuery](https://github.com/postgrespro/jsquery)を知っているなら
構文が違うJsQueryのようなものと考えてください。

JsQueryができる検索とPGroongaができる検索はほぼ同じですが、PGroongaだ
けができる特徴的な検索は全文字列値に対しての全文検索です。

たとえば、次のJSONがあるとします。

```json
{
  "message": "Server is started.",
  "host": "www.example.com",
  "tags": [
    "web",
  ]
}
```

すべての文字列値に対して全文検索ができるので、「`server`」でも
「`example`」でも「`web`」でもヒットします。

#### サンプル用テーブル定義とサンプルデータ

例を示すために使うサンプル用のテーブル定義とサンプルデータを次に示します。

```sql
CREATE TABLE logs (
  record jsonb
);

CREATE INDEX pgroonga_logs_index ON logs USING pgroonga (record);

INSERT INTO logs
     VALUES ('{
                "message": "Server is started.",
                "host":    "www.example.com",
                "tags": [
                  "web",
                  "example.com"
                ]
              }');
INSERT INTO logs
     VALUES ('{
                "message": "GET /",
                "host":    "www.example.com",
                "code":    200,
                "tags": [
                  "web",
                  "example.com"
                ]
              }');
INSERT INTO logs
     VALUES ('{
                "message": "Send to <info@example.com>.",
                "host":    "mail.example.net",
                "tags": [
                  "mail",
                  "example.net"
                ]
              }');
```

少ないデータでもインデックスを使うようにシーケンシャルスキャンを無効に
します。

```sql
SET enable_seqscan = off;
```

#### `@>`演算子

`@>`演算子は`jsonb`で条件を指定します。カラムの値が条件として指定した
`jsonb`を含んでいればマッチします。

マッチする例です。（結果を見やすくするためにPostgreSQL 9.5から使える
`jsonb_pretty()`関数を使っています。）

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @> '{"host": "www.example.com"}'::jsonb;
--             jsonb_pretty             
-- -------------------------------------
--  {                                  +
--      "host": "www.example.com",     +
--      "tags": [                      +
--          "web",                     +
--          "example.com"              +
--      ],                             +
--      "message": "Server is started."+
--  }
--  {                                  +
--      "code": 200,                   +
--      "host": "www.example.com",     +
--      "tags": [                      +
--          "web",                     +
--          "example.com"              +
--      ],                             +
--      "message": "GET /"             +
--  }
-- (2 rows)
```

マッチしない例です。

条件の`jsonb`で配列を指定した場合、すべての要素が含まれていればマッチ
します。（配列の要素の順序は関係ありません。）しかし、1つでも含まれて
いない要素があればマッチしません。次の`tags`に`"mail"`を含むレコードも
`"web"`を含むレコードもありますが、両方含むレコードはないのでヒットし
ません。

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @> '{"tags": ["mail", "web"]}'::jsonb;
--  jsonb_pretty 
-- --------------
-- (0 rows)
```

#### `@@`演算子

`@@`演算子は
[Groongaのスクリプト構文](http://groonga.org/ja/docs/reference/grn_expr/script_syntax.html)
で条件を指定します。条件をどのように指定すればよいかわかるためには、
PGroongaがどのように`jsonb`のデータに対してインデックスを作成している
かを理解する必要があります。

PGroongaは`jsonb`の値を分解し、それぞれの値に対してインデックスを張っ
ています。SQLでいうと次のスキーマがあると考えてください。

```sql
CREATE TABLE values (
  key text PRIMARY KEY,
  path text,
  paths text[],
  type text,
  boolean boolean,
  number double,
  string text,
  size numeric
);
```

それぞれ次の値が入っています。

  * `key`: 同じ値では同一になる値。フォーマットは「`${パス}|${種類}|${値}`」。条件で使うことはない。
  * `path`: その値の位置を示すルートからのパス。[jq](https://stedolan.github.io/jq/)と互換で、オブジェクトは`["${要素名}"]`、配列は`[]`となる。たとえば、`{"tags": ["web"]}`の`"web"`を示すパスは`.["tags"][]`。パスが完全にわかっている場合は条件でこの値を使う。
  * `paths`: その値の位置を示すパスが複数入っている。絶対パス、サブパス、`.${要素名1}.${要素名2}`表記のパス、配列なしのパスが入っているので条件で指定するときに便利。たとえば、`{"a": {"b": "c": ["x"]}}`の`"x"`の場合は次のパスが入っている。
     * `.a.b.c`
     * `.["a"]["b"]["c"]`
     * `.["a"]["b"]["c"][]`
     * `a.b.c`
     * `["a"]["b"]["c"]`
     * `["a"]["b"]["c"][]`
     * `b.c`
     * `["b"]["c"]`
     * `["b"]["c"][]`
     * `c`
     * `["c"]`
     * `["c"][]`
     * `[]`
  * `type`: そのパスの値の種類。種類によって値がどのカラムに入るかが変わる。次のうちのどれか。
    * `object`: オブジェクト。値はない。
    * `array`: 配列。`size`に要素数が入る。
    * `boolean`: 真偽値。`boolean`に値が入る。
    * `number`: 数値。`number`に値が入る。
    * `string`: 文字列。`string`に値が入る。
  * `boolean`: `type`が`boolean`のとき有効な値が入っている。それ以外のときは`false`が入っている。
  * `number`: `type`が`number`のとき有効な値が入っている。それ以外のときは`0`が入っている。
  * `string`: `type`が`string`のとき有効な値が入っている。それ以外のときは空文字列が入っている。
  * `size`: `type`が`array`のとき配列の要素数が入っている。それ以外のときは`0`が入っている。

たとえば、次のJSONを考えます。

```json
{
  "message": "GET /",
  "host":    "www.example.com",
  "code":    200,
  "tags": [
    "web",
    "example.com"
  ]
}
```

このJSONは次のように分解されます。（一部です。）

| key | path | paths | type | boolean | number | string | size |
| --- | ---- | ----- | ---- | ------- | ------ | ------ | ---- |
| `.|object` | `.` | `[.]` | `object` | | | | |
| `.["message"]|string|GET /` | `.["message"]` | `[.message, .["message"], message, ["message"]]` | `string` | | | `GET /` | |
| `.["tags"][]|string|web` | `.["tags"]` | `[.tags, .["tags"], .["tags"][], tags, ["tags"], ["tags"][], []]` | `string` | | | `web` | |

`@`演算子の条件では分解した個々の値を特定する条件を指定します。指定した条件すべてを含んだ`jsonb`がマッチした`jsonb`になります。

`www.example.com`という文字列を含んだ`jsonb`を検索する場合は次のようにします。

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @@ 'string == "www.example.com"';
--             jsonb_pretty             
-- -------------------------------------
--  {                                  +
--      "host": "www.example.com",     +
--      "tags": [                      +
--          "web",                     +
--          "example.com"              +
--      ],                             +
--      "message": "Server is started."+
--  }
--  {                                  +
--      "code": 200,                   +
--      "host": "www.example.com",     +
--      "tags": [                      +
--          "web",                     +
--          "example.com"              +
--      ],                             +
--      "message": "GET /"             +
--  }
-- (2 rows)
```

`code`が`200`台のレコードを検索する場合は次のようにします。省略記法（`.code`）でパスを指定したいので`paths @ "..."`という条件指定をしています。

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @@ 'paths @ ".code" && number >= 200 && number < 300';
--           jsonb_pretty          
-- --------------------------------
--  {                             +
--      "code": 200,              +
--      "host": "www.example.com",+
--      "tags": [                 +
--          "web",                +
--          "example.com"         +
--      ],                        +
--      "message": "GET /"        +
--  }
-- (1 row)
```

全文検索をする場合は次のように`string @ "..."`を使います。

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @@ 'string @ "started"';
--             jsonb_pretty             
-- -------------------------------------
--  {                                  +
--      "host": "www.example.com",     +
--      "tags": [                      +
--          "web",                     +
--          "example.com"              +
--      ],                             +
--      "message": "Server is started."+
--  }
-- (1 row)
```

クエリー構文（`a OR b`のような書き方）を使って全文検索をしたい場合は
`query("string", "...")`を使います。

```sql
SELECT jsonb_pretty(record) FROM logs WHERE record @@ 'query("string", "send OR server")';
--                  jsonb_pretty                 
-- ----------------------------------------------
--  {                                           +
--      "host": "www.example.com",              +
--      "tags": [                               +
--          "web",                              +
--          "example.com"                       +
--      ],                                      +
--      "message": "Server is started."         +
--  }
--  {                                           +
--      "host": "mail.example.net",             +
--      "tags": [                               +
--          "mail",                             +
--          "example.net"                       +
--      ],                                      +
--      "message": "Send to <info@example.com>."+
--  }
-- (2 rows)
```

### Groongaの機能を使う

多くの場合、PostgreSQLよりGroongaの方が高速に処理できます。たとえば、
ドリルダウン機能を使うことにより検索結果の取得と複数の`GROUP BY`結果の
取得を1つのクエリーで実行することができるため、複数の`SELECT`文を実行
するよりも高速です。他にも、Groongaは列指向のデータストアを使っている
ため、一部のカラムだけを検索・取得する場合は行指向のデータストアの
PostgreSQLよりも高速です。

しかし、直接Groongaで検索するとSQLとは違うAPIになり、使い勝手がよくあ
りません。それでもGroongaを使いたい場合のためにSQL経由でGroongaを使う
機能を用意しています。

#### `pgroonga.command`関数

`pgroonga.command`関数を使うと
[Groongaのコマンド](http://groonga.org/ja/docs/reference/command.html)
を実行してその結果を文字列で取得できます。

次は
[statusコマンド](http://groonga.org/ja/docs/reference/commands/status.html)
を実行する例です。

```sql
SELECT pgroonga.command('status');
--                                   command                                                                                                                  
-- -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--  [[0,1423911561.69344,6.15119934082031e-05],{"alloc_count":164,"starttime":1423911561,"uptime":0,"version":"5.0.0-6-g17847c9","n_queries":0,"cache_hit_rate":0.0,"command_version":1,"default_command_version":1,"max_command_version":2}]
-- (1 行)
```

Groongaのコマンドの実行結果はJSONなのでPostgreSQLのJSON関数を使って扱
いやすくすることができます。

たとえば、`status`コマンドの結果は次のようにするとそれぞれの値を1行と
して扱うことができます。

```sql
SELECT * FROM json_each(pgroonga.command('status')::json->1);
--            key           |       value        
-- -------------------------+--------------------
--  alloc_count             | 168
--  starttime               | 1423911561
--  uptime                  | 221
--  version                 | "5.0.0-6-g17847c9"
--  n_queries               | 0
--  cache_hit_rate          | 0.0
--  command_version         | 1
--  default_command_version | 1
--  max_command_version     | 2
-- (9 行)
```

#### `pgroonga.table_name`関数

PGroongaのインデックス対象のカラムの値はGroongaのデータベースにも保存
されています。そのため、Groongaの
[selectコマンド](http://groonga.org/ja/docs/reference/commands/select.html)
を使って検索し、値を出力することができます。

`select`コマンドを使うにはGroongaでのテーブル名が必要です。インデック
ス名をGroongaでのテーブル名に変換するには`pgroonga.table_name`関数を使
います。

`pgroonga.table_name`関数を使うと次のように`select`コマンドを使うこと
ができます。

```sql
SELECT *
  FROM json_array_elements(pgroonga.command('select ' || pgroonga.table_name('pgroonga_content_index'))::json->1->0);
--                                        value                                       
-- -----------------------------------------------------------------------------------
--  [4]
--  [["_id","UInt32"],["_key","UInt64"],["content","LongText"]]
--  [1,1,"PostgreSQLはリレーショナル・データベース管理システムです。"]
--  [2,2,"Groongaは日本語対応の高速な全文検索エンジンです。"]
--  [3,3,"PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。"]
--  [4,4,"groongaコマンドがあります。"]
-- (6 行)
```

`select`コマンドを使うとカラムに重みをつけることもできます。

例として次のようなスキーマとデータを使います。検索したいデータと出力し
たいデータを両方インデックス対象にしています。

```sql
CREATE TABLE terms (
  id integer,
  title text,
  content text,
  tag varchar(256)
);

CREATE INDEX pgroonga_terms_index
          ON terms
       USING pgroonga (title, content, tag);

INSERT INTO terms
     VALUES (1,
             'PostgreSQL',
             'PostgreSQLはリレーショナル・データベース管理システムです。',
             'PostgreSQL');
INSERT INTO terms
     VALUES (2,
             'Groonga',
             'Groongaは日本語対応の高速な全文検索エンジンです。',
             'Groonga');
INSERT INTO terms
     VALUES (3,
             'PGroonga',
             'PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。',
             'PostgreSQL');
```

[match_columnsオプション](http://groonga.org/ja/docs/reference/commands/select.html#select-match-columns)で重みを指定できます。

```sql
SELECT *
  FROM json_array_elements(
         pgroonga.command('select ' ||
                          pgroonga.table_name('pgroonga_terms_index') || ' ' ||
                          '--match_columns "title * 10 || content" ' ||
                          '--query "Groonga OR PostgreSQL OR 全文検索" ' ||
                          '--output_columns "_score, title, content" ' ||
                          '--sortby "-_score"'
                         )::json->1->0);
--                                            value                                            
-- --------------------------------------------------------------------------------------------
--  [3]
--  [["_score","Int32"],["title","LongText"],["content","LongText"]]
--  [12,"Groonga","Groongaは日本語対応の高速な全文検索エンジンです。"]
--  [11,"PostgreSQL","PostgreSQLはリレーショナル・データベース管理システムです。"]
--  [2,"PGroonga","PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。"]
-- (5 行)
```

[drilldownオプション](http://groonga.org/ja/docs/reference/commands/select.html#select-drilldown)
を加えるとドリルダウン結果も取得できます。

```sql
SELECT *
  FROM json_array_elements(
         pgroonga.command('select ' ||
                          pgroonga.table_name('pgroonga_terms_index') || ' ' ||
                          '--match_columns "title * 10 || content" ' ||
                          '--query "Groonga OR PostgreSQL OR 全文検索" ' ||
                          '--output_columns "_score, title" ' ||
                          '--sortby "-_score" ' ||
                          '--drilldown "tag"'
                         )::json->1);
--                                               value                                              
-- -------------------------------------------------------------------------------------------------
--  [[3],[["_score","Int32"],["title","LongText"]],[12,"Groonga"],[11,"PostgreSQL"],[2,"PGroonga"]]
--  [[2],[["_key","ShortText"],["_nsubrecs","Int32"]],["Groonga",1],["PostgreSQL",2]]
-- (2 行)
```

SQLの`SELECT`文でどうにもならなくなったときに、もしかしたらGroongaの
`select`コマンドを使えるかもしれません。

#### 注意

レコードを削除・更新している場合は、Groongaのデータベースには削除済み・
更新前のデータが残っています。

まず、更新前の状態を確認します。レコードは3つです。

```sql
SELECT *
  FROM json_array_elements(
         pgroonga.command('select ' ||
                          pgroonga.table_name('pgroonga_terms_index')
                         )::json->1->0);
--                                                    value                                                   
-- -----------------------------------------------------------------------------------------------------------
--  [3]
--  [["_id","UInt32"],["_key","UInt64"],["content","LongText"],["tag","ShortText"],["title","LongText"]]
--  [1,1,"PostgreSQLはリレーショナル・データベース管理システムです。","PostgreSQL","PostgreSQL"]
--  [2,2,"Groongaは日本語対応の高速な全文検索エンジンです。","Groonga","Groonga"]
--  [3,3,"PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。","PostgreSQL","PGroonga"]
-- (5 行)
```

更新します。

```sql
UPDATE terms
   SET title = 'Mroonga',
       content = 'MroongaはGroongaをバックエンドにしたMySQLのストレージエンジンです。',
       tag = 'MySQL'
 WHERE id = 3;
```

再度`select`コマンドを実行するとレコードが1つ増えて4つになっています。
これは更新前のレコードも残っているからです。

```sql
SELECT *
  FROM json_array_elements(
         pgroonga.command('select ' ||
                          pgroonga.table_name('pgroonga_terms_index')
                         )::json->1->0);
--                                                    value                                                   
-- -----------------------------------------------------------------------------------------------------------
--  [4]
--  [["_id","UInt32"],["_key","UInt64"],["content","LongText"],["tag","ShortText"],["title","LongText"]]
--  [1,1,"PostgreSQLはリレーショナル・データベース管理システムです。","PostgreSQL","PostgreSQL"]
--  [2,2,"Groongaは日本語対応の高速な全文検索エンジンです。","Groonga","Groonga"]
--  [3,3,"PGroongaはインデックスとしてGroongaを使うためのPostgreSQLの拡張機能です。","PostgreSQL","PGroonga"]
--  [4,4,"MroongaはGroongaをバックエンドにしたMySQLのストレージエンジンです。","MySQL","Mroonga"]
-- (6 行)
```

削除されたレコードは`VACUUM`時に削除されます。明示的に`VACUUM`を実行す
ると更新前のレコードがなくなって、レコード数は3つになります。

```sql
VACUUM
SELECT *
  FROM json_array_elements(
         pgroonga.command('select ' ||
                          pgroonga.table_name('pgroonga_terms_index')
                         )::json->1->0);
--                                                 value                                                 
-- ------------------------------------------------------------------------------------------------------
--  [3]
--  [["_id","UInt32"],["_key","UInt64"],["content","LongText"],["tag","ShortText"],["title","LongText"]]
--  [1,1,"PostgreSQLはリレーショナル・データベース管理システムです。","PostgreSQL","PostgreSQL"]
--  [2,2,"Groongaは日本語対応の高速な全文検索エンジンです。","Groonga","Groonga"]
--  [4,4,"MroongaはGroongaをバックエンドにしたMySQLのストレージエンジンです。","MySQL","Mroonga"]
-- (5 行)
```

Groongaのデータを直接使うときは気をつけてください。

## 変数

PGroongaの挙動をカスタマイズする変数があります。

### `pgroonga.log_type`変数

`pgroonga.log_type`を使うとPGroongaのログをどのように出力するかを変更
できます。

有効な値は次の通りです。

  * `file`: ファイルに出力します。デフォルトです。
  * `windows_event_log`: Windowsイベントログに出力します。
  * `postgresql`: PostgreSQLのログ出力先に出力します。

`file`を指定した場合のログファイルの場所は「`${PostgreSQLのデータディ
レクトリー}/pgroonga.log`」になります。場所は`pgroonga.log_path`で変更
できます。

`windows_event_log`はWindowsでしか使えません。使う場合はコマンドプロン
プトで次のコマンドを実行し、にWindowsに「`PGroonga`」というイベントを
登録してください。登録しなくてもログは出力されますが、イベントビューアー
でログを見たときに警告メッセージが入り、読みにくいです。

    > regsvr32 /n /i:PGroonga ${PostgreSQLをインストールしたフォルダ}\lib\pgevent.dll

`postgresql`はPostgreSQLのログ出力機能を使ってログを出力します。
PGroongaのログの先頭には次の文字列が含まれます。PGroongaのログだけ抽出
する場合に利用してください。この文字列の後はGroongaと同じフォーマット
のメッセージになります。

```text
pgroonga:log: 
```

Groongaのログメッセージのフォーマットは
[Groongaのドキュメント](http://groonga.org/ja/docs/reference/log.html#process-log)
を参照してください。

### `pgroonga.log_path`変数

`pgroonga.log_path`を使うとログ出力先のファイルを変更できます。
`pgroonga.log_type`が`file`のときだけ有効です。

デフォルトは「`${PostgreSQLのデータディレクトリー}/pgroonga.log`」です。

### `pgroonga.log_level`変数

`pgroonga.log_level`を使うとどのくらい詳細にログを出力するかを変更できます。

有効な値は次の通りです。

  * `none`: ログを出力しません。
  * `emergency`: 緊急レベルのログのみを出力します。
  * `alert`: `emergency`のログと警報レベルのログを出力します。
  * `critical`: `alert`のログと重大レベルのログを出力します。
  * `error`: `critical`のログとエラーレベルのログを出力します。
  * `warning`: `error`のログと警告レベルのログを出力します。
  * `notice`: `warning`のログと通知レベルのログを出力します。
  * `info`: `notice`のログと参考情報レベルのログを出力します。
  * `debug`: `info`のログとデバッグレベルのログを出力します。
  * `dump`: すべてのログを出力します。

デフォルトは`notice`です。

通常は変更する必要はありません。

変更する場合、使うことが多いのは`none`、`info`、`debug`です。

`none`は一切ログが必要ないときに使います。

`info`は通常時にもう少し詳細な情報が必要なときに使います。

`debug`は問題調査時に使います。

### `pgroonga.lock_timeout`変数

`pgroonga.lock_timeout`を使うとロック獲得のリトライ回数を変更できます。

PGroongaはデータを書き込むときにロックを獲得します。これは、同時にデー
タを書き込んでデータを破壊しないようにするためです。

ロックの実装はスピンロックです。つまり、次の処理を繰り返してロックを獲
得します。

  1. ロック獲得にトライ→獲得できたら繰り返し終了
  2. 一定時間待つ

ただし、一定回数リトライしてもロックを獲得できなかったら諦めます。その
リトライ回数が`pgroonga.lock_timeout`です。

デフォルト値は`10,000,000`（一千万）です。

PGroongaの「一定時間」は1ミリ秒で、デフォルトでは一千万回リトライする
ので、デフォルトでは約2.7時間かかってもロックを獲得できなかったら諦め
ます。

通常は約2.7時間もロック獲得に失敗することはありません。PGroongaのバグ
の可能性があるので
[GitHubのissue](https://github.com/pgroonga/pgroonga/issues)に報告して
ください。

## アンインストール

次のSQLでアンインストールできます。

```sql
DROP EXTENSION pgroonga CASCADE;
DELETE FROM pg_catalog.pg_am WHERE amname = 'pgroonga';
```

`pg_catalog.pg_am`から手動でレコードを消さないといけないのはおかしい気
がするので、何がおかしいか知っている人は教えてくれるとうれしいです。

## Travis CIで使う

Travis CIでのPGroongaのセットアップをするシェルスクリプトを提供してい
ます。次のように`.travis.yml`の`install`で使うようにしてください。また、
`sudo: required`を忘れないでください。セットアップスクリプトの中で
`sudo`コマンドを使っているため`sudo: required`の設定が必要です。

```yaml
sudo: required
install:
  - curl --silent --location https://github.com/pgroonga/pgroonga/raw/master/data/travis/setup.sh | sh
```

このシェルスクリプトの中では`template1`データベースに対して`CREATE
EXTENSION pgroonga`をしているので、新しくデータベースを作ればすぐに
PGroongaが使える状態になっています。

## ライセンス

ライセンスはBSDライセンスやMITライセンスと類似の
[PostgreSQLライセンス](http://opensource.org/licenses/postgresql)です。

著作権保持者などの詳細は[COPYING](COPYING)ファイルを参照してください。

バンドルしているソフトウェアのライセンスは異なります。バンドルしている
ソフトウェアとそのライセンス情報は次の通りです。

  * [xxHash](https://github.com/Cyan4973/xxHash)
    * BSDライセンス
    * 著作権情報： `Copyright (c) 2012-2014, Yann Collet`
    * 詳細： `vendor/xxHash/LICENSE`

  * [Groonga](https://groonga.org/)（Windows用パッケージのみにバンドル）
    * LGPL 2.1
    * 著作権情報： `Copyright(C) 2009-2015 Brazil`
    * 詳細： `vendor/groonga/COPYING`

## TODO

  * 実装
    * WAL対応
    * COLLATE対応（今は必ずGroongaのNormalizerAutoを使っている）
  * ドキュメント
    * 英語で書く
    * サイトを用意する

## 感謝

  * 板垣さん
    * PGroongaは板垣さんが開発した[textsearch_groonga](http://textsearch-ja.projects.pgfoundry.org/textsearch_groonga.html)をベースにしています。
